/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.file.recstore.Block;
import com.tridium.history.file.recstore.Page;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class WriteBlock
extends Block
implements DataOutput {
    public final Page page;
    private int start;
    private int pos;

    public void start(int n, int n2, int n3) throws IOException {
        this.pos = this.start = 12 + n * this.size;
        this.writeInt(n2);
        this.writeInt(n3);
    }

    public void write(int n) throws IOException {
        if (this.pos < this.start || this.pos >= this.start + this.size) {
            throw new IOException("Write out of range: " + this.pos + " not in " + this.start + " - " + (this.start + this.size - 1));
        }
        this.page.buf[this.pos++] = (byte)n;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.start + this.size - this.pos;
        if (n2 > n3) {
            throw new IOException("Block overflow: " + n2 + " > " + n3);
        }
        System.arraycopy(byArray, n, this.page.buf, this.pos, n2);
        this.pos += n2;
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void writeShort(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void writeChar(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void writeInt(int n) throws IOException {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)l & 0xFF);
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeBytes(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.write((byte)string.charAt(n2));
            ++n2;
        }
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.write(c >>> 8 & 0xFF);
            this.write(c & 0xFF);
            ++n2;
        }
    }

    public void writeUTF(String string) throws IOException, UTFDataFormatException {
        throw new UnsupportedOperationException("writeUTF not supported");
    }

    public WriteBlock(Page page, int n) {
        super(n);
        this.page = page;
    }
}

