/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.file.recstore.Page;
import com.tridium.history.file.recstore.ReadBlock;
import com.tridium.history.file.recstore.RecordSpec;
import com.tridium.history.file.recstore.RecordStore;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryCursor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RecordStoreDescendingCursor
extends HistoryCursor {
    private Page page;
    private int startBlock;
    private BAbsTime end;
    private ReadBlock readBlock;
    private BHistoryRecord[] recordCache;
    private int recordIndex;

    protected boolean doNext(BHistoryRecord bHistoryRecord) {
        try {
            if (this.recordIndex == -1) {
                if (this.page == null) {
                    return false;
                }
                this.recordIndex = this.page.getRecordCount() - 1;
                this.readBlock.init(this.page, this.page.getFirst());
                int n = 0;
                while (n < this.page.getRecordCount()) {
                    this.recordCache[n] = (BHistoryRecord)bHistoryRecord.read(this.readBlock).newCopy();
                    this.readBlock.nextBlock();
                    if (this.readBlock.getPageBlock() > this.startBlock) {
                        this.recordIndex = n;
                        break;
                    }
                    ++n;
                }
            }
            if (this.end != null && !this.end.isNull() && this.recordCache[this.recordIndex].getTimestamp().isBefore(this.end)) {
                return false;
            }
            if (this.recordCache[this.recordIndex] == null) {
                return false;
            }
            bHistoryRecord.copyFrom((BComplex)this.recordCache[this.recordIndex]);
            --this.recordIndex;
            if (this.recordIndex == -1) {
                this.page = this.page.prevPage();
                this.startBlock = this.recordCache.length;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private final /* synthetic */ void this() {
        this.recordCache = null;
        this.recordIndex = -1;
    }

    public RecordStoreDescendingCursor(RecordStore recordStore, BHistoryConfig bHistoryConfig, RecordSpec recordSpec, BAbsTime bAbsTime, Context context) {
        super(bHistoryConfig, bHistoryConfig.makeRecord(), context);
        this.this();
        this.page = recordSpec.page;
        this.startBlock = recordSpec.block;
        this.end = bAbsTime;
        this.readBlock = new ReadBlock(recordStore.getHeader().getBlockSize());
        this.recordCache = new BHistoryRecord[(int)Math.ceil(recordStore.getPageSize() / recordStore.getBlockSize())];
    }
}

