/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.file.recstore.Block;
import com.tridium.history.file.recstore.Page;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class ReadBlock
extends Block
implements DataInput {
    private Page page;
    private int pageBlock;
    private int blocksInRec;
    private int recBlock;
    private int start;
    private int pos;

    public void init(Page page, int n) throws IOException {
        this.page = page;
        this.pageBlock = n;
        this.start = 12 + n * this.size;
        if (this.start >= page.buf.length) {
            throw new EOFException();
        }
        this.pos = this.start;
        this.blocksInRec = this.readInt();
        this.recBlock = this.readInt();
    }

    public Page getPage() {
        return this.page;
    }

    public boolean nextBlock() throws IOException {
        try {
            this.init(this.page, this.pageBlock + 1);
            return true;
        }
        catch (EOFException eOFException) {
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public int getBlocksInRec() {
        return this.blocksInRec;
    }

    public int getRecBlock() {
        return this.recBlock;
    }

    public int getPageBlock() {
        return this.pageBlock;
    }

    public int read() throws IOException {
        if (this.pos == this.start + this.size) {
            if (this.recBlock + 1 == this.blocksInRec) {
                throw new EOFException();
            }
            this.init(this.page, this.pageBlock + 1);
        }
        try {
            return this.page.buf[this.pos++] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("pos = " + this.pos + ", start+size = " + (this.start + this.size));
            throw arrayIndexOutOfBoundsException;
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = n2;
        while (n4 != 0) {
            int n5 = Math.min(n4, this.start + this.size - this.pos);
            if (n5 == 0) {
                if (this.recBlock + 1 == this.blocksInRec) {
                    return n3 == 0 ? -1 : n3;
                }
                this.init(this.page, this.pageBlock + 1);
                n5 = Math.min(n4, this.start + this.size - this.pos);
            }
            System.arraycopy(this.page.buf, this.pos, byArray, n, n5);
            n4 -= n5;
            this.pos += n5;
            n += n5;
            n3 += n5;
        }
        return n3;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.read(byArray, n, n2);
        if (n3 != n2) {
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        this.pos += n;
        if (this.pos >= this.start + this.size) {
            throw new EOFException();
        }
        return n;
    }

    public boolean readBoolean() throws IOException {
        boolean bl = false;
        if (this.read() != 0) {
            bl = true;
        }
        return bl;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readUnsignedByte() throws IOException {
        return this.read();
    }

    public short readShort() throws IOException {
        return (short)((this.read() << 8) + this.read());
    }

    public int readUnsignedShort() throws IOException {
        return (this.read() << 8) + this.read();
    }

    public char readChar() throws IOException {
        return (char)((this.read() << 8) + this.read());
    }

    public int readInt() throws IOException {
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.read();
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    stringBuffer.append((char)n3);
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n4 = this.read();
                    if ((n4 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0x1F) << 6 | n4 & 0x3F));
                    break;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n4 = this.read();
                    int n5 = this.read();
                    if ((n4 & 0xC0) != 128 || (n5 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0xF) << 12 | (n4 & 0x3F) << 6 | n5 & 0x3F));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(stringBuffer);
    }

    public ReadBlock(int n) {
        super(n);
    }
}

