/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.fixed;

import com.tridium.history.EmptyHistoryCursor;
import com.tridium.history.SchemaChangeException;
import com.tridium.history.file.BFileHistoryTable;
import com.tridium.history.file.fixed.Header;
import com.tridium.history.file.fixed.Page;
import com.tridium.history.file.fixed.PageHistoryCursor;
import com.tridium.history.file.fixed.PageHistoryDescendingCursor;
import com.tridium.history.file.fixed.RecordSpec;
import java.io.IOException;
import java.io.PrintWriter;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.HistoryCursor;
import javax.baja.history.HistoryException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PageManager {
    private static final int EQUAL_OR_AFTER = 0;
    private static final int EQUAL_OR_BEFORE = 1;
    private static final int EQUAL = 2;
    private static final BRelTime ONE_MILLI = BRelTime.make((long)1L);
    private BFileHistoryTable table;
    private Header header;
    private int recordSize;
    private int recordCount;
    private int capacity;
    private Page firstPage;
    private Page lastPage;
    private Page recent;

    public void create() throws IOException {
        if (this.header == null) {
            throw new IllegalStateException("For create, pageSize and recsPerPage must be specified.");
        }
        this.nextLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            int n;
            this.header = this.readHeader(null);
            if (this.header.getRecordSize() != this.recordSize) {
                throw new SchemaChangeException("Record length has changed: " + this.header.getRecordSize() + " != " + this.recordSize);
            }
            long l = this.table.length() - 64L;
            long l2 = this.header.getPageSize();
            int n2 = (int)(l % l2);
            int n3 = (int)(l / l2);
            if (n2 != 0) {
                this.header.setPageCount(n3);
                if (this.header.getLastPage() > n3 - 1) {
                    this.header.setLastPage(n3 - 1);
                }
                if (this.header.getFirstPage() > n3 - 1) {
                    this.header.setFirstPage(this.header.getNextFirstPage());
                }
                this.writeHeader();
                this.table.setLength(64L + (long)n3 * l2);
            }
            if (n3 != this.header.getPageCount()) {
                this.header.setPageCount(n3);
                if (this.header.getLastPage() > n3 - 1) {
                    this.header.setLastPage(n3 - 1);
                }
                if (this.header.getFirstPage() > n3 - 1) {
                    this.header.setFirstPage(this.header.getNextFirstPage());
                }
                this.writeHeader();
            }
            this.capacity = this.header.getCapacity();
            int n4 = this.header.getFirstPage();
            int n5 = this.header.getLastPage();
            this.firstPage = this.readPage(n4);
            this.lastPage = n4 == n5 ? this.firstPage : this.readPage(n5);
            if (this.lastPage.getRecordCount() == 0 && (n = this.previousPage(this.lastPage.index)) != -1) {
                this.lastPage = this.readPage(n);
                this.header.setPageCount(n3--);
                this.header.setLastPage(this.lastPage.index);
                this.writeHeader();
            }
            this.computeRecordCount();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean flush() throws IOException {
        boolean bl = false;
        Object object = this.table.getTableLock();
        synchronized (object) {
            bl = this.writePage(this.firstPage);
            boolean bl2 = false;
            if (this.writePage(this.lastPage) || bl) {
                bl2 = true;
            }
            bl = bl2;
            boolean bl3 = false;
            if (this.writePage(this.recent)) return true;
            if (!bl) return bl3;
            return true;
        }
    }

    public void close() {
        try {
            this.flush();
        }
        catch (Exception exception) {}
        this.recent = null;
        this.lastPage = null;
        this.firstPage = null;
        this.recordCount = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int computeRecordCount() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            int n = this.header.getPageCount();
            if (n == 0) {
                this.recordCount = 0;
                return 0;
            }
            int n2 = 0;
            if (this.firstPage.index < this.lastPage.index) {
                n2 = this.lastPage.index - this.firstPage.index - 1;
            } else if (this.lastPage.index < this.firstPage.index) {
                n2 = n - this.firstPage.index - 1 + this.lastPage.index;
            }
            int n3 = this.header.getRecordsPerPage();
            this.recordCount = n2 * n3;
            this.recordCount += this.firstPage.getRecordCount();
            if (this.firstPage != this.lastPage) {
                this.recordCount += this.lastPage.getRecordCount();
            }
            return this.recordCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRecordCount() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.recordCount != -1) {
                return this.recordCount;
            }
            return this.computeRecordCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BAbsTime getFirstTimestamp() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.firstPage.getRecordCount() == 0) {
                return BAbsTime.NULL;
            }
            return this.firstPage.readTimestamp(this.firstPage.getFirstIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BAbsTime getLastTimestamp() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.lastPage.getRecordCount() == 0) {
                return BAbsTime.NULL;
            }
            return this.lastPage.readTimestamp(this.lastPage.getLastIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BHistoryRecord getLastRecord() throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (this.lastPage.getRecordCount() == 0) {
                return null;
            }
            BHistoryRecord bHistoryRecord = (BHistoryRecord)this.table.getConfig().getRecordType().getInstance();
            this.lastPage.read(this.lastPage.getLastIndex(), bHistoryRecord);
            return bHistoryRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void append(BHistoryRecord bHistoryRecord) throws IOException, HistoryException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (!this.lastPage.append(bHistoryRecord)) {
                this.nextLast();
                if (!this.lastPage.append(bHistoryRecord)) {
                    throw new IOException("Cannot append record.");
                }
            }
            ++this.recordCount;
            if (this.recordCount > this.capacity) {
                if (this.firstPage.trimFromStart(this.recordCount - this.capacity) == 0) {
                    this.nextFirst();
                    this.writeHeader();
                }
                this.recordCount = this.capacity;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(BHistoryRecord bHistoryRecord, BHistoryRecord bHistoryRecord2) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            BAbsTime bAbsTime = bHistoryRecord2.getTimestamp();
            RecordSpec recordSpec = this.findRecord(bAbsTime, 2);
            if (recordSpec == null) {
                throw new IOException("Record not found with timestamp " + bAbsTime + '.');
            }
            if (bHistoryRecord != null) {
                recordSpec.getRecord(bHistoryRecord);
            }
            recordSpec.setRecord(bHistoryRecord2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cursor query(BAbsTime bAbsTime, BAbsTime bAbsTime2) throws IOException, HistoryException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            RecordSpec recordSpec;
            RecordSpec recordSpec2;
            RecordSpec recordSpec3;
            BHistoryRecord bHistoryRecord;
            block21: {
                BHistoryRecord bHistoryRecord2;
                BHistoryRecord bHistoryRecord3;
                block20: {
                    block19: {
                        bHistoryRecord = this.table.getConfig().makeRecord();
                        if (this.table.getRecordCount() == 0) {
                            return new EmptyHistoryCursor(this.table.getConfig(), bHistoryRecord, null);
                        }
                        bHistoryRecord3 = null;
                        bHistoryRecord2 = null;
                        if (bAbsTime == null || bAbsTime.isNull()) {
                            recordSpec3 = new RecordSpec(this, this.firstPage.index, this.firstPage.getFirstIndex());
                        } else {
                            recordSpec3 = this.findRecord(bAbsTime, 0);
                            try {
                                recordSpec2 = this.findRecord(bAbsTime.subtract(ONE_MILLI), 1);
                                if (recordSpec2 != null) {
                                    bHistoryRecord3 = recordSpec2.getRecord((BHistoryRecord)bHistoryRecord.newCopy());
                                }
                            }
                            catch (Exception exception) {
                                if (!BHistoryService.logger.isTraceOn()) break block19;
                                BHistoryService.logger.trace("Error computing record prior to requested query for history '" + (Object)((Object)this.table.getConfig().getId()) + "' with query start time " + bAbsTime + ". Skipping prior record computation.", (Throwable)exception);
                            }
                        }
                    }
                    if (bAbsTime2 == null || bAbsTime2.isNull()) {
                        recordSpec = new RecordSpec(this, this.lastPage.index, this.lastPage.getLastIndex());
                    } else {
                        recordSpec = this.findRecord(bAbsTime2, 1);
                        try {
                            recordSpec2 = this.findRecord(bAbsTime2.add(ONE_MILLI), 0);
                            if (recordSpec2 != null) {
                                bHistoryRecord2 = recordSpec2.getRecord((BHistoryRecord)bHistoryRecord.newCopy());
                            }
                        }
                        catch (Exception exception) {
                            if (!BHistoryService.logger.isTraceOn()) break block20;
                            BHistoryService.logger.trace("Error computing record after requested query for history '" + (Object)((Object)this.table.getConfig().getId()) + "' with query end time " + bAbsTime2 + ". Skipping post record computation.", (Throwable)exception);
                        }
                    }
                }
                recordSpec2 = null;
                if (bHistoryRecord3 != null || bHistoryRecord2 != null) {
                    try {
                        recordSpec2 = new BasicContext(null, HistoryCursor.makeBoundaryRecordFacets(bHistoryRecord3, bHistoryRecord2));
                    }
                    catch (Exception exception) {
                        if (!BHistoryService.logger.isTraceOn()) break block21;
                        BHistoryService.logger.trace("Error creating context for query cursor for history '" + (Object)((Object)this.table.getConfig().getId()) + "' with query start time " + bAbsTime + " and end time " + bAbsTime2 + '.', (Throwable)exception);
                    }
                }
            }
            if (recordSpec3 == null && recordSpec == null) {
                return new EmptyHistoryCursor(this.table.getConfig(), bHistoryRecord, (Context)recordSpec2);
            }
            if (recordSpec3 != null && recordSpec != null && recordSpec3.getTimestamp().isAfter(recordSpec.getTimestamp())) {
                return new EmptyHistoryCursor(this.table.getConfig(), bHistoryRecord, (Context)recordSpec2);
            }
            return new PageHistoryCursor(this.table.getConfig(), bHistoryRecord, recordSpec3, recordSpec, (Context)recordSpec2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cursor queryDesc(BAbsTime bAbsTime, BAbsTime bAbsTime2) throws IOException, HistoryException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            RecordSpec recordSpec;
            RecordSpec recordSpec2;
            RecordSpec recordSpec3;
            BHistoryRecord bHistoryRecord;
            block21: {
                BHistoryRecord bHistoryRecord2;
                BHistoryRecord bHistoryRecord3;
                block20: {
                    block19: {
                        bHistoryRecord = this.table.getConfig().makeRecord();
                        if (this.table.getRecordCount() == 0) {
                            return new EmptyHistoryCursor(this.table.getConfig(), bHistoryRecord, null);
                        }
                        bHistoryRecord3 = null;
                        bHistoryRecord2 = null;
                        if (bAbsTime == null || bAbsTime.isNull()) {
                            recordSpec3 = new RecordSpec(this, this.firstPage.index, this.firstPage.getFirstIndex());
                        } else {
                            recordSpec3 = this.findRecord(bAbsTime, 0);
                            try {
                                recordSpec2 = this.findRecord(bAbsTime.subtract(ONE_MILLI), 1);
                                if (recordSpec2 != null) {
                                    bHistoryRecord3 = recordSpec2.getRecord((BHistoryRecord)bHistoryRecord.newCopy());
                                }
                            }
                            catch (Exception exception) {
                                if (!BHistoryService.logger.isTraceOn()) break block19;
                                BHistoryService.logger.trace("Error computing record prior to requested queryDesc for history '" + (Object)((Object)this.table.getConfig().getId()) + "' with query start time " + bAbsTime + ". Skipping prior record computation.", (Throwable)exception);
                            }
                        }
                    }
                    if (bAbsTime2 == null || bAbsTime2.isNull()) {
                        recordSpec = new RecordSpec(this, this.lastPage.index, this.lastPage.getLastIndex());
                    } else {
                        recordSpec = this.findRecord(bAbsTime2, 1);
                        try {
                            recordSpec2 = this.findRecord(bAbsTime2.add(ONE_MILLI), 0);
                            if (recordSpec2 != null) {
                                bHistoryRecord2 = recordSpec2.getRecord((BHistoryRecord)bHistoryRecord.newCopy());
                            }
                        }
                        catch (Exception exception) {
                            if (!BHistoryService.logger.isTraceOn()) break block20;
                            BHistoryService.logger.trace("Error computing record after requested queryDesc for history '" + (Object)((Object)this.table.getConfig().getId()) + "' with query end time " + bAbsTime2 + ". Skipping post record computation.", (Throwable)exception);
                        }
                    }
                }
                recordSpec2 = null;
                if (bHistoryRecord3 != null || bHistoryRecord2 != null) {
                    try {
                        recordSpec2 = new BasicContext(null, HistoryCursor.makeBoundaryRecordFacets(bHistoryRecord2, bHistoryRecord3));
                    }
                    catch (Exception exception) {
                        if (!BHistoryService.logger.isTraceOn()) break block21;
                        BHistoryService.logger.trace("Error creating context for queryDesc cursor for history '" + (Object)((Object)this.table.getConfig().getId()) + "' with query start time " + bAbsTime + " and end time " + bAbsTime2 + '.', (Throwable)exception);
                    }
                }
            }
            if (recordSpec3 == null && recordSpec == null) {
                return new EmptyHistoryCursor(this.table.getConfig(), bHistoryRecord, (Context)recordSpec2);
            }
            if (recordSpec3 != null && recordSpec != null && recordSpec3.getTimestamp().isAfter(recordSpec.getTimestamp())) {
                return new EmptyHistoryCursor(this.table.getConfig(), bHistoryRecord, (Context)recordSpec2);
            }
            return new PageHistoryDescendingCursor(this.table.getConfig(), bHistoryRecord, recordSpec, recordSpec3, (Context)recordSpec2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RecordSpec findRecord(BAbsTime bAbsTime, int n) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            RecordSpec recordSpec = null;
            RecordSpec recordSpec2 = null;
            RecordSpec recordSpec3 = null;
            boolean bl = true;
            boolean bl2 = true;
            BAbsTime bAbsTime2 = null;
            int n2 = this.getRecordCount();
            if (n2 == 0) {
                return null;
            }
            int n3 = 0;
            int n4 = n2 - 1;
            int n5 = n3;
            int n6 = n4;
            if (n2 == 1) {
                RecordSpec recordSpec4 = this.getRecordSpec(null, n5);
                bAbsTime2 = recordSpec4.getTimestamp();
                int n7 = bAbsTime.compareTo((Object)bAbsTime2);
                if (n7 == 0) {
                    return recordSpec4;
                }
                if (n7 < 0) {
                    if (n != 0) return null;
                    RecordSpec recordSpec5 = recordSpec4;
                    return recordSpec5;
                }
                if (n != 1) return null;
                RecordSpec recordSpec6 = recordSpec4;
                return recordSpec6;
            }
            while (true) {
                if (bl) {
                    bl = false;
                    bAbsTime2 = (recordSpec3 = this.getRecordSpec(recordSpec3, n5)).getTimestamp();
                    if (bAbsTime.equals((Object)bAbsTime2)) {
                        return recordSpec3;
                    }
                }
                if (bl2) {
                    bl2 = false;
                    bAbsTime2 = (recordSpec = this.getRecordSpec(recordSpec, n6)).getTimestamp();
                    if (bAbsTime.equals((Object)bAbsTime2)) {
                        return recordSpec;
                    }
                }
                if (n5 == n6 - 1) {
                    if (n5 == n3 && bAbsTime.compareTo((Object)(bAbsTime2 = (recordSpec3 = this.getRecordSpec(recordSpec3, n5)).getTimestamp())) < 0) {
                        if (n != 0) return null;
                        return recordSpec3;
                    }
                    if (n6 == n4 && bAbsTime.compareTo((Object)(bAbsTime2 = (recordSpec = this.getRecordSpec(recordSpec, n6)).getTimestamp())) > 0) {
                        if (n != 1) return null;
                        return recordSpec;
                    }
                    if (n == 0) {
                        return recordSpec;
                    }
                    if (n != 1) return null;
                    return recordSpec3;
                }
                int n8 = (n6 + n5) / 2;
                bAbsTime2 = (recordSpec2 = this.getRecordSpec(recordSpec2, n8)).getTimestamp();
                int n9 = bAbsTime.compareTo((Object)bAbsTime2);
                if (n9 < 0) {
                    n6 = n8;
                    recordSpec.copyFrom(recordSpec2);
                    bl2 = true;
                    continue;
                }
                if (n9 <= 0) {
                    return recordSpec2;
                }
                n5 = n8;
                recordSpec3.copyFrom(recordSpec2);
                bl = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getFirstRecordIndex() {
        Object object = this.table.getTableLock();
        synchronized (object) {
            return this.firstPage.getFirstIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLastRecordIndex() {
        Object object = this.table.getTableLock();
        synchronized (object) {
            int n = this.header.getPageCount();
            int n2 = this.header.getRecordsPerPage();
            return n * n2 + this.lastPage.getLastIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RecordSpec getRecordSpec(RecordSpec recordSpec, int n) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            block5: {
                int n2;
                block4: {
                    if (recordSpec == null) {
                        recordSpec = new RecordSpec(this);
                    }
                    if (n >= (n2 = this.firstPage.getRecordCount())) break block4;
                    recordSpec.set(this.firstPage.index, this.firstPage.getFirstIndex() + n);
                    break block5;
                }
                int n3 = this.header.getRecordsPerPage();
                int n4 = 1 + (n - n2) / n3;
                int n5 = n - n2 - (n4 - 1) * n3;
                int n6 = (this.firstPage.index + n4) % this.header.getMaxPages();
                recordSpec.set(n6, n5);
            }
            return recordSpec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BAbsTime getTimestamp(int n) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            int n2 = this.header.getRecordsPerPage();
            int n3 = n / n2;
            int n4 = n - n3 * n2;
            Page page = this.getPage(n3);
            return page.readTimestamp(n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int nextPage(int n) {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (n == this.header.getLastPage()) {
                return -1;
            }
            return this.header.next(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int previousPage(int n) {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (n == this.header.getFirstPage()) {
                return -1;
            }
            return this.header.previous(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Page getPage(int n) throws IOException {
        Object object = this.table.getTableLock();
        synchronized (object) {
            if (n == -1) {
                return null;
            }
            if (n == this.firstPage.index) {
                return this.firstPage;
            }
            if (n == this.lastPage.index) {
                return this.lastPage;
            }
            if (this.recent != null && n == this.recent.index) {
                return this.recent;
            }
            Page page = this.readPage(n);
            this.writePage(this.recent);
            this.recent = page;
            return page;
        }
    }

    int firstPage() {
        return this.firstPage.index;
    }

    int lastPage() {
        return this.lastPage.index;
    }

    int pageCount() {
        return this.header.getPageCount();
    }

    private final Header readHeader(Header header) throws IOException {
        if (header == null) {
            header = new Header();
        }
        this.table.seek(0L);
        header.read(this.table.in());
        return header;
    }

    private final Page readPage(int n) throws IOException {
        int n2 = this.header.getPageSize();
        this.table.seek(64L + (long)n2 * (long)n);
        Page page = new Page(n, n2, this.recordSize);
        page.read(this.table.in());
        return page;
    }

    private final void nextFirst() throws IOException {
        int n = this.header.getNextFirstPage();
        this.header.setFirstPage(n);
        if (n == this.lastPage.index) {
            this.firstPage = this.lastPage;
        } else if (this.recent != null && n == this.recent.index) {
            this.firstPage = this.recent;
            this.recent = null;
        } else {
            this.firstPage = this.readPage(n);
        }
    }

    private final void nextLast() throws IOException {
        this.writePage(this.lastPage);
        int n = this.header.getPageSize();
        int n2 = this.header.getNextLastPage();
        if (n2 == this.header.getFirstPage()) {
            this.nextFirst();
            this.writeHeader();
            this.lastPage = new Page(n2, n, this.header.getRecordSize());
            this.writePage(this.lastPage);
            this.header.setLastPage(n2);
            this.writeHeader();
        } else {
            if (this.recent != null && n2 == this.recent.index) {
                this.recent = null;
            }
            this.lastPage = new Page(n2, n, this.header.getRecordSize());
            this.writePage(this.lastPage);
            this.header.setLastPage(n2);
            if (this.header.getPageCount() == 0) {
                this.firstPage = this.lastPage;
                this.header.setFirstPage(0);
            }
            if (n2 == this.header.getPageCount()) {
                this.header.incrementPageCount();
            }
            this.writeHeader();
        }
    }

    private final boolean writeHeader() throws IOException {
        if (!this.header.isDirty()) {
            return false;
        }
        this.table.seek(0L);
        this.header.write(this.table.out());
        return true;
    }

    private final boolean writePage(Page page) throws IOException {
        if (page == null || !page.isDirty()) {
            return false;
        }
        this.table.seek(64L + (long)this.header.getPageSize() * (long)page.index);
        page.write(this.table.out());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dump(PrintWriter printWriter) throws IOException {
        printWriter.println("\n\n=== " + (Object)((Object)this.table.getConfig().getId()) + " ===");
        Object object = this.table.getTableLock();
        synchronized (object) {
            int n = this.header.getFirstPage();
            int n2 = this.header.getLastPage();
            int n3 = this.header.getPageCount();
            BHistoryConfig bHistoryConfig = this.table.getConfig();
            BHistoryRecord bHistoryRecord = bHistoryConfig.makeRecord();
            printWriter.println("---------- Header ----------");
            this.header.dump(printWriter);
            printWriter.println("----------------------------");
            int n4 = 0;
            while (true) {
                if (n4 >= n3) {
                    printWriter.flush();
                    return;
                }
                printWriter.print(n4);
                printWriter.print(": ");
                Page page = this.getPage(n4);
                boolean bl = false;
                if (n4 == n) {
                    bl = true;
                    printWriter.print("[first]");
                }
                if (n4 == n2) {
                    bl = true;
                    printWriter.print("[last]");
                }
                if (this.recent != null && n4 == this.recent.index) {
                    bl = true;
                    printWriter.print("[recent]");
                }
                if (bl) {
                    printWriter.print(" ");
                }
                if (n < n2 && (n4 < n || n4 > n2)) {
                    printWriter.print("[unused] ");
                } else if (n4 > n2 && n4 < n) {
                    printWriter.print("[unused] ");
                }
                printWriter.print(page.getRecordCount());
                printWriter.print(" records");
                if (page.getRecordCount() != 0) {
                    printWriter.print(' ');
                    page.read(page.getFirstIndex(), bHistoryRecord);
                    printWriter.print(page.getFirstIndex() + ": " + bHistoryRecord);
                    printWriter.print(" - ");
                    page.read(page.getLastIndex(), bHistoryRecord);
                    printWriter.print(page.getLastIndex() + ": " + bHistoryRecord);
                }
                printWriter.println();
                ++n4;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.recordCount = -1;
    }

    public PageManager(BFileHistoryTable bFileHistoryTable, int n) {
        this.this();
        this.table = bFileHistoryTable;
        this.recordSize = n;
    }

    public PageManager(BFileHistoryTable bFileHistoryTable, int n, int n2, int n3) {
        this.this();
        this.table = bFileHistoryTable;
        this.recordSize = n2;
        this.capacity = n3;
        this.header = new Header(n, n2, n3);
    }
}

