/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.fixed;

import com.tridium.history.file.VersionMismatchException;
import com.tridium.history.file.fixed.Page;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Header {
    public static final int SIZE = 64;
    private int version;
    private int pageSize;
    private int recSize;
    private int capacity;
    private int maxPages;
    private int pageCount;
    private int recsPerPage;
    private int firstPage;
    private int lastPage;
    private boolean dirty;

    public static int computeMaxPages(int n, int n2) {
        int n3 = n / n2;
        if (n % n2 != 0) {
            ++n3;
        }
        return ++n3;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public int getVersion() {
        return this.version;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getRecordSize() {
        return this.recSize;
    }

    public int getRecordsPerPage() {
        return this.recsPerPage;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int n) {
        this.pageCount = n;
        this.dirty = true;
    }

    public int incrementPageCount() {
        ++this.pageCount;
        this.dirty = true;
        return this.pageCount;
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public int getFirstPage() {
        return this.firstPage;
    }

    public void setFirstPage(int n) {
        this.firstPage = n;
        this.dirty = true;
    }

    public int getNextFirstPage() {
        return (this.firstPage + 1) % this.maxPages;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public void setLastPage(int n) {
        this.lastPage = n;
        this.dirty = true;
    }

    public int getNextLastPage() {
        return (this.lastPage + 1) % this.maxPages;
    }

    public int previous(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n - 1;
        if (n2 < 0) {
            n2 = this.pageCount - 1;
        }
        return n2;
    }

    public int next(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n + 1;
        if (n2 == this.pageCount) {
            n2 = 0;
        }
        return n2;
    }

    public void read(DataInput dataInput) throws IOException {
        this.version = dataInput.readInt();
        if (this.version != 1) {
            throw new VersionMismatchException(1, this.version);
        }
        this.pageSize = dataInput.readInt();
        this.pageCount = dataInput.readInt();
        this.recSize = dataInput.readInt();
        this.capacity = dataInput.readInt();
        this.firstPage = dataInput.readInt();
        this.lastPage = dataInput.readInt();
        this.recsPerPage = Page.computeRecordsPerPage(this.pageSize, this.recSize);
        this.maxPages = Header.computeMaxPages(this.capacity, this.recsPerPage);
        this.dirty = false;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.version);
        dataOutput.writeInt(this.pageSize);
        dataOutput.writeInt(this.pageCount);
        dataOutput.writeInt(this.recSize);
        dataOutput.writeInt(this.capacity);
        dataOutput.writeInt(this.firstPage);
        dataOutput.writeInt(this.lastPage);
        this.dirty = false;
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("version    : " + this.version);
        printWriter.println("pageSize   : " + this.pageSize);
        printWriter.println("recSize    : " + this.recSize);
        printWriter.println("capacity   : " + this.capacity);
        printWriter.println("maxPages   : " + this.maxPages);
        printWriter.println("pageCount  : " + this.pageCount);
        printWriter.println("recsPerPage: " + this.recsPerPage);
        printWriter.println("firstPage  : " + this.firstPage);
        printWriter.println("lastPage   : " + this.lastPage);
        printWriter.flush();
    }

    public String toString() {
        return "Header: firstPage=" + this.firstPage + " lastPage=" + this.lastPage + " pageCount=" + this.pageCount;
    }

    private final /* synthetic */ void this() {
        this.version = 1;
        this.firstPage = -1;
        this.lastPage = -1;
    }

    public Header() {
        this.this();
        this.dirty = true;
    }

    public Header(int n, int n2, int n3) {
        this.this();
        this.pageSize = n;
        this.recSize = n2;
        this.capacity = n3;
        this.recsPerPage = Page.computeRecordsPerPage(n, n2);
        this.maxPages = Header.computeMaxPages(n3, this.recsPerPage);
        this.dirty = true;
    }
}

