/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.fixed;

import com.tridium.history.file.BFileHistoryTable;
import com.tridium.history.file.fixed.PageManager;
import java.io.IOException;
import java.io.PrintWriter;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFixedLengthHistoryTable
extends BFileHistoryTable {
    public static final Type TYPE;
    private PageManager pageManager;
    static /* synthetic */ Class class$com$tridium$history$file$fixed$BFixedLengthHistoryTable;

    public Type getType() {
        return TYPE;
    }

    protected void createDataSection() throws IOException {
        BHistoryConfig bHistoryConfig = this.getConfig();
        BHistoryRecord bHistoryRecord = bHistoryConfig.makeRecord();
        if (!bHistoryRecord.isFixedSize()) {
            throw new HistoryException("This file format is only valid for histories with fixed length records.");
        }
        int n = this.getPageSize();
        int n2 = bHistoryRecord.getRecordSize();
        BCapacity bCapacity = bHistoryConfig.getCapacity();
        int n3 = -1;
        n3 = !bCapacity.isUnlimited() ? bCapacity.getMaxRecords() : Integer.MAX_VALUE;
        PageManager pageManager = new PageManager(this, n, n2, n3);
        pageManager.create();
    }

    private final int getPageSize() {
        return 4096;
    }

    protected void openDataSection() throws IOException {
        BHistoryRecord bHistoryRecord = this.getConfig().makeRecord();
        if (!bHistoryRecord.isFixedSize()) {
            throw new HistoryException("This file format is only valid for histories with fixed length records.");
        }
        int n = bHistoryRecord.getRecordSize();
        this.pageManager = new PageManager(this, n);
        this.pageManager.open();
    }

    protected boolean flushData() throws IOException {
        if (this.pageManager != null) {
            return this.pageManager.flush();
        }
        return false;
    }

    protected void closeData() {
    }

    protected boolean deleteData() {
        return true;
    }

    protected int doGetRecordCount() throws IOException, HistoryException {
        return this.pageManager.getRecordCount();
    }

    protected BAbsTime doGetFirstTimestamp() throws IOException, HistoryException {
        return this.pageManager.getFirstTimestamp();
    }

    protected BAbsTime doGetLastTimestamp() throws IOException {
        return this.pageManager.getLastTimestamp();
    }

    protected BHistoryRecord doGetLastRecord() throws IOException {
        return this.pageManager.getLastRecord();
    }

    protected boolean doAppend(BHistoryRecord bHistoryRecord) throws IOException {
        try {
            BFullPolicy bFullPolicy;
            int n;
            int n2 = this.pageManager.getRecordCount();
            BCapacity bCapacity = this.getConfig().getCapacity();
            if (bCapacity.isByRecordCount() && n2 >= (n = bCapacity.getMaxRecords()) && (bFullPolicy = this.getConfig().getFullPolicy()) == BFullPolicy.stop) {
                return false;
            }
            this.pageManager.append(bHistoryRecord);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    protected void doUpdate(BHistoryRecord bHistoryRecord, BHistoryRecord bHistoryRecord2) throws IOException {
        this.pageManager.update(bHistoryRecord, bHistoryRecord2);
    }

    protected Cursor doTimeQuery(BAbsTime bAbsTime, BAbsTime bAbsTime2, boolean bl) throws IOException {
        if (!bl) {
            return this.pageManager.query(bAbsTime, bAbsTime2);
        }
        return this.pageManager.queryDesc(bAbsTime, bAbsTime2);
    }

    public void dump(PrintWriter printWriter) throws IOException {
        this.pageManager.dump(printWriter);
        printWriter.flush();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BFixedLengthHistoryTable() {
    }

    public BFixedLengthHistoryTable(BHistoryConfig bHistoryConfig) {
        super(bHistoryConfig);
    }

    static {
        Class clazz = class$com$tridium$history$file$fixed$BFixedLengthHistoryTable;
        if (clazz == null) {
            clazz = class$com$tridium$history$file$fixed$BFixedLengthHistoryTable = BFixedLengthHistoryTable.class("[Lcom.tridium.history.file.fixed.BFixedLengthHistoryTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

