/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file;

import com.tridium.history.db.BHistoryDbTable;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.file.HistoryFileOutput;
import com.tridium.history.file.fixed.BFixedLengthHistoryTable;
import com.tridium.history.file.recstore.BRecordStoreHistoryTable;
import com.tridium.history.io.FileRandomAccess;
import com.tridium.history.io.RandomAccess;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.HistoryException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.io.RandomAccessFileInputStream;
import javax.baja.io.RandomAccessFileOutputStream;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BFileHistoryTable
extends BHistoryDbTable {
    public static final Type TYPE;
    private static final BIcon icon;
    private static final int MAGIC = -1593380578;
    private static final int VERSION = 1;
    private static final int CONFIG_OFFSET = 12;
    private static final int DEFAULT_DATA_OFFSET = 1600;
    private File file;
    private boolean local;
    private RandomAccessFile access;
    private HistoryFileOutput output;
    private RandomAccess dataAccess;
    private int version;
    private int dataOffset;
    private boolean resizing;
    private Object lockSync;
    private Queue appendQueue;
    private boolean locked;
    static /* synthetic */ Class class$com$tridium$history$file$BFileHistoryTable;

    public Type getType() {
        return TYPE;
    }

    public static BFileHistoryTable make(BHistoryDatabase bHistoryDatabase, BHistoryConfig bHistoryConfig, boolean bl) throws HistoryException {
        BFileHistoryTable bFileHistoryTable = BFileHistoryTable.makeDefault(bHistoryConfig.makeRecord());
        bFileHistoryTable.setConfig(bHistoryConfig);
        bFileHistoryTable.setDatabase(bHistoryDatabase);
        bFileHistoryTable.setConfig(bHistoryConfig);
        bFileHistoryTable.local = bl;
        return bFileHistoryTable;
    }

    public static BFileHistoryTable makeTest(BHistoryConfig bHistoryConfig, RandomAccess randomAccess) {
        BFileHistoryTable bFileHistoryTable = BFileHistoryTable.makeDefault(bHistoryConfig.makeRecord());
        bFileHistoryTable.setConfig(bHistoryConfig);
        bFileHistoryTable.dataAccess = randomAccess;
        return bFileHistoryTable;
    }

    private static final BFileHistoryTable makeDefault(BHistoryRecord bHistoryRecord) {
        if (bHistoryRecord.isFixedSize()) {
            return new BFixedLengthHistoryTable();
        }
        return new BRecordStoreHistoryTable();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BFileHistoryTable createFromFile(BHistoryDatabase bHistoryDatabase, File file, boolean bl) throws IOException, FileNotFoundException, HistoryException {
        BHistoryConfig bHistoryConfig;
        block8: {
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath() + " does not exist.");
            }
            DataInputStream dataInputStream = null;
            bHistoryConfig = null;
            try {
                try {
                    BHistoryId bHistoryId;
                    dataInputStream = new DataInputStream(new FileInputStream(file));
                    BFileHistoryTable.checkMagic(dataInputStream.readInt(), file);
                    int n = dataInputStream.readInt();
                    BFileHistoryTable.checkVersion(n, file);
                    int n2 = dataInputStream.readInt();
                    bHistoryConfig = (BHistoryConfig)new ValueDocDecoder((InputStream)dataInputStream).decodeDocument();
                    if (bl && !((BLocalHistoryDatabase)bHistoryDatabase).isLocal(bHistoryId = bHistoryConfig.getId())) {
                        bHistoryId = BHistoryId.make(((BLocalHistoryDatabase)bHistoryDatabase).getLocalStationName(), bHistoryId.getHistoryName());
                        bHistoryConfig.setId(bHistoryId);
                    }
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
                throw throwable;
            }
            {
                Object var6_12 = null;
                if (dataInputStream == null) break block8;
            }
            dataInputStream.close();
        }
        BFileHistoryTable bFileHistoryTable = BFileHistoryTable.make(bHistoryDatabase, bHistoryConfig, bl);
        bFileHistoryTable.file = file;
        return bFileHistoryTable;
    }

    /*
     * Exception decompiling
     */
    public static void setId(File var0, BHistoryId var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 127->131)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public File[] getFiles() {
        return new File[]{this.getFile()};
    }

    protected File getFile() {
        if (this.file == null) {
            BLocalHistoryDatabase bLocalHistoryDatabase = (BLocalHistoryDatabase)this.getDatabase();
            if (bLocalHistoryDatabase == null) {
                throw new IllegalStateException("Cannot open a history without a database.");
            }
            this.file = bLocalHistoryDatabase.getFile(this.getConfig().getId(), true);
        }
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int getRecordCount() {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            try {
                return this.doGetRecordCount();
            }
            catch (IOException iOException) {
                throw new HistoryException(iOException);
            }
        }
    }

    protected abstract int doGetRecordCount() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BAbsTime getFirstTimestamp() {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            try {
                return this.doGetFirstTimestamp();
            }
            catch (IOException iOException) {
                throw new HistoryException(iOException);
            }
        }
    }

    protected abstract BAbsTime doGetFirstTimestamp() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BAbsTime getLastTimestamp() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            try {
                return this.doGetLastTimestamp();
            }
            catch (IOException iOException) {
                throw new HistoryException(iOException);
            }
        }
    }

    protected abstract BAbsTime doGetLastTimestamp() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BHistoryRecord getLastRecord() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            try {
                return this.doGetLastRecord();
            }
            catch (IOException iOException) {
                throw new HistoryException(iOException);
            }
        }
    }

    protected abstract BHistoryRecord doGetLastRecord() throws IOException;

    public static void checkMagic(int n, File file) throws IOException {
        if (n != -1593380578) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("File is not a valid history file. ");
            stringBuffer.append("Bad magic number (0x");
            stringBuffer.append(Integer.toString(n, 16).toUpperCase());
            stringBuffer.append(") for ").append(file.getName());
            throw new IOException(stringBuffer.toString());
        }
    }

    public static void checkVersion(int n, File file) throws IOException {
        if (n > 1) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("File format version is not supported by this release. ");
            stringBuffer.append("The maximum version supported by this release is ");
            stringBuffer.append(1);
            stringBuffer.append(" but the format version for this file is ").append(n);
            stringBuffer.append('.');
            throw new IOException(stringBuffer.toString());
        }
    }

    protected final void doOpen() throws HistoryException {
        File file = this.getFile();
        boolean bl = file.exists() ^ true;
        if (this.access != null) {
            throw new IllegalStateException("File is already open.");
        }
        try {
            this.access = new RandomAccessFile(file, "rws");
            this.output = new HistoryFileOutput(this.access, (Object)this);
            if (bl) {
                this.dataOffset = 1600;
                this.access.writeInt(-1593380578);
                this.access.writeInt(1);
                this.access.writeInt(this.dataOffset);
                RandomAccessFileOutputStream randomAccessFileOutputStream = new RandomAccessFileOutputStream(this.access, 12L);
                ValueDocEncoder valueDocEncoder = new ValueDocEncoder((OutputStream)randomAccessFileOutputStream);
                valueDocEncoder.encodeDocument((BValue)this.getConfig());
                randomAccessFileOutputStream.flush();
                long l = this.access.getFilePointer();
                if (l > (long)this.dataOffset) {
                    while (l > (long)this.dataOffset) {
                        this.dataOffset *= 2;
                    }
                    this.access.seek(8L);
                    this.access.writeInt(this.dataOffset);
                }
                if (l < (long)this.dataOffset - 1L) {
                    this.access.seek(this.dataOffset - 1);
                    this.access.write(0);
                }
                this.access.seek(this.dataOffset);
                this.createDataSection();
                this.openDataSection();
            } else {
                BFileHistoryTable.checkMagic(this.access.readInt(), file);
                this.version = this.access.readInt();
                BFileHistoryTable.checkVersion(this.version, file);
                this.dataOffset = this.access.readInt();
                this.openDataSection();
            }
        }
        catch (IOException iOException) {
            if (this.access != null) {
                try {
                    this.access.close();
                }
                catch (Exception exception) {}
            }
            throw new HistoryException(iOException);
        }
    }

    protected abstract void createDataSection() throws IOException;

    protected abstract void openDataSection() throws IOException;

    protected void doFlush() throws HistoryException {
        try {
            this.flushData();
        }
        catch (IOException iOException) {
            throw new HistoryException(iOException);
        }
    }

    protected abstract boolean flushData() throws IOException;

    protected void doClose() {
        try {
            this.closeData();
        }
        catch (Exception exception) {}
        try {
            this.access.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.dataAccess = null;
        this.access = null;
        this.output = null;
        BLocalHistoryDatabase bLocalHistoryDatabase = (BLocalHistoryDatabase)this.getDatabase();
        if (bLocalHistoryDatabase != null) {
            bLocalHistoryDatabase.tableClosed(this);
        }
    }

    protected abstract void closeData();

    protected boolean doDelete() {
        if (!this.deleteData()) {
            return false;
        }
        try {
            if (this.access != null) {
                this.access.close();
                this.dataAccess = null;
                this.access = null;
                this.output = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.file != null) {
            return this.file.delete();
        }
        return true;
    }

    protected abstract boolean deleteData();

    public void doRenameHistory(String string) {
        BHistoryId.validateName(string);
        String string2 = this.getConfig().getId().getHistoryName();
        if (string2 != null && string2.equals(string)) {
            return;
        }
        BHistoryId bHistoryId = BHistoryId.make(this.getConfig().getId().getDeviceName(), string);
        if (this.getDatabase().exists(bHistoryId)) {
            throw new HistoryException(string + " already exists.  Cannot rename history.");
        }
        BHistoryConfig bHistoryConfig = (BHistoryConfig)this.getConfig().newCopy(true);
        bHistoryConfig.setId(bHistoryId);
        this.getDatabase().createHistory(bHistoryConfig);
        BIHistory bIHistory = this.getDatabase().getHistory(bHistoryId);
        Cursor cursor = this.timeQuery(null, null, false);
        while (cursor.next()) {
            bIHistory.append((BHistoryRecord)cursor.get());
        }
        if (!this.delete()) {
            throw new HistoryException("Cannot delete original history.");
        }
    }

    protected void doResize(BCapacity bCapacity, BFullPolicy bFullPolicy) {
        File file;
        File file2 = this.getFile();
        String string = file2.getAbsolutePath();
        if (string.endsWith(".hdb")) {
            string = string.substring(0, string.length() - 3) + "tmp";
        }
        if ((file = new File(string)).exists()) {
            file.delete();
        }
        BHistoryConfig bHistoryConfig = (BHistoryConfig)this.getConfig().newCopy(true);
        bHistoryConfig.setCapacity(bCapacity);
        bHistoryConfig.setFullPolicy(bFullPolicy);
        BFileHistoryTable bFileHistoryTable = BFileHistoryTable.make(null, bHistoryConfig, this.local);
        bFileHistoryTable.file = file;
        bFileHistoryTable.open();
        Cursor cursor = this.timeQuery(null, null, false);
        while (cursor.next()) {
            bFileHistoryTable.append((BHistoryRecord)cursor.get());
        }
        bFileHistoryTable.close();
        try {
            String string2 = file2.getAbsolutePath().substring(0, string.length() - 3) + "chk";
            File file3 = new File(string2);
            if (file3.exists()) {
                file3.delete();
            }
            if (!file.renameTo(file3)) {
                throw new HistoryException("Cannot rename new history: " + file.getAbsolutePath());
            }
            file = file3;
            if (!this.doDelete()) {
                throw new HistoryException("Cannot delete original history.");
            }
        }
        catch (HistoryException historyException) {
            if (file.exists()) {
                file.delete();
            }
            throw historyException;
        }
        if (!file.renameTo(file2)) {
            throw new HistoryException("Cannot rename new history: " + file.getAbsolutePath());
        }
        this.resizing = true;
        this.setConfig(bHistoryConfig);
        this.resizing = false;
        this.doOpen();
    }

    public void doClear() {
        this.doDelete();
        this.doOpen();
    }

    public void doClear(BAbsTime bAbsTime) {
        File file;
        if (bAbsTime == null || bAbsTime.isNull()) {
            return;
        }
        File file2 = this.getFile();
        if (!file2.exists()) {
            this.doClear();
            return;
        }
        String string = file2.getAbsolutePath();
        if (string.endsWith(".hdb")) {
            string = string.substring(0, string.length() - 3) + "tmp";
        }
        if ((file = new File(string)).exists()) {
            file.delete();
        }
        BHistoryConfig bHistoryConfig = (BHistoryConfig)this.getConfig().newCopy(true);
        BFileHistoryTable bFileHistoryTable = BFileHistoryTable.make(null, bHistoryConfig, this.local);
        bFileHistoryTable.file = file;
        bFileHistoryTable.open();
        Cursor cursor = this.timeQuery(bAbsTime, null, false);
        while (cursor.next()) {
            bFileHistoryTable.append((BHistoryRecord)cursor.get());
        }
        bFileHistoryTable.close();
        try {
            String string2 = file2.getAbsolutePath().substring(0, string.length() - 3) + "chk";
            File file3 = new File(string2);
            if (file3.exists()) {
                file3.delete();
            }
            if (!file.renameTo(file3)) {
                throw new HistoryException("Cannot rename new history: " + file.getAbsolutePath() + " to " + file3.getAbsolutePath());
            }
            file = file3;
            if (!this.doDelete()) {
                throw new HistoryException("Cannot delete original history.");
            }
        }
        catch (HistoryException historyException) {
            if (file.exists()) {
                file.delete();
            }
            throw historyException;
        }
        if (!file.renameTo(file2)) {
            throw new HistoryException("Cannot rename new history: " + file.getAbsolutePath() + " to " + file2.getAbsolutePath());
        }
        this.doOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Cursor timeQuery(BAbsTime bAbsTime, BAbsTime bAbsTime2, boolean bl) throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            this.open();
            try {
                return this.doTimeQuery(bAbsTime, bAbsTime2, bl);
            }
            catch (IOException iOException) {
                throw new HistoryException(iOException);
            }
        }
    }

    protected abstract Cursor doTimeQuery(BAbsTime var1, BAbsTime var2, boolean var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void lock() {
        Object object = this.tableLock;
        synchronized (object) {
            this.locked = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void unlock() {
        Object object = this.tableLock;
        synchronized (object) {
            this.locked = false;
            while (!this.appendQueue.isEmpty()) {
                BIHistoryRecordSet bIHistoryRecordSet = (BIHistoryRecordSet)this.appendQueue.dequeue();
                this.append(bIHistoryRecordSet);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int append(BIHistoryRecordSet bIHistoryRecordSet) throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            if (this.locked) {
                this.appendQueue.enqueue((Object)bIHistoryRecordSet);
                int n = 0;
                if (bIHistoryRecordSet != null) {
                    n = bIHistoryRecordSet.getRecordCount();
                }
                return n;
            }
            this.checkDeleted();
            this.open();
            try {
                int n = bIHistoryRecordSet.getRecordCount();
                if (n == 0) {
                    return 0;
                }
                int n2 = 0;
                BAbsTime bAbsTime = this.getLastTimestamp();
                int n3 = 0;
                while (true) {
                    if (n3 >= n) {
                        return n2;
                    }
                    BHistoryRecord bHistoryRecord = bIHistoryRecordSet.getRecord(n3);
                    BAbsTime bAbsTime2 = bHistoryRecord.getTimestamp();
                    if (bAbsTime != null && !bAbsTime.isNull() && bAbsTime2.isBefore(bAbsTime)) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Unable to append out-of-order record to ").append(this.getConfig().getId().toString());
                        stringBuffer.append(": ").append(bHistoryRecord.toString());
                        System.out.println(stringBuffer.toString());
                    } else {
                        if (!this.doAppend(bHistoryRecord)) {
                            return n2;
                        }
                        ++n2;
                        bAbsTime = bAbsTime2;
                    }
                    ++n3;
                }
            }
            catch (IOException iOException) {
                throw new HistoryException(iOException);
            }
        }
    }

    protected abstract boolean doAppend(BHistoryRecord var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(BHistoryRecord bHistoryRecord, BHistoryRecord bHistoryRecord2) throws HistoryException, UnsupportedOperationException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            this.open();
            try {
                this.doUpdate(bHistoryRecord, bHistoryRecord2);
            }
            catch (IOException iOException) {
                throw new HistoryException(iOException);
            }
            return;
        }
    }

    protected abstract void doUpdate(BHistoryRecord var1, BHistoryRecord var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readConfig() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            RandomAccessFileInputStream randomAccessFileInputStream = new RandomAccessFileInputStream(this.access, 12L);
            try {
                BHistoryConfig bHistoryConfig = (BHistoryConfig)new ValueDocDecoder((InputStream)randomAccessFileInputStream).decodeDocument();
                BHistoryId bHistoryId = bHistoryConfig.getId();
                if (this.local && !bHistoryId.getDeviceName().equals(Sys.getStation().getStationName())) {
                    bHistoryId = BHistoryId.make(Sys.getStation().getStationName(), bHistoryId.getHistoryName());
                    bHistoryConfig.setId(bHistoryId);
                }
                this.setConfig(bHistoryConfig);
            }
            catch (Exception exception) {
                throw new HistoryException(exception);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeConfig() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            boolean bl;
            block8: {
                bl = this.isOpen();
                if (!bl) {
                    this.open();
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ValueDocEncoder valueDocEncoder = new ValueDocEncoder((OutputStream)byteArrayOutputStream);
                    valueDocEncoder.encodeDocument((BValue)this.getConfig());
                    int n = byteArrayOutputStream.size();
                    if (n > this.dataOffset - 12) {
                        this.doResize(this.getConfig().getCapacity(), this.getConfig().getFullPolicy());
                        break block8;
                    }
                    RandomAccessFileOutputStream randomAccessFileOutputStream = new RandomAccessFileOutputStream(this.access, 12L);
                    ValueDocEncoder valueDocEncoder2 = new ValueDocEncoder((OutputStream)randomAccessFileOutputStream);
                    valueDocEncoder2.encodeDocument((BValue)this.getConfig());
                    randomAccessFileOutputStream.flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!bl) {
                this.close();
            }
            return;
        }
    }

    public void doConfigChanged() {
        if (this.isOpen() && !this.resizing) {
            try {
                this.writeConfig();
            }
            catch (Exception exception) {
                BHistoryService.logger.error("Unable to save configuration for " + (Object)((Object)this.getConfig().getId()), (Throwable)exception);
            }
        }
    }

    public RandomAccess getAccess() {
        if (this.dataAccess == null) {
            this.dataAccess = new FileRandomAccess(this.access, this.dataOffset);
        }
        return this.dataAccess;
    }

    public void seek(long l) throws IOException {
        this.access.seek((long)this.dataOffset + l);
    }

    public long pos() throws IOException {
        return this.access.getFilePointer() - (long)this.dataOffset;
    }

    public long length() throws IOException {
        return this.access.length() - (long)this.dataOffset;
    }

    public void setLength(long l) throws IOException {
        this.access.setLength(l + (long)this.dataOffset);
    }

    public DataOutput out() {
        return this.output;
    }

    public DataInput in() {
        return this.access;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.local = false;
        this.version = 1;
        this.resizing = false;
        this.lockSync = new Object();
        this.appendQueue = new Queue();
        this.locked = false;
    }

    public BFileHistoryTable() {
        this.this();
    }

    public BFileHistoryTable(BHistoryConfig bHistoryConfig) {
        super(bHistoryConfig);
        this.this();
    }

    static {
        Class clazz = class$com$tridium$history$file$BFileHistoryTable;
        if (clazz == null) {
            clazz = class$com$tridium$history$file$BFileHistoryTable = BFileHistoryTable.class("[Lcom.tridium.history.file.BFileHistoryTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"history.png");
    }
}

