/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.db;

import com.tridium.history.db.BLocalDbHistory;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.sys.metrics.Metrics;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConfigIndex {
    private static Comparator devNameComparator = new DeviceNameComparator();
    private static Comparator histNameComparator = new HistoryNameComparator();
    private static final Object INIT = new Object();
    private static final BIHistory[] NONE = new BIHistory[0];
    private BLocalHistoryDatabase db;
    private HashMap byDevice;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() {
        BHistoryDevice[] bHistoryDeviceArray = this.db.listDevicesFromFile();
        int n = bHistoryDeviceArray.length;
        HashMap hashMap = this.byDevice;
        synchronized (hashMap) {
            int n2 = 0;
            while (n2 < n) {
                this.byDevice.put(bHistoryDeviceArray[n2].getDeviceName(), INIT);
                ++n2;
            }
            return;
        }
    }

    public Cursor cursor() {
        return new AllCursor(this.db, this);
    }

    public Cursor cursor(BHistoryDevice bHistoryDevice) {
        return new DeviceCursor(this.db, this, bHistoryDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BHistoryConfig get(BHistoryId bHistoryId) {
        HashMap hashMap = this.lookupDevice(bHistoryId.getDeviceName(), false);
        if (hashMap == null) {
            return null;
        }
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            return (BHistoryConfig)((Object)hashMap.get((Object)bHistoryId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deviceExists(String string) {
        HashMap hashMap = this.byDevice;
        synchronized (hashMap) {
            boolean bl = false;
            if (this.byDevice.get(string) == null) return bl;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BHistoryDevice[] listDevices(boolean bl) {
        String[] stringArray = null;
        HashMap hashMap = this.byDevice;
        synchronized (hashMap) {
            stringArray = this.byDevice.keySet().toArray(new String[this.byDevice.size()]);
        }
        int n = stringArray.length;
        BHistoryDevice[] bHistoryDeviceArray = new BHistoryDevice[n];
        int n2 = 0;
        while (n2 < n) {
            bHistoryDeviceArray[n2] = new BHistoryDevice(this.db, stringArray[n2]);
            ++n2;
        }
        if (bl) {
            SortUtil.sort((Object[])bHistoryDeviceArray, (Object[])bHistoryDeviceArray, (Comparator)devNameComparator);
        }
        return bHistoryDeviceArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeDevice(String string) {
        HashMap hashMap = this.byDevice;
        synchronized (hashMap) {
            if (this.deviceExists(string)) {
                this.byDevice.remove(string);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BIHistory[] listHistories(BHistoryDevice bHistoryDevice, boolean bl) {
        HashMap hashMap = this.lookupDevice(bHistoryDevice.getDeviceName(), false);
        if (hashMap == null) {
            return NONE;
        }
        BHistoryConfig[] bHistoryConfigArray = null;
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            bHistoryConfigArray = hashMap.values().toArray(new BHistoryConfig[hashMap.size()]);
        }
        int n = bHistoryConfigArray.length;
        Object[] objectArray = new BIHistory[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = new BLocalDbHistory(this.db, bHistoryConfigArray[n2].getId());
            ++n2;
        }
        if (bl) {
            SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)histNameComparator);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(BHistoryId bHistoryId, BHistoryConfig bHistoryConfig) {
        HashMap hashMap = this.lookupDevice(bHistoryId.getDeviceName(), true);
        if (hashMap == null) return;
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            hashMap.put(bHistoryId, bHistoryConfig);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(BHistoryId bHistoryId, BHistoryConfig bHistoryConfig) {
        HashMap hashMap = this.lookupDevice(bHistoryId.getDeviceName(), true);
        if (hashMap == null) return;
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            hashMap.put(bHistoryId, bHistoryConfig);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(BHistoryId bHistoryId) {
        HashMap hashMap = this.lookupDevice(bHistoryId.getDeviceName(), false);
        if (hashMap == null) return;
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            hashMap.remove((Object)bHistoryId);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final HashMap lookupDevice(String string, boolean bl) {
        HashMap hashMap = null;
        HashMap hashMap2 = this.byDevice;
        // MONITORENTER : hashMap2
        Object object = this.byDevice.get(string);
        if (object == null && !bl) {
            // MONITOREXIT : hashMap2
            return null;
        }
        if (object != null && object != INIT) {
            // MONITOREXIT : hashMap2
            return (HashMap)object;
        }
        hashMap = new HashMap();
        object = this.db.listHistoriesFromFile(new BHistoryDevice(this.db, string));
        int n = 0;
        while (n < ((V)object).length) {
            try {
                BHistoryConfig bHistoryConfig = object[n].getConfig();
                if (!Metrics.incrementHistory()) {
                    BHistoryDatabase.log.error("Exceeded history limit");
                    throw new HistoryException("Exceeded history limit");
                }
                hashMap.put(object[n].getId(), bHistoryConfig);
            }
            catch (Exception exception) {
                BHistoryDatabase.log.error("Cannot get configuration for history: " + (Object)((Object)object[n].getId()), (Throwable)exception);
            }
            ++n;
        }
        hashMap2 = this.byDevice;
        // MONITORENTER : hashMap2
        Object v = this.byDevice.get(string);
        if (v != null && v != INIT) {
            hashMap = (HashMap)v;
            // MONITOREXIT : hashMap2
            return hashMap;
        }
        this.byDevice.put(string, hashMap);
        return hashMap;
    }

    private final /* synthetic */ void this() {
        this.byDevice = new HashMap(101);
    }

    public ConfigIndex(BLocalHistoryDatabase bLocalHistoryDatabase) {
        this.this();
        this.db = bLocalHistoryDatabase;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class AllCursor
    implements Cursor {
        private BHistorySpace space;
        private ConfigIndex index;
        private boolean done;
        private BHistoryConfig cfg;
        private Iterator current;
        private BHistoryDevice[] devices;
        private int deviceIndex;
        static /* synthetic */ Class class$javax$baja$history$BHistoryConfig;

        public Context getContext() {
            return null;
        }

        public BObject get() {
            if (this.done) {
                throw new IllegalStateException("No more elements.");
            }
            if (this.current == null) {
                throw new IllegalStateException("get() before next()");
            }
            return this.cfg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean next() {
            block11: {
                if (this.done) {
                    return false;
                }
                if (this.current != null) ** GOTO lbl36
                this.devices = this.space.listDevices();
                if (this.devices.length == 0) {
                    return this.toEnd();
                }
                this.deviceIndex = 0;
                var1_1 = ConfigIndex.access$0(this.index, this.devices[this.deviceIndex].getDeviceName(), false);
                if (var1_1 != null) break block11;
                this.current = new HashMap<K, V>().values().iterator();
                ** GOTO lbl36
            }
            var2_2 = var1_1;
            synchronized (var2_2) {
                this.current = var1_1.values().iterator();
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                if (true) ** GOTO lbl36
            }
            do {
                ++this.deviceIndex;
                if (this.deviceIndex == this.devices.length) {
                    return this.toEnd();
                }
                var1_1 = ConfigIndex.access$0(this.index, this.devices[this.deviceIndex].getDeviceName(), false);
                if (var1_1 == null) {
                    this.current = new HashMap<K, V>().values().iterator();
                    continue;
                }
                var2_2 = var1_1;
                synchronized (var2_2) {
                    this.current = var1_1.values().iterator();
                }
lbl36:
                // 5 sources

            } while (!this.current.hasNext());
            this.cfg = (BHistoryConfig)this.current.next();
            return true;
        }

        public boolean nextComponent() {
            return this.next();
        }

        public boolean next(Class clazz) {
            Class clazz2 = class$javax$baja$history$BHistoryConfig;
            if (clazz2 == null) {
                clazz2 = class$javax$baja$history$BHistoryConfig = AllCursor.class("[Ljavax.baja.history.BHistoryConfig;", false);
            }
            if (!clazz2.isAssignableFrom(clazz)) {
                return this.toEnd();
            }
            return this.next();
        }

        private final boolean toEnd() {
            this.done = true;
            this.devices = null;
            return false;
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final /* synthetic */ void this() {
            this.done = false;
        }

        public AllCursor(BHistorySpace bHistorySpace, ConfigIndex configIndex) {
            this.this();
            this.space = bHistorySpace;
            this.index = configIndex;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class DeviceCursor
    implements Cursor {
        private BHistorySpace space;
        private ConfigIndex index;
        private BHistoryDevice device;
        private BHistoryConfig cfg;
        private Iterator i;
        private boolean done;
        static /* synthetic */ Class class$javax$baja$history$BHistoryConfig;

        public Context getContext() {
            return null;
        }

        public BObject get() {
            if (this.done) {
                throw new IllegalStateException("No more elements.");
            }
            if (this.i == null) {
                throw new IllegalStateException("get() before next()");
            }
            return this.cfg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean next() {
            if (this.done) {
                return false;
            }
            if (this.i == null) {
                HashMap hashMap = this.index.lookupDevice(this.device.getDeviceName(), false);
                if (hashMap == null) {
                    this.done = true;
                    return false;
                }
                HashMap hashMap2 = hashMap;
                synchronized (hashMap2) {
                    this.i = hashMap.values().iterator();
                }
            }
            if (!this.i.hasNext()) {
                this.done = true;
                return false;
            }
            this.cfg = (BHistoryConfig)((Object)this.i.next());
            return true;
        }

        public boolean nextComponent() {
            return this.next();
        }

        public boolean next(Class clazz) {
            Class clazz2 = class$javax$baja$history$BHistoryConfig;
            if (clazz2 == null) {
                clazz2 = class$javax$baja$history$BHistoryConfig = DeviceCursor.class("[Ljavax.baja.history.BHistoryConfig;", false);
            }
            if (!clazz2.isAssignableFrom(clazz)) {
                this.done = true;
                return false;
            }
            return this.next();
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final /* synthetic */ void this() {
            this.done = false;
        }

        public DeviceCursor(BHistorySpace bHistorySpace, ConfigIndex configIndex, BHistoryDevice bHistoryDevice) {
            this.this();
            this.space = bHistorySpace;
            this.index = configIndex;
            this.device = bHistoryDevice;
        }
    }

    private static class DeviceNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            BHistoryDevice bHistoryDevice = (BHistoryDevice)((Object)object);
            BHistoryDevice bHistoryDevice2 = (BHistoryDevice)((Object)object2);
            return bHistoryDevice.getDeviceName().compareTo(bHistoryDevice2.getDeviceName());
        }

        public boolean equals(Object object) {
            return object instanceof DeviceNameComparator;
        }

        private DeviceNameComparator() {
        }
    }

    private static class HistoryNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((BIHistory)object).getNavDisplayName(null).compareTo(((BIHistory)object2).getNavDisplayName(null));
        }

        public boolean equals(Object object) {
            return object instanceof HistoryNameComparator;
        }

        private HistoryNameComparator() {
        }
    }
}

