/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.db;

import com.tridium.bql.collection.BObjectList;
import com.tridium.bql.collection.BObjectTable;
import com.tridium.bql.collection.TypeColumnList;
import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.history.BDataRecoveryHistoryRecorder;
import com.tridium.history.db.BHistoryDbTable;
import com.tridium.history.db.BLocalDbHistory;
import com.tridium.history.db.ConfigIndex;
import com.tridium.history.db.LocalDbCursor;
import com.tridium.history.db.TableHandle;
import com.tridium.history.file.BFileHistoryTable;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.archive.FileArchive;
import com.tridium.sys.Nre;
import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.resource.ResourceReport;
import com.tridium.util.EmptyCursor;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.baja.collection.BICollection;
import javax.baja.collection.BIList;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BStorageType;
import javax.baja.history.DuplicateHistoryException;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.io.ByteBuffer;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.PatternFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLocalHistoryDatabase
extends BHistoryDatabase {
    public static final Type TYPE;
    private static final int RESOURCE_CAP = 10000;
    public static final String ARCHIVE_ID = "history";
    public static Thread WARM_UP_THREAD;
    private static final int DEVICE_GROUPS = 10;
    private static final int HISTORY_GROUPS = 10;
    private HashMap byId;
    private File dbDir;
    private String localStationName;
    private BHistoryService service;
    private ConfigIndex configIndex;
    private boolean closing;
    private BDataRecoveryHistoryRecorder dataRecoveryRestorer;
    static /* synthetic */ Class class$com$tridium$history$db$BLocalHistoryDatabase;
    static /* synthetic */ Class class$javax$baja$history$BHistoryConfig;

    public Type getType() {
        return TYPE;
    }

    public String getDirectory() {
        if (this.dbDir == null) {
            return "";
        }
        return this.dbDir.getAbsolutePath();
    }

    public Cursor cursor() {
        if (this.configIndex == null) {
            return new EmptyCursor(null);
        }
        return this.configIndex.cursor();
    }

    public BIList toList() {
        return new BObjectList(this.cursor());
    }

    public BITable toTable() {
        return new BObjectTable((ColumnList)new TypeColumnList(BHistoryConfig.TYPE, null), (BICollection)this);
    }

    protected void doOpen() throws IOException {
        Object object;
        Object object2;
        if (this.dbDir == null) {
            FilePath filePath;
            this.dbDir = null;
            object2 = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            object = object2.getRuntimeDirectory(ARCHIVE_ID);
            BFileSpace bFileSpace = (BFileSpace)BOrd.make((String)"file:").get();
            BIFile bIFile = bFileSpace.findFile(filePath = new FilePath((String)object));
            if (bIFile == null) {
                BDirectory bDirectory = bFileSpace.makeDir(filePath);
                this.dbDir = ((BLocalFileStore)bDirectory.getStore()).getLocalFile();
            } else {
                this.dbDir = ((BLocalFileStore)bIFile.getStore()).getLocalFile();
            }
        } else if (!this.dbDir.exists()) {
            this.dbDir.mkdirs();
        }
        if (Sys.getStation() != null) {
            this.localStationName = Sys.getStation().getStationName();
        }
        if (((File)(object2 = this.getDeviceDirectoryRaw(this.localStationName))).exists() && ((File)object2).isDirectory() && !((File)object2).renameTo((File)(object = this.getDeviceDirectory(this.localStationName)))) {
            log.error("Cannot rename local directory.  Old data for local histories is left in " + ((File)object2).getAbsolutePath());
        }
        this.configIndex = new ConfigIndex(this);
        this.configIndex.init();
        if (System.getProperty("niagara.history.warmup", "true").equalsIgnoreCase("true")) {
            WARM_UP_THREAD = new Thread(new Runnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void run() {
                    BRelTime bRelTime = BRelTime.makeMinutes((int)5);
                    try {
                        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                        bRelTime = bHistoryService.getMaxOpenTime();
                    }
                    catch (Exception exception) {}
                    long l = bRelTime.getMillis();
                    try {
                        try {
                            Thread.sleep(2000L);
                            long l2 = Clock.ticks();
                            log.message("Starting async warmup of history config index...");
                            int n = 0;
                            Cursor cursor = BLocalHistoryDatabase.this.cursor();
                            while (true) {
                                if (!cursor.next()) {
                                    log.message("Async history config index warmup completed in " + (Clock.ticks() - l2) + " ms.");
                                }
                                cursor.get();
                                if (n++ % 200 != 0) continue;
                                BLocalHistoryDatabase.this.closeUnusedTables(l);
                            }
                        }
                        catch (Exception exception) {
                            log.error("Problem during async history config index warmup.", (Throwable)exception);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        if (Thread.currentThread() == WARM_UP_THREAD) {
                            WARM_UP_THREAD = null;
                        }
                        BLocalHistoryDatabase.this.closeUnusedTables(l);
                        throw throwable;
                    }
                    {
                        Object var5_10 = null;
                    }
                    if (Thread.currentThread() == WARM_UP_THREAD) {
                        WARM_UP_THREAD = null;
                    }
                    BLocalHistoryDatabase.this.closeUnusedTables(l);
                }
            }, "HistoryConfigIndexWarmUp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doClose() {
        this.closing = true;
        var1_1 = null;
        var2_2 = this.byId;
        synchronized (var2_2) {
            var1_1 = this.byId.values().toArray(new BHistoryDbTable[this.byId.size()]);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            var4_3 = 0;
            if (true) ** GOTO lbl16
        }
        do {
            if ((var5_4 = var1_1[var4_3]) != null) {
                var5_4.close();
            }
            ++var4_3;
lbl16:
            // 2 sources

        } while (var4_3 < var1_1.length);
        this.byId = new HashMap<K, V>(29);
        this.configIndex = null;
        this.closing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doFlush() {
        var1_1 = null;
        var2_2 = this.byId;
        synchronized (var2_2) {
            var1_1 = this.byId.values().toArray(new BHistoryDbTable[this.byId.size()]);
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            var4_3 = 0;
            if (true) ** GOTO lbl17
        }
        do {
            try {
                var1_1[var4_3].flush();
            }
            catch (Exception v1) {}
            ++var4_3;
lbl17:
            // 2 sources

        } while (var4_3 < var1_1.length);
    }

    public void createArchive() throws IOException {
        BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        if (bSystemPlatformService == null || !bSystemPlatformService.archiveEnabled(ARCHIVE_ID)) {
            return;
        }
        long l = System.currentTimeMillis();
        FileArchive fileArchive = null;
        LocalDbCursor localDbCursor = new LocalDbCursor(this, null);
        while (localDbCursor.next()) {
            BHistoryId bHistoryId = (BHistoryId)localDbCursor.get();
            BHistoryDbTable bHistoryDbTable = this.getTable(bHistoryId);
            if (!(bHistoryDbTable instanceof BFileHistoryTable)) continue;
            BFileHistoryTable bFileHistoryTable = (BFileHistoryTable)bHistoryDbTable;
            bFileHistoryTable.lock();
            long l2 = Clock.ticks();
            bFileHistoryTable.flush();
            File[] fileArray = bFileHistoryTable.getFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (!fileArray[n].isDirectory()) {
                    String string = this.getRelativePath(fileArray[n]);
                    if (fileArchive == null) {
                        fileArchive = bSystemPlatformService.createFileArchive(ARCHIVE_ID);
                    }
                    fileArchive.writeFile(fileArray[n], string);
                }
                ++n;
            }
            long l3 = Clock.ticks();
            if (log.isTraceOn()) {
                log.trace("Archived " + bFileHistoryTable.getConfig().getId().encodeToString() + " (" + (l3 - l2) + "ms)");
            }
            bFileHistoryTable.unlock();
        }
        if (fileArchive != null) {
            fileArchive.close();
        }
        long l4 = System.currentTimeMillis();
        log.message("Saved history archive (" + (l4 - l) + "ms)");
    }

    String getRelativePath(File file) {
        String string = this.dbDir.getAbsolutePath();
        return file.getAbsolutePath().substring(string.length() + 1);
    }

    public BHistoryDevice[] listDevices() {
        this.checkOpen();
        return this.configIndex.listDevices(true);
    }

    BHistoryDevice[] listDevicesFromFile() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.dbDir.list();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("station")) {
                arrayList.add(this.localStationName);
            } else {
                object = new File(this.dbDir, stringArray[n]);
                if (((File)object).exists() && ((File)object).isDirectory()) {
                    String[] stringArray2 = ((File)object).list();
                    arrayList.ensureCapacity(arrayList.size() + stringArray2.length);
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        arrayList.add(stringArray2[n2]);
                        ++n2;
                    }
                }
            }
            ++n;
        }
        n = arrayList.size();
        object = new BHistoryDevice[n];
        int n3 = 0;
        while (n3 < n) {
            object[n3] = new BHistoryDevice(this, (String)arrayList.get(n3));
            ++n3;
        }
        return object;
    }

    public BIHistory[] listHistories(BHistoryDevice bHistoryDevice) {
        this.checkOpen();
        return this.configIndex.listHistories(bHistoryDevice, true);
    }

    BIHistory[] listHistoriesFromFile(BHistoryDevice bHistoryDevice) {
        this.checkOpen();
        String string = bHistoryDevice.getDeviceName();
        File file = this.getDeviceDirectory(string);
        if (!file.exists()) {
            return new BLocalDbHistory[0];
        }
        ArrayList<BLocalDbHistory> arrayList = new ArrayList<BLocalDbHistory>();
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                String[] stringArray2 = file2.list();
                arrayList.ensureCapacity(arrayList.size() + stringArray2.length);
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (stringArray2[n2].endsWith(".hdb")) {
                        int n3 = stringArray2[n2].length();
                        BHistoryId bHistoryId = BHistoryId.make(string, stringArray2[n2].substring(0, n3 - 4));
                        BLocalDbHistory bLocalDbHistory = new BLocalDbHistory(this, bHistoryId);
                        arrayList.add(bLocalDbHistory);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList.toArray(new BLocalDbHistory[arrayList.size()]);
    }

    public boolean deviceExists(String string) {
        this.checkOpen();
        return this.configIndex.deviceExists(string);
    }

    public BHistoryDevice getDevice(String string) {
        this.checkOpen();
        if (this.deviceExists(string)) {
            return new BHistoryDevice(this, string);
        }
        return null;
    }

    public boolean exists(BHistoryId bHistoryId) {
        this.checkOpen();
        boolean bl = false;
        if (this.configIndex.get(bHistoryId) != null) {
            bl = true;
        }
        return bl;
    }

    public BIHistory getHistory(BHistoryId bHistoryId) {
        this.checkOpen();
        if (!this.exists(bHistoryId)) {
            return null;
        }
        return new BLocalDbHistory(this, bHistoryId);
    }

    public BHistoryConfig getConfig(BHistoryId bHistoryId) {
        this.checkOpen();
        return this.configIndex.get(bHistoryId);
    }

    public void setConfig(BHistoryConfig bHistoryConfig) {
        this.checkOpen();
        BHistoryId bHistoryId = bHistoryConfig.getId();
        if (!this.exists(bHistoryId)) {
            return;
        }
        BHistoryDbTable bHistoryDbTable = this.getTable(bHistoryId);
        BHistoryConfig bHistoryConfig2 = bHistoryDbTable.getConfig();
        bHistoryDbTable.setConfig(bHistoryConfig);
        this.configIndex.update(bHistoryId, bHistoryConfig);
        if (this.hasHistoryEventListeners() && !bHistoryConfig.equivalent((Object)bHistoryConfig2)) {
            this.fireHistoryEvent(BHistoryEvent.makeConfigChanged(bHistoryId, bHistoryConfig));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doDeleteHistory(BHistoryId bHistoryId, Context context) {
        Object object;
        this.checkOpen();
        BIHistory bIHistory = this.getHistory(bHistoryId);
        if (bIHistory != null && !(object = bIHistory.getPermissions(context)).hasAdminWrite()) {
            throw new PermissionException("User does not have permission to delete history " + (Object)((Object)bHistoryId));
        }
        object = this.byId;
        synchronized (object) {
            File file;
            BIHistory[] bIHistoryArray;
            Object object2;
            Object object3;
            block10: {
                BHistoryDbTable bHistoryDbTable;
                block9: {
                    bHistoryDbTable = (BHistoryDbTable)((Object)this.byId.get((Object)bHistoryId));
                    if (bHistoryDbTable != null) break block9;
                    object3 = this.getFile(bHistoryId, false);
                    if (!((File)object3).exists()) {
                        throw new HistoryNotFoundException(bHistoryId);
                    }
                    if (!((File)object3).delete()) {
                        throw new HistoryException("Cannot delete history " + (Object)((Object)bHistoryId) + '.');
                    }
                    break block10;
                }
                bHistoryDbTable.close();
                bHistoryDbTable.delete();
                this.byId.remove((Object)bHistoryId);
            }
            this.configIndex.remove(bHistoryId);
            if (context != null && (object3 = Nre.auditor) != null) {
                object2 = "";
                if (context != null && context.getUser() != null) {
                    object2 = context.getUser().getUsername();
                }
                object3.audit(new AuditEvent("Removed", "history:" + bHistoryId.encodeToString(), "", "", "", object2));
            }
            if ((object3 = bHistoryId.getDeviceName()) != null && (object2 = this.getDevice((String)object3)) != null && ((bIHistoryArray = this.listHistories((BHistoryDevice)((Object)object2))) == null || bIHistoryArray.length < 1) && (file = this.getDeviceDirectory((String)object3)) != null) {
                this.deleteDirectory(file);
                this.configIndex.removeDevice((String)object3);
                BOrd bOrd = BOrd.make((String)"local:|history:");
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRemoved((BOrd)bOrd, (String)object3, null));
            }
            return;
        }
    }

    private final void deleteDirectory(File file) {
        if (file != null) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                int n = 0;
                while (n < fileArray.length) {
                    if (fileArray[n].isDirectory()) {
                        this.deleteDirectory(fileArray[n]);
                    } else if (!fileArray[n].delete()) {
                        throw new HistoryException("Cannot delete file " + fileArray[n] + '.');
                    }
                    ++n;
                }
            }
            if (!file.delete()) {
                throw new HistoryException("Cannot delete directory " + file + '.');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void doRenameHistory(BHistoryId var1_1, String var2_2) {
        this.checkOpen();
        var3_3 = this.byId;
        // MONITORENTER : var3_3
        var5_4 = (BFileHistoryTable)this.getTable(var1_1);
        if (var5_4 == null) {
            throw new HistoryNotFoundException(var1_1);
        }
        var6_5 = var5_4.getTableLock();
        // MONITORENTER : var6_5
        ** try [egrp 2[TRYBLOCK] [3 : 57->147)] { 
lbl12:
        // 1 sources

        {
            var5_4.close();
            var8_6 = BHistoryId.make(var1_1.getDeviceName(), var2_2);
            var9_7 = this.getFile(var1_1, false);
            var10_8 = this.getFile(var8_6, true);
            if (var9_7.renameTo(var10_8)) {
                var5_4.delete();
                BFileHistoryTable.setId(var10_8, var8_6);
                this.configIndex.remove(var1_1);
                this.configIndex.add(var8_6, this.getTable(var8_6).getConfig());
                // MONITOREXIT : var6_5
                // MONITOREXIT : var3_3
                return;
            }
        }
lbl30:
        // 1 sources

        catch (Throwable v1) {
            // MONITOREXIT : var6_5
            throw v1;
        }
        var5_4 = (BFileHistoryTable)this.getTable(var1_1);
        if (var5_4 == null) {
            throw new HistoryNotFoundException(var1_1);
        }
        var5_4.renameHistory(var2_2);
        // MONITOREXIT : var3_3
    }

    public void resizeHistory(BHistoryConfig bHistoryConfig) {
        this.resizeHistory(bHistoryConfig.getId(), bHistoryConfig.getCapacity(), bHistoryConfig.getFullPolicy());
    }

    public void clearAllRecords(BHistoryId bHistoryId, Context context) {
        Object object;
        this.checkOpen();
        BIHistory bIHistory = this.getHistory(bHistoryId);
        if (bIHistory != null && !(object = bIHistory.getPermissions(context)).hasAdminWrite()) {
            throw new PermissionException("User does not have permission to clear all records from history " + (Object)((Object)bHistoryId));
        }
        object = this.getTable(bHistoryId);
        if (object == null) {
            throw new HistoryNotFoundException(bHistoryId);
        }
        int n = object.getRecordCount();
        object.clear();
        Auditor auditor = Nre.auditor;
        if (auditor != null) {
            String string = "";
            if (context != null && context.getUser() != null) {
                string = context.getUser().getUsername();
            }
            auditor.audit(new AuditEvent("Invoked", "history:" + bHistoryId.encodeToString(), "Clear", Integer.toString(n) + " records", Integer.toString(object.getRecordCount()) + " records", string));
        }
        if (this.hasHistoryEventListeners()) {
            this.fireHistoryEvent(BHistoryEvent.makeClearedAll(bHistoryId));
        }
    }

    public void clearOldRecords(BHistoryId bHistoryId, BAbsTime bAbsTime, Context context) {
        Object object;
        this.checkOpen();
        BIHistory bIHistory = this.getHistory(bHistoryId);
        if (bIHistory != null && !(object = bIHistory.getPermissions(context)).hasAdminWrite()) {
            throw new PermissionException("User does not have permission to clear old records from history " + (Object)((Object)bHistoryId));
        }
        object = this.getTable(bHistoryId);
        if (object == null) {
            throw new HistoryNotFoundException(bHistoryId);
        }
        int n = object.getRecordCount();
        object.clear(bAbsTime);
        Auditor auditor = Nre.auditor;
        if (auditor != null) {
            String string = "";
            if (context != null && context.getUser() != null) {
                string = context.getUser().getUsername();
            }
            auditor.audit(new AuditEvent("Invoked", "history:" + bHistoryId.encodeToString(), "Clear before " + bAbsTime.toString((Context)BHistoryRecord.TIMESTAMP_FACETS), Integer.toString(n) + " records", Integer.toString(object.getRecordCount()) + " records", string));
        }
        if (this.hasHistoryEventListeners()) {
            this.fireHistoryEvent(BHistoryEvent.makeClearedOld(bHistoryId, bAbsTime));
        }
    }

    protected final void doCreateHistory(BHistoryConfig bHistoryConfig) {
        if (!Metrics.incrementHistory()) {
            log.error("Exceeded history limit");
            throw new HistoryException("Exceeded history limit");
        }
        log.trace("Creating history for " + (Object)((Object)bHistoryConfig.getId()) + "...");
        if (this.exists(bHistoryConfig.getId())) {
            throw new DuplicateHistoryException(bHistoryConfig.getId());
        }
        bHistoryConfig = (BHistoryConfig)bHistoryConfig.newCopy(true);
        BFileHistoryTable bFileHistoryTable = null;
        if (bHistoryConfig.getStorageType() == BStorageType.file) {
            bFileHistoryTable = BFileHistoryTable.make(this, bHistoryConfig, this.isLocal(bHistoryConfig.getId()));
        } else {
            log.warning("Unsupported storage type: " + (Object)((Object)bHistoryConfig.getStorageType()) + ", using file storage.");
            bFileHistoryTable = BFileHistoryTable.make(this, bHistoryConfig, this.isLocal(bHistoryConfig.getId()));
        }
        try {
            bFileHistoryTable.open();
        }
        catch (Exception exception) {
            try {
                bFileHistoryTable.delete();
            }
            catch (Exception exception2) {}
            throw new HistoryException(exception);
        }
        bFileHistoryTable.close();
        this.configIndex.add(bHistoryConfig.getId(), bHistoryConfig);
        log.trace("History created for " + (Object)((Object)bHistoryConfig.getId()) + '.');
    }

    public void recreateHistory(BHistoryConfig bHistoryConfig, boolean bl) {
        bHistoryConfig = (BHistoryConfig)bHistoryConfig.newCopy(true);
        this.checkOpen();
        if (!this.exists(bHistoryConfig.getId())) {
            this.createHistory(bHistoryConfig);
            return;
        }
        BHistoryDbTable bHistoryDbTable = this.getTable(bHistoryConfig.getId());
        TableHandle tableHandle = bHistoryDbTable.getTableHandle();
        if (bl) {
            BHistoryId bHistoryId = bHistoryConfig.getId();
            String string = bHistoryId.getHistoryName();
            int n = 0;
            BHistoryId bHistoryId2 = BHistoryId.make(bHistoryId.getDeviceName(), string + "_cfg0");
            while (this.exists(bHistoryId2)) {
                bHistoryId2 = BHistoryId.make(bHistoryId2.getDeviceName(), string + "_cfg" + ++n);
            }
            this.renameHistory(bHistoryId, bHistoryId2.getHistoryName());
            bHistoryDbTable.close();
        } else {
            this.deleteHistory(bHistoryConfig.getId(), null);
        }
        this.createHistory(bHistoryConfig);
    }

    public void resizeHistory(BHistoryId bHistoryId, BCapacity bCapacity, BFullPolicy bFullPolicy) {
        this.checkOpen();
        BHistoryDbTable bHistoryDbTable = this.getTable(bHistoryId);
        if (bHistoryDbTable == null) {
            throw new HistoryNotFoundException(bHistoryId);
        }
        bHistoryDbTable.resize(bCapacity, bFullPolicy);
        if (this.hasHistoryEventListeners()) {
            this.fireHistoryEvent(BHistoryEvent.makeResized(bHistoryId, bCapacity, bFullPolicy));
        }
    }

    public BHistoryConfig[] getConfigs(String string) {
        BHistoryDevice[] bHistoryDeviceArray = this.listDevices();
        if (bHistoryDeviceArray == null) {
            return null;
        }
        Class clazz = class$javax$baja$history$BHistoryConfig;
        if (clazz == null) {
            clazz = class$javax$baja$history$BHistoryConfig = BLocalHistoryDatabase.class("[Ljavax.baja.history.BHistoryConfig;", false);
        }
        Array array = new Array(clazz);
        PatternFilter[] patternFilterArray = PatternFilter.parseList((String)string);
        if (patternFilterArray.length < 1) {
            return null;
        }
        int n = 0;
        while (n < bHistoryDeviceArray.length) {
            BIHistory[] bIHistoryArray = this.listHistories(bHistoryDeviceArray[n]);
            if (bIHistoryArray != null) {
                int n2 = 0;
                while (n2 < bIHistoryArray.length) {
                    BHistoryConfig bHistoryConfig = bIHistoryArray[n2].getConfig();
                    if (BLocalHistoryDatabase.acceptSystemTags(bHistoryConfig, patternFilterArray)) {
                        array.add((Object)bHistoryConfig);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (array.size() < 1) {
            return null;
        }
        return (BHistoryConfig[])array.trim();
    }

    public static final boolean acceptSystemTags(BHistoryConfig bHistoryConfig, PatternFilter[] patternFilterArray) {
        String[] stringArray = bHistoryConfig.getSystemTags().getNames();
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{""};
        }
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < patternFilterArray.length) {
                if (patternFilterArray[n2].accept(stringArray[n])) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BHistoryDbTable getTable(BHistoryId var1_1) throws HistoryException {
        block16: {
            var2_2 = null;
            if (var1_1 != null) {
                block15: {
                    var3_3 = this.byId;
                    synchronized (var3_3) {
                        var2_2 = (BHistoryDbTable)this.byId.get((Object)var1_1);
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 14] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                        v0 = false;
                        if (var2_2 != null) break block15;
                    }
                    v0 = true;
                }
                if (!(var6_4 = v0)) {
                    var7_5 = var2_2.getTableLock();
                    synchronized (var7_5) {
                        var6_4 = var2_2.isOpen() ^ true;
                        if (!var6_4) {
                            var2_2.updateLastAccess();
                        }
                    }
                }
                var3_3 = this.byId;
                synchronized (var3_3) {
                    if (!var6_4 || !(var7_5 = this.getFile(var1_1, false)).exists()) break block16;
                    ** try [egrp 3[TRYBLOCK] [5, 6 : 116->135)] { 
lbl30:
                    // 1 sources

                    {
                        var2_2 = BFileHistoryTable.createFromFile(this, (File)var7_5, this.isLocal(var1_1));
                        var2_2.open();
                    }
lbl36:
                    // 1 sources

                    catch (HistoryException var8_6) {
                        throw var8_6;
                    }
lbl38:
                    // 1 sources

                    catch (Exception var8_7) {
                        throw new HistoryException(var8_7);
                    }
                    this.byId.put(var1_1, var2_2);
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void tableClosed(BHistoryDbTable bHistoryDbTable) {
        if (this.closing) {
            return;
        }
        if (bHistoryDbTable.getDatabase() != this) {
            return;
        }
        BHistoryConfig bHistoryConfig = bHistoryDbTable.getConfig();
        if (bHistoryConfig == null) return;
        HashMap hashMap = this.byId;
        synchronized (hashMap) {
            this.byId.remove((Object)bHistoryConfig.getId());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void closeUnusedTables(long l) {
        BHistoryDbTable[] bHistoryDbTableArray = null;
        HashMap hashMap = this.byId;
        // MONITORENTER : hashMap
        bHistoryDbTableArray = this.byId.values().toArray(new BHistoryDbTable[this.byId.size()]);
        // MONITOREXIT : hashMap
        long l2 = Clock.ticks();
        int n = bHistoryDbTableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = bHistoryDbTableArray[n2].getTableLock();
            // MONITORENTER : object
            {
                if (!bHistoryDbTableArray[n2].checkLastAccess(l2, l)) {
                    bHistoryDbTableArray[n2].close();
                }
                // MONITOREXIT : object
                ++n2;
            }
        }
    }

    public boolean isLocal(BHistoryId bHistoryId) {
        return bHistoryId.getDeviceName().equals(this.localStationName);
    }

    public String getLocalStationName() {
        return this.localStationName;
    }

    public File getDeviceDirectory(String string) {
        File file = null;
        if (string.equals(this.localStationName)) {
            file = new File(this.dbDir, "station");
        } else {
            int n = (string.hashCode() & Integer.MAX_VALUE) % 10;
            String string2 = "seg" + n;
            file = new File(this.dbDir, string2 + File.separatorChar + string);
        }
        return file;
    }

    private final File getDeviceDirectoryRaw(String string) {
        int n = (string.hashCode() & Integer.MAX_VALUE) % 10;
        String string2 = "seg" + n;
        return new File(this.dbDir, string2 + File.separatorChar + string);
    }

    public File getFile(BHistoryId bHistoryId, boolean bl) {
        String string = bHistoryId.getDeviceName();
        String string2 = bHistoryId.getHistoryName();
        File file = this.getDeviceDirectory(string);
        int n = (string2.hashCode() & Integer.MAX_VALUE) % 10;
        String string3 = "seg" + n;
        File file2 = new File(file, string3);
        if (bl) {
            file2.mkdirs();
        }
        return new File(file2, string2 + ".hdb");
    }

    public boolean dataRecoveryRestore(IDataRecoveryRecord iDataRecoveryRecord) throws Exception {
        if (this.dataRecoveryRestorer != null) {
            return this.dataRecoveryRestorer.restore(this, iDataRecoveryRecord);
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dataRecoverySpy(SpyWriter spyWriter, Iterator iterator) throws Exception {
        Object object;
        int n;
        Object[] objectArray;
        Hashtable<DataRecoverySpyStat, DataRecoverySpyStat> hashtable = new Hashtable<DataRecoverySpyStat, DataRecoverySpyStat>();
        int n2 = 0;
        int n3 = 0;
        BHistoryEvent bHistoryEvent = BHistoryEvent.makeDbSaved();
        while (true) {
            Object var8_7;
            if (!iterator.hasNext()) {
                if (n3 <= 0) return;
                objectArray = new DataRecoverySpyStat[n3];
                objectArray = hashtable.values().toArray(objectArray);
                SortUtil.rsort((Object[])objectArray);
                n = objectArray.length;
                object = n2 + " History Events Recently Recorded in data recovery";
                if (n > BDataRecoveryComponentRecorder.SPY_EVENT_LIMIT) {
                    n = BDataRecoveryComponentRecorder.SPY_EVENT_LIMIT;
                    object = (String)object + " (truncated to " + n + " rows)";
                }
                break;
            }
            try {
                try {
                    object = (IDataRecoveryRecord)iterator.next();
                    byte[] byArray = object.getKey();
                    ByteBuffer byteBuffer = new ByteBuffer(byArray);
                    BHistoryEvent bHistoryEvent2 = (BHistoryEvent)bHistoryEvent.decode((DataInput)byteBuffer);
                    byte[] byArray2 = object.getData();
                    int n4 = byArray2 != null ? byArray.length + byArray2.length : byArray.length;
                    DataRecoverySpyStat dataRecoverySpyStat = (DataRecoverySpyStat)hashtable.get(new DataRecoverySpyStat(bHistoryEvent2));
                    if (dataRecoverySpyStat == null) {
                        dataRecoverySpyStat = new DataRecoverySpyStat(bHistoryEvent2);
                        hashtable.put(dataRecoverySpyStat, dataRecoverySpyStat);
                        ++n3;
                    }
                    dataRecoverySpyStat.event = bHistoryEvent2;
                    ++dataRecoverySpyStat.occurrences;
                    dataRecoverySpyStat.totalSize += n4;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                var8_7 = null;
                ++n2;
                throw throwable;
            }
            {
                var8_7 = null;
                ++n2;
                continue;
            }
            break;
        }
        spyWriter.startTable(true);
        spyWriter.trTitle(object, 4);
        spyWriter.w((Object)"<tr><th>Occurrences</th><th>Total Bytes</th><th>Avg Bytes</th><th>Last History Event of its Type</th></tr>\n");
        int n5 = 0;
        while (true) {
            if (n5 >= n) {
                spyWriter.endTable();
                return;
            }
            double d = (double)((DataRecoverySpyStat)objectArray[n5]).totalSize / (double)((DataRecoverySpyStat)objectArray[n5]).occurrences;
            spyWriter.tr((Object)("" + ((DataRecoverySpyStat)objectArray[n5]).occurrences), (Object)("" + ((DataRecoverySpyStat)objectArray[n5]).totalSize), (Object)("" + d), (Object)((DataRecoverySpyStat)objectArray[n5]).event.toString(null));
            ++n5;
        }
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 21: {
                this.reportResources((ResourceReport)object);
                break;
            }
            case 1002: {
                this.dataRecoveryRestorer = (BDataRecoveryHistoryRecorder)object;
                return null;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void reportResources(ResourceReport resourceReport) {
        Cursor cursor = this.cursor();
        int n = 0;
        int n2 = 0;
        while (cursor.next()) {
            BHistoryConfig bHistoryConfig = (BHistoryConfig)cursor.get();
            ++n;
            BCapacity bCapacity = bHistoryConfig.getCapacity();
            n2 += this.toResourceUnits(bCapacity);
        }
        resourceReport.add(ARCHIVE_ID, n2);
        resourceReport.put("history.count", "" + n);
    }

    private final int toResourceUnits(BCapacity bCapacity) {
        if (bCapacity.isUnlimited()) {
            return 10000;
        }
        if (bCapacity.isByRecordCount()) {
            return Math.min(250 + bCapacity.getMaxRecords() / 10, 10000);
        }
        if (bCapacity.isByStorageSize()) {
            return (int)Math.min(250L + bCapacity.getMaxStorage() / 10L, 10000L);
        }
        System.out.println("WARNING: LocalHistoryDatabase unknown capacity");
        return 10000;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.byId = new HashMap(29);
        this.localStationName = "local";
        this.closing = false;
    }

    public BLocalHistoryDatabase(File file) {
        this.this();
        this.dbDir = file;
    }

    public BLocalHistoryDatabase(BHistoryService bHistoryService) {
        this.this();
        this.service = bHistoryService;
    }

    static {
        Class clazz = class$com$tridium$history$db$BLocalHistoryDatabase;
        if (clazz == null) {
            clazz = class$com$tridium$history$db$BLocalHistoryDatabase = BLocalHistoryDatabase.class("[Lcom.tridium.history.db.BLocalHistoryDatabase;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        WARM_UP_THREAD = null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class DataRecoverySpyStat
    implements Comparable {
        BHistoryEvent event;
        int occurrences;
        int totalSize;
        int hashCode;

        public int hashCode() {
            if (this.hashCode == -1) {
                int n = 11;
                n ^= this.event.getId();
                BHistoryId bHistoryId = this.event.getHistoryId();
                if (bHistoryId != null) {
                    n ^= bHistoryId.hashCode();
                }
                this.hashCode = n;
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof DataRecoverySpyStat) {
                DataRecoverySpyStat dataRecoverySpyStat = (DataRecoverySpyStat)object;
                boolean bl = false;
                if (this.event.getId() == dataRecoverySpyStat.event.getId() && (this.event.getHistoryId() == dataRecoverySpyStat.event.getHistoryId() || this.event.getHistoryId() != null && this.event.getHistoryId().equals((Object)dataRecoverySpyStat.event.getHistoryId()))) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public int compareTo(Object object) {
            DataRecoverySpyStat dataRecoverySpyStat = (DataRecoverySpyStat)object;
            int n = this.occurrences - dataRecoverySpyStat.occurrences;
            if (n == 0) {
                return 0;
            }
            if (n < 0) {
                return -1;
            }
            return 1;
        }

        private final /* synthetic */ void this() {
            this.occurrences = 0;
            this.totalSize = 0;
            this.hashCode = -1;
        }

        public DataRecoverySpyStat(BHistoryEvent bHistoryEvent) {
            this.this();
            this.event = bHistoryEvent;
        }
    }
}

