/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.collection;

import com.tridium.history.collection.ColumnSpec;
import com.tridium.history.collection.PathColumn;
import com.tridium.history.collection.PropertyColumn;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.timezone.BTimeZone;

public class HistoryColumns
implements ColumnList {
    private ArrayList list;
    private HashMap table;

    public static HistoryColumns getColumns(BHistoryConfig bHistoryConfig) {
        BHistoryRecord bHistoryRecord = bHistoryConfig.makeRecord();
        Property[] propertyArray = bHistoryRecord.getPropertiesArray();
        HistoryColumns historyColumns = new HistoryColumns(propertyArray.length);
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            BFacets bFacets = null;
            try {
                bFacets = (BFacets)bHistoryConfig.get(property.getName() + "Facets");
            }
            catch (Exception exception) {}
            if (property.getType() == BAbsTime.TYPE) {
                BTimeZone bTimeZone = bHistoryConfig.getTimeZone();
                if ((bFacets = bFacets != null ? BFacets.make((BFacets)bFacets, (String)"TimeZone", (BIDataValue)bTimeZone) : BFacets.make((String)"TimeZone", (BIDataValue)bTimeZone)).get("showSeconds") == null) {
                    bFacets = BFacets.make((BFacets)bFacets, (String)"showSeconds", (BIDataValue)BBoolean.TRUE);
                }
            }
            historyColumns.addColumn(new PropertyColumn(propertyArray[n], null, bFacets));
            ++n;
        }
        return historyColumns;
    }

    public static HistoryColumns getColumns(BStruct bStruct, ColumnSpec[] columnSpecArray) {
        HistoryColumns historyColumns = new HistoryColumns(columnSpecArray.length);
        int n = 0;
        while (n < columnSpecArray.length) {
            BFacets bFacets = columnSpecArray[n].facets;
            String string = columnSpecArray[n].name;
            if (string.indexOf(46) == -1) {
                Property property = bStruct.getProperty(columnSpecArray[n].name);
                if (property != null) {
                    historyColumns.addColumn(new PropertyColumn(property, columnSpecArray[n].displayName, bFacets));
                } else {
                    historyColumns.addColumn(new PathColumn((BObject)bStruct, string, columnSpecArray[n].displayName, bFacets));
                }
            } else {
                historyColumns.addColumn(new PathColumn((BObject)bStruct, string, columnSpecArray[n].displayName, bFacets));
            }
            ++n;
        }
        return historyColumns;
    }

    public void addColumn(Column column) {
        this.list.add(column);
        this.table.put(column.getName(), column);
        if (this.list.size() != this.table.size()) {
            throw new BajaRuntimeException("Duplicate column: " + column.getName());
        }
    }

    public int size() {
        return this.list.size();
    }

    public Column get(int n) {
        return (Column)this.list.get(n);
    }

    public Column get(String string) {
        return (Column)this.table.get(string);
    }

    public int indexOf(String string) {
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            if (((Column)this.list.get(n2)).getName().equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Column[] list() {
        return this.list.toArray(new Column[this.list.size()]);
    }

    public HistoryColumns(int n) {
        this.list = new ArrayList(n);
        this.table = new HashMap();
    }
}

