/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import com.tridium.history.HistoryConfigChange;
import java.util.ArrayList;
import javax.baja.history.BHistoryConfig;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;

public class HistoryConfigChanges {
    private ArrayList list = new ArrayList(2);

    public static HistoryConfigChanges compare(BHistoryConfig bHistoryConfig, BHistoryConfig bHistoryConfig2) {
        BValue bValue;
        Property property;
        SlotCursor slotCursor;
        HistoryConfigChanges historyConfigChanges = new HistoryConfigChanges();
        if (bHistoryConfig2 == bHistoryConfig) {
            return historyConfigChanges;
        }
        SlotCursor slotCursor2 = bHistoryConfig.getProperties();
        while (slotCursor2.next()) {
            slotCursor = slotCursor2.property();
            property = bHistoryConfig2.getProperty(slotCursor.getName());
            if (property == null) {
                historyConfigChanges.add(HistoryConfigChange.makeRemoved((Property)slotCursor, (BValue)slotCursor2.get()));
                continue;
            }
            bValue = (BValue)slotCursor2.get();
            BValue bValue2 = bHistoryConfig2.get(property);
            if (HistoryConfigChanges.equalProps(bHistoryConfig, (Property)slotCursor, bHistoryConfig2, property) && bValue.equivalent((Object)bValue2)) continue;
            HistoryConfigChange historyConfigChange = HistoryConfigChange.makeChanged((Property)slotCursor, bValue, property, bValue2);
            historyConfigChanges.add(historyConfigChange);
        }
        slotCursor = bHistoryConfig2.getProperties();
        while (slotCursor.next()) {
            property = slotCursor.property();
            bValue = bHistoryConfig.getProperty(property.getName());
            if (bValue != null) continue;
            historyConfigChanges.add(HistoryConfigChange.makeAdded(property, (BValue)slotCursor.get()));
        }
        return historyConfigChanges;
    }

    private static final boolean equalProps(BHistoryConfig bHistoryConfig, Property property, BHistoryConfig bHistoryConfig2, Property property2) {
        if (property == property2) {
            return true;
        }
        if (!property.getName().equals(property2.getName())) {
            return false;
        }
        if (!property.getType().equals(property2.getType())) {
            return false;
        }
        if (bHistoryConfig.getFlags((Slot)property) != bHistoryConfig2.getFlags((Slot)property2)) {
            return false;
        }
        return bHistoryConfig.getSlotFacets((Slot)property).equals((Object)bHistoryConfig2.getSlotFacets((Slot)property2));
    }

    public static void addMissingMetadata(BHistoryConfig bHistoryConfig, BHistoryConfig bHistoryConfig2, HistoryConfigChanges historyConfigChanges) {
        int n = historyConfigChanges.getChangeCount();
        int n2 = 0;
        while (n2 < n) {
            HistoryConfigChange historyConfigChange = historyConfigChanges.get(n2);
            Property property = historyConfigChange.getOldProperty();
            try {
                if (historyConfigChange.getChangeType() == 1 && property != null && Flags.isMetadata((BComplex)bHistoryConfig, (Slot)property)) {
                    bHistoryConfig2.add(property.getName(), historyConfigChange.getOldValue(), bHistoryConfig.getFlags((Slot)property), bHistoryConfig.getSlotFacets((Slot)property), null);
                }
            }
            catch (Exception exception) {
                String string = property != null ? property.getName() : "null";
                System.out.println("Could not re-add missing dynamic metadata slot '" + string + "' to the new config from the old config for " + (Object)((Object)bHistoryConfig.getId()));
                exception.printStackTrace();
            }
            ++n2;
        }
    }

    public int getChangeCount() {
        return this.list.size();
    }

    public HistoryConfigChange get(int n) {
        return (HistoryConfigChange)this.list.get(n);
    }

    public HistoryConfigChange get(String string) {
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            HistoryConfigChange historyConfigChange = (HistoryConfigChange)this.list.get(n2);
            Property property = historyConfigChange.getOldProperty();
            if (property != null && property.getName().equals(string)) {
                return historyConfigChange;
            }
            property = historyConfigChange.getNewProperty();
            if (property != null && property.getName().equals(string)) {
                return historyConfigChange;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("HistoryConfigChanges:\n");
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("  ").append((HistoryConfigChange)this.list.get(n2)).append('\n');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void add(HistoryConfigChange historyConfigChange) {
        this.list.add(historyConfigChange);
    }
}

