/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import javax.baja.sys.BValue;
import javax.baja.sys.Property;

public class HistoryConfigChange {
    public static final int PROPERTY_ADDED = 0;
    public static final int PROPERTY_REMOVED = 1;
    public static final int PROPERTY_CHANGED = 2;
    private Property oldProp;
    private BValue oldValue;
    private Property newProp;
    private BValue newValue;
    private int changeType;

    public static HistoryConfigChange makeAdded(Property property, BValue bValue) {
        return new HistoryConfigChange(null, null, property, bValue, 0);
    }

    public static HistoryConfigChange makeRemoved(Property property, BValue bValue) {
        return new HistoryConfigChange(property, bValue, null, null, 1);
    }

    public static HistoryConfigChange makeChanged(Property property, BValue bValue, Property property2, BValue bValue2) {
        return new HistoryConfigChange(property, bValue, property2, bValue2, 2);
    }

    public int getChangeType() {
        return this.changeType;
    }

    public Property getOldProperty() {
        return this.oldProp;
    }

    public BValue getOldValue() {
        return this.oldValue;
    }

    public Property getNewProperty() {
        return this.newProp;
    }

    public BValue getNewValue() {
        return this.newValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        switch (this.changeType) {
            case 0: {
                stringBuffer.append("added ").append(this.newProp);
                break;
            }
            case 1: {
                stringBuffer.append("removed ").append(this.oldProp);
                break;
            }
            case 2: {
                stringBuffer.append("changed ");
                stringBuffer.append(this.oldProp).append('=').append(this.oldValue);
                stringBuffer.append(" -> ");
                stringBuffer.append(this.newProp).append('=').append(this.newValue);
                break;
            }
        }
        return stringBuffer.toString();
    }

    private HistoryConfigChange(Property property, BValue bValue, Property property2, BValue bValue2, int n) {
        this.oldProp = property;
        this.oldValue = bValue;
        this.newProp = property2;
        this.newValue = bValue2;
        this.changeType = n;
    }
}

