/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.virtual;

import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nv.BNiagaraVirtualPolicies;
import com.tridium.nv.INiagaraVirtualStationAdapter;
import com.tridium.nv.point.INiagaraProxyExt;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.util.Version;

public class DefaultNiagaraVirtualStationAdapter
implements INiagaraVirtualStationAdapter {
    private static final Log log = Log.getLog((String)"fox.niagaraVirtual");
    private BNiagaraStation station;

    public String getStationName() {
        return this.station.getStationName();
    }

    public BStatus getStationStatus() {
        return this.station.getStatus();
    }

    public boolean isVirtualsEnabled() {
        return this.station.getVirtualsEnabled();
    }

    public BNiagaraVirtualPolicies getNiagaraVirtualPolicies() {
        return this.station.getNiagaraNetwork().getVirtualPolicies();
    }

    public Object getStateLock() {
        return this.station.getPoints().stateLock;
    }

    public void registerProxyExt(INiagaraProxyExt iNiagaraProxyExt) {
        this.station.getPoints().registerProxyExt(iNiagaraProxyExt);
    }

    public void unregisterProxyExt(INiagaraProxyExt iNiagaraProxyExt) {
        BNiagaraPointDeviceExt bNiagaraPointDeviceExt = this.station.getPoints();
        if (bNiagaraPointDeviceExt == null) {
            return;
        }
        bNiagaraPointDeviceExt.unregisterProxyExt(iNiagaraProxyExt);
        if (bNiagaraPointDeviceExt.clientWorker != null) {
            bNiagaraPointDeviceExt.clientWorker.stopped(iNiagaraProxyExt);
        }
    }

    public Log getLog() {
        return log;
    }

    public Version getStationVersion(Version version) {
        Version version2 = version;
        if (this.station.getVersion().length() > 0) {
            version2 = new Version(this.station.getVersion());
        }
        return version2;
    }

    public DefaultNiagaraVirtualStationAdapter(BNiagaraStation bNiagaraStation) {
        this.station = bNiagaraStation;
    }
}

