/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.util;

import com.tridium.nd.util.Lock;

public class ReentrantLock
implements Lock {
    private final Sync sync = new NonfairSync();

    public void lock() {
        this.sync.lock();
    }

    public boolean tryLock() {
        return this.sync.tryLock();
    }

    public void unlock() {
        this.sync.unlock();
    }

    public int getHoldCount() {
        return this.sync.getHoldCount();
    }

    public boolean isHeldByCurrentThread() {
        return this.sync.isHeldByCurrentThread();
    }

    public boolean isLocked() {
        return this.sync.isLocked();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static abstract class Sync {
        protected transient Thread owner;
        protected transient int holds;

        public abstract void lock();

        final void incHolds() {
            int n = this.holds + 1;
            if (n < 0) {
                throw new Error("Maximum lock count exceeded.");
            }
            this.holds = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean tryLock() {
            Thread thread = Thread.currentThread();
            Sync sync = this;
            synchronized (sync) {
                if (this.owner == null) {
                    this.owner = thread;
                    this.holds = 1;
                    return true;
                }
                if (thread == this.owner) {
                    this.incHolds();
                    return true;
                }
                return false;
            }
        }

        public abstract void unlock();

        public synchronized int getHoldCount() {
            int n = 0;
            if (this.isHeldByCurrentThread()) {
                n = this.holds;
            }
            return n;
        }

        public synchronized boolean isHeldByCurrentThread() {
            boolean bl = false;
            if (this.holds > 0 && Thread.currentThread() == this.owner) {
                bl = true;
            }
            return bl;
        }

        public synchronized boolean isLocked() {
            boolean bl = false;
            if (this.owner != null) {
                bl = true;
            }
            return bl;
        }

        protected synchronized Thread getOwner() {
            return this.owner;
        }

        private final /* synthetic */ void this() {
            this.owner = null;
            this.holds = 0;
        }

        protected Sync() {
            this.this();
        }
    }

    static final class NonfairSync
    extends Sync {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void lock() {
            Thread thread = Thread.currentThread();
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.owner == null) {
                    this.owner = thread;
                    this.holds = 1;
                    return;
                }
                if (thread == this.owner) {
                    this.incHolds();
                    return;
                }
                boolean bl = Thread.interrupted();
                try {
                    while (true) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                        if (this.owner == null) {
                            this.owner = thread;
                            this.holds = 1;
                            Object var6_5 = null;
                            if (!bl) return;
                            Thread.currentThread().interrupt();
                            return;
                        }
                        continue;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (!bl) throw throwable;
                    Thread.currentThread().interrupt();
                    throw throwable;
                }
            }
        }

        public final synchronized void unlock() {
            if (Thread.currentThread() != this.owner) {
                throw new IllegalMonitorStateException("Not owner.");
            }
            if (--this.holds == 0) {
                this.owner = null;
                this.notify();
            }
        }
    }
}

