/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.user;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.user.BNiagaraUserDeviceExt;
import com.tridium.nd.user.UserStatus;
import com.tridium.nd.user.UserSyncException;
import java.io.IOException;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BUserSyncChannel
extends BFoxChannel {
    public static final Type TYPE;
    public static Log log;
    static /* synthetic */ Class class$com$tridium$nd$user$BUserSyncChannel;
    static /* synthetic */ Class class$javax$baja$user$BUser;

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (string == "startSync") {
            return this.startSync(foxRequest);
        }
        if (string == "endSync") {
            return this.endSync(foxRequest);
        }
        if (string == "getUserStatus") {
            return this.getUserStatus(foxRequest);
        }
        if (string == "getOutOfSync") {
            return this.getOutOfSync(foxRequest);
        }
        if (string == "updateUsers") {
            return this.updateUsers(foxRequest);
        }
        if (string == "updateUsersFromServer") {
            return this.updateUsersFromServer(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public void circuitOpened(FoxCircuit foxCircuit) throws Exception {
        String string = foxCircuit.command;
        throw new InvalidCommandException(string);
    }

    private final boolean supportsPasswordHashing(Version version) {
        if (version == null) {
            log.warning("Could not determine remote baja version (app.hello)");
            return false;
        }
        int n = version.major();
        int n2 = version.minor();
        int n3 = version.build();
        if (n < 3) {
            return false;
        }
        if (n == 3) {
            if (n2 <= 4) {
                return false;
            }
            if (n2 == 5) {
                boolean bl = false;
                if (n3 >= 400) {
                    bl = true;
                }
                return bl;
            }
            if (n2 == 6) {
                boolean bl = false;
                if (n3 >= 400) {
                    bl = true;
                }
                return bl;
            }
            if (n2 == 7) {
                boolean bl = false;
                if (n3 >= 100) {
                    bl = true;
                }
                return bl;
            }
            if (n2 >= 8) {
                return true;
            }
        }
        return n > 3;
    }

    private final Version getServerBajaVersion() throws Exception {
        Version version = this.getServerConnection().getRemoteVersion();
        return version;
    }

    private final Version getClientBajaVersion() throws Exception {
        Version version = this.getClientConnection().getRemoteVersion();
        return version;
    }

    private final boolean serverSupportsPasswordHashing() throws Exception {
        return this.supportsPasswordHashing(this.getServerBajaVersion());
    }

    private final boolean clientSupportsPasswordHashing() throws Exception {
        return this.supportsPasswordHashing(this.getClientBajaVersion());
    }

    public BNiagaraUserDeviceExt getUserDeviceExt() {
        BFoxConnection bFoxConnection = this.getConnection();
        NiagaraStation niagaraStation = bFoxConnection.getParentStation();
        if (niagaraStation == null) {
            return null;
        }
        return ((BNiagaraStation)niagaraStation).getUsers();
    }

    public void checkStatus(FoxResponse foxResponse) throws Exception {
        String string = foxResponse.getString("status");
        if (!string.equals("ok")) {
            throw new UserSyncException(foxResponse.getString("msg"));
        }
    }

    public void startSync(boolean bl) throws Exception {
        if (log.isTraceOn()) {
            log.trace("client.startSync: outgoing=" + bl);
        }
        FoxRequest foxRequest = this.makeRequest("startSync");
        if (bl && !this.clientSupportsPasswordHashing()) {
            throw new Exception("one-way password hashing support mismatch");
        }
        foxRequest.add("outgoing", bl);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        this.checkStatus(foxResponse);
    }

    public FoxResponse startSync(FoxRequest foxRequest) throws Exception {
        boolean bl = foxRequest.getBoolean("outgoing");
        if (log.isTraceOn()) {
            log.trace("server.startSync: outgoing=" + bl);
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BNiagaraUserDeviceExt bNiagaraUserDeviceExt = this.getUserDeviceExt();
        if (!bl && !this.serverSupportsPasswordHashing()) {
            foxResponse.add("status", "error");
            foxResponse.add("msg", "one-way password hashing support mismatch");
        } else if (bl && !bNiagaraUserDeviceExt.getSyncInEnabled()) {
            foxResponse.add("status", "error");
            foxResponse.add("msg", "syncOut is disabled.");
        } else if (!bl && !bNiagaraUserDeviceExt.getSyncOutEnabled()) {
            foxResponse.add("status", "error");
            foxResponse.add("msg", "syncIn is disabled.");
        } else if (bNiagaraUserDeviceExt.getStatus().isDisabled()) {
            foxResponse.add("status", "error");
            foxResponse.add("msg", "User synchronization is disabled.");
        } else {
            foxResponse.add("status", "ok");
        }
        return foxResponse;
    }

    public void endSync() throws Exception {
        FoxRequest foxRequest = this.makeRequest("endSync");
        FoxResponse foxResponse = this.sendSync(foxRequest);
        this.checkStatus(foxResponse);
    }

    public FoxResponse endSync(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BNiagaraUserDeviceExt bNiagaraUserDeviceExt = this.getUserDeviceExt();
        if (bNiagaraUserDeviceExt.getStatus().isDisabled()) {
            foxResponse.add("status", "error");
            foxResponse.add("msg", "User synchronization is disabled.");
        } else {
            bNiagaraUserDeviceExt.syncComplete();
            foxResponse.add("status", "ok");
        }
        return foxResponse;
    }

    public UserStatus[] getUserStatus(String[] stringArray) throws Exception {
        FoxRequest foxRequest = this.makeRequest("getUserStatus");
        int n = 0;
        while (n < stringArray.length) {
            foxRequest.add("p", stringArray[n]);
            ++n;
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        this.checkStatus(foxResponse);
        FoxTuple[] foxTupleArray = foxResponse.list("u");
        if (foxTupleArray == null) {
            return new UserStatus[0];
        }
        UserStatus[] userStatusArray = new UserStatus[foxTupleArray.length];
        int n2 = 0;
        while (n2 < userStatusArray.length) {
            FoxMessage foxMessage = (FoxMessage)foxTupleArray[n2];
            userStatusArray[n2] = new UserStatus(foxMessage.getString("n"), foxMessage.getString("p"), foxMessage.getString("v"));
            ++n2;
        }
        return userStatusArray;
    }

    public FoxResponse getUserStatus(FoxRequest foxRequest) throws IOException {
        FoxTuple[] foxTupleArray = foxRequest.list("p");
        String[] stringArray = new String[foxTupleArray.length];
        int n = 0;
        while (n < foxTupleArray.length) {
            stringArray[n] = ((FoxString)foxTupleArray[n]).value;
            ++n;
        }
        BNiagaraUserDeviceExt bNiagaraUserDeviceExt = this.getUserDeviceExt();
        UserStatus[] userStatusArray = bNiagaraUserDeviceExt.getUserStatus(stringArray);
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        foxResponse.add("status", "ok");
        int n2 = 0;
        while (n2 < userStatusArray.length) {
            FoxMessage foxMessage = new FoxMessage("u");
            foxMessage.add("n", userStatusArray[n2].getUserName());
            foxMessage.add("p", userStatusArray[n2].getPrototypeName());
            foxMessage.add("v", userStatusArray[n2].getVersion());
            foxResponse.add((FoxTuple)foxMessage);
            ++n2;
        }
        return foxResponse;
    }

    public UserStatus[] getOutOfSync(UserStatus[] userStatusArray) throws Exception {
        FoxTuple[] foxTupleArray;
        FoxRequest foxRequest = this.makeRequest("getOutOfSync");
        int n = 0;
        while (n < userStatusArray.length) {
            foxTupleArray = new FoxMessage("u");
            foxTupleArray.add("n", userStatusArray[n].getUserName());
            foxTupleArray.add("p", userStatusArray[n].getPrototypeName());
            foxTupleArray.add("v", userStatusArray[n].getVersion());
            foxRequest.add((FoxTuple)foxTupleArray);
            ++n;
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        this.checkStatus(foxResponse);
        foxTupleArray = foxResponse.list("u");
        if (foxTupleArray == null) {
            return new UserStatus[0];
        }
        UserStatus[] userStatusArray2 = new UserStatus[foxTupleArray.length];
        int n2 = 0;
        while (n2 < userStatusArray2.length) {
            FoxMessage foxMessage = (FoxMessage)foxTupleArray[n2];
            userStatusArray2[n2] = new UserStatus(foxMessage.getString("n"), foxMessage.getString("p"), foxMessage.getString("v"));
            ++n2;
        }
        return userStatusArray2;
    }

    public FoxResponse getOutOfSync(FoxRequest foxRequest) throws IOException {
        try {
            String string;
            String string2;
            UserStatus[] userStatusArray;
            FoxTuple[] foxTupleArray = foxRequest.list("u");
            UserStatus[] userStatusArray2 = new UserStatus[foxTupleArray.length];
            int n = 0;
            while (n < foxTupleArray.length) {
                userStatusArray = (UserStatus[])foxTupleArray[n];
                string2 = userStatusArray.getString("n");
                String string3 = userStatusArray.getString("p");
                string = userStatusArray.getString("v");
                userStatusArray2[n] = new UserStatus(string2, string3, string);
                ++n;
            }
            BNiagaraUserDeviceExt bNiagaraUserDeviceExt = this.getUserDeviceExt();
            userStatusArray = bNiagaraUserDeviceExt.getOutOfSync(userStatusArray2);
            string2 = new FoxResponse(foxRequest);
            string2.add("status", "ok");
            int n2 = 0;
            while (n2 < userStatusArray.length) {
                string = new FoxMessage("u");
                string.add("n", userStatusArray[n2].getUserName());
                string.add("p", userStatusArray[n2].getPrototypeName());
                string.add("v", userStatusArray[n2].getVersion());
                string2.add((FoxTuple)string);
                ++n2;
            }
            return string2;
        }
        catch (UserSyncException userSyncException) {
            log.error("Error", (Throwable)((Object)userSyncException));
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            foxResponse.add("status", "error");
            foxResponse.add("msg", userSyncException.getMessage());
            return foxResponse;
        }
    }

    public void updateUsers(BUser[] bUserArray) throws Exception {
        BComponent bComponent = new BComponent();
        int n = 0;
        while (n < bUserArray.length) {
            bComponent.add(bUserArray[n].getName(), bUserArray[n].newCopy());
            ++n;
        }
        if (log.isTraceOn()) {
            n = 0;
            while (n < bUserArray.length) {
                log.trace("sending update for: " + bUserArray[n].getName());
                ++n;
            }
        }
        FoxRequest foxRequest = this.makeRequest("updateUsers");
        foxRequest.add("bog", ValueDocEncoder.marshal((BValue)bComponent));
        FoxResponse foxResponse = this.sendSync(foxRequest);
        this.checkStatus(foxResponse);
        if (!foxResponse.getString("status").equals("ok")) {
            throw new UserSyncException(foxResponse.getString("msg"));
        }
    }

    /*
     * Unable to fully structure code
     */
    public FoxResponse updateUsers(FoxRequest var1_1) throws Exception {
        BUserSyncChannel.log.trace("update users");
        var2_2 = (BUserService)Sys.getService((Type)BUserService.TYPE);
        var3_3 = this.getUserDeviceExt();
        var4_4 = var1_1.getString("bog");
        if (BUserSyncChannel.log.isTraceOn()) {
            BUserSyncChannel.log.trace("users to update:\n" + var4_4);
        }
        var5_5 = (BComponent)ValueDocDecoder.unmarshal((String)var4_4);
        v0 = BUserSyncChannel.class$javax$baja$user$BUser;
        if (v0 == null) {
            v0 = BUserSyncChannel.class$javax$baja$user$BUser = BUserSyncChannel.class("[Ljavax.baja.user.BUser;", false);
        }
        var6_6 = new Array(v0);
        var7_7 = var5_5.getProperties();
        if (true) ** GOTO lbl17
        do {
            var6_6.add((Object)var7_7.get());
lbl17:
            // 2 sources

            if ((v1 = BUserSyncChannel.class$javax$baja$user$BUser) != null) continue;
            v1 = BUserSyncChannel.class("[Ljavax.baja.user.BUser;", false);
        } while (var7_7.next(v1));
        var8_8 = 0;
        while (var8_8 < var6_6.size()) {
            var9_10 = (BUser)var6_6.get(var8_8);
            var10_11 = var9_10.getName();
            var5_5.remove(var10_11);
            var3_3.syncUser(var10_11, var9_10);
            ++var8_8;
        }
        var8_9 = new FoxResponse(var1_1);
        var8_9.add("status", "ok");
        return var8_9;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void updateUsersFromServer(UserStatus[] var1_1) throws Exception {
        var2_2 = this.getUserDeviceExt();
        var3_3 = this.makeRequest("updateUsersFromServer");
        var4_4 = 0;
        while (var4_4 < var1_1.length) {
            var5_6 /* !! */  = new FoxMessage("u");
            var5_6 /* !! */ .add("n", var1_1[var4_4].getUserName());
            var5_6 /* !! */ .add("p", var1_1[var4_4].getPrototypeName());
            var5_6 /* !! */ .add("v", var1_1[var4_4].getVersion());
            var3_3.add((FoxTuple)var5_6 /* !! */ );
            ++var4_4;
        }
        var4_5 = this.sendSync(var3_3);
        this.checkStatus(var4_5);
        var5_6 /* !! */  = var4_5.getString("bog");
        if (BUserSyncChannel.log.isTraceOn()) {
            BUserSyncChannel.log.trace("users to update:\n" + (String)var5_6 /* !! */ );
        }
        var6_7 = (BComponent)ValueDocDecoder.unmarshal((String)var5_6 /* !! */ );
        v0 = BUserSyncChannel.class$javax$baja$user$BUser;
        if (v0 == null) {
            v0 = BUserSyncChannel.class$javax$baja$user$BUser = BUserSyncChannel.class("[Ljavax.baja.user.BUser;", false);
        }
        var7_8 = new Array(v0);
        var8_9 = var6_7.getProperties();
        if (true) ** GOTO lbl27
        do {
            var7_8.add((Object)var8_9.get());
lbl27:
            // 2 sources

            if ((v1 = BUserSyncChannel.class$javax$baja$user$BUser) != null) continue;
            v1 = BUserSyncChannel.class("[Ljavax.baja.user.BUser;", false);
        } while (var8_9.next(v1));
        var9_10 = 0;
        while (var9_10 < var7_8.size()) {
            var10_11 = (BUser)var7_8.get(var9_10);
            var11_12 = var10_11.getName();
            var6_7.remove(var11_12);
            var2_2.syncUser(var11_12, var10_11);
            ++var9_10;
        }
    }

    public FoxResponse updateUsersFromServer(FoxRequest foxRequest) throws Exception {
        String string;
        String string2;
        Object object;
        log.trace("update request");
        FoxTuple[] foxTupleArray = foxRequest.list("u");
        UserStatus[] userStatusArray = new UserStatus[foxTupleArray.length];
        int n = 0;
        while (n < foxTupleArray.length) {
            object = (FoxMessage)foxTupleArray[n];
            string2 = object.getString("n");
            String string3 = object.getString("p");
            string = object.getString("v");
            userStatusArray[n] = new UserStatus(string2, string3, string);
            ++n;
        }
        BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        object = this.getUserDeviceExt();
        string2 = new BComponent();
        int n2 = 0;
        while (n2 < userStatusArray.length) {
            string = (BUser)bUserService.get(userStatusArray[n2].getUserName());
            if (string != null) {
                string2.add(string.getName(), string.newCopy());
            }
            ++n2;
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        foxResponse.add("status", "ok");
        foxResponse.add("bog", ValueDocEncoder.marshal((BValue)string2));
        return foxResponse;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BUserSyncChannel() {
        super("usersync");
    }

    static {
        Class clazz = class$com$tridium$nd$user$BUserSyncChannel;
        if (clazz == null) {
            clazz = class$com$tridium$nd$user$BUserSyncChannel = BUserSyncChannel.class("[Lcom.tridium.nd.user.BUserSyncChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"niagara.users");
    }
}

