/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.user;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BSysChannel;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.user.BUserSyncChannel;
import com.tridium.nd.user.BUserSyncExt;
import com.tridium.nd.user.BUserSyncStrategy;
import com.tridium.nd.user.UserStatus;
import com.tridium.nd.user.UserSyncException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserEvent;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.BUserService;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNiagaraUserDeviceExt
extends BDeviceExt
implements BIStatus,
BINiagaraDeviceExt,
BFoxClientConnection.Interest {
    public static final Property syncInEnabled = BNiagaraUserDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property syncOutEnabled = BNiagaraUserDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property status = BNiagaraUserDeviceExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BNiagaraUserDeviceExt.newProperty((int)3, (String)"", null);
    public static final Property syncStrategy = BNiagaraUserDeviceExt.newProperty((int)0, (BValue)BUserSyncStrategy.prototypeRequired, null);
    public static final Property syncRequired = BNiagaraUserDeviceExt.newProperty((int)1, (boolean)true, null);
    public static final Property syncDelay = BNiagaraUserDeviceExt.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property syncRetry = BNiagaraUserDeviceExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)15)));
    public static final Property lastSyncAttempt = BNiagaraUserDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    public static final Property lastSyncSuccess = BNiagaraUserDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    public static final Action handleUserEvent = BNiagaraUserDeviceExt.newAction((int)4, (BValue)new BUserEvent(), null);
    public static final Action sync = BNiagaraUserDeviceExt.newAction((int)16, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static Log log;
    public static final int LOCAL_OVERRIDE = 0x10000000;
    private Clock.Ticket ticket;
    static /* synthetic */ Class class$com$tridium$nd$user$BNiagaraUserDeviceExt;
    static /* synthetic */ Class class$com$tridium$nd$user$UserStatus;
    static /* synthetic */ Class class$javax$baja$user$BUser;

    public boolean getSyncInEnabled() {
        return this.getBoolean(syncInEnabled);
    }

    public void setSyncInEnabled(boolean bl) {
        this.setBoolean(syncInEnabled, bl, null);
    }

    public boolean getSyncOutEnabled() {
        return this.getBoolean(syncOutEnabled);
    }

    public void setSyncOutEnabled(boolean bl) {
        this.setBoolean(syncOutEnabled, bl, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BUserSyncStrategy getSyncStrategy() {
        return (BUserSyncStrategy)this.get(syncStrategy);
    }

    public void setSyncStrategy(BUserSyncStrategy bUserSyncStrategy) {
        this.set(syncStrategy, (BValue)bUserSyncStrategy, null);
    }

    public boolean getSyncRequired() {
        return this.getBoolean(syncRequired);
    }

    public void setSyncRequired(boolean bl) {
        this.setBoolean(syncRequired, bl, null);
    }

    public BRelTime getSyncDelay() {
        return (BRelTime)this.get(syncDelay);
    }

    public void setSyncDelay(BRelTime bRelTime) {
        this.set(syncDelay, (BValue)bRelTime, null);
    }

    public BRelTime getSyncRetry() {
        return (BRelTime)this.get(syncRetry);
    }

    public void setSyncRetry(BRelTime bRelTime) {
        this.set(syncRetry, (BValue)bRelTime, null);
    }

    public BAbsTime getLastSyncAttempt() {
        return (BAbsTime)this.get(lastSyncAttempt);
    }

    public void setLastSyncAttempt(BAbsTime bAbsTime) {
        this.set(lastSyncAttempt, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastSyncSuccess() {
        return (BAbsTime)this.get(lastSyncSuccess);
    }

    public void setLastSyncSuccess(BAbsTime bAbsTime) {
        this.set(lastSyncSuccess, (BValue)bAbsTime, null);
    }

    public void handleUserEvent(BUserEvent bUserEvent) {
        this.invoke(handleUserEvent, (BValue)bUserEvent, null);
    }

    public void sync() {
        this.invoke(sync, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BNiagaraUserDeviceExt getForStation(BNiagaraStation bNiagaraStation) {
        SlotCursor slotCursor = bNiagaraStation.getProperties();
        Class clazz = class$com$tridium$nd$user$BNiagaraUserDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$nd$user$BNiagaraUserDeviceExt = BNiagaraUserDeviceExt.class("[Lcom.tridium.nd.user.BNiagaraUserDeviceExt;", false);
        }
        if (slotCursor.next(clazz)) {
            return (BNiagaraUserDeviceExt)slotCursor.get();
        }
        return null;
    }

    public static void setReadonly(BComplex bComplex) {
        Property property;
        int n;
        BComplex bComplex2 = bComplex.getParent();
        if (bComplex2 != null && ((n = bComplex2.getFlags((Slot)(property = bComplex.getPropertyInParent()))) & 1) != 0) {
            bComplex2.setFlags((Slot)property, n | 1);
        }
        BNiagaraUserDeviceExt.setChildrenReadonly(bComplex);
    }

    private static final void setChildrenReadonly(BComplex bComplex) {
        SlotCursor slotCursor = bComplex.getProperties();
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            if (!Flags.isReadonly((BComplex)bComplex, (Slot)property)) {
                bComplex.setFlags((Slot)property, bComplex.getFlags((Slot)property) | 1);
            }
            if (!property.getType().is(BComponent.TYPE)) continue;
            BNiagaraUserDeviceExt.setChildrenReadonly((BComplex)slotCursor.get());
        }
    }

    public void clientOpened() {
    }

    public void clientClosed() {
    }

    public void serverOpened() {
    }

    public void serverClosed() {
    }

    public void updateStatus() {
        this.checkConfig();
        if (!(this.getNiagaraStation().getStatus().isDown() || this.getNiagaraStation().getStatus().isDisabled() || this.getStatus().isDisabled())) {
            this.setSyncRequired(true);
        }
        if (this.isRunning() && this.getSyncRequired() && Sys.atSteadyState()) {
            this.scheduleSync(false);
        }
    }

    public final BFoxClientConnection getClientConnection() {
        return this.getNiagaraStation().getClientConnection();
    }

    public final BUserSyncChannel getClientUserChannel() {
        return (BUserSyncChannel)this.getNiagaraStation().getClientConnection().getChannels().get("usersync", BUserSyncChannel.TYPE);
    }

    public final BSysChannel getSysChannel() {
        return (BSysChannel)this.getNiagaraStation().getClientConnection().getChannels().get("sys", BSysChannel.TYPE);
    }

    public void checkConfig() {
        BNiagaraStation bNiagaraStation;
        BUserService bUserService = null;
        try {
            bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {}
        if (bUserService == null) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("UserService not found.");
            return;
        }
        if (!bUserService.isDistributable()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(bUserService.getType().getTypeName() + " does not support distribution of user accounts.");
            return;
        }
        boolean bl = false;
        BStatus bStatus = this.getStatus();
        boolean bl2 = false;
        if (!this.getSyncInEnabled() && !this.getSyncOutEnabled()) {
            bl2 = true;
        }
        this.setStatus(BStatus.makeDisabled((BStatus)bStatus, (boolean)bl2));
        if (this.getSyncInEnabled() && this.getSyncOutEnabled()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("syncIn and syncOut cannot be enabled for the same station.");
            bl = true;
        }
        if (!bl) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            this.setFaultCause("");
        }
        if ((bNiagaraStation = this.getNiagaraStation()) != null) {
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)bNiagaraStation.isDown()));
        }
    }

    public BUser getPrototype(String string) {
        BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        if (string.length() == 0 && this.getSyncStrategy() == BUserSyncStrategy.useDefaultPrototype) {
            return bUserService.getUserPrototypes().getDefaultPrototype();
        }
        BUser bUser = (BUser)bUserService.getUserPrototypes().get(string);
        if (bUser == null && this.getSyncStrategy() == BUserSyncStrategy.useDefaultPrototype) {
            bUser = bUserService.getUserPrototypes().getDefaultPrototype();
        }
        return bUser;
    }

    /*
     * Unable to fully structure code
     */
    public UserStatus[] getUserStatus(String[] var1_1) {
        var2_2 = false;
        var3_3 = 0;
        while (var3_3 < var1_1.length) {
            if (var1_1[var3_3].equals("*")) {
                var2_2 = true;
                break;
            }
            ++var3_3;
        }
        if ((v0 = BNiagaraUserDeviceExt.class$com$tridium$nd$user$UserStatus) == null) {
            v0 = BNiagaraUserDeviceExt.class$com$tridium$nd$user$UserStatus = BNiagaraUserDeviceExt.class("[Lcom.tridium.nd.user.UserStatus;", false);
        }
        var3_4 = new Array(v0);
        var4_5 = (BUserService)Sys.getService((Type)BUserService.TYPE);
        var5_6 = var4_5.getProperties();
        if (true) ** GOTO lbl31
        do {
            if ((var6_7 = (BUser)var5_6.get()).getNetworkUser()) {
                if (var2_2) {
                    var3_4.add((Object)new UserStatus(var6_7));
                } else {
                    var7_8 = var6_7.getPrototypeName();
                    if (var7_8.length() != 0) {
                        var8_9 = 0;
                        while (var8_9 < var1_1.length) {
                            if (var1_1[var8_9].equals(var7_8)) {
                                var3_4.add((Object)new UserStatus(var6_7));
                                break;
                            }
                            ++var8_9;
                        }
                    }
                }
            }
lbl31:
            // 8 sources

            if ((v1 = BNiagaraUserDeviceExt.class$javax$baja$user$BUser) != null) continue;
            v1 = BNiagaraUserDeviceExt.class("[Ljavax.baja.user.BUser;", false);
        } while (var5_6.next(v1));
        return (UserStatus[])var3_4.trim();
    }

    /*
     * Unable to fully structure code
     */
    public UserStatus[] getOutOfSync(UserStatus[] var1_1) {
        if (!this.getSyncInEnabled()) {
            throw new UserSyncException("User synchronization is disabled. (syncIn)");
        }
        var2_2 = new HashMap<String, UserStatus>();
        var3_3 = 0;
        while (var3_3 < var1_1.length) {
            var2_2.put(var1_1[var3_3].getUserName(), var1_1[var3_3]);
            ++var3_3;
        }
        var3_4 = new ArrayList<Property>(16);
        var4_5 = (BUserService)Sys.getService((Type)BUserService.TYPE);
        var5_6 = var4_5.getProperties();
        if (true) ** GOTO lbl28
        do {
            if (!var5_6.property().isFrozen() && (var6_7 = (BUser)var5_6.get()).getNetworkUser()) {
                var7_8 = (UserStatus)var2_2.get(var6_7.getName());
                if (var7_8 == null) {
                    var3_4.add(var5_6.property());
                } else if (this.getSyncStrategy() == BUserSyncStrategy.prototypeRequired && (var8_9 = this.getPrototype(var7_8.getPrototypeName())) == null) {
                    var3_4.add(var5_6.property());
                } else if (!var7_8.getPrototypeName().equals(var6_7.getPrototypeName())) {
                    var3_4.add(var5_6.property());
                }
            }
lbl28:
            // 8 sources

            if ((v0 = BNiagaraUserDeviceExt.class$javax$baja$user$BUser) != null) continue;
            v0 = BNiagaraUserDeviceExt.class("[Ljavax.baja.user.BUser;", false);
        } while (var5_6.next(v0));
        var6_7 = var3_4.iterator();
        while (var6_7.hasNext()) {
            var4_5.remove((Property)var6_7.next());
        }
        v1 = BNiagaraUserDeviceExt.class$com$tridium$nd$user$UserStatus;
        if (v1 == null) {
            v1 = BNiagaraUserDeviceExt.class$com$tridium$nd$user$UserStatus = BNiagaraUserDeviceExt.class("[Lcom.tridium.nd.user.UserStatus;", false);
        }
        var7_8 = new Array(v1);
        var6_7 = var2_2.values().iterator();
        while (var6_7.hasNext()) {
            var8_9 = (UserStatus)var6_7.next();
            var9_10 = (BUser)var4_5.get(var8_9.getUserName());
            var10_11 = this.getPrototype(var8_9.getPrototypeName());
            if (this.getSyncStrategy() == BUserSyncStrategy.prototypeRequired && var10_11 == null || var9_10 != null && var9_10.getVersion().equals(var8_9.getVersion()) && (var10_11 == null || var9_10.getPrototypeVersion().equals(var10_11.getVersion()))) continue;
            var7_8.add((Object)var8_9);
        }
        return (UserStatus[])var7_8.trim();
    }

    public void syncUser(String string, BUser bUser) {
        if (!this.getSyncInEnabled()) {
            return;
        }
        BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUser bUser2 = (BUser)bUserService.get(string);
        if (bUser2 == null) {
            this.addUser(string, bUser);
        } else {
            this.updateUser(bUser2, bUser);
        }
    }

    private final void addUser(String string, BUser bUser) {
        this.applyPrototype(bUser);
        BUserSyncExt bUserSyncExt = new BUserSyncExt();
        bUserSyncExt.setSourceStation(this.getDevice().getSlotPathOrd());
        Property property = bUser.getProperty("syncExt");
        if (property == null) {
            bUser.add("syncExt", (BValue)bUserSyncExt, 1);
        } else {
            bUser.set(property, (BValue)bUserSyncExt);
        }
        BNiagaraUserDeviceExt.setReadonly((BComplex)bUser);
        BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        bUserService.add(string, (BValue)bUser, 1);
    }

    private final void updateUser(BUser bUser, BUser bUser2) {
        this.applyPrototype(bUser2);
        BUserSyncExt bUserSyncExt = new BUserSyncExt();
        bUserSyncExt.setSourceStation(this.getDevice().getSlotPathOrd());
        Property property = bUser2.getProperty("syncExt");
        if (property == null) {
            bUser2.add("syncExt", (BValue)bUserSyncExt, 1);
        } else {
            bUser2.set(property, (BValue)bUserSyncExt);
        }
        BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        Property property2 = bUserService.getProperty(bUser.getName());
        if (!property2.isFrozen()) {
            BNiagaraUserDeviceExt.setReadonly((BComplex)bUser2);
        }
        bUserService.set(property2, (BValue)bUser2);
    }

    public void applyPrototype(BUser bUser) {
        Property property;
        BUser bUser2 = this.getPrototype(bUser.getPrototypeName());
        if (bUser2 == null) {
            return;
        }
        SlotCursor slotCursor = bUser2.getProperties();
        while (slotCursor.next()) {
            property = slotCursor.property();
            if (!this.isLocalOverride((BComponent)bUser2, (Slot)property)) continue;
            this.setFrom(bUser2, bUser, property);
        }
        slotCursor = bUser.getProperties();
        property = new Array();
        while (slotCursor.next()) {
            Property property2;
            Property property3 = slotCursor.property();
            if (property3.isFrozen() || !property3.getType().is(BIMixIn.TYPE) || (property2 = bUser2.getProperty(property3.getName())) != null) continue;
            property.add((Object)property3);
        }
        int n = 0;
        while (n < property.size()) {
            bUser.remove((Property)property.get(n));
            ++n;
        }
        bUser.setPrototypeVersion(bUser2.getVersion());
    }

    private final boolean isLocalOverride(BComponent bComponent, Slot slot) {
        boolean bl = false;
        if ((bComponent.getFlags(slot) & 0x10000000) != 0) {
            bl = true;
        }
        return bl;
    }

    private final void setFrom(BUser bUser, BUser bUser2, Property property) {
        Property property2 = property;
        Property property3 = property;
        if (!property2.isFrozen()) {
            property3 = bUser2.getProperty(property2.getName());
        }
        switch (property.getTypeAccess()) {
            case 0: {
                bUser2.setBoolean(property3, bUser.getBoolean(property2));
                break;
            }
            case 2: {
                bUser2.setInt(property3, bUser.getInt(property2));
                break;
            }
            case 3: {
                bUser2.setLong(property3, bUser.getLong(property2));
                break;
            }
            case 4: {
                bUser2.setFloat(property3, bUser.getFloat(property2));
                break;
            }
            case 5: {
                bUser2.setDouble(property3, bUser.getDouble(property2));
                break;
            }
            case 6: {
                bUser2.setString(property3, bUser.getString(property2));
                break;
            }
            case 7: {
                BValue bValue = bUser.get(property2);
                BValue bValue2 = bUser2.get(property3);
                if (bValue2.getClass() == bValue.getClass() && !bValue2.isSimple()) {
                    bValue2.asComplex().copyFrom(bValue.asComplex());
                    break;
                }
                bUser2.set(property3, bValue.newCopy());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        bUser2.setFlags((Slot)property3, bUser2.getFlags((Slot)property) & 0xEFFFFFFF);
    }

    public void started() {
        this.checkConfig();
        if (!this.getStatus().isDisabled()) {
            this.linkToService();
        }
        if (this.getSyncOutEnabled() && this.getSyncRequired() && Sys.atSteadyState()) {
            this.scheduleSync(false);
        }
    }

    public void atSteadyState() {
        if (this.getSyncOutEnabled() && this.getSyncRequired()) {
            this.scheduleSync(false);
        }
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (!Flags.isReadonly((BComplex)this, (Slot)property)) {
            this.checkConfig();
        }
        if (property == status) {
            if (this.getStatus().isDisabled()) {
                this.unlinkFromService();
            } else {
                this.linkToService();
            }
        }
        if (this.getStatus().isFault()) {
            return;
        }
        if (property == syncRequired) {
            if (this.getSyncRequired()) {
                this.scheduleSync(false);
            } else {
                this.cancelSync();
            }
        } else if (property == syncOutEnabled && this.getSyncOutEnabled() && this.getSyncRequired()) {
            this.scheduleSync(false);
        } else if (property == syncInEnabled && this.getSyncInEnabled() && this.getSyncRequired()) {
            this.scheduleSync(false);
        } else if (property == syncDelay) {
            if (this.ticket != null) {
                this.scheduleSync(false);
            }
        } else if (property == syncStrategy) {
            this.setSyncRequired(true);
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == sync) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)this.getDevice();
            if (bNiagaraStation != null) {
                bNiagaraStation.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
            }
            return null;
        }
        return super.post(action, bValue, context);
    }

    public void doHandleUserEvent(BUserEvent bUserEvent) {
        this.setSyncRequired(true);
    }

    private final void linkToService() {
        if (this.get("serviceLink") != null) {
            return;
        }
        BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUserPrototypes bUserPrototypes = bUserService.getUserPrototypes();
        this.linkTo("serviceLink", (BComponent)bUserService, (Slot)BUserService.userEvent, (Slot)handleUserEvent);
        this.linkTo("serviceProtoLink", (BComponent)bUserPrototypes, (Slot)BUserPrototypes.userEvent, (Slot)handleUserEvent);
    }

    private final void unlinkFromService() {
        Property property = this.getProperty("serviceLink");
        if (property != null) {
            this.remove(property);
        }
    }

    public void doSync() {
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
        if (!this.getSyncInEnabled() && !this.getSyncOutEnabled()) {
            return;
        }
        BNiagaraStation bNiagaraStation = this.getNiagaraStation();
        if (bNiagaraStation.getStatus().isDisabled()) {
            return;
        }
        if (bNiagaraStation.getStatus().isDown()) {
            return;
        }
        this.setLastSyncAttempt(BAbsTime.now());
        BFoxClientConnection bFoxClientConnection = this.getClientConnection();
        try {
            bFoxClientConnection.engageNoRetry((BFoxClientConnection.Interest)this);
            if (this.getSyncOutEnabled()) {
                this.syncToRemote();
            } else if (this.getSyncInEnabled()) {
                this.syncFromRemote();
            }
            this.syncComplete();
        }
        catch (Exception exception) {
            log.error("Cannot sync users with remote station.", (Throwable)exception);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            String string = exception.getMessage();
            if (string == null) {
                string = exception.toString();
            }
            this.setFaultCause(string);
            this.scheduleSync(true);
        }
        if (bFoxClientConnection.isEngaged((BFoxClientConnection.Interest)this)) {
            bFoxClientConnection.disengage((BFoxClientConnection.Interest)this);
        }
    }

    public void scheduleSync(boolean bl) {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)(bl ? this.getSyncRetry() : this.getSyncDelay()), (Action)sync, null);
        if (log.isTraceOn()) {
            log.trace("sync scheduled for " + this.getDevice().getName());
        }
    }

    public void cancelSync() {
        if (this.ticket != null) {
            this.ticket.cancel();
            if (log.isTraceOn()) {
                log.trace("sync cancelled for " + this.getDevice().getName());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void syncToRemote() throws Exception {
        if (BNiagaraUserDeviceExt.log.isTraceOn()) {
            BNiagaraUserDeviceExt.log.trace("sync users to " + this.getDevice().getName());
        }
        var1_1 = this.getClientUserChannel();
        var1_1.startSync(true);
        var2_2 = (BUserService)Sys.getService((Type)BUserService.TYPE);
        v0 = BNiagaraUserDeviceExt.class$com$tridium$nd$user$UserStatus;
        if (v0 == null) {
            v0 = BNiagaraUserDeviceExt.class$com$tridium$nd$user$UserStatus = BNiagaraUserDeviceExt.class("[Lcom.tridium.nd.user.UserStatus;", false);
        }
        var3_3 = new Array(v0, var2_2.getSlotCount());
        var4_4 = var2_2.getProperties();
        if (true) ** GOTO lbl16
        do {
            if ((var5_5 = (UserStatus[])var4_4.get()).getNetworkUser()) {
                var3_3.add((Object)new UserStatus((BUser)var4_4.get()));
            }
lbl16:
            // 4 sources

            if ((v1 = BNiagaraUserDeviceExt.class$javax$baja$user$BUser) != null) continue;
            v1 = BNiagaraUserDeviceExt.class("[Ljavax.baja.user.BUser;", false);
        } while (var4_4.next(v1));
        var5_5 = var1_1.getOutOfSync((UserStatus[])var3_3.trim());
        var6_6 = 0;
        while (var6_6 < var5_5.length) {
            v2 = BNiagaraUserDeviceExt.class$javax$baja$user$BUser;
            if (v2 == null) {
                v2 = BNiagaraUserDeviceExt.class("[Ljavax.baja.user.BUser;", false);
            }
            var7_7 = new Array(v2);
            var8_8 = 0;
            while (var8_8 < 10 && var6_6 < var5_5.length) {
                var9_9 = (BUser)var2_2.get(var5_5[var6_6].getUserName());
                if (var9_9 != null) {
                    var7_7.add((Object)var9_9);
                    if (var8_8 + 1 < 10) {
                        ++var6_6;
                    }
                }
                ++var8_8;
            }
            var1_1.updateUsers((BUser[])var7_7.trim());
            ++var6_6;
        }
        var1_1.endSync();
    }

    private final void syncFromRemote() throws Exception {
        if (log.isTraceOn()) {
            log.trace("sync users from " + this.getDevice().getName());
        }
        BUserSyncChannel bUserSyncChannel = this.getClientUserChannel();
        bUserSyncChannel.startSync(false);
        BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        String[] stringArray = null;
        if (this.getSyncStrategy() == BUserSyncStrategy.prototypeRequired) {
            stringArray = bUserService.getUserPrototypes().getPrototypeNames();
        } else if (this.getSyncStrategy() == BUserSyncStrategy.useDefaultPrototype) {
            stringArray = new String[]{"*"};
        } else {
            throw new UserSyncException("Unsupported sync strategy: " + (Object)((Object)this.getSyncStrategy()));
        }
        UserStatus[] userStatusArray = bUserSyncChannel.getUserStatus(stringArray);
        UserStatus[] userStatusArray2 = this.getOutOfSync(userStatusArray);
        if (userStatusArray2.length != 0) {
            int n = 0;
            while (n < userStatusArray2.length) {
                Class clazz = class$com$tridium$nd$user$UserStatus;
                if (clazz == null) {
                    clazz = BNiagaraUserDeviceExt.class("[Lcom.tridium.nd.user.UserStatus;", false);
                }
                Array array = new Array(clazz);
                int n2 = 0;
                while (n2 < 10 && n < userStatusArray2.length) {
                    array.add((Object)userStatusArray2[n]);
                    if (n2 + 1 < 10) {
                        ++n;
                    }
                    ++n2;
                }
                bUserSyncChannel.updateUsersFromServer((UserStatus[])array.trim());
                ++n;
            }
        }
        bUserSyncChannel.endSync();
    }

    public void syncComplete() {
        this.setSyncRequired(false);
        this.setLastSyncSuccess(BAbsTime.now());
        this.checkConfig();
    }

    private final BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.getParent();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$nd$user$BNiagaraUserDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$nd$user$BNiagaraUserDeviceExt = BNiagaraUserDeviceExt.class("[Lcom.tridium.nd.user.BNiagaraUserDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"user.png");
        log = Log.getLog((String)"niagara.users");
    }
}

