/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.sysdef;

import com.tridium.nd.ui.sysdef.BBox;
import com.tridium.nd.ui.sysdef.BTextOutputPane;
import com.tridium.nd.ui.sysdef.ICancelHint;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.sys.BValue;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class TaskDetailPane
implements Runnable,
ICancelHint {
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    private static final BImage runningIcon = BImage.make((String)"module://icons/x16/job/running.png");
    private static final BImage canceledIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    private static final BImage successIcon = BImage.make((String)"module://icons/x16/job/success.png");
    private static final BImage failedIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    private static final String unknownLabel = lex.getText("TaskDetailPane.status.notStarted");
    private BTextOutputPane log;
    private BLabel[] stateMessageLabels;
    private BLabel[] stateIconLabels;
    private TaskItem[] items;
    private TaskItem currentItem;
    private boolean canceled;
    private BWidget taskDetailPane;
    private boolean cancelEnabled;
    private BLabel bottomLabel;

    public abstract String getItemListHeading();

    public abstract TaskItem[] makeTaskItems();

    public final BWidget getPane() {
        if (this.taskDetailPane == null) {
            throw new IllegalStateException("must call init() before getPane()");
        }
        return this.taskDetailPane;
    }

    public void reset() {
        this.log.clear();
        int n = 0;
        while (n < this.items.length) {
            this.items[n].state = BJobState.unknown;
            this.stateMessageLabels[n].setText(TaskDetailPane.stateToLabel(BJobState.unknown));
            this.stateIconLabels[n].setImage(TaskDetailPane.stateToIcon(BJobState.unknown));
            ++n;
        }
        this.canceled = false;
        this.currentItem = null;
        this.setBottomLabelText("");
        this.setCancelEnabled(true);
        this.update();
    }

    public final BTextOutputPane getLog() {
        return this.log;
    }

    public final void setBottomLabelText(String string) {
        this.bottomLabel.setText(string);
    }

    public void init() {
        this.items = this.makeTaskItems();
        this.stateMessageLabels = new BLabel[this.items.length];
        this.stateIconLabels = new BLabel[this.items.length];
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        bGridPane.add(null, (BValue)new BLabel(this.getItemListHeading()));
        BGridPane bGridPane2 = new BGridPane(4);
        bGridPane2.setHalign(BHalign.left);
        bGridPane2.setValign(BValign.top);
        bGridPane2.add(null, (BValue)new BBox(16.0, 0.0));
        bGridPane2.add(null, (BValue)new BNullWidget());
        bGridPane2.add(null, (BValue)new BBox(10.0, 0.0));
        bGridPane2.add(null, (BValue)new BNullWidget());
        int n = 0;
        while (n < this.items.length) {
            this.stateIconLabels[n] = new BLabel(TaskDetailPane.stateToIcon(BJobState.unknown));
            bGridPane2.add(null, (BValue)this.stateIconLabels[n]);
            bGridPane2.add(null, (BValue)new BLabel(this.items[n].description));
            bGridPane2.add(null, (BValue)new BBox(0.0, 16.0));
            this.stateMessageLabels[n] = new BLabel(TaskDetailPane.stateToLabel(BJobState.unknown));
            bGridPane2.add(null, (BValue)this.stateMessageLabels[n]);
            ++n;
        }
        bGridPane.add(null, (BValue)bGridPane2);
        this.bottomLabel = new BLabel();
        bGridPane.add(null, (BValue)this.bottomLabel);
        this.log = new BTextOutputPane();
        this.taskDetailPane = new BEdgePane((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 10.0, 0.0), null, null, null, (BWidget)this.log);
        this.log.setUseAutoScroll(true);
        this.update();
    }

    protected void setCurrentItem(TaskItem taskItem, BJobState bJobState) {
        this.setCurrentItem(taskItem);
        this.updateCurrentItemState(bJobState);
    }

    protected synchronized void setCurrentItem(TaskItem taskItem) {
        this.currentItem = taskItem;
    }

    protected final synchronized TaskItem getCurrentItem() {
        return this.currentItem;
    }

    protected final synchronized void updateCurrentItemState(BJobState bJobState) {
        if (this.currentItem == null) {
            this.currentItem = this.items[0];
        }
        if (this.currentItem.state != bJobState) {
            this.currentItem.state = this.stateTransition(this.currentItem.state, bJobState);
            int n = 0;
            while (n < this.items.length) {
                if (this.items[n] == this.currentItem) {
                    this.stateMessageLabels[n].setText(TaskDetailPane.stateToLabel(this.currentItem.state));
                    this.stateIconLabels[n].setImage(TaskDetailPane.stateToIcon(this.currentItem.state));
                    break;
                }
                ++n;
            }
            this.update();
        }
    }

    protected synchronized BJobState update() {
        BJobState bJobState = BJobState.unknown;
        int n = 0;
        while (n < this.items.length) {
            BJobState bJobState2 = this.stateTransition(bJobState, this.items[n].state);
            if (bJobState2 == BJobState.success) {
                if (n == this.items.length - 1) {
                    return bJobState2;
                }
            } else {
                bJobState = bJobState2;
            }
            ++n;
        }
        return bJobState;
    }

    private final BJobState stateTransition(BJobState bJobState, BJobState bJobState2) {
        if (bJobState == bJobState2) {
            return bJobState;
        }
        switch (bJobState.getOrdinal()) {
            case 5: {
                return bJobState;
            }
            case 3: {
                return bJobState2 == BJobState.failed ? bJobState2 : bJobState;
            }
            case 0: {
                return bJobState2;
            }
            case 1: {
                return bJobState2 == BJobState.unknown ? bJobState : bJobState2;
            }
            case 4: {
                if (bJobState2 == BJobState.failed || bJobState2 == BJobState.canceled) {
                    return bJobState2;
                }
                return bJobState;
            }
        }
        if (bJobState2 == BJobState.failed || bJobState2 == BJobState.canceled) {
            return bJobState2;
        }
        return bJobState;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCancelEnabled(boolean bl) {
        this.cancelEnabled = bl;
    }

    public boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    public void cancel() {
        this.cancel(true);
    }

    public void checkCanceled() throws ICancelHint.CanceledException {
        if (this.isCanceled()) {
            throw new ICancelHint.CanceledException();
        }
    }

    public void cancel(boolean bl) {
        if (this.isCancelEnabled()) {
            if (bl) {
                this.updateCurrentItemState(BJobState.canceling);
            } else {
                this.updateCurrentItemState(BJobState.canceled);
            }
            this.setCancelEnabled(false);
            this.canceled = true;
        } else if (!bl) {
            this.updateCurrentItemState(BJobState.canceled);
        }
    }

    protected static BImage stateToIcon(BJobState bJobState) {
        switch (bJobState.getOrdinal()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return canceledIcon;
            }
            case 4: {
                return successIcon;
            }
            case 5: {
                return failedIcon;
            }
        }
        return BImage.NULL;
    }

    protected static String stateToLabel(BJobState bJobState) {
        if (bJobState == BJobState.unknown) {
            return unknownLabel;
        }
        return bJobState.toString();
    }

    private final /* synthetic */ void this() {
        this.currentItem = null;
        this.canceled = false;
        this.cancelEnabled = true;
    }

    public TaskDetailPane() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected static class TaskItem {
        public BJobState state;
        public String description;

        private final /* synthetic */ void this() {
            this.state = BJobState.unknown;
        }

        public TaskItem(String string) {
            this.this();
            this.description = string;
        }
    }
}

