/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.sysdef;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.sysdef.BLocalSysDefStation;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.workbench.shell.BNiagaraWbShell;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BICredentials;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.commands.InvokeActionCommand;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSubject;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSysDefNetwork
extends BWbView
implements Runnable {
    public static final Action updateDetails = BSysDefNetwork.newAction((int)0, null);
    public static final Type TYPE;
    static Lexicon lex;
    static BImage foxTunnelIcon;
    BTextField startStation;
    BTextField targetStation;
    BTextEditorPane stationServices;
    private BNiagaraNetwork network = null;
    private ProviderSession sysdef = null;
    BTree tree = new BTree();
    Model model;
    Node localNode;
    static /* synthetic */ Class class$com$tridium$nd$ui$sysdef$BSysDefNetwork;
    static /* synthetic */ Class class$com$tridium$nd$ui$sysdef$BSysDefNetwork$Node;

    public void updateDetails() {
        this.invoke(updateDetails, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        super.doLoadValue(bObject, context);
        this.network = (BNiagaraNetwork)bObject;
        this.sysdef = this.network.getSysDefProvider().createSession("SysDefNetwork", context);
        BEdgePane bEdgePane = new BEdgePane();
        this.loadTree();
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.tree, BBorder.inset, BInsets.DEFAULT));
        BGridPane bGridPane = new BGridPane(4);
        this.startStation = new BTextField("Start");
        this.targetStation = new BTextField("Target");
        bGridPane.add(null, (BValue)new BButton((Command)new ConnectCommand()));
        bGridPane.add(null, (BValue)this.startStation);
        bGridPane.add(null, (BValue)this.targetStation);
        bGridPane.add(null, (BValue)new BButton((Command)new FindCommand()));
        bGridPane.add(null, (BValue)new BButton((Command)new EngageTestCommand()));
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setTop((BWidget)bGridPane);
        this.stationServices = new BTextEditorPane("", 5, 80, false);
        bEdgePane2.setBottom((BWidget)this.stationServices);
        bEdgePane.setBottom((BWidget)bEdgePane2);
        this.setContent((BWidget)bEdgePane);
        this.network.getWorkers().register(this, 1000L);
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        if (this.network != null) {
            this.network.getWorkers().unregister(this);
        }
        return super.doSaveValue(bObject, context);
    }

    public void deactivated() {
        if (this.sysdef != null) {
            this.sysdef.close();
        }
        if (this.network != null) {
            this.network.getWorkers().unregister(this);
        }
        super.deactivated();
    }

    public void stopped() throws Exception {
        if (this.sysdef != null) {
            this.sysdef.close();
        }
        if (this.network != null) {
            this.network.getWorkers().unregister(this);
        }
        super.stopped();
    }

    public void run() {
        this.tree.repaint();
        this.updateServices();
    }

    void updateServices() {
        Node node = (Node)this.tree.getSelection().getNode();
        StringBuffer stringBuffer = new StringBuffer();
        if (node != null) {
            BProviderStation bProviderStation = (BProviderStation)this.sysdef.getStation(node.station);
            Object[] objectArray = bProviderStation.getServiceTypes().trim();
            SortUtil.sort((Object[])objectArray);
            int n = 0;
            if (objectArray != null) {
                n = objectArray.length;
            }
            int n2 = n;
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append(((BTypeSpec)objectArray[n3]).getTypeName()).append("; ");
                if (n3 > 0 && n3 % 4 == 0) {
                    stringBuffer.append("\n");
                }
                ++n3;
            }
        }
        this.stationServices.setText(stringBuffer.toString());
    }

    private final void loadTree() {
        BProviderStation bProviderStation = (BProviderStation)this.sysdef.getLocalStation();
        BINiagaraStation[] bINiagaraStationArray = this.sysdef.getSupervisors(bProviderStation);
        int n = 0;
        while (n < bINiagaraStationArray.length) {
            this.model.addRoot(new SupervisorNode((TreeModel)this.model, null, (BProviderStation)bINiagaraStationArray[n]));
            ++n;
        }
        this.localNode = new Node(this.model, null, bProviderStation.getStationName());
        this.model.addRoot(this.localNode);
    }

    public void doUpdateDetails() {
        Node node = (Node)this.tree.getSelection().getNode();
        if (node == null) {
            System.out.println("None selected.");
        } else {
            System.out.println("Selected: " + node.station);
            this.updateServices();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BSysDefNetwork() {
        this.tree.setMultipleSelection(false);
        this.tree.setController((TreeController)new Controller());
        this.model = new Model();
        this.tree.setModel((TreeModel)this.model);
        this.linkTo((BComponent)this.tree, (Slot)BTree.actionPerformed, (Slot)updateDetails);
    }

    static {
        Class clazz = class$com$tridium$nd$ui$sysdef$BSysDefNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$nd$ui$sysdef$BSysDefNetwork = BSysDefNetwork.class("[Lcom.tridium.nd.ui.sysdef.BSysDefNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$nd$ui$sysdef$BSysDefNetwork;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$nd$ui$sysdef$BSysDefNetwork = BSysDefNetwork.class("[Lcom.tridium.nd.ui.sysdef.BSysDefNetwork;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        foxTunnelIcon = BImage.make((BIcon)BIcon.std((String)"foxTunnel.png"));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ConnectCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            Node node = (Node)BSysDefNetwork.this.tree.getSelection().getNode();
            if (node != null) {
                BFoxSession bFoxSession = BSysDefNetwork.this.sysdef.getFoxSession(BSysDefNetwork.this.sysdef.getStation(node.station));
                BOrd bOrd = bFoxSession.getNavOrd();
                BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)BSysDefNetwork.this.getWbShell();
                if (!bNiagaraWbShell.isApplet() && !bFoxSession.isConnected()) {
                    try {
                        BISession bISession = BSysDefNetwork.this.network.getSession();
                        BICredentials bICredentials = (BICredentials)((BComplex)((BFoxSession)bISession).getCredentials()).newCopy(true);
                        bNiagaraWbShell.resolve(bOrd, bICredentials);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        if (throwable instanceof UnresolvedException) {
                            throwable2 = throwable.getCause();
                        }
                        String string = lex.getText("mgr.connect.cannotConnect", new Object[]{node.station, bOrd});
                        BDialog.error((BWidget)BSysDefNetwork.this, (String)BDialog.TITLE_ERROR, (Object)string, (Throwable)throwable2);
                        return null;
                    }
                    if (!bFoxSession.isConnected()) {
                        throw new IllegalStateException();
                    }
                }
                if (bFoxSession != null) {
                    bNiagaraWbShell.hyperlink(new HyperlinkInfo(BOrd.make((BOrd)bOrd, (String)"station:|slot:/")));
                }
            }
            return null;
        }

        public ConnectCommand() {
            super((BWidget)BSysDefNetwork.this, "Connect");
            this.icon = foxTunnelIcon;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class FindCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            String string = BSysDefNetwork.this.startStation.getText().length() == 0 ? ((Node)BSysDefNetwork.this.model.getRoot((int)(BSysDefNetwork.this.model.getRootCount() - 1))).station : BSysDefNetwork.this.startStation.getText();
            String[][] stringArray = BSysDefNetwork.this.sysdef.getRoutes(string, BSysDefNetwork.this.targetStation.getText());
            System.out.println("Routes from: " + string + " to " + BSysDefNetwork.this.targetStation.getText());
            int n = 0;
            while (n < stringArray.length) {
                System.out.println("  Route " + n + ": " + TextUtil.join((String[])stringArray[n], (char)','));
                ++n;
            }
            return null;
        }

        public FindCommand() {
            super((BWidget)BSysDefNetwork.this, "Find");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class EngageTestCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            Node node = (Node)BSysDefNetwork.this.tree.getSelection().getNode();
            if (node != null) {
                BINiagaraStation bINiagaraStation = BSysDefNetwork.this.sysdef.getStation(node.station);
                bINiagaraStation.engageNoRetry("test");
                System.out.println(bINiagaraStation.getStationName() + " engaged " + bINiagaraStation.isEngaged("test"));
                bINiagaraStation.disengage("test");
            }
            return null;
        }

        public EngageTestCommand() {
            super((BWidget)BSysDefNetwork.this, "Engage/Disengage");
            this.icon = foxTunnelIcon;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Node
    extends TreeNode {
        String station;
        TreeNode[] subordinates;

        public TreeNode getChild(int n) {
            this.load();
            return this.subordinates[n];
        }

        public int getChildCount() {
            this.load();
            return this.subordinates.length;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"device.png"));
        }

        public String getText() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.station);
            BProviderStation bProviderStation = (BProviderStation)BSysDefNetwork.this.sysdef.getStation(this.station);
            stringBuffer.append("    -    foxTunnel: ").append((Object)bProviderStation.getFoxTunneling());
            if (bProviderStation.getOnlyTunnelKnownStations().getOrdinal() == 0) {
                stringBuffer.append("*");
            }
            stringBuffer.append(", httpTunnel: ").append((Object)bProviderStation.getHttpTunneling());
            if (bProviderStation.getProxyAuthenticationWhenTunneling().getOrdinal() == 0) {
                stringBuffer.append("*");
            }
            return stringBuffer.toString();
        }

        public boolean hasChildren() {
            return true;
        }

        protected void load() {
            if (this.subordinates == null) {
                System.out.println("Load: " + this.station);
                BINiagaraStation[] bINiagaraStationArray = BSysDefNetwork.this.sysdef.getSubordinates(BSysDefNetwork.this.sysdef.getStation(this.station));
                this.subordinates = new TreeNode[bINiagaraStationArray.length];
                int n = 0;
                while (n < bINiagaraStationArray.length) {
                    this.subordinates[n] = new Node(this.getModel(), this, bINiagaraStationArray[n].getStationName());
                    ++n;
                }
            }
        }

        public Node(TreeModel treeModel, TreeNode treeNode, String string) {
            super(treeModel, treeNode);
            this.station = string;
            this.subordinates = null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SupervisorNode
    extends Node {
        public boolean hasChildren() {
            return false;
        }

        public SupervisorNode(TreeModel treeModel, TreeNode treeNode, BProviderStation bProviderStation) {
            super(treeModel, treeNode, bProviderStation.getStationName());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends TreeModel {
        Array roots;

        public TreeNode getRoot(int n) {
            return (TreeNode)this.roots.get(n);
        }

        public int getRootCount() {
            return this.roots.size();
        }

        public void addRoot(Node node) {
            this.roots.add((Object)node);
        }

        private final /* synthetic */ void this() {
            Class clazz = class$com$tridium$nd$ui$sysdef$BSysDefNetwork$Node;
            if (clazz == null) {
                clazz = class$com$tridium$nd$ui$sysdef$BSysDefNetwork$Node = BSysDefNetwork.class("[Lcom.tridium.nd.ui.sysdef.BSysDefNetwork$Node;", false);
            }
            this.roots = new Array(clazz);
        }

        Model() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Controller
    extends TreeController {
        protected BMenu makePopup(TreeSubject treeSubject) {
            BMenu bMenu = super.makePopup(treeSubject);
            if (bMenu == null) {
                bMenu = new BMenu();
            }
            bMenu.add(null, (Command)new LocalStationCommand(treeSubject.getActiveNode(), BLocalSysDefStation.changeAllTunneling));
            bMenu.add(null, (Command)new LocalStationCommand(treeSubject.getActiveNode(), BLocalSysDefStation.changeFoxTunneling));
            bMenu.add(null, (Command)new LocalStationCommand(treeSubject.getActiveNode(), BLocalSysDefStation.changeHttpTunneling));
            bMenu.add(null, (Command)new LocalStationCommand(treeSubject.getActiveNode(), BLocalSysDefStation.changeOnlyTunnelKnownStations));
            bMenu.add(null, (Command)new LocalStationCommand(treeSubject.getActiveNode(), BLocalSysDefStation.changeProxyAuthenticationWhenTunneling));
            bMenu.add(null, (Command)new ConnectCommand());
            return bMenu;
        }

        Controller() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LocalStationCommand
    extends Command {
        Action action;
        Node selection;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() throws Exception {
            CommandArtifact commandArtifact;
            block8: {
                BICredentials bICredentials;
                BFoxSession bFoxSession = BSysDefNetwork.this.sysdef.getFoxSession(BSysDefNetwork.this.sysdef.getStation(this.selection.station));
                BFoxClientConnection.StringInterest stringInterest = null;
                BOrd bOrd = bFoxSession.getNavOrd();
                BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)BSysDefNetwork.this.getWbShell();
                if (!bFoxSession.isConnected()) {
                    Object object;
                    try {
                        if (bNiagaraWbShell.isApplet()) {
                            bFoxSession.getConnection().setCheckBrandCompatibility(false);
                        }
                        object = BSysDefNetwork.this.network.getSession();
                        bICredentials = (BICredentials)((BComplex)((BFoxSession)object).getCredentials()).newCopy(true);
                        bNiagaraWbShell.resolve(bOrd, bICredentials);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        if (throwable instanceof UnresolvedException) {
                            throwable2 = throwable.getCause();
                        }
                        String string = lex.getText("mgr.connect.cannotConnect", new Object[]{this.selection.station, bOrd});
                        BDialog.error((BWidget)BSysDefNetwork.this, (String)BDialog.TITLE_ERROR, (Object)string, (Throwable)throwable2);
                        return null;
                    }
                    if (!bFoxSession.isConnected()) {
                        throw new IllegalStateException();
                    }
                    object = new StringBuffer();
                    ((StringBuffer)object).append("SysDefAction_").append(this.action.getName()).append("_");
                    ((StringBuffer)object).append(this.selection.station).append("_");
                    ((StringBuffer)object).append(BAbsTime.now().encodeToString());
                    stringInterest = new BFoxClientConnection.StringInterest(((StringBuffer)object).toString());
                    bFoxSession.getConnection().engageNoRetry((BFoxClientConnection.Interest)stringInterest);
                }
                try {
                    BOrd bOrd2 = BOrd.make((String)"service:niagaraDriver:NiagaraNetwork");
                    BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)bOrd2.get((BObject)bFoxSession);
                    BOrd bOrd3 = BOrd.make((BOrd)bNiagaraNetwork.getSlotPathOrd(), (String)"slot:localStation");
                    BComponent bComponent = (BComponent)bOrd3.get((BObject)bNiagaraNetwork);
                    bComponent.lease();
                    InvokeActionCommand invokeActionCommand = new InvokeActionCommand((BWidget)BSysDefNetwork.this, bComponent, this.action);
                    commandArtifact = invokeActionCommand.doInvoke();
                    bICredentials = null;
                    if (stringInterest == null) break block8;
                }
                catch (Throwable throwable) {
                    block9: {
                        bICredentials = null;
                        if (stringInterest == null) break block9;
                        bFoxSession.getConnection().disengage(stringInterest);
                    }
                    throw throwable;
                }
                bFoxSession.getConnection().disengage(stringInterest);
            }
            return commandArtifact;
        }

        public LocalStationCommand(TreeNode treeNode, Action action) {
            super((BWidget)BSysDefNetwork.this, action.getDefaultDisplayName(null));
            this.action = action;
            this.selection = (Node)treeNode;
        }
    }
}

