/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.ui.FoxSessionSupport;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.gx.BImage;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.ui.BWidget;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrLearn;

public abstract class NiagaraLearn
extends MgrLearn {
    public static final int UNESCAPE = 1;
    BComponent target;
    FoxSessionSupport sessionSupport;
    BOrd bqlQuery;
    BITable lastLearn;

    public NiagaraLearn(BAbstractManager bAbstractManager) {
        super(bAbstractManager);
    }

    public BComponent getTarget() {
        return this.target;
    }

    public BFoxSession getTargetSession() {
        return this.sessionSupport == null ? null : this.sessionSupport.getTargetSession();
    }

    protected BWidget makeJobBar() {
        return null;
    }

    public void load(BComponent bComponent) {
        super.load(bComponent);
        this.target = bComponent;
        BISession bISession = bComponent.getSession();
        this.sessionSupport = bISession instanceof BFoxSession ? new FoxSessionSupport(this.getManager(), (BFoxSession)bISession) : new FoxSessionSupport(this.getManager(), null);
    }

    public BFoxSession connect(BNiagaraStation bNiagaraStation) {
        bNiagaraStation.lease(1);
        return this.sessionSupport.connect(bNiagaraStation.getStationName(), bNiagaraStation.getAddress(), bNiagaraStation.getClientConnection().getPort(), bNiagaraStation.getClientConnection().getUseFoxs());
    }

    public BFoxSession connect(BNiagaraStation bNiagaraStation, boolean bl) {
        bNiagaraStation.lease(1);
        return this.connect(bNiagaraStation.getStationName(), bNiagaraStation.getAddress(), bNiagaraStation.getClientConnection().getPort(), bNiagaraStation.getClientConnection().getUseFoxs(), bNiagaraStation.getNiagaraNetwork(), bl);
    }

    public BFoxSession connect(BLearnStation bLearnStation, boolean bl) {
        String string = bl ? bLearnStation.getHostName() : bLearnStation.getHostAddress();
        boolean bl2 = false;
        if (bLearnStation.getScheme().equalsIgnoreCase("foxs")) {
            bl2 = true;
        }
        return this.sessionSupport.connect(bLearnStation.getStationName(), BOrd.make((String)("ip:" + string)), bLearnStation.getFoxPort(), bl2);
    }

    public BFoxSession connect(String string, BOrd bOrd, int n, boolean bl) {
        return this.sessionSupport.connect(string, bOrd, n, bl);
    }

    public BFoxSession connect(String string, BOrd bOrd, int n, boolean bl, String[] stringArray) {
        return this.sessionSupport.connect(string, bOrd, n, bl, stringArray);
    }

    BFoxSession connect(String string, BOrd bOrd, int n, boolean bl, BNiagaraNetwork bNiagaraNetwork, boolean bl2) {
        String string2;
        if (!bl2) {
            return this.connect(string, bOrd, n, bl);
        }
        BFoxSession bFoxSession = (BFoxSession)bNiagaraNetwork.getSession();
        String[] stringArray = bFoxSession.getTunnelAuthorities();
        StringBuffer stringBuffer = new StringBuffer();
        bNiagaraNetwork.getFoxService().lease();
        if (bNiagaraNetwork.getFoxService().getOnlyTunnelKnownStations()) {
            stringBuffer.append(string);
        } else {
            string2 = ((BHost)bOrd.get()).getHostname();
            if (string2.indexOf(58) != string2.lastIndexOf(58) && !string2.startsWith("[") && !string2.endsWith("]")) {
                stringBuffer.append("[").append(string2).append("]");
            } else {
                stringBuffer.append(string2);
            }
        }
        stringBuffer.append(":" + n);
        string2 = stringBuffer.toString();
        if (stringArray == null) {
            stringArray = new String[]{string2};
        } else {
            int n2 = stringArray.length;
            String[] stringArray2 = new String[n2 + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            stringArray2[n2] = string2;
            stringArray = stringArray2;
        }
        BOrd bOrd2 = bFoxSession.getHost().getNavOrd();
        int n3 = bFoxSession.getPort();
        return this.connect(string, bOrd2, n3, bFoxSession.getUseFoxs(), stringArray);
    }

    public void bqlDiscover(BFoxSession bFoxSession, BTypeSpec bTypeSpec) throws Exception {
        BStation bStation;
        BBqlQueryBuilder bBqlQueryBuilder;
        BOrd bOrd;
        String string;
        if (this.bqlQuery == null) {
            string = this.getBqlProjection();
            this.bqlQuery = BOrd.make((String)("station:|slot:/|bql:select " + string + " from " + bTypeSpec));
        }
        if ((bOrd = (bBqlQueryBuilder = new BBqlQueryBuilder((BObject)(bStation = (BStation)(string = (BComponentSpace)bFoxSession.getNavChild("station")).getRootComponent()), this.bqlQuery, false)).open((BWidget)this.getManager())) == null) {
            return;
        }
        this.bqlQuery = bOrd.relativizeToSession();
        BITable bITable = (BITable)this.bqlQuery.get((BObject)bFoxSession);
        this.updateTable(bFoxSession, bITable);
    }

    public String getBqlProjection() {
        StringBuffer stringBuffer = new StringBuffer();
        MgrColumn[] mgrColumnArray = this.getColumns();
        for (int i = 0; i < mgrColumnArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            Column column = (Column)mgrColumnArray[i];
            stringBuffer.append(column.projection);
        }
        stringBuffer.append(",icon");
        return stringBuffer.toString();
    }

    public BImage getIcon(Object object) {
        return ((Node)object).getIcon();
    }

    public boolean hasChildren(Object object) {
        return ((Node)object).hasChildren();
    }

    public Object[] getChildren(Object object) {
        return ((Node)object).getChildren();
    }

    public void updateTable(BFoxSession bFoxSession, BITable bITable) {
        this.lastLearn = bITable;
        Object[] objectArray = new Node[bITable.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.makeNode(bFoxSession);
            ((Node)objectArray[i]).update(bITable, i);
        }
        this.updateRoots(objectArray);
    }

    protected Node makeNode(BFoxSession bFoxSession) {
        return new Node(bFoxSession);
    }

    public static class Node {
        public BFoxSession session;
        public BImage icon;
        public BObject[] cells;

        public Node(BFoxSession bFoxSession) {
            this.session = bFoxSession;
        }

        public BImage getIcon() {
            return this.icon;
        }

        public Object get(MgrColumn mgrColumn) {
            return ((Column)mgrColumn).get(this);
        }

        public boolean hasChildren() {
            return false;
        }

        public Node[] getChildren() {
            return new Node[0];
        }

        public void update(BITable bITable, int n) {
            ColumnList columnList = bITable.getColumns();
            this.cells = new BObject[columnList.size() - 1];
            for (int i = 0; i < this.cells.length; ++i) {
                this.cells[i] = bITable.get(n, columnList.get(i));
            }
            this.icon = BImage.make((String)bITable.get(n, columnList.get(columnList.size() - 1)).toString());
        }
    }

    public static class Column
    extends MgrColumn {
        public final String projection;
        int colIndex = -1;
        int special;

        public Column(String string, String string2) {
            this(string, string2, 0, 0);
        }

        public Column(String string, String string2, int n) {
            this(string, string2, n, 0);
        }

        public Column(String string, String string2, int n, int n2) {
            super(string, n);
            this.projection = string2;
            this.special = n2;
        }

        public int getColumnIndex() {
            if (this.colIndex == -1) {
                MgrColumn[] mgrColumnArray = this.getManager().getLearn().getColumns();
                for (int i = 0; i < mgrColumnArray.length; ++i) {
                    if (mgrColumnArray[i] != this) continue;
                    this.colIndex = i;
                    break;
                }
                if (this.colIndex == -1) {
                    throw new IllegalStateException("Column not in manager.getDiscoveryColumns()");
                }
            }
            return this.colIndex;
        }

        public Object get(Object object) {
            BObject bObject = ((Node)object).cells[this.getColumnIndex()];
            if ((this.special & 1) != 0) {
                return SlotPath.unescape((String)bObject.toString());
            }
            return bObject;
        }
    }
}

