/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.util.Arrays;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.sys.BComplex;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;

public class FoxSessionSupport {
    static Lexicon lex = Lexicon.make((Class)(class$com$tridium$nd$ui$FoxSessionSupport == null ? (class$com$tridium$nd$ui$FoxSessionSupport = FoxSessionSupport.class$("com.tridium.nd.ui.FoxSessionSupport")) : class$com$tridium$nd$ui$FoxSessionSupport));
    BAbstractManager manager;
    BFoxSession targetSession;
    static /* synthetic */ Class class$com$tridium$nd$ui$FoxSessionSupport;

    public FoxSessionSupport(BAbstractManager bAbstractManager, BFoxSession bFoxSession) {
        this.manager = bAbstractManager;
        this.targetSession = bFoxSession;
    }

    public BFoxSession getTargetSession() {
        return this.targetSession;
    }

    public BFoxSession connect(BNiagaraStation bNiagaraStation) {
        bNiagaraStation.lease(1);
        return this.connect(bNiagaraStation.getName(), bNiagaraStation.getAddress(), bNiagaraStation.getClientConnection().getPort(), bNiagaraStation.getClientConnection().getUseFoxs());
    }

    public BFoxSession connect(BLearnStation bLearnStation) {
        boolean bl = false;
        if (bLearnStation.getScheme().equalsIgnoreCase("foxs")) {
            bl = true;
        }
        return this.connect(bLearnStation.getStationName(), BOrd.make((String)("ip:" + bLearnStation.getHostAddress())), bLearnStation.getFoxPort(), bl);
    }

    public BFoxSession connect(String string, BOrd bOrd, int n, boolean bl) {
        return this.connect(string, bOrd, n, bl, null);
    }

    public BFoxSession connect(String string, BOrd bOrd, int n, boolean bl, String[] stringArray) {
        if (this.targetSession == null) {
            BDialog.error((BWidget)this.manager, (Object)lex.getText("mgr.connect.noTargetSession"));
            return null;
        }
        BFoxSession bFoxSession = null;
        BFoxSession[] bFoxSessionArray = BFoxSession.list();
        for (int i = 0; i < bFoxSessionArray.length; ++i) {
            if (!string.equals(bFoxSessionArray[i].getStationName()) || !Arrays.equals(stringArray, bFoxSessionArray[i].getTunnelAuthorities())) continue;
            bFoxSession = bFoxSessionArray[i];
            break;
        }
        if (bFoxSession == null) {
            BHost bHost = (BHost)bOrd.get();
            bFoxSession = BFoxSession.make((String)string, (BHost)bHost, (int)n, (boolean)bl, (String[])stringArray);
        }
        if (!bFoxSession.isConnected()) {
            BOrd bOrd2 = bFoxSession.getNavOrd();
            BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)this.manager.getWbShell();
            try {
                BICredentials bICredentials = (BICredentials)((BComplex)this.targetSession.getCredentials()).newCopy(true);
                bNiagaraWbShell.resolve(bOrd2, bICredentials);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable instanceof UnresolvedException) {
                    throwable2 = throwable.getCause();
                }
                String string2 = bNiagaraWbShell.isApplet() ? lex.getText("mgr.connect.cannotConnect.applet") : lex.getText("mgr.connect.cannotConnect", new Object[]{string, bOrd2});
                BDialog.error((BWidget)this.manager, (String)BDialog.TITLE_ERROR, (Object)string2, (Throwable)throwable2);
                return null;
            }
        }
        if (!bFoxSession.isConnected()) {
            throw new IllegalStateException();
        }
        if (!string.equals(bFoxSession.getStationName())) {
            BDialog.error((BWidget)this.manager, (Object)lex.getText("mgr.connect.mismatchStationName", new Object[]{bOrd, bFoxSession.getStationName(), string}));
            return null;
        }
        return bFoxSession;
    }

    public BFoxSession fwConnect(BNiagaraStation bNiagaraStation) throws Exception {
        bNiagaraStation.lease(1);
        String string = bNiagaraStation.getStationName();
        BNiagaraNetwork bNiagaraNetwork = bNiagaraStation.getNiagaraNetwork();
        BFoxSession bFoxSession = (BFoxSession)bNiagaraNetwork.getSession();
        String[] stringArray = bFoxSession.getTunnelAuthorities();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(":" + bNiagaraStation.getClientConnection().getPort());
        String string2 = stringBuffer.toString();
        if (stringArray == null) {
            stringArray = new String[]{string2};
        } else {
            int n = stringArray.length;
            String[] stringArray2 = new String[n + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray2[n] = string2;
            stringArray = stringArray2;
        }
        BOrd bOrd = bFoxSession.getHost().getNavOrd();
        int n = bFoxSession.getPort();
        return this.fwConnect(string, bOrd, n, bFoxSession.getUseFoxs(), stringArray);
    }

    BFoxSession fwConnect(String string, BOrd bOrd, int n, boolean bl, String[] stringArray) throws Exception {
        if (this.targetSession == null) {
            throw new IllegalStateException(lex.getText("mgr.connect.noTargetSession"));
        }
        BHost bHost = (BHost)bOrd.get();
        BFoxSession bFoxSession = bl ? (BFoxSession)this.targetSession.fw(806, (Object)string, (Object)bHost, (Object)new Integer(n), (Object)stringArray) : (BFoxSession)this.targetSession.fw(802, (Object)string, (Object)bHost, (Object)new Integer(n), (Object)stringArray);
        BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)this.manager.getWbShell();
        if (bNiagaraWbShell.isApplet()) {
            bFoxSession.getConnection().setCheckBrandCompatibility(false);
        }
        BICredentials bICredentials = (BICredentials)((BComplex)this.targetSession.getCredentials()).newCopy(true);
        bFoxSession.setCredentials(bICredentials);
        boolean bl2 = false;
        Exception exception = null;
        boolean bl3 = false;
        while (!bl2) {
            try {
                bFoxSession.connect();
            }
            catch (AuthenticationException authenticationException) {
                if (AuthUtil.challenge((BWidget)bNiagaraWbShell, (AuthenticationException)authenticationException, (boolean)bl3)) {
                    bl3 = true;
                    continue;
                }
                return null;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            bl2 = true;
        }
        if (exception != null) {
            try {
                bFoxSession.disconnect();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw exception;
        }
        if (!bFoxSession.isConnected()) {
            throw new IllegalStateException();
        }
        if (!string.equals(bFoxSession.getStationName())) {
            try {
                bFoxSession.disconnect();
            }
            catch (Exception exception4) {
                exception4.printStackTrace();
            }
            throw new IllegalStateException(lex.getText("mgr.connect.mismatchStationName", new Object[]{bOrd, bFoxSession.getStationName(), string}));
        }
        return bFoxSession;
    }

    public static int getFwConnectionType(BFoxSession bFoxSession) {
        int n = -1;
        try {
            Object object;
            if (bFoxSession != null && (object = bFoxSession.getConnection().fw(803, null, null, null, null)) instanceof Integer) {
                n = (Integer)object;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

