/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.ui.BStationMgrCommand;
import com.tridium.nd.ui.NiagaraLearn;
import com.tridium.nd.ui.StationModel;
import com.tridium.workbench.job.BJobBar;
import javax.baja.driver.BDevice;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceState;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.util.Lexicon;
import javax.baja.workbench.component.table.ComponentTableSubject;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BStationManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$nd$ui$BStationManager == null ? (class$com$tridium$nd$ui$BStationManager = BStationManager.class$("com.tridium.nd.ui.BStationManager")) : class$com$tridium$nd$ui$BStationManager));
    static BImage stationIcon = BImage.make((String)"module://icons/x16/device.png");
    static BImage secureStationIcon = BImage.make((BIcon)BIcon.make((BIcon)BIcon.std((String)"device.png"), (BIcon)BIcon.std((String)"badges/lock.png")));
    static boolean lastUseHostName = false;
    final Lexicon lex = Lexicon.make((Class)(class$com$tridium$nd$ui$BStationManager == null ? (class$com$tridium$nd$ui$BStationManager = BStationManager.class$("com.tridium.nd.ui.BStationManager")) : class$com$tridium$nd$ui$BStationManager));
    final String lexFoxPort = this.lex.getText("stationManager.foxPort");
    final String lexUseFoxs = this.lex.getText("stationManager.useFoxs");
    final String lexClientConn = this.lex.getText("stationManager.clientConn");
    final String lexServerConn = this.lex.getText("stationManager.serverConn");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(2);
    MgrColumn colDeviceExts = new DeviceExtsColumn((BDevice)new BNiagaraStation());
    MgrColumn colAddress = new MgrColumn.Prop(BNiagaraStation.address, 1);
    MgrColumn colFoxPort = new MgrColumn.PropPath(this.lexFoxPort, new Property[]{BNiagaraStation.clientConnection, BFoxClientConnection.port}, 3);
    MgrColumn colUseFoxs = new MgrColumn.PropPath(this.lexUseFoxs, new Property[]{BNiagaraStation.clientConnection, BFoxClientConnection.useFoxs}, 3);
    MgrColumn colHostModel = new MgrColumn.Prop(BNiagaraStation.hostModel);
    MgrColumn colVersion = new MgrColumn.Prop(BNiagaraStation.version);
    MgrColumn colUser = new MgrColumn.PropPath(new Property[]{BNiagaraStation.clientConnection, BFoxClientConnection.username}, 3);
    MgrColumn colPass = new MgrColumn.PropPath(new Property[]{BNiagaraStation.clientConnection, BFoxClientConnection.password}, 3);
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 0);
    MgrColumn colFatalCause = new MgrColumn.Prop(BDevice.faultCause, 2);
    MgrColumn colClientConn = new MgrColumn.PropPath(this.lexClientConn, new Property[]{BNiagaraStation.clientConnection, BFoxConnection.state}, 0);
    MgrColumn colServerConn = new MgrColumn.PropPath(this.lexServerConn, new Property[]{BNiagaraStation.serverConnection, BFoxConnection.state}, 0);
    MgrColumn colVirtualsEnabled = new MgrColumn.Prop(BNiagaraStation.virtualsEnabled, 1);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colDeviceExts, this.colAddress, this.colFoxPort, this.colUseFoxs, this.colHostModel, this.colVersion, this.colUser, this.colPass, this.colStatus, this.colEnabled, this.colHealth, this.colFatalCause, this.colClientConn, this.colServerConn, this.colVirtualsEnabled};
    BIDeviceFolder folder;
    BNiagaraNetwork network;
    BLearnStation[] lastLearn;
    ToggleCommand useHostName = new ToggleCommand((BWidget)this, "Use Host Name");
    ToggleCommand useHostAddress = new ToggleCommand((BWidget)this, "Use Host Address");
    static /* synthetic */ Class class$com$tridium$nd$ui$BStationManager;
    static /* synthetic */ Class class$com$tridium$fox$sys$BLearnStation;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$MgrController$IMgrCommand;

    public Type getType() {
        return TYPE;
    }

    public BStationManager() {
        boolean bl = lastUseHostName;
        HostToggle hostToggle = new HostToggle();
        hostToggle.add(this.useHostName);
        hostToggle.add(this.useHostAddress);
        if (bl) {
            this.useHostName.setSelected(true);
        } else {
            this.useHostAddress.setSelected(true);
        }
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    public BNiagaraNetwork getNetwork() {
        return (BNiagaraNetwork)this.getCurrentValue();
    }

    public void doLoadValue(BObject bObject, Context context) {
        super.doLoadValue(bObject, context);
        this.folder = (BIDeviceFolder)bObject;
        try {
            this.network = (BNiagaraNetwork)this.folder.getNetwork();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateDiscoveryRows(BComponent bComponent) {
        Object[] objectArray = (BLearnStation[])bComponent.getChildren(class$com$tridium$fox$sys$BLearnStation == null ? (class$com$tridium$fox$sys$BLearnStation = BStationManager.class$("com.tridium.fox.sys.BLearnStation")) : class$com$tridium$fox$sys$BLearnStation);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = (BLearnStation)objectArray[i].newCopy();
        }
        this.learnRowsInvariant(objectArray);
        this.lastLearn = objectArray;
        this.getLearn().updateRoots(objectArray);
    }

    public void learnRowsInvariant(Object[] objectArray) {
        boolean bl = this.useHostName.isSelected();
        for (int i = 0; i < objectArray.length; ++i) {
            BLearnStation bLearnStation = (BLearnStation)objectArray[i];
            bLearnStation.invariant(bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class OpenStationCommand
    extends Command {
        String stationName;
        BOrd host;
        int port;
        boolean useFoxs;
        boolean tunnel;
        BMouseEvent event;

        OpenStationCommand(BWidget bWidget, BNiagaraStation bNiagaraStation, BMouseEvent bMouseEvent, boolean bl) {
            super(bWidget, BStationManager.this.lex.module, bl ? "stationManager.openStationTunnel" : "stationManager.openStation");
            this.stationName = bNiagaraStation.getName();
            this.host = bNiagaraStation.getAddress();
            this.port = bNiagaraStation.getClientConnection().getPort();
            this.useFoxs = bNiagaraStation.getClientConnection().getUseFoxs();
            this.event = bMouseEvent;
            this.tunnel = bl;
        }

        OpenStationCommand(BWidget bWidget, BLearnStation bLearnStation, BMouseEvent bMouseEvent, boolean bl) {
            super(bWidget, BStationManager.this.lex.module, bl ? "stationManager.openStationTunnel" : "stationManager.openStation");
            String string = BStationManager.this.useHostName.isSelected() ? bLearnStation.getHostName() : bLearnStation.getHostAddress();
            this.stationName = bLearnStation.getStationName();
            this.host = BOrd.make((String)("ip:" + string));
            this.port = bLearnStation.getFoxPort();
            this.useFoxs = false;
            if (bLearnStation.getScheme().equalsIgnoreCase("foxs")) {
                this.useFoxs = true;
            }
            this.event = bMouseEvent;
            this.tunnel = bl;
        }

        public CommandArtifact doInvoke() throws Exception {
            BNiagaraNetwork bNiagaraNetwork;
            Learn learn = (Learn)BStationManager.this.getLearn();
            BFoxSession bFoxSession = learn.connect(this.stationName, this.host, this.port, this.useFoxs, bNiagaraNetwork = BStationManager.this.network != null ? BStationManager.this.network : BStationManager.this.getNetwork(), this.tunnel);
            if (bFoxSession != null) {
                BStationManager.this.getWbShell().hyperlink(new HyperlinkInfo(bFoxSession.getNavOrd(), (BInputEvent)this.event));
            }
            return null;
        }
    }

    class Controller
    extends DeviceController {
        Controller(BStationManager bStationManager2) {
            super((BDeviceManager)bStationManager2);
            this.allDescendants.setFlags(this.allDescendants.getFlags() | 8);
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            BStationManager.this.getLearn().setJob(BStationManager.this.network.submitStationDiscoveryJob());
            return null;
        }

        public BMenu makePopup(BLearnTable bLearnTable, TreeTableSubject treeTableSubject, BMenu bMenu) {
            bMenu = super.makePopup(bLearnTable, treeTableSubject, bMenu);
            if (treeTableSubject.size() == 1) {
                BLearnStation bLearnStation = (BLearnStation)treeTableSubject.get(0);
                bMenu.add(null, (BValue)new BSeparator());
                bMenu.add(null, (Command)new OpenStationCommand((BWidget)this.getManager(), bLearnStation, null, false));
                bMenu.add(null, (Command)new OpenStationCommand((BWidget)this.getManager(), bLearnStation, null, true));
            }
            return bMenu;
        }

        public BMenu makePopup(BMgrTable bMgrTable, ComponentTableSubject componentTableSubject, BMenu bMenu) {
            bMenu = super.makePopup(bMgrTable, componentTableSubject, bMenu);
            if (componentTableSubject.size() == 1 && componentTableSubject.get(0) instanceof BNiagaraStation) {
                BNiagaraStation bNiagaraStation = (BNiagaraStation)componentTableSubject.get(0);
                bMenu.add(null, (BValue)new BSeparator());
                bMenu.add(null, (Command)new OpenStationCommand((BWidget)this.getManager(), bNiagaraStation, null, false));
                bMenu.add(null, (Command)new OpenStationCommand((BWidget)this.getManager(), bNiagaraStation, null, true));
            }
            return bMenu;
        }

        public BMenu makeOptionsMenu(BLearnTable bLearnTable, BMenu bMenu) {
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (Command)BStationManager.this.useHostName);
            bMenu.add(null, (Command)BStationManager.this.useHostAddress);
            return bMenu;
        }

        public CommandArtifact drop(BMgrTable bMgrTable, TransferContext transferContext) throws Exception {
            try {
                Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
                BObject[] bObjectArray = mark.getValues();
                boolean bl = bObjectArray.length > 0;
                for (int i = 0; i < bObjectArray.length; ++i) {
                    if (bObjectArray[i] instanceof BFoxSession) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    MgrEdit mgrEdit = new MgrEdit(this.getManager(), this.add.getLabel());
                    for (int i = 0; i < bObjectArray.length; ++i) {
                        BFoxSession bFoxSession = (BFoxSession)bObjectArray[i];
                        BNiagaraStation bNiagaraStation = new BNiagaraStation();
                        bNiagaraStation.setAddress(bFoxSession.getHost().getAbsoluteOrd());
                        bNiagaraStation.getClientConnection().setPort(bFoxSession.getPort());
                        MgrEditRow mgrEditRow = new MgrEditRow((BComponent)bNiagaraStation, null, null);
                        mgrEdit.addRow(mgrEditRow);
                        if (bFoxSession.getStationName() == null) continue;
                        mgrEditRow.setName(bFoxSession.getStationName());
                    }
                    return mgrEdit.invoke(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.drop(bMgrTable, transferContext);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BStationMgrCommand.TYPE.getTypeInfo());
            Array array = new Array(class$javax$baja$workbench$mgr$MgrController$IMgrCommand == null ? (class$javax$baja$workbench$mgr$MgrController$IMgrCommand = BStationManager.class$("javax.baja.workbench.mgr.MgrController$IMgrCommand")) : class$javax$baja$workbench$mgr$MgrController$IMgrCommand);
            for (int i = 0; i < typeInfoArray.length; ++i) {
                BStationMgrCommand bStationMgrCommand = (BStationMgrCommand)typeInfoArray[i].getInstance();
                if (!bStationMgrCommand.isCommandActive(BStationManager.this)) continue;
                array.add((Object)bStationMgrCommand.makeCommand(BStationManager.this));
            }
            return Controller.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])((MgrController.IMgrCommand[])array.trim()));
        }

        public void updateCommands() {
            MgrController.IMgrCommand[] iMgrCommandArray = this.getCommands();
            for (int i = 0; i < iMgrCommandArray.length; ++i) {
                if (!(iMgrCommandArray[i] instanceof BStationMgrCommand.Cmd)) continue;
                BStationMgrCommand.Cmd cmd = (BStationMgrCommand.Cmd)iMgrCommandArray[i];
                cmd.updateCommand();
            }
            super.updateCommands();
        }
    }

    static class State
    extends DeviceState {
        BLearnStation[] lastLearn;

        State() {
        }

        protected void saveForOrd(BAbstractManager bAbstractManager) {
            super.saveForOrd(bAbstractManager);
            BStationManager bStationManager = (BStationManager)bAbstractManager;
            this.lastLearn = bStationManager.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager bAbstractManager) {
            super.restoreForOrd(bAbstractManager);
            BStationManager bStationManager = (BStationManager)bAbstractManager;
            if (this.lastLearn != null) {
                bStationManager.lastLearn = this.lastLearn;
                bStationManager.getLearn().updateRoots((Object[])this.lastLearn);
            }
        }
    }

    class HostToggle
    extends ToggleCommandGroup {
        HostToggle() {
        }

        protected void selected(ToggleCommand toggleCommand) {
            lastUseHostName = toggleCommand == BStationManager.this.useHostName;
            MgrLearn mgrLearn = BStationManager.this.getLearn();
            if (mgrLearn == null) {
                return;
            }
            Object[] objectArray = BStationManager.this.getLearn().getRoots();
            if (objectArray == null) {
                return;
            }
            BStationManager.this.learnRowsInvariant(objectArray);
            mgrLearn.getTable().repaint();
        }
    }

    class Learn
    extends NiagaraLearn {
        Learn(BStationManager bStationManager2) {
            super((BAbstractManager)bStationManager2);
        }

        public BWidget makeJobBar() {
            return new BJobBar();
        }

        protected MgrColumn[] makeColumns() {
            Property[] propertyArray = new BLearnStation().getPropertiesArray();
            MgrColumn[] mgrColumnArray = new MgrColumn[propertyArray.length];
            for (int i = 0; i < propertyArray.length; ++i) {
                Property property = propertyArray[i];
                int n = property.getDefaultFlags();
                int n2 = 0;
                if ((n & 8) == 0) {
                    n2 |= 2;
                }
                mgrColumnArray[i] = new MgrColumn.Prop(propertyArray[i], n2);
            }
            return mgrColumnArray;
        }

        public boolean isMatchable(Object object, BComponent bComponent) {
            return true;
        }

        public BImage getIcon(Object object) {
            BLearnStation bLearnStation = (BLearnStation)object;
            if (bLearnStation.getScheme().equalsIgnoreCase("foxs")) {
                return secureStationIcon;
            }
            return stationIcon;
        }

        public MgrTypeInfo[] toTypes(Object object) {
            return BStationManager.this.getModel().getNewTypes();
        }

        public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
            BLearnStation bLearnStation = (BLearnStation)object;
            String string = BStationManager.this.useHostName.isSelected() ? bLearnStation.getHostName() : bLearnStation.getHostAddress();
            mgrEditRow.setName(bLearnStation.getStationName());
            mgrEditRow.setCell(BStationManager.this.colAddress, (BValue)BOrd.make((String)("ip:" + string)));
            mgrEditRow.setCell(BStationManager.this.colFoxPort, (BValue)BInteger.make((int)bLearnStation.getFoxPort()));
            mgrEditRow.setCell(BStationManager.this.colUseFoxs, (BValue)(bLearnStation.getScheme().equalsIgnoreCase("foxs") ? BBoolean.TRUE : BBoolean.FALSE));
        }

        public boolean isExisting(Object object, BComponent bComponent) {
            BLearnStation bLearnStation = (BLearnStation)object;
            if (bComponent instanceof BNiagaraStation) {
                BNiagaraStation bNiagaraStation = (BNiagaraStation)bComponent;
                return bLearnStation.getStationName().equals(bNiagaraStation.getName());
            }
            return false;
        }

        public void jobComplete(BJob bJob) {
            super.jobComplete(bJob);
            BStationManager.this.updateDiscoveryRows((BComponent)bJob);
        }
    }

    class Model
    extends StationModel {
        Model(BStationManager bStationManager2) {
            super(bStationManager2);
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BNiagaraStation.TYPE);
        }

        public int getSubscribeDepth() {
            return 1;
        }

        protected MgrColumn[] makeColumns() {
            return this.appendMixInColumns(BStationManager.this.cols, BNiagaraStation.TYPE);
        }
    }
}

