/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nd.ui.FoxSessionSupport;
import com.tridium.nd.ui.NiagaraLearn;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.driver.ui.point.PointState;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BNiagaraPointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$nd$ui$BNiagaraPointManager == null ? (class$com$tridium$nd$ui$BNiagaraPointManager = BNiagaraPointManager.class$("com.tridium.nd.ui.BNiagaraPointManager")) : class$com$tridium$nd$ui$BNiagaraPointManager));
    final Lexicon lex = Lexicon.make((Class)(class$com$tridium$nd$ui$BNiagaraPointManager == null ? (class$com$tridium$nd$ui$BNiagaraPointManager = BNiagaraPointManager.class$("com.tridium.nd.ui.BNiagaraPointManager")) : class$com$tridium$nd$ui$BNiagaraPointManager));
    final Lexicon driverLex = Lexicon.make((String)"driver");
    final String lexOut = this.driverLex.getText("out");
    final String lexSlotPath = UiLexicon.bajaui.getText("slotPath");
    final String lexHandle = UiLexicon.bajaui.getText("handle");
    final String lexType = UiLexicon.bajaui.getText("type");
    final String lexDisplayNames = UiLexicon.bajaui.getText("displayNames");
    final String lexDisplayName = UiLexicon.bajaui.getText("displayName");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colDisplayName = new DisplayNameColumn(this.lexDisplayName, 3);
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colPointId = new PointIdColumn(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.pointId}, 1);
    MgrColumn colString = new MgrColumn.ToString(this.lexOut, 0);
    MgrColumn colSubStatus = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.subscriptionStatus}, 0);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.enabled}, 3);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.tuningPolicyName}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.faultCause}, 2);
    MgrColumn colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.readValue}, 2);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.deviceFacets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.conversion}, 3);
    MgrColumn colDisplayNames = new DisplayNamesColumn(this.lexDisplayNames, 6);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colDisplayName, this.colType, this.colPointId, this.colString, this.colEnabled, this.colFacets, this.colTuning, this.colSubStatus, this.colFaultCause, this.colReadValue, this.colDeviceFacets, this.colConversion, this.colDisplayNames};
    MgrColumn dcolPath = new NiagaraLearn.Column(this.lexSlotPath, "toPathString", 0, 1);
    MgrColumn dcolHandle = new NiagaraLearn.Column(this.lexHandle, "handle", 2);
    MgrColumn dcolType = new NiagaraLearn.Column(this.lexType, "type");
    MgrColumn[] dcols = new MgrColumn[]{this.dcolPath, this.dcolHandle, this.dcolType};
    BIPointFolder folder;
    BNiagaraStation station;
    BNiagaraPointDeviceExt points;
    TunnelDiscoveryMode tunnelDiscovery;
    BFoxSession session;
    static /* synthetic */ Class class$com$tridium$nd$ui$BNiagaraPointManager;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    public void stopped() throws Exception {
        try {
            if (FoxSessionSupport.getFwConnectionType(this.session) != -1) {
                this.session.disconnect();
            }
            this.session = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.stopped();
    }

    public void deactivated() {
        try {
            if (FoxSessionSupport.getFwConnectionType(this.session) != -1) {
                this.session.disconnect();
            }
            this.session = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.deactivated();
    }

    BFoxSession openFoxSession() {
        if (this.session != null) {
            if (this.session.isConnected()) {
                return this.session;
            }
            this.session.disconnect();
        }
        Learn learn = (Learn)this.getLearn();
        try {
            this.session = learn.sessionSupport.fwConnect(this.station);
        }
        catch (Exception exception) {
            this.session = null;
            this.session = learn.connect(this.station, this.tunnelDiscovery.isSelected());
        }
        return this.session;
    }

    void loadNodes(LearnNode[] learnNodeArray) {
        Array array = new Array(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BNiagaraPointManager.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
        for (int i = 0; i < learnNodeArray.length; ++i) {
            BFormat bFormat;
            BNameMap bNameMap;
            LearnNode learnNode = learnNodeArray[i];
            if (learnNode.value != null) continue;
            String string = learnNode.get(this.dcolHandle).toString();
            BComponent bComponent = (BComponent)BOrd.make((String)("station:|h:" + string)).get((BObject)learnNode.session);
            BComplex bComplex = bComponent.getParent();
            if (bComplex != null && (bNameMap = (BNameMap)bComplex.get("displayNames")) != null && (bFormat = bNameMap.get(bComponent.getName())) != null) {
                learnNode.displayName = bFormat;
            }
            learnNode.value = bComponent;
            learnNode.name = bComponent.getName();
            learnNode.path = bComponent.getSlotPath().getBody();
            array.add((Object)bComponent);
        }
        BComponent[] bComponentArray = (BComponent[])array.trim();
        BComponent.lease((BComponent[])bComponentArray, (int)0);
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.folder = (BIPointFolder)bObject;
        try {
            this.points = (BNiagaraPointDeviceExt)this.folder.getDeviceExt();
            this.station = (BNiagaraStation)this.points.getDevice();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.doLoadValue(bObject, context);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DisplayNameColumn
    extends MgrColumn {
        DisplayNameColumn(String string, int n) {
            super(string, n);
        }

        public Object get(Object object) {
            BFormat bFormat;
            BNameMap bNameMap;
            if (object instanceof LearnNode) {
                LearnNode learnNode = (LearnNode)object;
                return learnNode.displayName;
            }
            BComplex bComplex = (BComplex)object;
            BComplex bComplex2 = bComplex.getParent();
            if (bComplex2 != null && (bNameMap = (BNameMap)bComplex2.get("displayNames")) != null && (bFormat = bNameMap.get(bComplex.getName())) != null) {
                return bFormat;
            }
            return BFormat.DEFAULT;
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BFormat bFormat;
            BNameMap bNameMap;
            LearnNode learnNode = (LearnNode)mgrEditRow.getDiscovery();
            if (learnNode != null) {
                return learnNode.displayName;
            }
            BComponent bComponent = mgrEditRow.getTarget();
            BComplex bComplex = bComponent.getParent();
            if (bComplex != null && (bNameMap = (BNameMap)bComplex.get("displayNames")) != null && (bFormat = bNameMap.get(bComponent.getName())) != null) {
                return bFormat;
            }
            return BFormat.DEFAULT;
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            if (bValue == null) {
                return;
            }
            LearnNode learnNode = (LearnNode)mgrEditRow.getDiscovery();
            if (learnNode != null) {
                learnNode.displayName = (BFormat)bValue;
            } else {
                BComponent bComponent = mgrEditRow.getTarget();
                BComponent bComponent2 = (BComponent)bComponent.getParent();
                if (bComponent2 != null) {
                    BNameMap bNameMap = (BNameMap)bComponent2.get("displayNames");
                    if (bNameMap == null) {
                        if (!bValue.equals((Object)BFormat.DEFAULT)) {
                            bNameMap = BNameMap.make((BNameMap)BNameMap.DEFAULT, (String)bComponent.getName(), (BFormat)((BFormat)bValue));
                            bComponent2.add("displayNames", (BValue)bNameMap);
                        }
                    } else {
                        bNameMap = !bValue.equals((Object)BFormat.DEFAULT) ? BNameMap.make((BNameMap)bNameMap, (String)bComponent.getName(), (BFormat)((BFormat)bValue)) : BNameMap.remove((BNameMap)bNameMap, (String)bComponent.getName());
                        bComponent2.set("displayNames", (BValue)bNameMap);
                    }
                }
            }
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            if (mgrEditRowArray.length != 1) {
                return null;
            }
            BFormat bFormat = (BFormat)mgrEditRowArray[0].getCell(n);
            BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            if (bWbFieldEditor == null) {
                bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bFormat);
            }
            BFacets bFacets = BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)30));
            bWbFieldEditor.loadValue((BObject)bFormat, (Context)bFacets);
            return bWbFieldEditor;
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            BFormat bFormat = BFormat.make((String)bWbFieldEditor.saveValue().toString());
            for (int i = 0; i < mgrEditRowArray.length; ++i) {
                mgrEditRowArray[i].setCell(n, (BValue)bFormat);
                ((LearnNode)mgrEditRowArray[i].getDiscovery()).displayName = bFormat;
            }
        }
    }

    static class DisplayNamesColumn
    extends MgrColumn {
        DisplayNamesColumn(String string, int n) {
            super(string, n);
        }

        public Object get(Object object) {
            BValue bValue;
            if (object instanceof BComplex && (bValue = ((BComplex)object).get("displayNames")) instanceof BNameMap) {
                return bValue;
            }
            return null;
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BValue bValue = mgrEditRow.getTarget().get("displayNames");
            if (bValue != null) {
                bValue = bValue.newCopy();
            }
            return bValue;
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BValue bValue2;
            if (bValue == null) {
                return;
            }
            BComponent bComponent = mgrEditRow.getTarget();
            BNameMap bNameMap = (BNameMap)bValue;
            String[] stringArray = bNameMap.list();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (bComponent.get(stringArray[i]) != null) continue;
                    bNameMap = BNameMap.remove((BNameMap)bNameMap, (String)stringArray[i]);
                }
            }
            if ((bValue2 = bComponent.get("displayNames")) == null) {
                bComponent.add("displayNames", (BValue)bNameMap, 261, context);
            } else if (!bValue2.equivalent((Object)bNameMap)) {
                bComponent.set(bComponent.getProperty("displayNames"), (BValue)bNameMap, context);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            if (mgrEditRowArray.length != 1) {
                return null;
            }
            BValue bValue = mgrEditRowArray[0].getCell(n);
            if (bValue == null) {
                return null;
            }
            Context context = mgrEditRowArray[0].getManager().getCurrentContext();
            BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bValue, (Context)context);
            if (bWbEditor != null && bWbEditor.getClass() == bWbFieldEditor.getClass()) {
                bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            }
            bWbFieldEditor.loadValue((BObject)bValue, context);
            return bWbFieldEditor;
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            BValue bValue = (BValue)bWbFieldEditor.saveValue();
            for (int i = 0; i < mgrEditRowArray.length; ++i) {
                mgrEditRowArray[i].setCell(n, bValue);
            }
        }
    }

    static class PointIdColumn
    extends MgrColumn.PropPath {
        PointIdColumn(Property[] propertyArray, int n) {
            super(propertyArray, n);
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            return SlotPath.unescape((String)object2.toString());
        }
    }

    class TunnelDiscoveryMode
    extends MgrController.MgrToggleCommand {
        BWidget tunnelModeIndicator;
        BNullWidget nullWidget = new BNullWidget();

        TunnelDiscoveryMode(BWidget bWidget) {
            super(bWidget, BNiagaraPointManager.this.lex, "tunnelDiscovery");
            BLabel bLabel = new BLabel(this.getIcon(), BNiagaraPointManager.this.lex.getText("tunnelDiscovery.label"), Theme.widget().getBoldText());
            bLabel.setHalign(BHalign.left);
            BBorderPane bBorderPane = new BBorderPane((BWidget)bLabel, BBorder.solid, BInsets.make((double)3.0, (double)3.0, (double)3.0, (double)3.0));
            bBorderPane.setFill(BBrush.make((String)"#fefec0"));
            this.tunnelModeIndicator = new BBorderPane((BWidget)bBorderPane, BBorder.inset, BInsets.DEFAULT);
        }

        public CommandArtifact doInvoke() throws Exception {
            this.updateIndicator();
            return super.doInvoke();
        }

        void updateIndicator() {
            BWidget bWidget = BNiagaraPointManager.this.getContent();
            if (bWidget instanceof BEdgePane) {
                BEdgePane bEdgePane = (BEdgePane)bWidget;
                if (this.isSelected()) {
                    bEdgePane.setTop(this.tunnelModeIndicator);
                } else {
                    bEdgePane.setTop((BWidget)this.nullWidget);
                }
            }
        }
    }

    class Controller
    extends PointController {
        Controller(BNiagaraPointManager bNiagaraPointManager2) {
            super((BPointManager)bNiagaraPointManager2);
            this.cancel.setFlags(0);
            BNiagaraPointManager.this.tunnelDiscovery = new TunnelDiscoveryMode((BWidget)bNiagaraPointManager2);
            if (bNiagaraPointManager2.isLearnable()) {
                BNiagaraPointManager.this.tunnelDiscovery.setFlags(1);
            }
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            MgrController.IMgrCommand[] iMgrCommandArray = super.makeCommands();
            int n = 0;
            if (iMgrCommandArray != null) {
                n = iMgrCommandArray.length;
            }
            MgrController.IMgrCommand[] iMgrCommandArray2 = new MgrController.IMgrCommand[n + 1];
            for (int i = 0; i < n; ++i) {
                iMgrCommandArray2[i] = iMgrCommandArray[i];
            }
            iMgrCommandArray2[n] = BNiagaraPointManager.this.tunnelDiscovery;
            return iMgrCommandArray2;
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            Learn learn = (Learn)BNiagaraPointManager.this.getLearn();
            BNiagaraPointManager.this.openFoxSession();
            if (BNiagaraPointManager.this.session == null) {
                return null;
            }
            learn.bqlDiscover(BNiagaraPointManager.this.session, BTypeSpec.make((String)"control:ControlPoint"));
            return null;
        }

        protected CommandArtifact doAdd(Object[] objectArray, Context context) throws Exception {
            LearnNode[] learnNodeArray = new LearnNode[objectArray.length];
            System.arraycopy(objectArray, 0, learnNodeArray, 0, objectArray.length);
            BNiagaraPointManager.this.loadNodes(learnNodeArray);
            return super.doAdd(objectArray, context);
        }

        public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand iMgrCommand) {
            if (iMgrCommand == this.discover) {
                return new MgrController.IMgrCommand[]{BNiagaraPointManager.this.tunnelDiscovery};
            }
            return super.getDropDownCommands(iMgrCommand);
        }
    }

    class State
    extends PointState {
        BITable lastLearn;
        boolean lastTunnelDiscovery = false;

        State() {
        }

        protected void saveForOrd(BAbstractManager bAbstractManager) {
            super.saveForOrd(bAbstractManager);
            BNiagaraPointManager bNiagaraPointManager = (BNiagaraPointManager)bAbstractManager;
            Learn learn = (Learn)bNiagaraPointManager.getLearn();
            this.lastLearn = learn.lastLearn;
            this.lastTunnelDiscovery = BNiagaraPointManager.this.tunnelDiscovery.isSelected();
        }

        protected void restoreForOrd(BAbstractManager bAbstractManager) {
            super.restoreForOrd(bAbstractManager);
            BNiagaraPointManager bNiagaraPointManager = (BNiagaraPointManager)bAbstractManager;
            bNiagaraPointManager.tunnelDiscovery.setSelected(this.lastTunnelDiscovery);
            bNiagaraPointManager.tunnelDiscovery.updateIndicator();
            Learn learn = (Learn)bNiagaraPointManager.getLearn();
            if (this.lastLearn != null) {
                bNiagaraPointManager.openFoxSession();
                if (bNiagaraPointManager.session != null) {
                    learn.updateTable(bNiagaraPointManager.session, this.lastLearn);
                }
            }
        }
    }

    class LearnNode
    extends NiagaraLearn.Node {
        LearnNode parent;
        String name;
        BFormat displayName = BFormat.DEFAULT;
        String path;
        BValue value;
        BFacets facets;

        public LearnNode(BFoxSession bFoxSession) {
            super(bFoxSession);
        }

        public LearnNode(LearnNode learnNode, BComponent bComponent, Property property, BValue bValue, BFacets bFacets) {
            super(learnNode.session);
            this.parent = learnNode;
            this.name = property.getName();
            this.path = learnNode.path + "/" + this.name;
            this.value = bValue;
            this.facets = bFacets;
            String string = "";
            if (bValue.isComponent()) {
                string = "" + bValue.asComponent().getHandle();
            }
            this.icon = BImage.make((BIcon)bValue.getIcon());
            this.cells = new BObject[]{BString.make((String)bComponent.getDisplayName((Slot)property, null)), BString.make((String)string), bValue.getType().getTypeSpec()};
        }

        public boolean hasChildren() {
            if (this.value == null) {
                return true;
            }
            return this.value instanceof BComponent;
        }

        public NiagaraLearn.Node[] getChildren() {
            this.loadNode();
            if (!this.value.isComponent()) {
                return new LearnNode[0];
            }
            BComponent bComponent = (BComponent)this.value;
            bComponent.lease();
            Property[] propertyArray = bComponent.getPropertiesArray();
            ArrayList<LearnNode> arrayList = new ArrayList<LearnNode>(propertyArray.length);
            for (int i = 0; i < propertyArray.length; ++i) {
                Property property = propertyArray[i];
                BValue bValue = bComponent.get(property);
                if (Flags.isHidden((BComplex)bComponent, (Slot)property) || bValue instanceof BLink || bValue instanceof BWsAnnotation) continue;
                arrayList.add(new LearnNode(this, bComponent, property, bValue, bComponent.getSlotFacets((Slot)property)));
            }
            return arrayList.toArray(new LearnNode[arrayList.size()]);
        }

        BValue loadNode() {
            BNiagaraPointManager.this.loadNodes(new LearnNode[]{this});
            return this.value;
        }

        public String toPointId() {
            if (this.path == null) {
                this.path = this.cells[0].toString();
            }
            return "slot:" + this.path;
        }
    }

    class Learn
    extends NiagaraLearn {
        Learn(BNiagaraPointManager bNiagaraPointManager2) {
            super((BAbstractManager)bNiagaraPointManager2);
        }

        protected MgrColumn[] makeColumns() {
            return BNiagaraPointManager.this.dcols;
        }

        public boolean isDepthExpandable(int n) {
            return true;
        }

        public MgrTypeInfo[] toTypes(Object object) {
            ArrayList arrayList = new ArrayList();
            String string = BNiagaraPointManager.this.dcolType.get(object).toString();
            TypeInfo typeInfo = Sys.getRegistry().getType(string);
            PointModel.addPointTypes((TypeInfo)typeInfo, arrayList, (boolean)false);
            return arrayList.toArray(new MgrTypeInfo[arrayList.size()]);
        }

        public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
            LearnNode learnNode = (LearnNode)object;
            BValue bValue = learnNode.loadNode();
            BFacets bFacets = learnNode.facets;
            if (bFacets == null) {
                bFacets = PointModel.mapPointFacets(null, (Object)bValue);
            }
            mgrEditRow.setDefaultName(learnNode.name);
            mgrEditRow.setCell(BNiagaraPointManager.this.colFacets, (BValue)bFacets);
            mgrEditRow.setCell(BNiagaraPointManager.this.colDeviceFacets, (BValue)bFacets);
            mgrEditRow.setCell(BNiagaraPointManager.this.colPointId, (BValue)BString.make((String)learnNode.toPointId()));
        }

        protected NiagaraLearn.Node makeNode(BFoxSession bFoxSession) {
            return new LearnNode(bFoxSession);
        }

        public boolean isExisting(Object object, BComponent bComponent) {
            LearnNode learnNode = (LearnNode)object;
            if (bComponent instanceof BControlPoint) {
                BControlPoint bControlPoint = (BControlPoint)bComponent;
                BNiagaraProxyExt bNiagaraProxyExt = (BNiagaraProxyExt)bControlPoint.getProxyExt();
                return bNiagaraProxyExt.getPointId().equals(learnNode.toPointId());
            }
            return false;
        }
    }

    class Model
    extends PointModel {
        Model(BNiagaraPointManager bNiagaraPointManager2) {
            super((BPointManager)bNiagaraPointManager2);
        }

        protected MgrColumn[] makeColumns() {
            return BNiagaraPointManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList arrayList = new ArrayList();
            Model.addBooleanPointTypes(arrayList, (boolean)false);
            Model.addNumericPointTypes(arrayList, (boolean)false);
            Model.addEnumPointTypes(arrayList, (boolean)false);
            Model.addStringPointTypes(arrayList, (boolean)false);
            return arrayList.toArray(new MgrTypeInfo[arrayList.size()]);
        }

        public CommandArtifact addInstances(MgrEditRow[] mgrEditRowArray, Context context) throws Exception {
            String[] stringArray = new String[mgrEditRowArray.length];
            BComponent[] bComponentArray = new BComponent[mgrEditRowArray.length];
            for (int i = 0; i < mgrEditRowArray.length; ++i) {
                stringArray[i] = mgrEditRowArray[i].getName();
                bComponentArray[i] = mgrEditRowArray[i].getTarget();
            }
            Mark mark = new Mark((BObject[])bComponentArray, stringArray);
            BComponent bComponent = mgrEditRowArray[0].getEdit().getAddContainer();
            mark.moveTo((BObject)bComponent, null);
            BNameMap bNameMap = (BNameMap)bComponent.get("displayNames");
            for (int i = 0; i < mgrEditRowArray.length; ++i) {
                Object object = mgrEditRowArray[i].getDiscovery();
                BFormat bFormat = null;
                bFormat = object == null ? (BFormat)mgrEditRowArray[i].getCell(BNiagaraPointManager.this.colDisplayName) : ((LearnNode)object).displayName;
                if (bFormat == null || bFormat.equals((Object)BFormat.DEFAULT)) continue;
                if (bNameMap == null) {
                    bNameMap = BNameMap.NULL;
                    bComponent.add("displayNames", (BValue)bNameMap);
                }
                bNameMap = BNameMap.make((BNameMap)bNameMap, (String)stringArray[i], (BFormat)bFormat);
            }
            if (bNameMap != null) {
                bComponent.set("displayNames", (BValue)bNameMap);
            }
            return null;
        }
    }
}

