/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BProviderEvent;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.BResolveBits;
import com.tridium.nd.sysdef.BSysDefProvider;
import com.tridium.nd.sysdef.SysDefException;
import java.util.Comparator;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nd.SysDefSession;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;
import javax.baja.util.BNameList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ProviderSession
implements SysDefSession {
    public static final String SESSION_NAME = "sessionName_";
    private final Context base;
    private final BSysDefProvider provider;
    private final BAbsTime creation;
    static /* synthetic */ Class class$javax$baja$nd$BINiagaraStation;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    public final String getSessionName() {
        return this.getFacets().gets(SESSION_NAME, "<anonymous>");
    }

    public final BAbsTime getCreation() {
        return this.creation;
    }

    protected void checkClosed() throws SysDefException {
        if (!this.isOpen()) {
            throw new SysDefException("SysDefSession is closed.");
        }
    }

    private final BINiagaraStation[] resolveStations(String[] stringArray) {
        Class clazz = class$javax$baja$nd$BINiagaraStation;
        if (clazz == null) {
            clazz = class$javax$baja$nd$BINiagaraStation = ProviderSession.class("[Ljavax.baja.nd.BINiagaraStation;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < stringArray.length) {
            BINiagaraStation bINiagaraStation = this.getStation(stringArray[n]);
            if (bINiagaraStation != null) {
                array.add((Object)bINiagaraStation);
            }
            ++n;
        }
        return (BINiagaraStation[])array.trim();
    }

    public final void close() {
        this.provider.sessionClosed(this);
        this.doClose();
    }

    public abstract void doClose();

    public BINiagaraStation getLocalStation() {
        return this.getStation(Sys.getStation().getStationName());
    }

    public final BINiagaraStation getStation(String string) {
        this.checkClosed();
        return this.doGetStation(string);
    }

    public abstract BProviderStation doGetStation(String var1);

    public BINiagaraStation[] getSubordinates(BINiagaraStation bINiagaraStation) {
        this.checkClosed();
        return this.resolveStations(this.getRoleRefs(bINiagaraStation, BStationRole.subordinate));
    }

    public BINiagaraStation[] getSupervisors(BINiagaraStation bINiagaraStation) {
        this.checkClosed();
        return this.resolveStations(this.getRoleRefs(bINiagaraStation, BStationRole.supervisor));
    }

    private final String getFoxTunnelAuthority(BProviderStation bProviderStation, BProviderStation bProviderStation2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bProviderStation.getOnlyTunnelKnownStations().getOrdinal() == 0) {
            stringBuffer.append(bProviderStation2.getStationName());
        } else {
            String string = bProviderStation2.getIpHost().getHostname();
            if (string.indexOf(58) != string.lastIndexOf(58) && !string.startsWith("[") && !string.endsWith("]")) {
                stringBuffer.append("[").append(string).append("]");
            } else {
                stringBuffer.append(string);
            }
        }
        stringBuffer.append(":").append(bProviderStation2.getFoxPort());
        return stringBuffer.toString();
    }

    public BFoxSession getFoxSession(BINiagaraStation bINiagaraStation) {
        Object object;
        Object object2;
        BProviderStation bProviderStation = (BProviderStation)bINiagaraStation;
        String[][] stringArray = this.getRoutes(null, bProviderStation.getStationName());
        int n = 0;
        String[] stringArray2 = null;
        if (stringArray != null && stringArray.length > 0) {
            stringArray2 = stringArray[0];
            n = stringArray2.length;
        }
        if (n <= 1) {
            BFoxSession bFoxSession;
            Object object3 = BHost.getHost((String)bProviderStation.getIpHost().getHostname());
            if (object3 == null) {
                object3 = Sys.getLocalHost().getHostAddress().equals(bProviderStation.getIpHost().getHostname()) ? BLocalHost.INSTANCE : bProviderStation.getIpHost();
            }
            int n2 = bProviderStation.getFoxPort();
            boolean bl = false;
            if (bProviderStation.getFoxsPort() > 0) {
                n2 = bProviderStation.getFoxsPort();
                bl = true;
            }
            if ((bFoxSession = BFoxSession.make(null, (BHost)object3, (int)n2, (boolean)bl)).getCredentials() == null) {
                try {
                    BNiagaraStation bNiagaraStation = (BNiagaraStation)this.provider.getNiagaraNetwork().getNiagaraStation(stringArray2[1]);
                    BUsernameAndPassword bUsernameAndPassword = new BUsernameAndPassword(bNiagaraStation.getClientConnection().getUsername(), bNiagaraStation.getClientConnection().getPassword());
                    bFoxSession.setCredentials((BICredentials)bUsernameAndPassword);
                    bFoxSession.getConnection().setUsername(bUsernameAndPassword.getUsername());
                    bFoxSession.getConnection().setPassword(bUsernameAndPassword.getPassword());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            return bFoxSession;
        }
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = ProviderSession.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        BISession bISession = this.provider.getSession();
        Object object4 = null;
        int n3 = 1911;
        int n4 = 1;
        BICredentials bICredentials = null;
        if (bISession instanceof BFoxSession) {
            object2 = (BFoxSession)bISession;
            bICredentials = object2.getCredentials();
            object4 = object2.getHost();
            n3 = object2.getPort();
            object = object2.getTunnelAuthorities();
            if (object != null) {
                int n5 = 0;
                while (n5 < ((String[])object).length) {
                    array.add((Object)object[n5]);
                    ++n5;
                }
            }
        } else {
            object2 = this.doGetStation(stringArray2[1]);
            object4 = BHost.getHost((String)((BProviderStation)object2).getIpHost().getHostname());
            if (object4 == null) {
                object4 = Sys.getLocalHost().getHostAddress().equals(((BProviderStation)object2).getIpHost().getHostname()) ? BLocalHost.INSTANCE : ((BProviderStation)object2).getIpHost();
            }
            n3 = ((BProviderStation)object2).getFoxPort();
            n4 = 2;
            try {
                object = (BNiagaraStation)this.provider.getNiagaraNetwork().getNiagaraStation(stringArray2[1]);
                bICredentials = new BUsernameAndPassword(((BNiagaraStation)object).getClientConnection().getUsername(), ((BNiagaraStation)object).getClientConnection().getPassword());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        int n6 = n4;
        while (n6 < n) {
            array.add((Object)this.getFoxTunnelAuthority((BProviderStation)this.getStation(stringArray2[n6 - 1]), (BProviderStation)this.getStation(stringArray2[n6])));
            ++n6;
        }
        BFoxSession bFoxSession = BFoxSession.make((String)bProviderStation.getStationName(), (BHost)object4, (int)n3, (boolean)false, (String[])((String[])array.trim()));
        if (bFoxSession.getCredentials() == null) {
            bFoxSession.setCredentials(bICredentials);
            bFoxSession.getConnection().setUsername(((BUsernameAndPassword)bICredentials).getUsername());
            bFoxSession.getConnection().setPassword(((BUsernameAndPassword)bICredentials).getPassword());
        }
        return bFoxSession;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[][] getRoutes(String string, String string2) {
        BINiagaraStation bINiagaraStation;
        if (string == null) {
            bINiagaraStation = this.getLocalStation();
            if (bINiagaraStation == null) return new String[0][0];
            string = bINiagaraStation.getStationName();
        } else if (this.getStation(string) == null) {
            return new String[0][0];
        }
        bINiagaraStation = null;
        bINiagaraStation = this.getStation(string2);
        if (bINiagaraStation == null) {
            return new String[0][0];
        }
        Class clazz = array$Ljava$lang$String;
        if (clazz == null) {
            clazz = array$Ljava$lang$String = ProviderSession.class("[Ljava.lang.String;", true);
        }
        Array array = new Array(clazz);
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = ProviderSession.class("[Ljava.lang.String;", false);
        }
        Array array2 = new Array(clazz2);
        array2.push((Object)string2);
        this.getRoutes(array2, array, this.getRoleRefs(bINiagaraStation, BStationRole.supervisor), string);
        String[][] stringArray = (String[][])array.trim();
        SortUtil.sort((Object[])stringArray, (Object[])stringArray, (Comparator)new Comparator(){

            public final int compare(Object object, Object object2) {
                int n = ((String[])object).length;
                int n2 = ((String[])object2).length;
                return n - n2;
            }
        });
        return stringArray;
    }

    private final void getRoutes(Array array, Array array2, String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            array.push((Object)stringArray[n]);
            if (stringArray[n].equals(string)) {
                array2.add((Object)((String[])array.reverse().trim()));
            } else {
                BProviderStation bProviderStation = new BProviderStation(stringArray[n]);
                this.getRoutes(array, array2, this.getRoleRefs(bProviderStation, BStationRole.supervisor), string);
            }
            array.pop();
            ++n;
        }
    }

    public final String[] getRoleRefs(BINiagaraStation bINiagaraStation, BStationRole bStationRole) {
        this.checkClosed();
        return this.doGetRoleRefs(bINiagaraStation, bStationRole);
    }

    protected abstract String[] doGetRoleRefs(BINiagaraStation var1, BStationRole var2);

    public final BProviderStation read(String string) {
        this.checkClosed();
        return this.doRead(string);
    }

    protected BProviderStation doRead(String string) {
        BProviderStation bProviderStation = (BProviderStation)this.getStation(string);
        if (bProviderStation != null && !bProviderStation.getResolved().equals((Object)BResolveBits.ALL)) {
            if (!bProviderStation.getResolved().getBit(1)) {
                throw new IllegalStateException("HOST should have been resolved.");
            }
            if (!bProviderStation.getResolved().getBit(2)) {
                Array array = this.getServices(bProviderStation);
                bProviderStation.setServiceTypes(array);
            }
            if (!bProviderStation.getResolved().isBits(4)) {
                bProviderStation.setSubordinates(BNameList.make((String[])this.getRoleRefs(bProviderStation, BStationRole.subordinate)));
                bProviderStation.setSupervisors(BNameList.make((String[])this.getRoleRefs(bProviderStation, BStationRole.supervisor)));
            }
            bProviderStation.setResolved(BResolveBits.ALL);
        }
        return bProviderStation;
    }

    public final void insert(BProviderStation bProviderStation) throws SysDefException {
        this.checkClosed();
        try {
            this.doInsert(bProviderStation);
        }
        catch (SysDefException sysDefException) {
            throw sysDefException;
        }
        catch (Exception exception) {
            throw new SysDefException("insert failed.", exception);
        }
        this.provider.fireProviderEvent(BProviderEvent.makeInsert(bProviderStation.getStationName()));
    }

    protected abstract void doInsert(BProviderStation var1);

    public final BResolveBits update(BProviderStation bProviderStation, BResolveBits bResolveBits) throws SysDefException {
        return this.update(bProviderStation, bResolveBits, true);
    }

    public final BResolveBits update(BProviderStation bProviderStation, BResolveBits bResolveBits, boolean bl) throws SysDefException {
        this.checkClosed();
        BResolveBits bResolveBits2 = BResolveBits.NONE;
        if (!bResolveBits.isBits(BResolveBits.STATION) && (bResolveBits.getBit(1) || bResolveBits.getBit(2))) {
            throw new SysDefException("toUpdate bits must be one of ALL, NONE, STATION, or NETWORK: " + (Object)((Object)bResolveBits));
        }
        try {
            bResolveBits2 = this.doUpdate(bProviderStation, bResolveBits, bl);
        }
        catch (SysDefException sysDefException) {
            throw sysDefException;
        }
        catch (Exception exception) {
            throw new SysDefException("update failed.", exception);
        }
        this.provider.fireProviderEvent(BProviderEvent.makeUpdate(bProviderStation.getStationName(), bResolveBits2));
        return bResolveBits2;
    }

    protected abstract BResolveBits doUpdate(BProviderStation var1, BResolveBits var2, boolean var3);

    public final boolean delete(BProviderStation bProviderStation) {
        return this.delete(bProviderStation.getStationName());
    }

    public final boolean delete(String string) {
        this.checkClosed();
        boolean bl = false;
        try {
            bl = this.doDelete(string);
            this.provider.fireProviderEvent(BProviderEvent.makeDelete(string));
        }
        catch (Exception exception) {}
        return bl;
    }

    protected abstract boolean doDelete(String var1);

    public final BResolveBits persist(BProviderStation bProviderStation) {
        return this.persist(bProviderStation, true);
    }

    public BResolveBits persist(BProviderStation bProviderStation, boolean bl) {
        this.checkClosed();
        if (this.getStation(bProviderStation.getStationName()) == null) {
            if (bl) {
                this.insert(bProviderStation);
            }
            return BResolveBits.ALL;
        }
        return this.update(bProviderStation, BResolveBits.ALL, bl);
    }

    public Context getBase() {
        return this.base;
    }

    public BObject getFacet(String string) {
        return this.base == null ? null : this.base.getFacet(string);
    }

    public BFacets getFacets() {
        return this.base == null ? BFacets.DEFAULT : this.base.getFacets();
    }

    public String getLanguage() {
        return this.base == null ? Sys.getLanguage() : this.base.getLanguage();
    }

    public BUser getUser() {
        return this.base == null ? null : this.base.getUser();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ProviderSession(BSysDefProvider bSysDefProvider) {
        this(bSysDefProvider, null);
    }

    public ProviderSession(BSysDefProvider bSysDefProvider, Context context) {
        this.base = context;
        this.provider = bSysDefProvider;
        this.creation = BAbsTime.now();
    }
}

