/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.BResolveBits;
import com.tridium.nd.sysdef.BSysDefChannel;
import com.tridium.nd.sysdef.BSysDefProvider;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.nd.sysdef.SysDefException;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nre.util.Array;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FoxProviderSession
extends ProviderSession {
    public static final int SESSION_INIT = -1;
    private static final int SESSION_CLOSED = -2;
    private int sessionId;
    BNiagaraNetwork network;
    private BProviderStation local;

    protected BSysDefChannel getChannel() {
        BFoxSession bFoxSession = (BFoxSession)this.network.getSession();
        BFoxClientConnection bFoxClientConnection = bFoxSession.getConnection();
        return (BSysDefChannel)bFoxClientConnection.getChannels().get("sysdef", BSysDefChannel.TYPE);
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setOpen(int n) {
        this.checkClosed();
        if (this.sessionId != -1) {
            throw new SysDefException("Session id changed from " + this.sessionId + " to " + n);
        }
        this.sessionId = n;
    }

    public void setClosed() {
        this.sessionId = -2;
    }

    public BINiagaraStation getLocalStation() {
        return this.getStation(this.local.getStationName());
    }

    public BProviderStation doGetStation(String string) {
        this.checkClosed();
        try {
            return this.getChannel().getStation(this, string);
        }
        catch (SysDefException sysDefException) {
            throw sysDefException;
        }
        catch (Exception exception) {
            throw new SysDefException("Operation failed.", exception);
        }
    }

    protected void checkClosed() throws SysDefException {
        if (this.sessionId == -2) {
            throw new SysDefException("SysDefSession has been closed.");
        }
    }

    public boolean isOpen() {
        boolean bl = false;
        if (this.sessionId != -2) {
            bl = true;
        }
        return bl;
    }

    public void doClose() {
        if (this.sessionId == -1) {
            this.sessionId = -2;
        }
        if (!this.isOpen()) {
            return;
        }
        try {
            this.getChannel().closeSession(this);
        }
        catch (SysDefException sysDefException) {
            throw sysDefException;
        }
        catch (Exception exception) {
            throw new SysDefException("Operation failed.", exception);
        }
    }

    public Array getServices(BINiagaraStation bINiagaraStation) {
        this.checkClosed();
        try {
            return this.getChannel().getServiceTypes(this, bINiagaraStation);
        }
        catch (SysDefException sysDefException) {
            throw sysDefException;
        }
        catch (Exception exception) {
            throw new SysDefException("Operation failed.", exception);
        }
    }

    public BINiagaraStation[] getSubordinates(BINiagaraStation bINiagaraStation) {
        return this.getStations(bINiagaraStation, BStationRole.subordinate);
    }

    public BINiagaraStation[] getSupervisors(BINiagaraStation bINiagaraStation) {
        return this.getStations(bINiagaraStation, BStationRole.supervisor);
    }

    private final BINiagaraStation[] getStations(BINiagaraStation bINiagaraStation, BStationRole bStationRole) {
        this.checkClosed();
        try {
            return this.getChannel().getStations(this, bINiagaraStation, bStationRole);
        }
        catch (SysDefException sysDefException) {
            throw sysDefException;
        }
        catch (Exception exception) {
            throw new SysDefException("Operation failed.", exception);
        }
    }

    public String[] doGetRoleRefs(BINiagaraStation bINiagaraStation, BStationRole bStationRole) {
        BINiagaraStation[] bINiagaraStationArray = null;
        switch (bStationRole.getOrdinal()) {
            case 2: {
                bINiagaraStationArray = this.getSupervisors(bINiagaraStation);
                break;
            }
            case 1: {
                bINiagaraStationArray = this.getSubordinates(bINiagaraStation);
                break;
            }
            default: {
                return new String[0];
            }
        }
        String[] stringArray = new String[bINiagaraStationArray.length];
        int n = 0;
        while (n < bINiagaraStationArray.length) {
            stringArray[n] = bINiagaraStationArray[n].getStationName();
            ++n;
        }
        return stringArray;
    }

    public BProviderStation doRead(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void doInsert(BProviderStation bProviderStation) throws SysDefException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected BResolveBits doUpdate(BProviderStation bProviderStation, BResolveBits bResolveBits, boolean bl) throws SysDefException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected boolean doDelete(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private final /* synthetic */ void this() {
        this.sessionId = -1;
    }

    public FoxProviderSession(BNiagaraNetwork bNiagaraNetwork, BSysDefProvider bSysDefProvider, Context context) {
        super(bSysDefProvider, context);
        this.this();
        this.network = bNiagaraNetwork;
        bNiagaraNetwork.loadSlots();
        this.local = bNiagaraNetwork.getLocalStation();
        this.local.loadSlots();
        this.sessionId = -1;
    }
}

