/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BProviderEvent;
import com.tridium.nd.sysdef.BProviderState;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.FoxProviderSession;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.nd.sysdef.SysDefException;
import com.tridium.nd.util.ReentrantReadWriteLock;
import java.util.HashSet;
import java.util.Iterator;
import javax.baja.driver.BNetworkExt;
import javax.baja.log.Log;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Version;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BSysDefProvider
extends BNetworkExt {
    public static final Property state = BSysDefProvider.newProperty((int)3, (BValue)BProviderState.stopped, null);
    public static final Property faultCause = BSysDefProvider.newProperty((int)3, (String)"", null);
    public static final Action startup = BSysDefProvider.newAction((int)16, null);
    public static final Action shutdown = BSysDefProvider.newAction((int)16, (BValue)BBoolean.FALSE, null);
    public static final Action purge = BSysDefProvider.newAction((int)16, null);
    public static final Topic providerEvent = BSysDefProvider.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon ICON;
    protected static final Log log;
    private final ReentrantReadWriteLock purgeLock;
    private Object sessionLock;
    private boolean allowSessions;
    private HashSet sessions;
    private Clock.Ticket ticket;
    private Invocation purgeInvoke;
    static /* synthetic */ Class class$com$tridium$nd$sysdef$BSysDefProvider;
    static /* synthetic */ Class class$com$tridium$fox$sys$BFoxServerConnection;

    public BProviderState getState() {
        return (BProviderState)this.get(state);
    }

    public void setState(BProviderState bProviderState) {
        this.set(state, (BValue)bProviderState, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public void startup() {
        this.invoke(startup, null, null);
    }

    public void shutdown(BBoolean bBoolean) {
        this.invoke(shutdown, (BValue)bBoolean, null);
    }

    public void purge() {
        this.invoke(purge, null, null);
    }

    public void fireProviderEvent(BProviderEvent bProviderEvent) {
        this.fire(providerEvent, (BValue)bProviderEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getNetwork();
    }

    public boolean isCompatible(Version version) {
        return version.isNull() ^ true;
    }

    private final void cancelTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
    }

    public final ProviderSession createSession(String string, Context context) {
        BasicContext basicContext = new BasicContext(context, BFacets.make((String)"sessionName_", (String)string));
        return this.createSession((Context)basicContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ProviderSession createSession(Context context) {
        if (this.getComponentSpace().isProxyComponentSpace()) {
            this.lease(1);
            if (!this.getState().isRunning()) {
                throw new SysDefException("Provider is not running.");
            }
            return new FoxProviderSession(this.getNiagaraNetwork(), this, context);
        }
        ProviderSession providerSession = null;
        Object object = this.sessionLock;
        synchronized (object) {
            if (!this.allowSessions) {
                throw new SysDefException("Provider is not running.");
            }
            providerSession = this.makeSession(context);
            this.sessions.add(providerSession);
            return providerSession;
        }
    }

    protected abstract ProviderSession makeSession(Context var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void sessionClosed(ProviderSession providerSession) {
        if (this.getComponentSpace().isProxyComponentSpace()) {
            return;
        }
        BSysDefProvider bSysDefProvider = this;
        synchronized (bSysDefProvider) {
            Object object = this.sessionLock;
            synchronized (object) {
                this.sessions.remove(providerSession);
                if (!this.allowSessions && this.getState().isStopping() && this.sessions.size() == 0) {
                    this.setState(BProviderState.stopped);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doStartup() {
        BSysDefProvider bSysDefProvider = this;
        synchronized (bSysDefProvider) {
            if (!this.getState().isStopped()) {
                StringBuffer stringBuffer = new StringBuffer().append("Cannot startup the provider: ");
                switch (this.getState().getOrdinal()) {
                    case 0: 
                    case 3: {
                        return;
                    }
                    case 1: {
                        stringBuffer.append("It is in the process of shutting down.");
                        throw new SysDefException(stringBuffer.toString());
                    }
                    case 4: {
                        stringBuffer.append("An unrecoverable error has occured.");
                        throw new SysDefException(stringBuffer.toString());
                    }
                }
                throw new IllegalStateException(this.getState().toString());
            }
            this.setState(BProviderState.starting);
            Object object = this.sessionLock;
            synchronized (object) {
                this.allowSessions = true;
            }
            this.getNiagaraNetwork().getLocalStation().getPersistTask().execute();
            this.setState(BProviderState.running);
            this.purge();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public void doShutdown(BBoolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [6 : 10->379)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPurge() {
        ProviderSession providerSession = null;
        try {
            block18: {
                try {
                    int n;
                    String[] stringArray;
                    this.cancelTicket();
                    providerSession = this.createSession("Purge", null);
                    BProviderStation bProviderStation = (BProviderStation)providerSession.getLocalStation();
                    if (bProviderStation == null) {
                        log.trace("Nothing to purge, the local host is not in the provider yet.");
                        Object var3_4 = null;
                        if (providerSession != null) {
                            providerSession.close();
                        }
                        this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeHours((int)12), (Action)purge, null);
                        return;
                    }
                    HashSet hashSet = new HashSet();
                    this.loadStationNames(hashSet);
                    this.purgeLock.writeLock().lock();
                    try {
                        hashSet.remove(bProviderStation.getStationName());
                        stringArray = providerSession.getRoleRefs(bProviderStation, BStationRole.supervisor);
                        n = 0;
                        while (n < stringArray.length) {
                            hashSet.remove(stringArray[n]);
                            ++n;
                        }
                        this.findReachable(bProviderStation, hashSet, providerSession);
                        Iterator iterator = hashSet.iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            if (log.isTraceOn()) {
                                log.trace("Purging orphan: " + string);
                            }
                            providerSession.delete(string);
                        }
                        Object var7_14 = null;
                        this.purgeLock.writeLock().unlock();
                        if (hashSet.size() == 0) break block18;
                    }
                    catch (Throwable throwable) {
                        Object var7_13 = null;
                        this.purgeLock.writeLock().unlock();
                        throw throwable;
                    }
                    stringArray = this.getNiagaraNetwork().getDevices();
                    n = 0;
                    while (n < stringArray.length) {
                        BNiagaraStation bNiagaraStation = (BNiagaraStation)((Object)stringArray[n]);
                        if (bNiagaraStation.getSysDef().getRole().isSupervisor()) {
                            if (log.isTraceOn()) {
                                log.trace("Forcing supervisor " + stringArray[n].getName() + " to purge.");
                            }
                            bNiagaraStation.getSysDef().getSyncTask().setSignalPurge(true);
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    if (!log.isTraceOn()) break block18;
                    log.trace("Purge failed: " + exception.getMessage());
                }
            }
            Object var3_6 = null;
            if (providerSession != null) {
                providerSession.close();
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (providerSession != null) {
                providerSession.close();
            }
            this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeHours((int)12), (Action)purge, null);
            throw throwable;
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeHours((int)12), (Action)purge, null);
    }

    protected abstract void loadStationNames(HashSet var1);

    private final void findReachable(BINiagaraStation bINiagaraStation, HashSet hashSet, ProviderSession providerSession) {
        if (bINiagaraStation == null) {
            return;
        }
        String[] stringArray = providerSession.getRoleRefs(bINiagaraStation, BStationRole.subordinate);
        int n = 0;
        while (n < stringArray.length) {
            hashSet.remove(stringArray[n]);
            this.findReachable(providerSession.getStation(stringArray[n]), hashSet, providerSession);
            ++n;
        }
    }

    final void blockPurge() {
        this.purgeLock.readLock().lock();
    }

    final void unblockPurge() {
        this.purgeLock.readLock().unlock();
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.shutdown(BBoolean.TRUE);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == purge || action == startup || action == shutdown) {
            try {
                BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)this.getNetwork();
                Invocation invocation = new Invocation((BComponent)this, action, bValue, context);
                try {
                    bNiagaraNetwork.getWorkers().process(invocation);
                    return null;
                }
                catch (NotRunningException notRunningException) {
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return super.post(action, bValue, context);
    }

    public BIcon getIcon() {
        return ICON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spy(SpyWriter spyWriter) throws Exception {
        BAbsTime bAbsTime = BAbsTime.now();
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"Open Sessions", 3);
        spyWriter.w((Object)"<tr>");
        spyWriter.thTitle((Object)"Session Name");
        spyWriter.thTitle((Object)"Creation Time");
        spyWriter.thTitle((Object)"Time Open");
        spyWriter.w((Object)"</tr>");
        Object object = this.sessionLock;
        synchronized (object) {
            ProviderSession[] providerSessionArray = this.sessions.toArray(new ProviderSession[this.sessions.size()]);
            int n = 0;
            while (n < providerSessionArray.length) {
                ProviderSession providerSession = providerSessionArray[n];
                BAbsTime bAbsTime2 = providerSession.getCreation();
                spyWriter.w((Object)"<tr>");
                spyWriter.td((Object)XWriter.safeToString((String)providerSession.getSessionName(), (boolean)false));
                spyWriter.td((Object)bAbsTime2);
                spyWriter.td((Object)bAbsTime2.delta(bAbsTime));
                spyWriter.w((Object)"</tr>");
                ++n;
            }
        }
        spyWriter.endTable();
        super.spy(spyWriter);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.purgeLock = new ReentrantReadWriteLock();
        this.sessionLock = new Object();
        this.allowSessions = false;
        this.sessions = new HashSet();
        this.ticket = null;
        this.purgeInvoke = new Invocation((BComponent)this, purge, null, null);
    }

    public BSysDefProvider() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nd$sysdef$BSysDefProvider;
        if (clazz == null) {
            clazz = class$com$tridium$nd$sysdef$BSysDefProvider = BSysDefProvider.class("[Lcom.tridium.nd.sysdef.BSysDefProvider;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ICON = BIcon.std((String)"cloud.png");
        log = Log.getLog((String)"niagara.sysdef");
    }
}

