/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.BResolveBits;
import com.tridium.nd.sysdef.BSyncTask;
import com.tridium.nd.sysdef.FoxProviderSession;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.nd.sysdef.SysDefException;
import java.io.IOException;
import javax.baja.log.Log;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nd.SysDefSession;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameList;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSysDefChannel
extends BFoxChannel {
    public static final Type TYPE;
    public static final String CHANNEL = "sysdef";
    private static final Log slog;
    private static final String SERVICES = "services";
    private static final String CLOSE_SESSION = "close";
    private static final String CHANGE_ROLE = "role";
    private static final String GET1 = "gs";
    private static final String SYNC_TO_SUB = "toSub";
    private static final String PERSIST = "persist";
    private static final String SYNC_TO_SUP = "toSup";
    private static final String GET_ROLES = "getRoles";
    private IntHashMap sessionReg;
    private int nextId;
    public StringBuffer lastSync;
    static /* synthetic */ Class class$com$tridium$nd$sysdef$BSysDefChannel;
    static /* synthetic */ Class class$javax$baja$util$BTypeSpec;
    static /* synthetic */ Class class$javax$baja$nd$BINiagaraStation;
    static /* synthetic */ Class class$com$tridium$nd$sysdef$BProviderStation;

    public Type getType() {
        return TYPE;
    }

    public FoxResponse process(FoxRequest foxRequest) throws Throwable {
        String string = foxRequest.command;
        if (string.equals(SERVICES)) {
            return this.getServiceTypes(foxRequest);
        }
        if (string.equals(CHANGE_ROLE)) {
            return this.changeRole(foxRequest);
        }
        if (string.equals(CLOSE_SESSION)) {
            return this.closeSession(foxRequest);
        }
        if (string.equals(GET1)) {
            return this.getStation(foxRequest);
        }
        if (string.equals(SYNC_TO_SUB)) {
            return this.syncToSubordinate(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public void circuitOpened(FoxCircuit foxCircuit) throws Throwable {
        String string = foxCircuit.command;
        if (string.equals(GET_ROLES)) {
            this.getStations(foxCircuit);
            return;
        }
        if (string.equals(SYNC_TO_SUP)) {
            this.syncToSupervisor(foxCircuit);
            return;
        }
        throw new InvalidCommandException(string);
    }

    protected void checkStatus(FoxMessage foxMessage) throws Exception {
        String string = foxMessage.getString("status");
        if (!string.equals("ok")) {
            if (string.equals("error")) {
                throw new SysDefException(foxMessage.getString("msg"));
            }
            slog.warning(foxMessage.getString("msg"));
        }
    }

    protected BProviderStation decodeStation(FoxMessage foxMessage) throws Exception {
        return (BProviderStation)DecoderFactory.decode((FoxMessage)foxMessage, (String)"station", null);
    }

    protected void handleServerException(ProviderSession providerSession, FoxMessage foxMessage, Throwable throwable) {
        if (providerSession != null && foxMessage.getBoolean("wasCreated", false)) {
            int n;
            try {
                n = foxMessage.getInt("sessionId");
            }
            catch (Exception exception) {
                throw new IllegalStateException("should have had sessionId.");
            }
            if (this.isTraceOn()) {
                this.trace("Closing piggy-backed session: " + n);
            }
            this.closeSession(providerSession, n);
        }
        foxMessage.add("status", "error");
        foxMessage.add("msg", "[" + Sys.getStation().getStationName() + "]: " + throwable.getMessage());
    }

    protected BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
    }

    protected BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.getConnection().getParentStation();
    }

    protected BNiagaraSysDefDeviceExt getSysDefExt() {
        BNiagaraStation bNiagaraStation = this.getNiagaraStation();
        return bNiagaraStation == null ? null : bNiagaraStation.getSysDef();
    }

    private final String sn(String string) {
        return this.getNiagaraStation().getStationName() + ':' + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sessionClosed(Throwable var1_1) throws Exception {
        var2_2 = null;
        var3_3 = this.sessionReg;
        synchronized (var3_3) {
            var2_2 = (SysDefSession[])this.sessionReg.toArray((Object[])new SysDefSession[this.sessionReg.size()]);
            this.sessionReg.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
            var5_4 = 0;
            if (true) ** GOTO lbl21
        }
        do {
            if (var5_4 == 0) {
                BSysDefChannel.slog.warning("SysDefChannel for session " + this.getServerConnection().getName() + " is closing with " + var2_2.length + " open SysDef sessions. Closing them.", var1_1);
            }
            try {
                var2_2[var5_4].close();
            }
            catch (Exception var6_5) {
                var6_5.printStackTrace();
            }
            ++var5_4;
lbl21:
            // 2 sources

        } while (var5_4 < var2_2.length);
        super.sessionClosed(var1_1);
    }

    private final void setSession(FoxProviderSession foxProviderSession, FoxMessage foxMessage) {
        foxMessage.add("sessionId", foxProviderSession.getSessionId());
        foxMessage.add("sessionName", foxProviderSession.getSessionName());
    }

    private final void setSession(FoxProviderSession foxProviderSession, FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = new FoxMessage("session");
        this.setSession(foxProviderSession, foxMessage);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        this.assignSessionId(foxProviderSession, foxMessage2);
    }

    private final ProviderSession getSession(FoxMessage foxMessage, FoxMessage foxMessage2, boolean bl) throws Exception {
        int n = foxMessage.getInt("sessionId");
        String string = foxMessage.getString("sessionName");
        if (n == -1) {
            if (bl) {
                BNiagaraNetwork bNiagaraNetwork = this.getNiagaraNetwork();
                ProviderSession providerSession = bNiagaraNetwork.getSysDefProvider().createSession("fox_" + string, this.getServerConnection().getSessionContext());
                n = this.registerSession(providerSession);
                foxMessage2.add("sessionId", n);
                foxMessage2.add("wasCreated", true);
                return providerSession;
            }
            throw new SysDefException("Invalid fox session id. (" + n + ')');
        }
        ProviderSession providerSession = this.getSession(n);
        return providerSession;
    }

    private final ProviderSession getSession(FoxCircuit foxCircuit, boolean bl) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        FoxMessage foxMessage2 = new FoxMessage();
        ProviderSession providerSession = null;
        try {
            providerSession = this.getSession(foxMessage, foxMessage2, bl);
            foxCircuit.writeMessage(foxMessage2);
            foxCircuit.flush();
        }
        catch (Exception exception) {
            this.handleServerException(providerSession, foxMessage2, exception);
            throw exception;
        }
        return providerSession;
    }

    private final void assignSessionId(FoxProviderSession foxProviderSession, FoxMessage foxMessage) throws Exception {
        int n = foxMessage.getInt("sessionId", -1);
        if (n == -1) {
            if (foxProviderSession.getSessionId() == -1) {
                throw new SysDefException("Missing session id.");
            }
        } else {
            foxProviderSession.setOpen(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int registerSession(ProviderSession providerSession) {
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            int n = this.nextId;
            this.nextId = (this.nextId + 1) % 0x7FFFFFFE;
            while (true) {
                if (this.sessionReg.get(n) == null) {
                    this.sessionReg.put(n, (Object)providerSession);
                    return n;
                }
                n = this.nextId;
                this.nextId = (this.nextId + 1) % 0x7FFFFFFE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void unregisterSession(int n) {
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            this.sessionReg.remove(n);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ProviderSession getSession(int n) {
        IntHashMap intHashMap = this.sessionReg;
        synchronized (intHashMap) {
            return (ProviderSession)this.sessionReg.get(n);
        }
    }

    public void closeSession(FoxProviderSession foxProviderSession) throws Exception {
        FoxRequest foxRequest = this.makeRequest(CLOSE_SESSION);
        this.setSession(foxProviderSession, (FoxMessage)foxRequest);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        this.checkStatus((FoxMessage)foxResponse);
        foxProviderSession.setClosed();
    }

    private final FoxResponse closeSession(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            int n = foxRequest.getInt("sessionId");
            ProviderSession providerSession = this.getSession((FoxMessage)foxRequest, (FoxMessage)foxResponse, false);
            if (providerSession != null) {
                this.closeSession(providerSession, n);
                foxResponse.add("status", "ok");
            } else {
                foxResponse.add("status", "warn");
                foxResponse.add("msg", "Session " + n + " was already closed on remote station " + Sys.getStation().getStationName());
            }
        }
        catch (SysDefException sysDefException) {
            this.handleServerException(null, (FoxMessage)foxResponse, (Throwable)((Object)sysDefException));
        }
        return foxResponse;
    }

    private final void closeSession(ProviderSession providerSession, int n) {
        providerSession.close();
        this.unregisterSession(n);
    }

    public BProviderStation getStation(FoxProviderSession foxProviderSession, String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest(GET1);
        this.setSession(foxProviderSession, (FoxMessage)foxRequest);
        foxRequest.add("stationName", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        this.checkStatus((FoxMessage)foxResponse);
        this.assignSessionId(foxProviderSession, (FoxMessage)foxResponse);
        BProviderStation bProviderStation = this.decodeStation((FoxMessage)foxResponse);
        bProviderStation.network = foxProviderSession.network;
        return bProviderStation;
    }

    private final FoxResponse getStation(FoxRequest foxRequest) {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ProviderSession providerSession = null;
        try {
            providerSession = this.getSession((FoxMessage)foxRequest, (FoxMessage)foxResponse, true);
            String string = foxRequest.getString("stationName");
            BProviderStation bProviderStation = (BProviderStation)providerSession.getStation(string);
            BogCodec.add((FoxMessage)foxResponse, (String)"station", (BValue)bProviderStation, null);
            foxResponse.add("status", "ok");
        }
        catch (Exception exception) {
            this.handleServerException(providerSession, (FoxMessage)foxResponse, exception);
        }
        return foxResponse;
    }

    public Array getServiceTypes(FoxProviderSession foxProviderSession, BINiagaraStation bINiagaraStation) throws Exception {
        FoxRequest foxRequest = this.makeRequest(SERVICES);
        this.setSession(foxProviderSession, (FoxMessage)foxRequest);
        foxRequest.add("stationName", bINiagaraStation.getStationName());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        this.checkStatus((FoxMessage)foxResponse);
        this.assignSessionId(foxProviderSession, (FoxMessage)foxResponse);
        String[] stringArray = foxResponse.listStrings("spec");
        Class clazz = class$javax$baja$util$BTypeSpec;
        if (clazz == null) {
            clazz = class$javax$baja$util$BTypeSpec = BSysDefChannel.class("[Ljavax.baja.util.BTypeSpec;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < stringArray.length) {
            array.add((Object)BTypeSpec.make((String)stringArray[n]));
            ++n;
        }
        return array;
    }

    private final FoxResponse getServiceTypes(FoxRequest foxRequest) {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        ProviderSession providerSession = null;
        try {
            providerSession = this.getSession((FoxMessage)foxRequest, (FoxMessage)foxResponse, true);
            String string = foxRequest.getString("stationName");
            BProviderStation bProviderStation = new BProviderStation(string);
            Array array = providerSession.getServices(bProviderStation);
            int n = 0;
            while (n < array.size()) {
                foxResponse.add("spec", array.get(n).toString());
                ++n;
            }
            foxResponse.add("status", "ok");
        }
        catch (Exception exception) {
            this.handleServerException(providerSession, (FoxMessage)foxResponse, exception);
        }
        return foxResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BINiagaraStation[] getStations(FoxProviderSession foxProviderSession, BINiagaraStation bINiagaraStation, BStationRole bStationRole) throws Exception {
        BINiagaraStation[] bINiagaraStationArray;
        FoxCircuit foxCircuit = this.openCircuit(GET_ROLES);
        try {
            this.setSession(foxProviderSession, foxCircuit);
            FoxMessage foxMessage = new FoxMessage("req");
            foxMessage.add("stationName", bINiagaraStation.getStationName());
            foxMessage.add(CHANGE_ROLE, bStationRole.getOrdinal());
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            Class clazz = class$javax$baja$nd$BINiagaraStation;
            if (clazz == null) {
                clazz = class$javax$baja$nd$BINiagaraStation = BSysDefChannel.class("[Ljavax.baja.nd.BINiagaraStation;", false);
            }
            Array array = new Array(clazz);
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            this.checkStatus(foxMessage2);
            while (!foxMessage2.getBoolean("EOF", false)) {
                BProviderStation bProviderStation = this.decodeStation(foxMessage2);
                array.add((Object)bProviderStation);
                bProviderStation.network = foxProviderSession.network;
                foxMessage2 = foxCircuit.readMessage();
            }
            if (array.size() != foxMessage2.getInt("size")) {
                throw new IllegalStateException("Actual size: " + array.size() + " <> Expected size: " + foxMessage2.getInt("size"));
            }
            bINiagaraStationArray = (BINiagaraStation[])array.trim();
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            foxCircuit.close();
            throw throwable;
        }
        foxCircuit.close();
        return bINiagaraStationArray;
    }

    private final void getStations(FoxCircuit foxCircuit) {
        FoxMessage foxMessage = null;
        FoxMessage foxMessage2 = new FoxMessage();
        ProviderSession providerSession = null;
        try {
            providerSession = this.getSession(foxCircuit, true);
            foxMessage = foxCircuit.readMessage();
            BProviderStation bProviderStation = new BProviderStation(foxMessage.getString("stationName"));
            int n = foxMessage.getInt(CHANGE_ROLE);
            BINiagaraStation[] bINiagaraStationArray = null;
            switch (n) {
                case 1: {
                    bINiagaraStationArray = providerSession.getSubordinates(bProviderStation);
                    break;
                }
                case 2: {
                    bINiagaraStationArray = providerSession.getSupervisors(bProviderStation);
                    break;
                }
                default: {
                    throw new IllegalStateException("PEER role not supported.");
                }
            }
            int n2 = 0;
            while (n2 < bINiagaraStationArray.length) {
                foxMessage2 = new FoxMessage();
                foxMessage2.add("status", "ok");
                BogCodec.add((FoxMessage)foxMessage2, (String)"station", (BValue)((BProviderStation)bINiagaraStationArray[n2]), null);
                foxCircuit.writeMessage(foxMessage2);
                ++n2;
            }
            foxMessage2 = new FoxMessage();
            foxMessage2.add("status", "ok");
            foxMessage2.add("size", bINiagaraStationArray.length);
            foxMessage2.add("EOF", true);
            foxCircuit.writeMessage(foxMessage2);
            foxCircuit.flush();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            this.handleServerException(null, foxMessage2, exception);
            try {
                foxCircuit.writeMessage(foxMessage2);
                foxCircuit.flush();
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    private final FoxRequest makePersistRequest(BProviderStation bProviderStation, boolean bl) throws Exception {
        FoxRequest foxRequest = this.makeRequest(PERSIST);
        foxRequest.add(CHANGE_ROLE, this.getSysDefExt().getRole().getOppositeRole().getOrdinal());
        foxRequest.add("commit", bl);
        BogCodec.add((FoxMessage)foxRequest, (String)"station", (BValue)bProviderStation, null);
        return foxRequest;
    }

    /*
     * Exception decompiling
     */
    private final FoxResponse persist(FoxMessage var1_1, ProviderSession var2_2) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 208->211)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final BResolveBits persist(BProviderStation bProviderStation, BStationRole bStationRole, boolean bl, ProviderSession providerSession) throws Exception {
        BNiagaraStation bNiagaraStation = this.getNiagaraStation();
        BNiagaraNetwork bNiagaraNetwork = this.getNiagaraNetwork();
        BResolveBits bResolveBits = null;
        if (bNiagaraStation != null && bNiagaraStation.getStationName().equals(bProviderStation.getStationName())) {
            this.verifyRole(bStationRole);
            bNiagaraNetwork.getLocalStation().addRef(bProviderStation.getStationName(), this.getSysDefExt().getRole());
            bResolveBits = providerSession.persist(bProviderStation, bl);
            if (bl && this.getSysDefExt().getRole().isSubordinate() && !bResolveBits.equals((Object)BResolveBits.NONE)) {
                bNiagaraNetwork.getLocalStation().networkChanged();
            }
        } else {
            bResolveBits = providerSession.persist(bProviderStation, bl);
        }
        return bResolveBits;
    }

    private final void verifyRole(BStationRole bStationRole) throws SysDefException {
        BStationRole bStationRole2 = this.getSysDefExt().getRole();
        if (!bStationRole.equals((Object)bStationRole2)) {
            throw new SysDefException("Expected role for station " + this.getNiagaraStation().getStationName() + " to be " + (Object)((Object)bStationRole) + ", but current role is: " + (Object)((Object)bStationRole2));
        }
    }

    public void changeRole(BStationRole bStationRole) throws Exception {
        FoxRequest foxRequest = this.makeRequest(CHANGE_ROLE);
        foxRequest.add(CHANGE_ROLE, bStationRole.getOppositeRole().getOrdinal());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        this.checkStatus((FoxMessage)foxResponse);
        this.commitRole(bStationRole, true);
    }

    private final FoxResponse changeRole(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            BStationRole bStationRole = BStationRole.make(foxRequest.getInt(CHANGE_ROLE));
            BNiagaraSysDefDeviceExt bNiagaraSysDefDeviceExt = this.getSysDefExt();
            BStationRole bStationRole2 = bNiagaraSysDefDeviceExt.getRole();
            if (!bStationRole.equals((Object)bStationRole2) || !bStationRole.equals((Object)BStationRole.peer)) {
                this.checkRoleChange();
            }
            this.commitRole(bStationRole, false);
            foxResponse.add("status", "ok");
        }
        catch (Exception exception) {
            this.handleServerException(null, (FoxMessage)foxResponse, exception);
        }
        return foxResponse;
    }

    private final void checkRoleChange() throws SysDefException {
        if (!this.getSysDefExt().isOperational()) {
            throw new SysDefException("SysDef extension not in a valid state to change roles: " + this.getSysDefExt().getStatus());
        }
        if (!this.getSysDefExt().getRoleManager().isRoleSynced()) {
            throw new SysDefException("Simultaneous role change detected; cannot change role.");
        }
    }

    private final void commitRole(BStationRole bStationRole, boolean bl) {
        BNiagaraSysDefDeviceExt bNiagaraSysDefDeviceExt = this.getSysDefExt();
        BStationRole bStationRole2 = bNiagaraSysDefDeviceExt.getRole();
        this.getNiagaraNetwork().getLocalStation().removeRef(this.getNiagaraStation().getStationName(), bStationRole2);
        bNiagaraSysDefDeviceExt.getRoleManager().setActualRole(bStationRole);
        bNiagaraSysDefDeviceExt.getRoleManager().setDesiredRole(bStationRole);
        if (bl) {
            bNiagaraSysDefDeviceExt.getSyncTask().setRequestReciprocatedSync(true);
        }
    }

    public void syncToSubordinate(BSyncTask bSyncTask) throws Exception {
        BProviderStation bProviderStation = new BProviderStation();
        bProviderStation.copyFrom((BComplex)this.getNiagaraNetwork().getLocalStation());
        bProviderStation.setSubordinates(BNameList.make((String)this.getNiagaraStation().getName()));
        bProviderStation.setSupervisors(BNameList.DEFAULT);
        FoxRequest foxRequest = this.makeRequest(SYNC_TO_SUB);
        foxRequest.add("reciprocateSync", bSyncTask.getRequestReciprocatedSync());
        foxRequest.add("persistReq", (FoxMessage)this.makePersistRequest(bProviderStation, true));
        FoxResponse foxResponse = this.sendSync(foxRequest);
        this.checkStatus((FoxMessage)foxResponse);
    }

    /*
     * Exception decompiling
     */
    private final FoxResponse syncToSubordinate(FoxRequest var1_1) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 121->124)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void syncToSupervisor(BSyncTask bSyncTask) throws Exception {
        this.lastSync = new StringBuffer();
        BNiagaraNetwork bNiagaraNetwork = this.getNiagaraNetwork();
        ProviderSession providerSession = null;
        FoxCircuit foxCircuit = this.openCircuit(SYNC_TO_SUP);
        try {
            try {
                FoxMessage foxMessage = new FoxMessage();
                foxMessage.add("reciprocateSync", bSyncTask.getRequestReciprocatedSync());
                foxMessage.add("purge", bSyncTask.getSignalPurge());
                foxCircuit.writeMessage(foxMessage);
                providerSession = bNiagaraNetwork.getSysDefProvider().createSession(this.sn("syncToSupervisor_client"), null);
                this.syncToSupervisor(providerSession.doGetStation(bNiagaraNetwork.getLocalStation().getStationName()), foxCircuit, providerSession, this.lastSync);
                FoxMessage foxMessage2 = new FoxMessage();
                foxMessage2.add("EOF", true);
                foxCircuit.writeMessage(foxMessage2);
                foxCircuit.flush();
                FoxMessage foxMessage3 = foxCircuit.readMessage();
                this.checkStatus(foxMessage3);
            }
            catch (Exception exception) {
                this.lastSync.append("ERROR");
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (slog.isTraceOn()) {
                slog.trace("Sync'd Subtree to " + this.getNiagaraStation().getStationName() + ":\n" + this.lastSync.toString());
            }
            foxCircuit.close();
            if (providerSession == null) throw throwable;
            providerSession.close();
            throw throwable;
        }
        {
            Object var6_11 = null;
        }
        if (slog.isTraceOn()) {
            slog.trace("Sync'd Subtree to " + this.getNiagaraStation().getStationName() + ":\n" + this.lastSync.toString());
        }
        foxCircuit.close();
        if (providerSession == null) return;
        providerSession.close();
    }

    private final void syncToSupervisor(BProviderStation bProviderStation, FoxCircuit foxCircuit, ProviderSession providerSession, StringBuffer stringBuffer) throws Exception {
        if (bProviderStation == null) {
            return;
        }
        stringBuffer.append('(').append(bProviderStation.getStationName());
        if (!bProviderStation.getResolved().equals((Object)BResolveBits.ALL)) {
            bProviderStation = providerSession.read(bProviderStation.getStationName());
        }
        FoxMessage foxMessage = null;
        FoxRequest foxRequest = this.makePersistRequest(bProviderStation, false);
        foxCircuit.writeMessage((FoxMessage)foxRequest);
        foxCircuit.flush();
        foxMessage = foxCircuit.readMessage();
        this.checkStatus(foxMessage);
        if (foxMessage.getBoolean("networkStale")) {
            stringBuffer.append("+ ");
            String[] stringArray = bProviderStation.getStationRefs(BStationRole.subordinate);
            int n = 0;
            while (n < stringArray.length) {
                this.syncToSupervisor(providerSession.read(stringArray[n]), foxCircuit, providerSession, stringBuffer);
                ++n;
            }
        } else if (foxMessage.getBoolean("stationStale")) {
            stringBuffer.append("[s]");
        }
        stringBuffer.append(')');
    }

    /*
     * Exception decompiling
     */
    private final void syncToSupervisor(FoxCircuit var1_1) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [3 : 546->552)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sessionReg = new IntHashMap();
        this.nextId = 0;
    }

    public BSysDefChannel() {
        super(CHANNEL);
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nd$sysdef$BSysDefChannel;
        if (clazz == null) {
            clazz = class$com$tridium$nd$sysdef$BSysDefChannel = BSysDefChannel.class("[Lcom.tridium.nd.sysdef.BSysDefChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        slog = Log.getLog((String)"niagara.sysdef");
    }
}

