/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.sysdef.BBooleanPropertyState;
import com.tridium.nd.sysdef.BResolveBits;
import com.tridium.nd.sysdef.BSysDefVersion;
import com.tridium.nd.sysdef.ProviderSession;
import java.util.ListIterator;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameList;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BProviderStation
extends BComponent
implements BINiagaraStation {
    public static final Property stationName = BProviderStation.newProperty((int)1, (String)"", null);
    public static final Property alias = BProviderStation.newProperty((int)1, (String)"", null);
    public static final Property address = BProviderStation.newProperty((int)1, (String)"127.0.0.1", null);
    public static final Property foxPort = BProviderStation.newProperty((int)1, (int)-1, null);
    public static final Property foxsPort = BProviderStation.newProperty((int)1, (int)-1, null);
    public static final Property httpPort = BProviderStation.newProperty((int)1, (int)-1, null);
    public static final Property httpsPort = BProviderStation.newProperty((int)1, (int)-1, null);
    public static final Property niagaraDaemonPort = BProviderStation.newProperty((int)1, (int)-1, null);
    public static final Property niagaraDaemonSslPort = BProviderStation.newProperty((int)1, (int)-1, null);
    public static final Property foxTunneling = BProviderStation.newProperty((int)1, (BValue)BBooleanPropertyState.stale, null);
    public static final Property httpTunneling = BProviderStation.newProperty((int)1, (BValue)BBooleanPropertyState.stale, null);
    public static final Property onlyTunnelKnownStations = BProviderStation.newProperty((int)1, (BValue)BBooleanPropertyState.stale, null);
    public static final Property proxyAuthenticationWhenTunneling = BProviderStation.newProperty((int)1, (BValue)BBooleanPropertyState.stale, null);
    public static final Property services = BProviderStation.newProperty((int)5, (BValue)BNameList.DEFAULT, null);
    public static final Property subordinates = BProviderStation.newProperty((int)5, (BValue)BNameList.DEFAULT, null);
    public static final Property supervisors = BProviderStation.newProperty((int)5, (BValue)BNameList.DEFAULT, null);
    public static final Property stationVersion = BProviderStation.newProperty((int)5, (BValue)BSysDefVersion.DEFAULT, null);
    public static final Property networkVersion = BProviderStation.newProperty((int)5, (BValue)BSysDefVersion.DEFAULT, null);
    public static final Type TYPE;
    protected static final String BITS = "bits";
    private static final BIcon icon;
    private Object refLock;
    BNiagaraNetwork network;
    static /* synthetic */ Class class$com$tridium$nd$sysdef$BProviderStation;
    static /* synthetic */ Class class$javax$baja$util$BTypeSpec;

    public String getStationName() {
        return this.getString(stationName);
    }

    public void setStationName(String string) {
        this.setString(stationName, string, null);
    }

    public String getAlias() {
        return this.getString(alias);
    }

    public void setAlias(String string) {
        this.setString(alias, string, null);
    }

    public String getAddress() {
        return this.getString(address);
    }

    public void setAddress(String string) {
        this.setString(address, string, null);
    }

    public int getFoxPort() {
        return this.getInt(foxPort);
    }

    public void setFoxPort(int n) {
        this.setInt(foxPort, n, null);
    }

    public int getFoxsPort() {
        return this.getInt(foxsPort);
    }

    public void setFoxsPort(int n) {
        this.setInt(foxsPort, n, null);
    }

    public int getHttpPort() {
        return this.getInt(httpPort);
    }

    public void setHttpPort(int n) {
        this.setInt(httpPort, n, null);
    }

    public int getHttpsPort() {
        return this.getInt(httpsPort);
    }

    public void setHttpsPort(int n) {
        this.setInt(httpsPort, n, null);
    }

    public int getNiagaraDaemonPort() {
        return this.getInt(niagaraDaemonPort);
    }

    public void setNiagaraDaemonPort(int n) {
        this.setInt(niagaraDaemonPort, n, null);
    }

    public int getNiagaraDaemonSslPort() {
        return this.getInt(niagaraDaemonSslPort);
    }

    public void setNiagaraDaemonSslPort(int n) {
        this.setInt(niagaraDaemonSslPort, n, null);
    }

    public BBooleanPropertyState getFoxTunneling() {
        return (BBooleanPropertyState)this.get(foxTunneling);
    }

    public void setFoxTunneling(BBooleanPropertyState bBooleanPropertyState) {
        this.set(foxTunneling, (BValue)bBooleanPropertyState, null);
    }

    public BBooleanPropertyState getHttpTunneling() {
        return (BBooleanPropertyState)this.get(httpTunneling);
    }

    public void setHttpTunneling(BBooleanPropertyState bBooleanPropertyState) {
        this.set(httpTunneling, (BValue)bBooleanPropertyState, null);
    }

    public BBooleanPropertyState getOnlyTunnelKnownStations() {
        return (BBooleanPropertyState)this.get(onlyTunnelKnownStations);
    }

    public void setOnlyTunnelKnownStations(BBooleanPropertyState bBooleanPropertyState) {
        this.set(onlyTunnelKnownStations, (BValue)bBooleanPropertyState, null);
    }

    public BBooleanPropertyState getProxyAuthenticationWhenTunneling() {
        return (BBooleanPropertyState)this.get(proxyAuthenticationWhenTunneling);
    }

    public void setProxyAuthenticationWhenTunneling(BBooleanPropertyState bBooleanPropertyState) {
        this.set(proxyAuthenticationWhenTunneling, (BValue)bBooleanPropertyState, null);
    }

    public BNameList getServices() {
        return (BNameList)this.get(services);
    }

    public void setServices(BNameList bNameList) {
        this.set(services, (BValue)bNameList, null);
    }

    public BNameList getSubordinates() {
        return (BNameList)this.get(subordinates);
    }

    public void setSubordinates(BNameList bNameList) {
        this.set(subordinates, (BValue)bNameList, null);
    }

    public BNameList getSupervisors() {
        return (BNameList)this.get(supervisors);
    }

    public void setSupervisors(BNameList bNameList) {
        this.set(supervisors, (BValue)bNameList, null);
    }

    public BSysDefVersion getStationVersion() {
        return (BSysDefVersion)this.get(stationVersion);
    }

    public void setStationVersion(BSysDefVersion bSysDefVersion) {
        this.set(stationVersion, (BValue)bSysDefVersion, null);
    }

    public BSysDefVersion getNetworkVersion() {
        return (BSysDefVersion)this.get(networkVersion);
    }

    public void setNetworkVersion(BSysDefVersion bSysDefVersion) {
        this.set(networkVersion, (BValue)bSysDefVersion, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIpHost getIpHost() {
        return new BIpHost(this.getAddress());
    }

    public final synchronized void updateStationVersion() {
        this.setStationVersion(this.getStationVersion().increment());
    }

    public final synchronized void updateNetworkVersion() {
        this.setNetworkVersion(this.getNetworkVersion().increment());
    }

    public final synchronized void resetVersions() {
        this.setStationVersion(BSysDefVersion.make());
        this.setNetworkVersion(BSysDefVersion.make());
    }

    public final void setResolved(BResolveBits bResolveBits) {
        if (this.get(BITS) == null) {
            this.add(BITS, (BValue)bResolveBits, 1);
        } else {
            this.set(BITS, (BValue)bResolveBits);
        }
    }

    public final void removeResolved() {
        if (this.get(BITS) != null) {
            this.remove(BITS);
        }
    }

    public final BResolveBits getResolved() {
        BResolveBits bResolveBits = null;
        bResolveBits = (BResolveBits)this.get(BITS);
        return bResolveBits == null ? BResolveBits.NONE : bResolveBits;
    }

    public final boolean hasService(BTypeSpec bTypeSpec) {
        try {
            return this.getServices().contains(SlotPath.escape((String)bTypeSpec.encodeToString()));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public final Array getServiceTypes() {
        Class clazz = class$javax$baja$util$BTypeSpec;
        if (clazz == null) {
            clazz = class$javax$baja$util$BTypeSpec = BProviderStation.class("[Ljavax.baja.util.BTypeSpec;", false);
        }
        Array array = new Array(clazz);
        String[] stringArray = this.getServices().getNames();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                try {
                    array.add((Object)BTypeSpec.DEFAULT.decodeFromString(SlotPath.unescape((String)stringArray[n])));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                ++n;
            }
        }
        return array;
    }

    public final void setServiceTypes(Array array) {
        Object[] objectArray = array.trim();
        int n = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        int n2 = n;
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            try {
                stringArray[n3] = SlotPath.escape((String)((BTypeSpec)objectArray[n3]).encodeToString());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n3;
        }
        BNameList bNameList = BNameList.make((String[])stringArray);
        if (!this.getServices().equals((Object)bNameList)) {
            this.setServices(bNameList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addRef(String string, BStationRole bStationRole) {
        if (bStationRole.equals((Object)BStationRole.peer)) {
            return false;
        }
        Object object = this.refLock;
        synchronized (object) {
            BNameList bNameList = this.getList(bStationRole);
            if (!bNameList.contains(string)) {
                this.setList(BNameList.union((BNameList)bNameList, (BNameList)BNameList.make((String)string)), bStationRole);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeRef(String string, BStationRole bStationRole) {
        if (bStationRole.equals((Object)BStationRole.peer)) {
            return false;
        }
        Object object = this.refLock;
        synchronized (object) {
            BNameList bNameList = this.getList(bStationRole);
            if (bNameList.contains(string)) {
                this.setList(BNameList.difference((BNameList)bNameList, (BNameList)BNameList.make((String)string)), bStationRole);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String[] getStationRefs(BStationRole bStationRole) {
        if (bStationRole.equals((Object)BStationRole.peer)) {
            return new String[0];
        }
        Object object = this.refLock;
        synchronized (object) {
            return this.getList(bStationRole).getNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isReferenced(String string, BStationRole bStationRole) {
        if (bStationRole.equals((Object)BStationRole.peer)) {
            return false;
        }
        Object object = this.refLock;
        synchronized (object) {
            return this.getList(bStationRole).contains(string);
        }
    }

    protected final void setList(BNameList bNameList, BStationRole bStationRole) {
        switch (bStationRole.getOrdinal()) {
            case 1: {
                this.setSubordinates(bNameList);
                break;
            }
            case 2: {
                this.setSupervisors(bNameList);
                break;
            }
            default: {
                throw new IllegalStateException("Role: " + bStationRole.toString() + " not supported.");
            }
        }
    }

    protected final BNameList getList(BStationRole bStationRole) {
        switch (bStationRole.getOrdinal()) {
            case 1: {
                return this.getSubordinates();
            }
            case 2: {
                return this.getSupervisors();
            }
        }
        throw new IllegalStateException("Role: " + bStationRole.toString() + " not supported.");
    }

    ProviderSession getProviderSession() {
        if (this.network != null) {
            return (ProviderSession)this.network.createSysDefSession(null);
        }
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        return (ProviderSession)bNiagaraNetwork.createSysDefSession(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFoxSession getFoxSession() {
        ProviderSession providerSession = null;
        try {
            BFoxSession bFoxSession;
            providerSession = this.getProviderSession();
            BFoxSession bFoxSession2 = bFoxSession = providerSession.getFoxSession(this);
            Object var3_4 = null;
            if (providerSession != null) {
                providerSession.close();
            }
            return bFoxSession2;
        }
        catch (Throwable throwable) {
            block3: {
                Object var3_5 = null;
                if (providerSession == null) break block3;
                providerSession.close();
            }
            throw throwable;
        }
    }

    public boolean isEngaged(String string) {
        return this.getFoxSession().isEngaged(string);
    }

    public void engageNoRetry(String string) throws Exception {
        this.getFoxSession().engageNoRetry(string);
    }

    public void engageNoRetry(String string, long l) throws Exception {
        this.getFoxSession().engageNoRetry(string, l);
    }

    public void engageRetry(String string) throws Exception {
        this.getFoxSession().engageRetry(string);
    }

    public void disengage(String string) {
        this.getFoxSession().disengage(string);
    }

    public BValue invokeAction(BOrd bOrd, String string, BValue bValue) throws Exception {
        return ((BPointChannel)this.getFoxSession().getConnection().getChannels().get("point", BPointChannel.TYPE)).invoke(bOrd.encodeToString(), string, bValue);
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        Array array = this.getServiceTypes().sort();
        spyWriter.startTable(true);
        spyWriter.w((Object)"<tr>");
        spyWriter.thTitle((Object)(array.size() + " Services"));
        spyWriter.w((Object)"</tr>");
        ListIterator listIterator = array.iterator();
        while (listIterator.hasNext()) {
            BTypeSpec bTypeSpec = (BTypeSpec)listIterator.next();
            spyWriter.w((Object)"<tr>").td((Object)bTypeSpec).w((Object)"</tr>");
        }
        spyWriter.endTable();
        super.spy(spyWriter);
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer().append(this.getStationName()).append(" [ ").append(BOrd.make((BOrd)this.getIpHost().getAbsoluteOrd(), (String)("fox:" + this.getFoxPort())).toString(context));
        if (this.getFoxsPort() != -1) {
            stringBuffer.append(", ").append(BOrd.make((BOrd)this.getIpHost().getAbsoluteOrd(), (String)("foxs:" + this.getFoxsPort())).toString(context));
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.refLock = new Object();
        this.network = null;
    }

    public BProviderStation() {
        this.this();
    }

    public BProviderStation(String string) {
        this.this();
        this.setStationName(string);
    }

    static {
        Class clazz = class$com$tridium$nd$sysdef$BProviderStation;
        if (clazz == null) {
            clazz = class$com$tridium$nd$sysdef$BProviderStation = BProviderStation.class("[Lcom.tridium.nd.sysdef.BProviderStation;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://niagaraDriver/rc/sysDefStation.png");
    }
}

