/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.spy;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.ServerWorker;
import com.tridium.nd.spy.SpyStation;
import com.tridium.nv.BNiagaraVirtualGateway;
import java.io.IOException;
import javax.baja.driver.BDevice;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;

public class SpyStations
extends SpyDir {
    public final BNiagaraNetwork network;

    public Spy find(String string) {
        BNiagaraStation bNiagaraStation = (BNiagaraStation)this.network.getStation(string);
        return new SpyStation(bNiagaraStation);
    }

    public void write(SpyWriter spyWriter) throws IOException {
        spyWriter.startTable(true);
        BDevice[] bDeviceArray = this.network.getDevices();
        spyWriter.w((Object)"<tr>");
        spyWriter.thTitle((Object)"Station");
        spyWriter.thTitle((Object)"Status");
        spyWriter.thTitle((Object)"Client");
        spyWriter.thTitle((Object)"Server");
        spyWriter.thTitle((Object)"Points Client");
        spyWriter.thTitle((Object)"Niagara Virtuals Client");
        spyWriter.thTitle((Object)"Points/Virtuals Server");
        spyWriter.thTitle((Object)"Health");
        spyWriter.w((Object)"</tr>");
        int n = 0;
        while (n < bDeviceArray.length) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)bDeviceArray[n];
            String string = bNiagaraStation.getName();
            spyWriter.w((Object)"<tr>");
            spyWriter.td((Object)("<a href='" + string + "'>" + bNiagaraStation.getName() + "</a>"));
            spyWriter.td((Object)bNiagaraStation.getStatus());
            spyWriter.td((Object)("<a href='" + string + "/client'>" + bNiagaraStation.getClientConnection().getState() + "</a>"));
            spyWriter.td((Object)("<a href='" + string + "/server'>" + bNiagaraStation.getServerConnection().getState() + "</a>"));
            spyWriter.td((Object)("<a href='" + string + "/pointsClient'>" + SpyStations.toPointsClient(bNiagaraStation.getPoints()) + "</a>"));
            spyWriter.td((Object)("<a href='" + string + "/niagaraVirtuals'>" + SpyStations.toNiagaraVirtuals(bNiagaraStation.getVirtual()) + "</a>"));
            spyWriter.td((Object)("<a href='" + string + "/pointsServer'>" + SpyStations.toPointsServer(bNiagaraStation.getPoints()) + "</a>"));
            spyWriter.td((Object)bNiagaraStation.getHealth());
            spyWriter.w((Object)"</tr>");
            ++n;
        }
        spyWriter.endTable();
    }

    public static String toPointsClient(BNiagaraPointDeviceExt bNiagaraPointDeviceExt) {
        return "ProxyPoints: " + bNiagaraPointDeviceExt.getPoints().length;
    }

    public static String toNiagaraVirtuals(BNiagaraVirtualGateway bNiagaraVirtualGateway) {
        return "Niagara Virtual Components: " + bNiagaraVirtualGateway.getNiagaraVirtualComponents().length;
    }

    public static String toPointsServer(BNiagaraPointDeviceExt bNiagaraPointDeviceExt) {
        ServerWorker serverWorker = bNiagaraPointDeviceExt.serverWorker;
        String string = serverWorker != null ? "" + serverWorker.getSubscriptionCount() : "inactive";
        return "Subscriptions: " + string;
    }

    public SpyStations(BNiagaraNetwork bNiagaraNetwork) {
        this.network = bNiagaraNetwork;
    }
}

