/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.spy;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.spy.SpyConnection;
import com.tridium.nd.spy.SpyNiagaraVirtualsClient;
import com.tridium.nd.spy.SpyPointsClient;
import com.tridium.nd.spy.SpyPointsServer;
import com.tridium.nd.spy.SpyStations;
import com.tridium.nd.virtual.BNiagaraVirtualDeviceExt;
import java.io.IOException;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;

public class SpyStation
extends SpyDir {
    public final BNiagaraStation station;

    public void write(SpyWriter spyWriter) throws IOException {
        String string = "";
        spyWriter.startProps();
        spyWriter.trTitle((Object)("Station " + this.station.getName()), 2);
        spyWriter.prop((Object)"path", (Object)this.station.toPathString());
        spyWriter.prop((Object)"handle", this.station.getHandle());
        spyWriter.prop((Object)"currentTime", (Object)Clock.time());
        spyWriter.prop((Object)"health", (Object)this.station.getHealth());
        spyWriter.prop((Object)"health.lastOkTime", (Object)this.station.getHealth().getLastOkTime());
        spyWriter.prop((Object)"health.lastFailTime", (Object)this.station.getHealth().getLastFailTime());
        spyWriter.prop((Object)"health.lastFailCause", (Object)this.station.getHealth().getLastFailCause());
        spyWriter.trTitle((Object)("<a href='" + string + "client'>Client Connection</a>"), 2);
        BFoxClientConnection bFoxClientConnection = this.station.getClientConnection();
        this.writeCommonConn(spyWriter, (BFoxConnection)bFoxClientConnection);
        spyWriter.prop((Object)"username", (Object)bFoxClientConnection.getUsername());
        spyWriter.prop((Object)"connect", (Object)bFoxClientConnection.getLastConnectTime());
        spyWriter.prop((Object)"disconnect", (Object)(bFoxClientConnection.getLastDisconnectTime() + ": " + bFoxClientConnection.getLastDisconnectCause()));
        spyWriter.prop((Object)"failure", (Object)(bFoxClientConnection.getLastFailureTime() + ": " + bFoxClientConnection.getLastFailureCause()));
        spyWriter.prop((Object)"nextAttempt", (Object)bFoxClientConnection.getNextAttemptTime());
        spyWriter.prop((Object)"interests", bFoxClientConnection.getInterests().length);
        spyWriter.trTitle((Object)("<a href='" + string + "server'>Server Connection</a>"), 2);
        BFoxServerConnection bFoxServerConnection = this.station.getServerConnection();
        this.writeCommonConn(spyWriter, (BFoxConnection)bFoxServerConnection);
        spyWriter.prop((Object)"connect", (Object)bFoxServerConnection.getLastConnectTime());
        spyWriter.prop((Object)"lastLogin", (Object)(bFoxServerConnection.getLastLoginTime() + ": " + bFoxServerConnection.getLastLoginUsername() + " from " + bFoxServerConnection.getLastLoginAddress()));
        spyWriter.prop((Object)"disconnect", (Object)(bFoxServerConnection.getLastDisconnectTime() + ": " + bFoxServerConnection.getLastDisconnectCause()));
        spyWriter.trTitle((Object)("<a href='" + string + "pointsClient'>Client Points</a>"), 2);
        BNiagaraPointDeviceExt bNiagaraPointDeviceExt = this.station.getPoints();
        spyWriter.prop((Object)"count", (Object)SpyStations.toPointsClient(bNiagaraPointDeviceExt));
        spyWriter.trTitle((Object)("<a href='" + string + "niagaraVirtuals'>Client Niagara Virtuals</a>"), 2);
        BNiagaraVirtualDeviceExt bNiagaraVirtualDeviceExt = this.station.getVirtual();
        spyWriter.prop((Object)"count", (Object)SpyStations.toNiagaraVirtuals(bNiagaraVirtualDeviceExt));
        spyWriter.trTitle((Object)("<a href='" + string + "pointsServer'>Server Points/Virtuals</a>"), 2);
        spyWriter.prop((Object)"count", (Object)SpyStations.toPointsServer(bNiagaraPointDeviceExt));
        spyWriter.endProps();
    }

    private final void writeCommonConn(SpyWriter spyWriter, BFoxConnection bFoxConnection) {
        spyWriter.prop((Object)"state", (Object)bFoxConnection.getState());
        FoxSession foxSession = bFoxConnection.session();
        if (foxSession == null) {
            spyWriter.prop((Object)"session", (Object)"null");
        } else {
            int n = foxSession.getId();
            String string = foxSession.getRemoteHello().getString("app.name", "unknown");
            String string2 = foxSession.getRemoteHello().getString("app.version", "unknown");
            spyWriter.prop((Object)"session", (Object)("id=" + n + " (" + string + "  " + string2 + ')'));
        }
    }

    public SpyStation(BNiagaraStation bNiagaraStation) {
        this.station = bNiagaraStation;
        String string = bNiagaraStation.getName();
        this.add("client", new SpyConnection(string + " Client Connection", (BFoxConnection)bNiagaraStation.getClientConnection()));
        this.add("server", new SpyConnection(string + " Server Connection", (BFoxConnection)bNiagaraStation.getServerConnection()));
        this.add("pointsClient", (Spy)new SpyPointsClient(bNiagaraStation.getPoints()));
        this.add("niagaraVirtuals", (Spy)new SpyNiagaraVirtualsClient(bNiagaraStation.getVirtual()));
        this.add("pointsServer", (Spy)new SpyPointsServer(bNiagaraStation.getPoints()));
    }
}

