/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.spy;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxConnection;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.SlotCursor;

public class SpyConnection
extends Spy {
    static DateFormat format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy z");
    public final String title;
    public final BFoxConnection conn;

    public void write(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps();
        spyWriter.trTitle((Object)this.title, 2);
        spyWriter.prop((Object)"currentTime", (Object)Clock.time());
        this.writeInterests(spyWriter);
        spyWriter.trTitle((Object)"Properties", 2);
        SlotCursor slotCursor = this.conn.loadSlots().getProperties();
        while (slotCursor.next()) {
            spyWriter.prop((Object)slotCursor.property().getName(), (Object)slotCursor.get());
        }
        spyWriter.trTitle((Object)"Session", 2);
        FoxSession foxSession = this.conn.session();
        if (foxSession == null) {
            spyWriter.prop((Object)"null", (Object)"");
        } else {
            foxSession.dumpProps((PrintWriter)spyWriter);
        }
        spyWriter.endProps();
        this.writeInterestLog(spyWriter);
    }

    private final void writeInterests(SpyWriter spyWriter) throws Exception {
        if (!(this.conn instanceof BFoxClientConnection)) {
            return;
        }
        BFoxClientConnection bFoxClientConnection = (BFoxClientConnection)this.conn;
        BFoxClientConnection.Interest[] interestArray = bFoxClientConnection.getInterests();
        spyWriter.trTitle((Object)("Interests [" + interestArray.length + "] (see log below)"), 2);
        int n = 0;
        while (n < interestArray.length) {
            spyWriter.prop((Object)("interest[" + n + ']'), (Object)interestArray[n]);
            ++n;
        }
    }

    private final void writeInterestLog(SpyWriter spyWriter) {
        if (!(this.conn instanceof BFoxClientConnection)) {
            return;
        }
        BFoxClientConnection bFoxClientConnection = (BFoxClientConnection)this.conn;
        BFoxClientConnection.InterestLogItem[] interestLogItemArray = bFoxClientConnection.getInterestLog();
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)("Interest Log [" + interestLogItemArray.length + ']'), 4);
        spyWriter.w((Object)"<tr>").th((Object)"Interest").th((Object)"Engage").th((Object)"Disengage").th((Object)"Duration").w((Object)"</tr>\n");
        int n = 0;
        while (n < interestLogItemArray.length) {
            String string;
            String string2;
            long l = Clock.ticks();
            long l2 = interestLogItemArray[n].startTicks;
            long l3 = interestLogItemArray[n].endTicks;
            String string3 = SpyConnection.toTime(l2);
            if (l3 == 0L) {
                string2 = "Active";
                string = BRelTime.toString((long)(l - l2));
            } else {
                string2 = SpyConnection.toTime(l3);
                string = BRelTime.toString((long)(l3 - l2));
            }
            spyWriter.tr((Object)interestLogItemArray[n].interest, (Object)string3, (Object)string2, (Object)string);
            ++n;
        }
        spyWriter.endTable();
    }

    static String toTime(long l) {
        return format.format(new Date(Clock.millis() - Clock.ticks() + l));
    }

    public SpyConnection(String string, BFoxConnection bFoxConnection) {
        this.title = string;
        this.conn = bFoxConnection;
    }
}

