/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.point.ServerEntry;
import java.util.HashMap;
import javax.baja.net.NotConnectedException;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.Clock;
import javax.baja.sys.Subscriber;
import javax.baja.util.ICoalesceable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ServerWorker
extends Subscriber
implements Runnable,
ICoalesceable {
    public static final int WORKER_SLEEP = 1000;
    public static final ServerEntry[] noEntries = new ServerEntry[0];
    private final FoxLog log;
    private final BNiagaraPointDeviceExt points;
    private final BNiagaraStation station;
    private final BFoxServerConnection connection;
    private final BPointChannel channel;
    private IntHashMap byMessageId;
    private HashMap byComponent;

    public void start() {
        BNiagaraNetwork bNiagaraNetwork = this.station.getNiagaraNetwork();
        if (bNiagaraNetwork != null) {
            bNiagaraNetwork.getWorkers().register(this, 1000L);
        }
    }

    public void kill() {
        BNiagaraNetwork bNiagaraNetwork = this.station.getNiagaraNetwork();
        if (bNiagaraNetwork != null) {
            bNiagaraNetwork.getWorkers().unregister(this);
        }
        this.unsubAll();
    }

    public void run() {
        try {
            FoxRequest foxRequest = this.getSubscriptionChanges();
            if (foxRequest != null) {
                this.channel.sendChange(foxRequest);
            }
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            this.log.error("Error sendChange()", throwable);
        }
    }

    private final synchronized FoxRequest getSubscriptionChanges() {
        long l = Clock.ticks();
        FoxRequest foxRequest = null;
        IntHashMap.Iterator iterator = this.byMessageId.iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            if (!serverEntry.sendUpdate(l)) continue;
            if (foxRequest == null) {
                foxRequest = this.channel.makeRequest("change");
            }
            foxRequest.add((FoxTuple)serverEntry.update(this.log));
            serverEntry.changed = false;
            serverEntry.lastSent = l;
        }
        return foxRequest;
    }

    public ServerEntry getEntry(int n) {
        return (ServerEntry)this.byMessageId.get(n);
    }

    public ServerEntry[] getEntries(BComponent bComponent) {
        ServerEntry[] serverEntryArray = (ServerEntry[])this.byComponent.get(bComponent);
        if (serverEntryArray == null) {
            return noEntries;
        }
        return serverEntryArray;
    }

    public ServerEntry[] getAllEntries() {
        return (ServerEntry[])this.byMessageId.toArray((Object[])new ServerEntry[this.byMessageId.size()]);
    }

    public synchronized void sub(ServerEntry serverEntry) {
        this.byMessageId.put(serverEntry.messageId, (Object)serverEntry);
        ServerEntry[] serverEntryArray = this.getEntries(serverEntry.component);
        ServerEntry[] serverEntryArray2 = new ServerEntry[serverEntryArray.length + 1];
        System.arraycopy(serverEntryArray, 0, serverEntryArray2, 0, serverEntryArray.length);
        serverEntryArray2[serverEntryArray.length] = serverEntry;
        this.byComponent.put(serverEntry.component, serverEntryArray2);
        try {
            super.subscribe(serverEntry.component);
        }
        catch (Throwable throwable) {
            this.byMessageId.remove(serverEntry.messageId);
            this.byComponent.remove(serverEntry.component);
        }
    }

    public synchronized void unsub(int n) {
        ServerEntry serverEntry = (ServerEntry)this.byMessageId.get(n);
        if (serverEntry == null) {
            return;
        }
        this.byMessageId.remove(serverEntry.messageId);
        BComponent bComponent = serverEntry.component;
        ServerEntry[] serverEntryArray = this.getEntries(bComponent);
        if (serverEntryArray.length == 1) {
            if (serverEntryArray[0] != serverEntry) {
                throw new IllegalStateException();
            }
            this.byComponent.remove(bComponent);
            super.unsubscribe(bComponent);
        } else {
            ServerEntry[] serverEntryArray2 = new ServerEntry[serverEntryArray.length - 1];
            int n2 = 0;
            int n3 = 0;
            while (n2 < serverEntryArray.length) {
                if (serverEntryArray[n2] != serverEntry) {
                    serverEntryArray2[n3++] = serverEntryArray[n2];
                }
                ++n2;
            }
            this.byComponent.put(bComponent, serverEntryArray2);
        }
    }

    public synchronized void unsubAll() {
        super.unsubscribeAll();
        this.byMessageId.clear();
        this.byComponent.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void event(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getId() != 0) {
            return;
        }
        ServerEntry[] serverEntryArray = this.getEntries(bComponentEvent.getSourceComponent());
        int n = 0;
        while (n < serverEntryArray.length) {
            ServerWorker serverWorker;
            ServerEntry serverEntry = serverEntryArray[n];
            if (serverEntry.path == null || serverEntry.path.length <= 0 || (serverWorker = bComponentEvent.getSlot()) != null && serverWorker.equals(serverEntry.path[0])) {
                serverWorker = this;
                synchronized (serverWorker) {
                    serverEntry.changed = true;
                }
            }
            ++n;
        }
    }

    public String toString() {
        return this.station.getName() + ":Server Worker";
    }

    public Object getCoalesceKey() {
        return this;
    }

    public ICoalesceable coalesce(ICoalesceable iCoalesceable) {
        return iCoalesceable;
    }

    private final /* synthetic */ void this() {
        this.byMessageId = new IntHashMap();
        this.byComponent = new HashMap();
    }

    ServerWorker(BNiagaraPointDeviceExt bNiagaraPointDeviceExt) {
        this.this();
        this.points = bNiagaraPointDeviceExt;
        this.station = (BNiagaraStation)bNiagaraPointDeviceExt.getDevice();
        this.connection = this.station.getServerConnection();
        this.channel = (BPointChannel)this.connection.getChannels().get("point", BPointChannel.TYPE);
        this.log = this.channel.log;
    }
}

