/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.fox.message.FoxBoolean;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nv.point.BVirtualAction;
import javax.baja.data.BIDataValue;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BPermissions;
import javax.baja.status.BIStatus;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;

public class ServerEntry
implements Comparable {
    public final int messageId;
    public final String type;
    public final String pointId;
    public int minSendTime;
    public int maxSendTime;
    public long subTime;
    public long lastSent;
    public BComponent component;
    public Property[] path;
    public BPermissions permissions;
    public boolean changed;
    public boolean sendActions;

    public FoxMessage init(BPointChannel bPointChannel) {
        boolean bl;
        OrdTarget ordTarget;
        FoxMessage foxMessage = new FoxMessage("pt");
        foxMessage.add("mid", this.messageId);
        try {
            try {
                ordTarget = BOrd.make((String)this.pointId).resolve((BObject)Sys.getStation());
                this.component = ordTarget.getComponent();
                this.path = ordTarget.getPropertyPathInComponent();
            }
            catch (NullOrdException nullOrdException) {
                foxMessage.add("err", "Null ord: " + this.pointId);
                return foxMessage;
            }
            catch (UnresolvedException unresolvedException) {
                foxMessage.add("err", "Unresolved ord: " + this.pointId);
                return foxMessage;
            }
            this.permissions = bPointChannel.getPermissionsFor(this.component);
            if (!this.permissions.hasOperatorRead()) {
                foxMessage.add("err", "Invalid permissions");
                return foxMessage;
            }
        }
        catch (Throwable throwable) {
            bPointChannel.log.error("Cannot init: " + this.pointId, throwable);
            foxMessage.add("err", throwable.toString());
            return foxMessage;
        }
        ordTarget = this.update(bPointChannel.log);
        this.lastSent = this.subTime = Clock.ticks();
        boolean bl2 = false;
        if (ordTarget.getString("err", null) == null) {
            bl2 = true;
        }
        if (bl = bl2) {
            bPointChannel.getServerWorker().sub(this);
        }
        return ordTarget;
    }

    public boolean sendUpdate(long l) {
        long l2 = this.lastSent + (long)this.maxSendTime;
        if (l > l2) {
            return true;
        }
        if (!this.component.isMounted()) {
            return true;
        }
        if (!this.changed) {
            return false;
        }
        long l3 = this.lastSent + (long)this.minSendTime;
        return l3 <= l;
    }

    public FoxMessage update(FoxLog foxLog) {
        FoxMessage foxMessage = new FoxMessage("pt");
        foxMessage.add("mid", this.messageId);
        try {
            if (!this.component.isMounted()) {
                foxMessage.add("err", "Component removed");
                return foxMessage;
            }
            BComponent bComponent = this.component;
            if (this.path != null) {
                int n = 0;
                while (n < this.path.length) {
                    if ((bComponent = ((BComplex)bComponent).get(this.path[n])) == null) {
                        foxMessage.add("err", "Unresolved path");
                        return foxMessage;
                    }
                    ++n;
                }
            }
            ServerEntry.targetToMessage(this.type, (BObject)bComponent, foxMessage);
            if (this.sendActions) {
                foxMessage.add((FoxTuple)ServerEntry.actionsToMessage(this.component, this.permissions, foxLog, false));
                this.sendActions = false;
            }
        }
        catch (Exception exception) {
            foxLog.error("update", (Throwable)exception);
            foxMessage.add("err", exception.toString());
        }
        return foxMessage;
    }

    public static FoxMessage targetToMessage(String string, BObject bObject, FoxMessage foxMessage) {
        try {
            String string2;
            try {
                switch (string.charAt(0)) {
                    case 'b': {
                        foxMessage.add("v", ((BIBoolean)bObject).getBoolean());
                        break;
                    }
                    case 'n': {
                        foxMessage.add("v", ((BINumeric)bObject).getNumeric());
                        break;
                    }
                    case 'e': {
                        foxMessage.add("v", ((BIEnum)bObject).getEnum().getOrdinal());
                        break;
                    }
                    case 'v': {
                        if (bObject instanceof BComponent) {
                            System.out.println("Error: target to message is a component: " + bObject.getType());
                        }
                        foxMessage.add("v", ValueDocEncoder.marshal((BValue)((BValue)bObject)));
                        break;
                    }
                    default: {
                        string2 = bObject instanceof BIStatusValue ? ((BIStatusValue)bObject).getStatusValue().getValueValue().toString(null) : bObject.toString(null);
                        foxMessage.add("v", string2);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                foxMessage.add("err", "Type mismatch " + string + " != " + bObject.getType());
                return foxMessage;
            }
            string2 = BStatus.ok;
            if (bObject instanceof BIStatus) {
                string2 = ((BIStatus)bObject).getStatus();
            }
            foxMessage.add("s", string2.encodeToString());
            return foxMessage;
        }
        catch (Exception exception) {
            foxMessage.add("err", "Internal error " + exception);
            return foxMessage;
        }
    }

    public static BVirtualAction[] messageToActions(FoxMessage foxMessage, FoxLog foxLog) {
        try {
            FoxTuple[] foxTupleArray = foxMessage.list("action");
            BVirtualAction[] bVirtualActionArray = new BVirtualAction[foxTupleArray.length];
            int n = 0;
            while (n < bVirtualActionArray.length) {
                FoxTuple foxTuple;
                FoxMessage foxMessage2 = (FoxMessage)foxTupleArray[n];
                String string = foxMessage2.getString("name");
                String string2 = "";
                FoxTuple foxTuple2 = foxMessage2.getOptional("display");
                if (foxTuple2 != null) {
                    string2 = ((FoxString)foxTuple2).value;
                }
                String string3 = foxMessage2.getString("param", null);
                String string4 = foxMessage2.getString("return", null);
                String string5 = foxMessage2.getString("flags", null);
                String string6 = foxMessage2.getString("facets", null);
                Type type = null;
                if (string3 != null) {
                    type = Sys.getType((String)string3);
                }
                Type type2 = null;
                if (string4 != null) {
                    type2 = Sys.getType((String)string4);
                }
                int n2 = 0;
                if (string5 != null) {
                    n2 = Flags.decodeFromString((String)string5);
                }
                BFacets bFacets = BFacets.NULL;
                if (string6 != null) {
                    bFacets = BFacets.make((String)string6);
                }
                if ((foxTuple = foxMessage2.getOptional("frozen")) != null) {
                    bFacets = BFacets.make((BFacets)bFacets, (String)"nVirtualFroz", (BIDataValue)BBoolean.make((boolean)((FoxBoolean)foxTuple).value));
                }
                bVirtualActionArray[n] = new BVirtualAction(string, string2, type2, type, n2, bFacets);
                ++n;
            }
            return bVirtualActionArray;
        }
        catch (Exception exception) {
            foxLog.error("messageToActions", (Throwable)exception);
            return new BVirtualAction[0];
        }
    }

    public static FoxMessage actionsToMessage(BComponent bComponent, BPermissions bPermissions, FoxLog foxLog, boolean bl) {
        FoxMessage foxMessage = new FoxMessage("actions");
        try {
            Action[] actionArray = bComponent.getActionsArray();
            int n = 0;
            while (n < actionArray.length) {
                Action action = actionArray[n];
                if (!Flags.isHidden((BComplex)bComponent, (Slot)action) && !(Flags.isOperator((BComplex)bComponent, (Slot)action) ? !bPermissions.hasOperatorInvoke() : !bPermissions.hasAdminInvoke())) {
                    Type type = action.getParameterType();
                    Type type2 = action.getReturnType();
                    int n2 = bComponent.getFlags((Slot)action);
                    BFacets bFacets = bComponent.getSlotFacets((Slot)action);
                    FoxMessage foxMessage2 = new FoxMessage("action");
                    foxMessage2.add("name", action.getName());
                    foxMessage2.add("flags", Flags.encodeToString((int)n2));
                    if (type != null) {
                        foxMessage2.add("param", type.toString());
                    }
                    if (type2 != null) {
                        foxMessage2.add("return", type2.toString());
                    }
                    if (!bFacets.isNull()) {
                        foxMessage2.add("facets", bFacets.encodeToString());
                    }
                    if (bl) {
                        BNameMap bNameMap;
                        BFormat bFormat;
                        foxMessage2.add("frozen", bFacets.getb("nVirtualFroz", action.isFrozen()));
                        Property property = bComponent.getProperty("displayNames");
                        if (property != null && property.getType().is(BNameMap.TYPE) && (bFormat = (bNameMap = (BNameMap)bComponent.get(property)).get(action.getName())) != null) {
                            foxMessage2.add("display", bFormat.encodeToString());
                        }
                    } else {
                        foxMessage2.add("display", bComponent.getDisplayName((Slot)action, null));
                    }
                    foxMessage.add((FoxTuple)foxMessage2);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            foxLog.error("actionsToMessage", (Throwable)exception);
        }
        return foxMessage;
    }

    public String toString() {
        return "[" + this.messageId + "] " + this.pointId;
    }

    public String pathToString() {
        if (this.path == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.path.length) {
            if (n > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(this.path[n].getName());
            ++n;
        }
        return stringBuffer.toString();
    }

    public String lastSentToString() {
        if (this.lastSent == this.subTime) {
            return "onSub";
        }
        return BRelTime.toString((long)(Clock.ticks() - this.lastSent));
    }

    public String subscribeDurationToString() {
        return BRelTime.toString((long)(Clock.ticks() - this.subTime));
    }

    public int compareTo(Object object) {
        int n = ((ServerEntry)object).messageId;
        if (n == this.messageId) {
            return 0;
        }
        if (this.messageId < n) {
            return -1;
        }
        return 1;
    }

    public ServerEntry(FoxMessage foxMessage) throws Exception {
        this.messageId = foxMessage.getInt("mid");
        this.pointId = foxMessage.getString("pid");
        this.type = foxMessage.getString("t").intern();
        this.minSendTime = foxMessage.getInt("minSend");
        this.maxSendTime = foxMessage.getInt("maxSend");
        this.sendActions = foxMessage.getBoolean("fetchActions", false);
    }
}

