/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.EngageTimeoutException;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nv.point.BSubscriptionState;
import com.tridium.nv.point.INiagaraProxyExt;
import java.util.ArrayList;
import javax.baja.net.NotConnectedException;
import javax.baja.util.ICoalesceable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ClientWorker
implements Runnable,
ICoalesceable,
BFoxClientConnection.Interest {
    public static final int WORKER_SLEEP = 1000;
    private final FoxLog log;
    private final BNiagaraPointDeviceExt points;
    private final BNiagaraStation station;
    private final BFoxClientConnection connection;
    private final BPointChannel channel;
    private ArrayList toSub;
    private ArrayList toUnsub;
    private Object stoppedLock;
    private ArrayList stopped;

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        }
        return bl;
    }

    public final String toString() {
        try {
            return this.station.getName() + ":Client Worker";
        }
        catch (Exception exception) {
            return this.points.toString();
        }
    }

    public void start() {
        BNiagaraNetwork bNiagaraNetwork = this.station.getNiagaraNetwork();
        if (bNiagaraNetwork != null) {
            bNiagaraNetwork.getWorkers().register(this, 1000L);
        }
    }

    public void kill() {
        BNiagaraNetwork bNiagaraNetwork = this.station.getNiagaraNetwork();
        if (bNiagaraNetwork != null) {
            bNiagaraNetwork.getWorkers().unregister(this);
        }
        this.connection.disengage((BFoxClientConnection.Interest)this);
    }

    public void run() {
        try {
            this.workIt();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (EngageTimeoutException engageTimeoutException) {
            this.log.trace("EngageTimeoutException");
        }
        catch (Throwable throwable) {
            this.log.error("Error workIt()", throwable);
        }
    }

    public void workIt() throws Exception {
        this.toSub.clear();
        this.toUnsub.clear();
        boolean bl = this.pick();
        if (bl) {
            try {
                this.connection.engageNoRetry((BFoxClientConnection.Interest)this, this.connection.getRetryPeriod().getMillis(), true);
            }
            catch (Exception exception) {
                try {
                    this.connection.disengage((BFoxClientConnection.Interest)this);
                }
                catch (Exception exception2) {}
                return;
            }
        }
        this.connection.disengage((BFoxClientConnection.Interest)this);
        return;
        try {
            this.sendSub();
            this.sendUnsub();
            this.sendStopped();
        }
        catch (NotConnectedException notConnectedException) {
            this.log.trace("NotConnectedException");
        }
        catch (Exception exception) {
            this.log.error("Sending batches", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean pick() {
        Object object = this.points.stateLock;
        synchronized (object) {
            boolean bl = false;
            INiagaraProxyExt[] iNiagaraProxyExtArray = this.points.getProxyExtensions();
            int n = 0;
            while (n < iNiagaraProxyExtArray.length) {
                if (this.pick(iNiagaraProxyExtArray[n])) {
                    bl = true;
                }
                ++n;
            }
            return bl;
        }
    }

    private final boolean pick(INiagaraProxyExt iNiagaraProxyExt) {
        BSubscriptionState bSubscriptionState = iNiagaraProxyExt.getSubscriptionState();
        if (bSubscriptionState == BSubscriptionState.unsubscribed) {
            if (iNiagaraProxyExt.isPointSubscribed() && !iNiagaraProxyExt.isDisabled() && this.connection.isConnected()) {
                iNiagaraProxyExt.pendingSubscribe();
            } else {
                return false;
            }
        }
        if (bSubscriptionState == BSubscriptionState.proxyError) {
            return false;
        }
        if (bSubscriptionState == BSubscriptionState.pendingSubscribe || bSubscriptionState == BSubscriptionState.sendingSubscribe) {
            this.toSub.add(iNiagaraProxyExt);
        }
        if (bSubscriptionState == BSubscriptionState.pendingUnsubscribe || bSubscriptionState == BSubscriptionState.sendingUnsubscribe) {
            this.toUnsub.add(iNiagaraProxyExt);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void sendSub() throws Exception {
        Object object;
        if (this.toSub.size() == 0) {
            return;
        }
        try {
            object = this.points.stateLock;
            synchronized (object) {
                if (!this.connection.isConnected()) {
                    throw new NotConnectedException();
                }
                int n = 0;
                while (n < this.toSub.size()) {
                    INiagaraProxyExt iNiagaraProxyExt = (INiagaraProxyExt)this.toSub.get(n);
                    if (iNiagaraProxyExt.getSubscriptionState() != BSubscriptionState.sendingSubscribe) {
                        iNiagaraProxyExt.sendingSubscribe();
                    }
                    ++n;
                }
            }
        }
        catch (NotConnectedException notConnectedException) {
            throw notConnectedException;
        }
        catch (Exception exception) {
            Object object2 = this.points.stateLock;
            synchronized (object2) {
                int n = 0;
                while (true) {
                    if (n >= this.toSub.size()) {
                        throw exception;
                    }
                    ((INiagaraProxyExt)this.toSub.get(n)).setSubscriptionState(BSubscriptionState.unsubscribed);
                    ++n;
                }
            }
        }
        try {
            this.channel.subscribe(this.toSub);
        }
        catch (Exception exception) {
            Object object3 = this.points.stateLock;
            synchronized (object3) {
                int n = 0;
                while (true) {
                    if (n >= this.toSub.size()) {
                        throw exception;
                    }
                    ((INiagaraProxyExt)this.toSub.get(n)).setSubscriptionState(BSubscriptionState.unsubscribed);
                    ++n;
                }
            }
        }
        object = null;
        Object object4 = this.points.stateLock;
        synchronized (object4) {
            if (!this.connection.isConnected()) {
                throw new NotConnectedException();
            }
            int n = 0;
            while (n < this.toSub.size()) {
                try {
                    ((INiagaraProxyExt)this.toSub.get(n)).sentSubscribe();
                }
                catch (Exception exception) {
                    object = exception;
                }
                ++n;
            }
        }
        if (object == null) return;
        throw object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void sendUnsub() throws Exception {
        if (this.toUnsub.size() == 0) {
            return;
        }
        Object object = this.points.stateLock;
        // MONITORENTER : object
        if (!this.connection.isConnected()) {
            throw new NotConnectedException();
        }
        int n = 0;
        while (n < this.toUnsub.size()) {
            INiagaraProxyExt iNiagaraProxyExt = (INiagaraProxyExt)this.toUnsub.get(n);
            if (iNiagaraProxyExt.getSubscriptionState() != BSubscriptionState.sendingUnsubscribe) {
                iNiagaraProxyExt.sendingUnsubscribe();
            }
            ++n;
        }
        // MONITOREXIT : object
        this.channel.unsubscribe(this.toUnsub);
        Exception exception = null;
        object = this.points.stateLock;
        // MONITORENTER : object
        if (!this.connection.isConnected()) {
            throw new NotConnectedException();
        }
        int n2 = 0;
        while (n2 < this.toUnsub.size()) {
            try {
                ((INiagaraProxyExt)this.toUnsub.get(n2)).sentUnsubscribe();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            ++n2;
        }
        // MONITOREXIT : object
        if (exception == null) return;
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void sendStopped() throws Exception {
        ArrayList arrayList;
        if (this.stopped.size() == 0) {
            return;
        }
        Object object = this.stoppedLock;
        synchronized (object) {
            arrayList = this.stopped;
            this.stopped = new ArrayList();
        }
        this.channel.unsubscribe(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopped(INiagaraProxyExt iNiagaraProxyExt) {
        if (iNiagaraProxyExt.getSubscriptionState() == BSubscriptionState.unsubscribed) return;
        Object object = this.stoppedLock;
        synchronized (object) {
            this.stopped.add(new Integer(iNiagaraProxyExt.getMessageId()));
            return;
        }
    }

    public Object getCoalesceKey() {
        return this;
    }

    public ICoalesceable coalesce(ICoalesceable iCoalesceable) {
        return iCoalesceable;
    }

    private final /* synthetic */ void this() {
        this.toSub = new ArrayList();
        this.toUnsub = new ArrayList();
        this.stoppedLock = new Object();
        this.stopped = new ArrayList();
    }

    ClientWorker(BNiagaraPointDeviceExt bNiagaraPointDeviceExt) {
        this.this();
        this.points = bNiagaraPointDeviceExt;
        this.station = (BNiagaraStation)bNiagaraPointDeviceExt.getDevice();
        this.connection = this.station.getClientConnection();
        this.channel = (BPointChannel)this.connection.getChannels().get("point", BPointChannel.TYPE);
        this.log = this.channel.log;
    }
}

