/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nd.point.BNiagaraTuningPolicy;
import com.tridium.nd.point.ServerEntry;
import com.tridium.nd.point.ServerWorker;
import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.point.BSubscriptionState;
import com.tridium.nv.point.BVirtualAction;
import com.tridium.nv.point.INiagaraProxyExt;
import com.tridium.nv.point.IProxyActionParent;
import java.util.ArrayList;
import javax.baja.control.util.BOverride;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.IntHashMap;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPointChannel
extends BFoxChannel {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$nd$point$BPointChannel;

    public Type getType() {
        return TYPE;
    }

    public final BNiagaraPointDeviceExt getPoints() {
        try {
            return ((BNiagaraStation)this.getConnection().getParent()).getPoints();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final ServerWorker getServerWorker() {
        return ((BNiagaraStation)this.getConnection().getParent()).getPoints().serverWorker;
    }

    private final BNiagaraNetwork getNiagaraNetwork() {
        return ((BNiagaraStation)this.getConnection().getParent()).getNiagaraNetwork();
    }

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (string == "sub") {
            return this.subscribe(foxRequest);
        }
        if (string == "unsub") {
            return this.unsubscribe(foxRequest);
        }
        if (string == "change") {
            return this.change(foxRequest);
        }
        if (string == "getActionDefault") {
            return this.getActionDefault(foxRequest);
        }
        if (string == "invoke") {
            return this.invoke(foxRequest);
        }
        if (string == "getActions") {
            return this.getActions(foxRequest);
        }
        if (string == "write") {
            return this.write(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public synchronized void subscribe(ArrayList arrayList) throws Exception {
        try {
            FoxMessage foxMessage;
            FoxTuple[] foxTupleArray;
            BNiagaraTuningPolicy bNiagaraTuningPolicy = (BNiagaraTuningPolicy)this.getNiagaraNetwork().getTuningPolicies().getDefaultPolicy();
            FoxRequest foxRequest = this.makeRequest("sub");
            int n = 0;
            while (n < arrayList.size()) {
                foxTupleArray = (FoxTuple[])arrayList.get(n);
                BNiagaraTuningPolicy bNiagaraTuningPolicy2 = foxTupleArray instanceof BNiagaraProxyExt ? ((BNiagaraProxyExt)foxTupleArray).getNiagaraTuningPolicy() : bNiagaraTuningPolicy;
                foxMessage = new FoxMessage("pt");
                foxMessage.add("mid", foxTupleArray.getMessageId());
                foxMessage.add("pid", foxTupleArray.getPointId());
                foxMessage.add("t", foxTupleArray.getPointType());
                foxMessage.add("minSend", (int)bNiagaraTuningPolicy2.getMinUpdateTime().getMillis());
                foxMessage.add("maxSend", (int)bNiagaraTuningPolicy2.getMaxUpdateTime().getMillis());
                if (foxTupleArray.isActionFetchRequired()) {
                    foxMessage.add("fetchActions", true);
                }
                foxRequest.add((FoxTuple)foxMessage);
                ++n;
            }
            FoxResponse foxResponse = this.sendSync(foxRequest);
            if (this.isTraceOn()) {
                this.trace("c:sub");
                foxResponse.dump();
            }
            foxTupleArray = foxResponse.list("pt");
            int n2 = 0;
            while (n2 < foxTupleArray.length) {
                foxMessage = (INiagaraProxyExt)arrayList.get(n2);
                FoxMessage foxMessage2 = (FoxMessage)foxTupleArray[n2];
                try {
                    this.subscribed((INiagaraProxyExt)foxMessage, foxMessage2);
                }
                catch (Throwable throwable) {
                    this.log.error("subscribe", throwable);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            try {
                this.unsubscribe(arrayList);
            }
            catch (Exception exception2) {}
            throw exception;
        }
    }

    private final void subscribed(INiagaraProxyExt iNiagaraProxyExt, FoxMessage foxMessage) throws Exception {
        if (iNiagaraProxyExt.getMessageId() != foxMessage.getInt("mid")) {
            throw new IllegalStateException("messageId mismatch");
        }
        this.refreshValue(iNiagaraProxyExt, foxMessage);
        FoxMessage foxMessage2 = (FoxMessage)foxMessage.getOptional("actions");
        if (foxMessage2 != null) {
            iNiagaraProxyExt.updateActions(ServerEntry.messageToActions(foxMessage2, this.log));
        }
    }

    private final FoxResponse subscribe(FoxRequest foxRequest) throws Exception {
        FoxTuple[] foxTupleArray = foxRequest.list("pt");
        if (this.isTraceOn()) {
            this.trace("s:sub");
            foxRequest.dump();
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        int n = 0;
        while (n < foxTupleArray.length) {
            FoxMessage foxMessage = (FoxMessage)foxTupleArray[n];
            ServerEntry serverEntry = new ServerEntry(foxMessage);
            foxResponse.add((FoxTuple)serverEntry.init(this));
            ++n;
        }
        return foxResponse;
    }

    public synchronized void unsubscribe(ArrayList arrayList) throws Exception {
        FoxRequest foxRequest = this.makeRequest("unsub");
        int n = 0;
        while (n < arrayList.size()) {
            FoxMessage foxMessage = new FoxMessage("pt");
            Object e = arrayList.get(n);
            if (e instanceof INiagaraProxyExt) {
                foxMessage.add("mid", ((INiagaraProxyExt)e).getMessageId());
            } else {
                foxMessage.add("mid", ((Integer)e).intValue());
            }
            foxRequest.add((FoxTuple)foxMessage);
            ++n;
        }
        if (this.isTraceOn()) {
            this.trace("c:unsub");
            foxRequest.dump();
        }
        this.sendSync(foxRequest);
    }

    private final FoxResponse unsubscribe(FoxRequest foxRequest) throws Exception {
        FoxTuple[] foxTupleArray = foxRequest.list("pt");
        int n = 0;
        while (n < foxTupleArray.length) {
            FoxMessage foxMessage = (FoxMessage)foxTupleArray[n];
            this.unsubscribePoint(foxMessage);
            ++n;
        }
        return new FoxResponse(foxRequest);
    }

    private final void unsubscribePoint(FoxMessage foxMessage) {
        try {
            int n = foxMessage.getInt("mid");
            if (this.isTraceOn()) {
                this.trace("s:unsub " + n);
            }
            this.getServerWorker().unsub(n);
        }
        catch (Exception exception) {
            this.log.error("unsubscribePoint", (Throwable)exception);
        }
    }

    public void sendChange(FoxRequest foxRequest) throws Exception {
        this.sendAsync(foxRequest);
    }

    public FoxResponse change(FoxRequest foxRequest) throws Exception {
        FoxTuple[] foxTupleArray = foxRequest.list("pt");
        IntHashMap intHashMap = new IntHashMap();
        int n = 0;
        while (n < foxTupleArray.length) {
            FoxMessage foxMessage = (FoxMessage)foxTupleArray[n];
            intHashMap.put(foxMessage.getInt("mid"), (Object)foxMessage);
            ++n;
        }
        INiagaraProxyExt[] iNiagaraProxyExtArray = this.getPoints().getProxyExtensions();
        int n2 = 0;
        while (n2 < iNiagaraProxyExtArray.length) {
            FoxMessage foxMessage;
            if (iNiagaraProxyExtArray[n2].getSubscriptionState() == BSubscriptionState.subscribed && (foxMessage = (FoxMessage)intHashMap.get(iNiagaraProxyExtArray[n2].getMessageId())) != null) {
                try {
                    this.refreshValue(iNiagaraProxyExtArray[n2], foxMessage);
                }
                catch (Throwable throwable) {
                    this.log.error("refreshValue", throwable);
                }
            }
            ++n2;
        }
        return null;
    }

    void refreshValue(INiagaraProxyExt iNiagaraProxyExt, FoxMessage foxMessage) throws Exception {
        String string = foxMessage.getString("err", null);
        iNiagaraProxyExt.setSubscriptionError(string);
        if (string != null) {
            return;
        }
        Object object = null;
        String string2 = iNiagaraProxyExt.getPointType();
        object = string2 == "b" ? new BStatusBoolean(foxMessage.getBoolean("v")) : (string2 == "n" ? new BStatusNumeric(foxMessage.getFloat("v")) : (string2 == "e" ? new BStatusEnum((BEnum)BDynamicEnum.make((int)foxMessage.getInt("v"))) : (string2 == "v" ? ValueDocDecoder.unmarshal((String)foxMessage.getString("v")) : new BStatusString(foxMessage.getString("v")))));
        if (object instanceof BStatusValue) {
            BStatus bStatus = (BStatus)BStatus.DEFAULT.decodeFromString(foxMessage.getString("s", "0"));
            ((BStatusValue)object).setStatus(bStatus);
        }
        iNiagaraProxyExt.readValueOk((BValue)object);
    }

    public BValue getActionDefault(IProxyActionParent iProxyActionParent, BVirtualAction bVirtualAction) throws Exception {
        String string;
        FoxRequest foxRequest = this.makeRequest("getActionDefault");
        foxRequest.add("pid", iProxyActionParent.getPointId());
        foxRequest.add("name", bVirtualAction.getProxyActionName());
        if (this.isTraceOn()) {
            this.trace("c:getActionDefault");
            foxRequest.dump();
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        BValue bValue = null;
        String string2 = foxResponse.getString("default", null);
        if (string2 != null && (bValue = ValueDocDecoder.unmarshal((String)string2)) != null && bValue instanceof BOverride && (string = foxResponse.getString("maxOverrideDuration", null)) != null) {
            BOverride bOverride = (BOverride)bValue;
            bOverride.setMaxOverrideDuration((BRelTime)BRelTime.DEFAULT.decodeFromString(string));
        }
        return bValue;
    }

    private final FoxResponse getActionDefault(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.getString("pid");
        String string2 = foxRequest.getString("name");
        OrdTarget ordTarget = BOrd.make((String)string).resolve((BObject)Sys.getStation());
        BComponent bComponent = ordTarget.getComponent();
        if (bComponent == null) {
            throw new UnresolvedException(string);
        }
        Action action = bComponent.getAction(string2);
        if (action == null) {
            throw new UnresolvedException("No action " + string2);
        }
        BValue bValue = bComponent.getActionParameterDefault(action);
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        if (bValue != null) {
            BOverride bOverride;
            foxResponse.add("default", ValueDocEncoder.marshal((BValue)bValue));
            if (bValue instanceof BOverride && !(bOverride = (BOverride)bValue).getMaxOverrideDuration().equals((Object)BRelTime.DEFAULT)) {
                foxResponse.add("maxOverrideDuration", bOverride.getMaxOverrideDuration().encodeToString());
            }
        }
        if (this.isTraceOn()) {
            this.trace("s:getActionDefault");
            foxResponse.dump();
        }
        return foxResponse;
    }

    public BValue invoke(IProxyActionParent iProxyActionParent, BVirtualAction bVirtualAction, BValue bValue) throws Exception {
        return this.invoke(iProxyActionParent.getPointId(), bVirtualAction.getProxyActionName(), bValue);
    }

    public BValue invoke(String string, String string2, BValue bValue) throws Exception {
        FoxRequest foxRequest = this.makeRequest("invoke");
        foxRequest.add("pid", string);
        foxRequest.add("name", string2);
        if (bValue != null) {
            foxRequest.add("arg", ValueDocEncoder.marshal((BValue)bValue));
        }
        if (this.isTraceOn()) {
            this.trace("c:invoke");
            foxRequest.dump();
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        BValue bValue2 = null;
        String string3 = foxResponse.getString("return", null);
        if (string3 != null) {
            bValue2 = ValueDocDecoder.unmarshal((String)string3);
        }
        return bValue2;
    }

    private final FoxResponse invoke(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.getString("pid");
        String string2 = foxRequest.getString("name");
        String string3 = foxRequest.getString("arg", null);
        OrdTarget ordTarget = BOrd.make((String)string).resolve((BObject)Sys.getStation());
        BComponent bComponent = ordTarget.getComponent();
        if (bComponent == null) {
            throw new UnresolvedException(string);
        }
        Action action = bComponent.getAction(string2);
        if (action == null) {
            throw new UnresolvedException("No action " + string2);
        }
        BValue bValue = null;
        if (string3 != null) {
            bValue = ValueDocDecoder.unmarshal((String)string3);
        }
        BValue bValue2 = null;
        try {
            bValue2 = bComponent.invoke(action, bValue, this.getSessionContext());
        }
        catch (ActionInvokeException actionInvokeException) {
            throw (Exception)actionInvokeException.getCause();
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        if (bValue2 != null) {
            foxResponse.add("return", ValueDocEncoder.marshal((BValue)bValue2));
        }
        if (this.isTraceOn()) {
            this.trace("s:invoke");
            foxResponse.dump();
        }
        return foxResponse;
    }

    public BVirtualAction[] getActions(IProxyActionParent iProxyActionParent) throws Exception {
        FoxRequest foxRequest = this.makeRequest("getActions");
        foxRequest.add("pid", iProxyActionParent.getPointId());
        foxRequest.add("virtual", true);
        if (this.isTraceOn()) {
            this.trace("c:getActions");
            foxRequest.dump();
        }
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return ServerEntry.messageToActions((FoxMessage)foxResponse.get("actions"), this.log);
    }

    public FoxResponse getActions(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BOrd bOrd = BOrd.make((String)foxRequest.getString("pid"));
        BComponent bComponent = (BComponent)bOrd.get((BObject)Sys.getStation());
        BPermissions bPermissions = this.getPermissionsFor(bComponent);
        if (!bPermissions.hasOperatorRead()) {
            throw new Exception("Invalid permissions to read Actions");
        }
        if (bComponent instanceof BNiagaraVirtualComponent) {
            ((BNiagaraVirtualComponent)bComponent).niagaraVirtualCompCheckActions();
        }
        boolean bl = foxRequest.getBoolean("virtual");
        foxResponse.add((FoxTuple)ServerEntry.actionsToMessage(bComponent, bPermissions, this.log, bl));
        return foxResponse;
    }

    public void write(BOrd bOrd, String string, BValue bValue) throws Exception {
        FoxRequest foxRequest = this.makeRequest("write");
        foxRequest.add("pid", bOrd.toString());
        foxRequest.add("name", string);
        foxRequest.add("val", ValueDocEncoder.marshal((BValue)bValue));
        if (this.isTraceOn()) {
            this.trace("c:write");
            foxRequest.dump();
        }
        this.sendSync(foxRequest);
    }

    private final FoxResponse write(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BOrd bOrd = BOrd.make((String)foxRequest.getString("pid"));
        BComponent bComponent = (BComponent)bOrd.get((BObject)this);
        String string = foxRequest.getString("name");
        if (string == null) {
            throw new UnresolvedException("No Property name decoded");
        }
        Property property = bComponent.getProperty(string);
        if (property == null) {
            throw new UnresolvedException("Invalid Property name");
        }
        BValue bValue = ValueDocDecoder.unmarshal((String)foxRequest.getString("val"));
        bComponent.set(property, bValue, this.getSessionContext());
        return foxResponse;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BPointChannel() {
        super("point");
    }

    static {
        Class clazz = class$com$tridium$nd$point$BPointChannel;
        if (clazz == null) {
            clazz = class$com$tridium$nd$point$BPointChannel = BPointChannel.class("[Lcom.tridium.nd.point.BPointChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

