/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.history;

import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.history.BNiagaraHistoryDeviceExt;
import com.tridium.nd.history.BNiagaraHistoryImport;
import javax.baja.driver.util.BDescriptor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.HistoryException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BArchiveChannel
extends BFoxChannel {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$nd$history$BArchiveChannel;

    public Type getType() {
        return TYPE;
    }

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (string == "createHistory") {
            return this.createHistory(foxRequest);
        }
        if (string == "updateConfig") {
            return this.updateConfig(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public void circuitOpened(FoxCircuit foxCircuit) throws Exception {
        String string = foxCircuit.command;
        throw new InvalidCommandException(string);
    }

    public void createHistory(BHistoryConfig bHistoryConfig) throws Exception {
        FoxRequest foxRequest = this.makeRequest("createHistory");
        foxRequest.add("xml", ValueDocEncoder.marshal((BValue)bHistoryConfig));
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("success", false)) {
            if (foxResponse.getBoolean("importAlreadyExists", false)) {
                throw new HistoryException("Active import already exists for history: " + bHistoryConfig.getId());
            }
            throw new HistoryException("Cannot create history: " + bHistoryConfig.getId());
        }
    }

    public FoxResponse createHistory(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        String string = foxRequest.getString("xml", null);
        BHistoryConfig bHistoryConfig = (BHistoryConfig)ValueDocDecoder.unmarshal((String)string);
        bHistoryConfig = bNiagaraNetwork.getHistoryPolicies().makeConfig(bHistoryConfig);
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        if (this.activeHistoryImportExists(bHistoryConfig.getId())) {
            foxResponse.add("success", false);
            foxResponse.add("importAlreadyExists", true);
        } else {
            bHistoryConfig = this.updateSource(bNiagaraNetwork, bHistoryConfig);
            try {
                bHistoryDatabase.createHistory(bHistoryConfig);
                foxResponse.add("success", bHistoryDatabase.exists(bHistoryConfig.getId()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                foxResponse.add("success", false);
            }
        }
        return foxResponse;
    }

    public void updateConfig(BHistoryConfig bHistoryConfig) throws Exception {
        FoxRequest foxRequest = this.makeRequest("updateConfig");
        foxRequest.add("xml", ValueDocEncoder.marshal((BValue)bHistoryConfig));
        FoxResponse foxResponse = this.sendSync(foxRequest);
        if (!foxResponse.getBoolean("success", false)) {
            if (foxResponse.getBoolean("importAlreadyExists", false)) {
                throw new HistoryException("Active import already exists for history: " + bHistoryConfig.getId());
            }
            throw new HistoryException("Cannot reconfigure history: " + bHistoryConfig.getId());
        }
    }

    public FoxResponse updateConfig(FoxRequest foxRequest) throws Exception {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BNiagaraNetwork bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        String string = foxRequest.getString("xml", null);
        BHistoryConfig bHistoryConfig = (BHistoryConfig)ValueDocDecoder.unmarshal((String)string);
        bHistoryConfig = bNiagaraNetwork.getHistoryPolicies().makeConfig(bHistoryConfig);
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        if (this.activeHistoryImportExists(bHistoryConfig.getId())) {
            foxResponse.add("success", false);
            foxResponse.add("importAlreadyExists", true);
        } else {
            bHistoryConfig = this.updateSource(bNiagaraNetwork, bHistoryConfig);
            try {
                bHistoryDatabase.reconfigureHistory(bHistoryConfig);
                foxResponse.add("success", bHistoryDatabase.exists(bHistoryConfig.getId()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                foxResponse.add("success", false);
            }
        }
        return foxResponse;
    }

    private final BHistoryConfig updateSource(BNiagaraNetwork bNiagaraNetwork, BHistoryConfig bHistoryConfig) {
        try {
            BNiagaraStation bNiagaraStation = null;
            BComplex bComplex = this.getParent();
            while (bComplex != null) {
                if (bComplex instanceof BNiagaraStation) {
                    bNiagaraStation = (BNiagaraStation)bComplex;
                    break;
                }
                bComplex = bComplex.getParent();
            }
            if (bNiagaraStation != null) {
                BOrd bOrd = this.getSourceOrd(bNiagaraStation);
                BOrdList bOrdList = bHistoryConfig.getSource();
                if (bOrdList.size() < 1) {
                    bHistoryConfig.setSource(BOrdList.make((BOrd)bOrd));
                } else if (!bOrdList.get(bOrdList.size() - 1).equals((Object)bOrd)) {
                    BOrdList bOrdList2 = BOrdList.add((BOrdList)bOrdList, (BOrd)bOrd);
                    bHistoryConfig.setSource(bOrdList2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bHistoryConfig;
    }

    private final BOrd getSourceOrd(BNiagaraStation bNiagaraStation) {
        BComponentSpace bComponentSpace = bNiagaraStation.getComponentSpace();
        if (bComponentSpace == null) {
            return bNiagaraStation.getSlotPathOrd();
        }
        BOrd bOrd = bComponentSpace.getOrdInSession();
        if (bOrd == null) {
            return bNiagaraStation.getSlotPathOrd();
        }
        return BOrd.make((BOrd)bOrd, (BOrd)bNiagaraStation.getSlotPathOrd());
    }

    private final boolean activeHistoryImportExists(BHistoryId bHistoryId) {
        if (bHistoryId == null || this.getConnection() == null) {
            return false;
        }
        NiagaraStation niagaraStation = this.getConnection().getParentStation();
        if (niagaraStation == null || !(niagaraStation instanceof BNiagaraStation)) {
            return false;
        }
        String string = niagaraStation.getStationName();
        BNiagaraHistoryDeviceExt bNiagaraHistoryDeviceExt = ((BNiagaraStation)niagaraStation).getHistories();
        if (bNiagaraHistoryDeviceExt == null) {
            return false;
        }
        BDescriptor[] bDescriptorArray = bNiagaraHistoryDeviceExt.getDescriptors();
        if (bDescriptorArray == null) {
            return false;
        }
        int n = 0;
        while (n < bDescriptorArray.length) {
            if (bDescriptorArray[n] instanceof BNiagaraHistoryImport && bDescriptorArray[n].getEnabled() && !bDescriptorArray[n].isDisabled() && ((BNiagaraHistoryImport)bDescriptorArray[n]).getHistoryId().fromShorthand(string).equals((Object)bHistoryId)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BArchiveChannel() {
        super("archive");
    }

    static {
        Class clazz = class$com$tridium$nd$history$BArchiveChannel;
        if (clazz == null) {
            clazz = class$com$tridium$nd$history$BArchiveChannel = BArchiveChannel.class("[Lcom.tridium.nd.history.BArchiveChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

