/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.alarm;

import com.tridium.alarm.BIUpdatableAlarmSource;
import com.tridium.alarm.BStationRecipient;
import com.tridium.alarm.BTextCustomizer;
import com.tridium.alarm.BTextOp;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.alarm.AlarmWorker;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmClassFolder;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BICollection;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNiagaraAlarmDeviceExt
extends BAlarmDeviceExt
implements BINiagaraDeviceExt,
BFoxClientConnection.Interest,
BIUpdatableAlarmSource {
    public static final Property alarmClass = BNiagaraAlarmDeviceExt.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:DeviceExtAlarmClassFE")));
    public static final Property sourceName = BNiagaraAlarmDeviceExt.newProperty((int)0, (BValue)new BTextCustomizer(BTextOp.prepend, BFormat.make((String)"%parent.parent.displayName%:")), null);
    public static final Property workerState = BNiagaraAlarmDeviceExt.newProperty((int)3, (String)"", null);
    public static final Property lastSendTime = BNiagaraAlarmDeviceExt.newProperty((int)9, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property lastSendFailureTime = BNiagaraAlarmDeviceExt.newProperty((int)9, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property lastSendFailureCause = BNiagaraAlarmDeviceExt.newProperty((int)1, (String)"", null);
    public static final Action updateAlarm = BNiagaraAlarmDeviceExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE;
    public static final Log logger;
    private Queue workQueue;
    AlarmWorker worker;
    private BStatus oldStatus;
    static /* synthetic */ Class class$com$tridium$nd$alarm$BNiagaraAlarmDeviceExt;
    static /* synthetic */ Class class$com$tridium$alarm$BStationRecipient;

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String string) {
        this.setString(alarmClass, string, null);
    }

    public BTextCustomizer getSourceName() {
        return (BTextCustomizer)this.get(sourceName);
    }

    public void setSourceName(BTextCustomizer bTextCustomizer) {
        this.set(sourceName, (BValue)bTextCustomizer, null);
    }

    public String getWorkerState() {
        return this.getString(workerState);
    }

    public void setWorkerState(String string) {
        this.setString(workerState, string, null);
    }

    public BAbsTime getLastSendTime() {
        return (BAbsTime)this.get(lastSendTime);
    }

    public void setLastSendTime(BAbsTime bAbsTime) {
        this.set(lastSendTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastSendFailureTime() {
        return (BAbsTime)this.get(lastSendFailureTime);
    }

    public void setLastSendFailureTime(BAbsTime bAbsTime) {
        this.set(lastSendFailureTime, (BValue)bAbsTime, null);
    }

    public String getLastSendFailureCause() {
        return this.getString(lastSendFailureCause);
    }

    public void setLastSendFailureCause(String string) {
        this.setString(lastSendFailureCause, string, null);
    }

    public void updateAlarm(BAlarmRecord bAlarmRecord) {
        this.invoke(updateAlarm, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void updateStatus() {
        BDevice bDevice = this.getDevice();
        BStatus bStatus = bDevice.getStatus();
        if ((this.oldStatus.isStale() || this.oldStatus.isDisabled()) && !bStatus.isDisabled()) {
            this.initWorker(false);
        } else if (!this.oldStatus.isDisabled() && bStatus.isDisabled()) {
            if (this.worker != null) {
                this.worker.kill("disabled");
            }
        } else if ((this.oldStatus.isStale() || this.oldStatus.isFault()) && !bStatus.isFault()) {
            this.initWorker(false);
        } else if (!this.oldStatus.isFault() && bStatus.isFault()) {
            if (this.worker != null) {
                this.worker.kill("fault");
            }
        } else if ((this.oldStatus.isStale() || this.oldStatus.isDown()) && !bStatus.isDown()) {
            this.initWorker(true);
        } else if (!this.oldStatus.isDown()) {
            bStatus.isDown();
        }
        this.oldStatus = bStatus;
    }

    public void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.updateStatus();
        }
    }

    public void stationStarted() throws Exception {
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void initWorker(boolean bl) {
        Queue queue = this.workQueue;
        synchronized (queue) {
            this.workQueue.clear();
            if (bl) {
                this.workQueue.enqueue((Object)new InitNewAlarms(this.getLastSendTime()));
                this.workQueue.enqueue((Object)new InitAlarmUpdates(this.getLastSendTime()));
                this.workQueue.enqueue((Object)new InitAckPending());
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
            if (this.worker == null) {
                this.worker = new AlarmWorker(this, this.workQueue);
            }
            if (!this.worker.isRunning()) {
                this.worker.start();
            }
            return;
        }
    }

    public void stopped() {
        if (this.worker != null) {
            this.worker.kill("ext stopped");
            this.worker = null;
        }
    }

    public void doUpdateAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        if (logger.isTraceOn()) {
            logger.trace("BNiagaraAlarms.doUpdateAlarm: " + bAlarmRecord.getTimestamp() + ' ' + bAlarmRecord.getAlarmClass() + ' ' + bAlarmRecord.getSource());
        }
        if (!this.oldStatus.isDisabled() && !this.oldStatus.isFault()) {
            if (!this.oldStatus.isDown() && ((BNiagaraStation)this.getDevice()).getClientConnection().isConnected()) {
                this.workQueue.enqueue((Object)new AlarmRecordQueueItem(bAlarmRecord));
            } else {
                this.initWorker(true);
            }
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        BAlarmRecord bAlarmRecord2 = (BAlarmRecord)bAlarmRecord.newCopy();
        if (logger.isTraceOn()) {
            logger.trace("BNiagaraAlarms.doAckAlarm: " + bAlarmRecord2.getTimestamp() + ' ' + bAlarmRecord2.getAlarmClass() + ' ' + bAlarmRecord2.getSource());
        }
        BOrdList bOrdList = bAlarmRecord2.getSource();
        BOrdList bOrdList2 = BOrdList.remove((BOrdList)bOrdList, (int)(bOrdList.size() - 1));
        bAlarmRecord2.setSource(bOrdList2);
        BObject bObject = bAlarmRecord2.getAlarmData().get("hyperlinkOrd");
        if (bObject != null) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)this.getParent();
            String string = AlarmWorker.makeStationSessionOrdSegment(bNiagaraStation);
            if (bObject.toString().startsWith(string)) {
                String string2 = bObject.toString().substring(string.length());
                bAlarmRecord2.setAlarmData(BFacets.make((BFacets)bAlarmRecord2.getAlarmData(), (String)"hyperlinkOrd", (BIDataValue)BString.make((String)string2)));
            }
        }
        if (!this.oldStatus.isDisabled() && !this.oldStatus.isFault()) {
            if (!this.oldStatus.isDown() && ((BNiagaraStation)this.getDevice()).getClientConnection().isConnected()) {
                this.workQueue.enqueue((Object)new AlarmRecordQueueItem(bAlarmRecord2));
            } else {
                this.initWorker(true);
            }
        }
        return BBoolean.make((boolean)true);
    }

    public void doRouteAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        if (!this.oldStatus.isDisabled() && !this.oldStatus.isFault()) {
            if (!this.oldStatus.isDown() && ((BNiagaraStation)this.getDevice()).getClientConnection().isConnected()) {
                this.workQueue.enqueue((Object)new AlarmRecordQueueItem(bAlarmRecord));
            } else {
                this.initWorker(true);
            }
        }
    }

    public BStationRecipient[] getRegisteredStationRecipients() {
        try {
            Class clazz = class$com$tridium$alarm$BStationRecipient;
            if (clazz == null) {
                clazz = class$com$tridium$alarm$BStationRecipient = BNiagaraAlarmDeviceExt.class("[Lcom.tridium.alarm.BStationRecipient;", false);
            }
            Array array = new Array(clazz);
            this.doGetRegisteredRecipients(Sys.getService((Type)BAlarmService.TYPE), array);
            return (BStationRecipient[])array.trim();
        }
        catch (Exception exception) {
            return new BStationRecipient[0];
        }
    }

    private final void doGetRegisteredRecipients(BComponent bComponent, Array array) {
        BComponent[] bComponentArray = bComponent.getChildComponents();
        int n = 0;
        while (n < bComponentArray.length) {
            if (bComponentArray[n] instanceof BAlarmClassFolder) {
                this.doGetRegisteredRecipients(bComponentArray[n], array);
            } else if (bComponentArray[n] instanceof BStationRecipient && this.getDevice() != null && ((BStationRecipient)bComponentArray[n]).getRemoteStation().equals(this.getDevice().getName())) {
                array.add((Object)bComponentArray[n]);
            }
            ++n;
        }
    }

    public void clientOpened() {
    }

    public void clientClosed() {
    }

    public void serverOpened() {
    }

    public void serverClosed() {
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("NiagaraAlarmDeviceExt");
        spyWriter.prop((Object)"deviceStatus", (Object)("" + this.oldStatus));
        spyWriter.prop((Object)"queueSize", (Object)("" + this.workQueue.size()));
        int n = this.workQueue.size() > 3 ? 3 : this.workQueue.size();
        Object[] objectArray = this.workQueue.toArray();
        int n2 = 0;
        while (n2 < n) {
            spyWriter.prop((Object)("queueElem" + n2), (Object)("" + objectArray[n2].getClass()));
            ++n2;
        }
        if (this.worker == null) {
            spyWriter.prop((Object)"worker", (Object)"null");
        } else {
            spyWriter.prop((Object)"worker", (Object)this.getWorkerState());
        }
        spyWriter.endProps();
        super.spy(spyWriter);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.workQueue = new CoalesceQueue();
        this.oldStatus = BStatus.stale;
    }

    public BNiagaraAlarmDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nd$alarm$BNiagaraAlarmDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$nd$alarm$BNiagaraAlarmDeviceExt = BNiagaraAlarmDeviceExt.class("[Lcom.tridium.nd.alarm.BNiagaraAlarmDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        logger = Log.getLog((String)"niagara.alarms");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class InitNewAlarms
    implements InitJob {
        BAbsTime startTime;

        public void execute() {
            String string = "alarm:|bql:select * where lastUpdate > AbsTime '" + this.startTime.encodeToString() + '\'';
            BStationRecipient[] bStationRecipientArray = BNiagaraAlarmDeviceExt.this.getRegisteredStationRecipients();
            if (bStationRecipientArray.length <= 0) {
                return;
            }
            BOrd bOrd = BOrd.make((String)string);
            BICollection bICollection = (BICollection)bOrd.resolve().get();
            Cursor cursor = bICollection.cursor();
            Array[] arrayArray = new Array[4];
            int n = 0;
            while (cursor.next()) {
                BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
                String string2 = bAlarmRecord.getAlarmData().gets(BAlarmClass.ESCALATED, null);
                int n2 = 0;
                if (string2 != null) {
                    if (string2.equals(BAlarmClass.LEVEL_1)) {
                        n2 = 1;
                    } else if (string2.equals(BAlarmClass.LEVEL_2)) {
                        n2 = 2;
                    } else if (string2.equals(BAlarmClass.LEVEL_3)) {
                        n2 = 3;
                    }
                }
                int n3 = 0;
                while (n3 < bStationRecipientArray.length) {
                    arrayArray[0] = new Array((Object[])bStationRecipientArray[n3].getSubscribedAlarmClasses());
                    arrayArray[1] = new Array((Object[])bStationRecipientArray[n3].getSubscribedEscalatedAlarmClasses(1));
                    arrayArray[2] = new Array((Object[])bStationRecipientArray[n3].getSubscribedEscalatedAlarmClasses(2));
                    arrayArray[3] = new Array((Object[])bStationRecipientArray[n3].getSubscribedEscalatedAlarmClasses(3));
                    int n4 = 0;
                    while (n4 <= n2) {
                        if (arrayArray[n4].contains((Object)bAlarmRecord.getAlarmClass()) && bStationRecipientArray[n3].accept(bAlarmRecord)) {
                            BNiagaraAlarmDeviceExt.this.workQueue.enqueue((Object)new AlarmRecordQueueItem(bAlarmRecord));
                            ++n;
                        }
                        ++n4;
                    }
                    ++n3;
                }
            }
            if (logger.isTraceOn()) {
                logger.trace("enqueued " + n + " alarms");
            }
        }

        public InitNewAlarms(BAbsTime bAbsTime) {
            this.startTime = bAbsTime;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class InitAlarmUpdates
    implements InitJob {
        BAbsTime startTime;

        public void execute() {
            String string = "alarm:|bql:select * where lastUpdate > AbsTime '" + this.startTime.encodeToString() + '\'';
            string = string + " AND source LIKE '%" + BNiagaraAlarmDeviceExt.this.getSlotPath() + "' AND alarmData LIKE '%notes=%' AND ackState != alarm:AckState.ackPending";
            BOrd bOrd = BOrd.make((String)string);
            BICollection bICollection = (BICollection)bOrd.resolve().get();
            Cursor cursor = bICollection.cursor();
            int n = 0;
            while (cursor.next()) {
                BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
                BNiagaraAlarmDeviceExt.this.workQueue.enqueue((Object)new AlarmRecordQueueItem(bAlarmRecord));
                ++n;
            }
            if (logger.isTraceOn()) {
                logger.trace("enqueued " + n + " alarms");
            }
        }

        public InitAlarmUpdates(BAbsTime bAbsTime) {
            this.startTime = bAbsTime;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class InitAckPending
    implements InitJob {
        public void execute() {
            String string = "alarm:|bql:select * from ackPendingAlarms";
            BOrd bOrd = BOrd.make((String)string);
            BICollection bICollection = (BICollection)bOrd.resolve().get();
            Cursor cursor = bICollection.cursor();
            int n = 0;
            while (cursor.next()) {
                BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
                BOrdList bOrdList = bAlarmRecord.getSource();
                if (bOrdList.size() == 0 || !bOrdList.get(bOrdList.size() - 1).toString().equals(BNiagaraAlarmDeviceExt.this.getSlotPath().toString())) continue;
                BAlarmRecord bAlarmRecord2 = (BAlarmRecord)bAlarmRecord.newCopy();
                BOrdList bOrdList2 = BOrdList.remove((BOrdList)bOrdList, (int)(bOrdList.size() - 1));
                bAlarmRecord2.setSource(bOrdList2);
                BObject bObject = bAlarmRecord2.getAlarmData().get("hyperlinkOrd");
                if (bObject != null) {
                    BNiagaraStation bNiagaraStation = (BNiagaraStation)BNiagaraAlarmDeviceExt.this.getParent();
                    String string2 = AlarmWorker.makeStationSessionOrdSegment(bNiagaraStation);
                    if (bObject.toString().startsWith(string2)) {
                        String string3 = bObject.toString().substring(string2.length());
                        bAlarmRecord2.setAlarmData(BFacets.make((BFacets)bAlarmRecord2.getAlarmData(), (String)"hyperlinkOrd", (BIDataValue)BString.make((String)string3)));
                    }
                }
                BNiagaraAlarmDeviceExt.this.workQueue.enqueue((Object)new AlarmRecordQueueItem(bAlarmRecord2));
                ++n;
            }
            if (logger.isTraceOn()) {
                logger.trace("enqueued " + n + " alarm acks");
            }
        }

        InitAckPending() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class AlarmRecordQueueItem
    implements ICoalesceable {
        BAlarmRecord record;

        public ICoalesceable coalesce(ICoalesceable iCoalesceable) {
            if (iCoalesceable instanceof AlarmRecordQueueItem && ((AlarmRecordQueueItem)iCoalesceable).record.getLastUpdate().isBefore(this.record.getLastUpdate())) {
                return this;
            }
            return iCoalesceable;
        }

        public Object getCoalesceKey() {
            return this.record.getUuid();
        }

        AlarmRecordQueueItem(BAlarmRecord bAlarmRecord) {
            this.record = (BAlarmRecord)bAlarmRecord.newCopy();
        }
    }

    static interface InitJob {
        public void execute();
    }
}

