/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.alarm;

import com.tridium.alarm.AlarmClassRouteAlarmInvocation;
import com.tridium.alarm.BTextOp;
import com.tridium.alarm.fox.FoxAlarmCodec;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.alarm.AlarmWorker;
import com.tridium.nd.alarm.BNiagaraAlarmDeviceExt;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAlarmChannel
extends BFoxChannel {
    public static final Action alarmAck = BAlarmChannel.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action alarmUpdate = BAlarmChannel.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE;
    public static final Log logger;
    BUser lastUser;
    static /* synthetic */ Class class$com$tridium$nd$alarm$BAlarmChannel;
    static /* synthetic */ Class class$com$tridium$alarm$AlarmClassRouteAlarmInvocation;

    public void alarmAck(BAlarmRecord bAlarmRecord) {
        this.invoke(alarmAck, (BValue)bAlarmRecord, null);
    }

    public void alarmUpdate(BAlarmRecord bAlarmRecord) {
        this.invoke(alarmUpdate, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (logger.isTraceOn()) {
            logger.trace("AlarmChannel.command = " + string);
        }
        try {
            if (string == "new") {
                return this.newAlarms(foxRequest);
            }
            if (string == "ack") {
                return this.ackAlarms(foxRequest);
            }
            if (string == "update") {
                return this.updateAlarms(foxRequest);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        throw new InvalidCommandException(string);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == alarmAck) {
            Queue queue = (Queue)((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).fw(601);
            queue.enqueue((Object)new AlarmClassRouteAlarmInvocation((BComponent)this, action, (BAlarmRecord)bValue, context));
            return null;
        }
        return super.post(action, bValue, context);
    }

    private final FoxResponse newAlarms(FoxRequest foxRequest) throws Exception {
        Object object;
        Class clazz;
        if (logger.isTraceOn()) {
            logger.trace("recieved: new");
        }
        BUser bUser = this.getSessionContext().getUser();
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BNiagaraAlarmDeviceExt bNiagaraAlarmDeviceExt = this.getDeviceExt();
        bNiagaraAlarmDeviceExt.setLastReceivedTime(BAbsTime.make());
        if (logger.isTraceOn()) {
            logger.trace("checking required permissions");
        }
        try {
            bUser.check((BIProtected)bAlarmService, BPermissions.adminWrite);
            if (logger.isTraceOn()) {
                logger.trace("AlarmChannel: " + bUser + " has valid permissions");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        FoxTuple[] foxTupleArray = foxRequest.list("alarm");
        if (logger.isTraceOn()) {
            logger.trace("received " + foxTupleArray.length + " alarms");
        }
        if ((clazz = class$com$tridium$alarm$AlarmClassRouteAlarmInvocation) == null) {
            clazz = class$com$tridium$alarm$AlarmClassRouteAlarmInvocation = BAlarmChannel.class("[Lcom.tridium.alarm.AlarmClassRouteAlarmInvocation;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < foxTupleArray.length) {
            String string;
            BNiagaraStation bNiagaraStation;
            String string2;
            BString bString;
            BAlarmRecord bAlarmRecord = FoxAlarmCodec.decodeAlarm((FoxMessage)((FoxMessage)foxTupleArray[n]));
            String string3 = bNiagaraAlarmDeviceExt.getAlarmClass();
            if (string3 != null && !string3.equals("")) {
                bAlarmRecord.setAlarmClass(SlotPath.escape((String)TextUtil.replace((String)string3, (String)"%alarmClass%", (String)SlotPath.unescape((String)bAlarmRecord.getAlarmClass()))));
            }
            object = bAlarmRecord.getSource();
            BOrdList bOrdList = BOrdList.add((BOrdList)object, (BOrd)BOrd.make((OrdQuery)bNiagaraAlarmDeviceExt.getSlotPath()));
            bAlarmRecord.setSource(bOrdList);
            if (this.isTraceOn()) {
                this.trace("BAlarmChannel: new -> routeAlarm " + bAlarmRecord.getTimestamp() + ' ' + bAlarmRecord.getSource().encodeToString());
            }
            if ((bString = (BString)bAlarmRecord.getAlarmData().get("sourceName")) != null) {
                string2 = this.getDeviceExt().getSourceName().customize(bString.toString());
                bAlarmRecord.setAlarmData(BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)string2)));
            } else if (this.getDeviceExt().getSourceName().getOp() == BTextOp.replace) {
                string2 = this.getDeviceExt().getSourceName().customize("");
                bAlarmRecord.setAlarmData(BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)string2)));
            }
            string2 = bAlarmRecord.getAlarmData().get("hyperlinkOrd");
            if (string2 != null) {
                bNiagaraStation = (BNiagaraStation)this.getDeviceExt().getParent();
                string = AlarmWorker.makeStationSessionOrdSegment(bNiagaraStation);
                BString bString2 = (BString)string2;
                if (!string2.toString().startsWith(string)) {
                    bString2 = BString.make((String)(string + string2.toString()));
                }
                bAlarmRecord.setAlarmData(BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (String)"hyperlinkOrd", (BIDataValue)bString2));
            }
            bNiagaraStation = bAlarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
            string = (AlarmClassRouteAlarmInvocation)bNiagaraStation.post(BAlarmClass.routeAlarm, (BValue)bAlarmRecord, null);
            array.add((Object)string);
            ++n;
        }
        AlarmClassRouteAlarmInvocation[] alarmClassRouteAlarmInvocationArray = (AlarmClassRouteAlarmInvocation[])array.trim();
        boolean bl = false;
        while (!bl) {
            bl = true;
            int n2 = 0;
            while (n2 < alarmClassRouteAlarmInvocationArray.length) {
                if (!alarmClassRouteAlarmInvocationArray[n2].isFinished()) {
                    bl = false;
                }
                ++n2;
            }
            Thread.sleep(10L);
        }
        boolean bl2 = false;
        object = null;
        int n3 = 0;
        while (n3 < alarmClassRouteAlarmInvocationArray.length) {
            object = alarmClassRouteAlarmInvocationArray[n3].getException();
            if (object != null) {
                bl2 = true;
            }
            ++n3;
        }
        if (foxRequest.getBoolean("dbWriteSuccessEnabled", false)) {
            foxResponse.add("dbWriteSuccess", bl2 ^ true);
            if (bl2) {
                foxResponse.add("failureCause", ((Throwable)object).getMessage());
            }
        }
        return foxResponse;
    }

    public void newAlarms(BAlarmRecord[] bAlarmRecordArray) throws Exception {
        FoxRequest foxRequest = this.makeRequest("new");
        foxRequest.add("dbWriteSuccessEnabled", true);
        BAbsTime bAbsTime = BAbsTime.NULL;
        if (logger.isTraceOn()) {
            logger.trace("sending " + bAlarmRecordArray.length + " alarms");
        }
        int n = 0;
        while (n < bAlarmRecordArray.length) {
            foxRequest.add("alarm", FoxAlarmCodec.encodeAlarm((BAlarmRecord)bAlarmRecordArray[n]));
            if (bAlarmRecordArray[n].getLastUpdate().isAfter(bAbsTime)) {
                bAbsTime = bAlarmRecordArray[n].getLastUpdate();
            }
            ++n;
        }
        try {
            FoxResponse foxResponse = this.sendSync(foxRequest);
            if (!foxResponse.getBoolean("dbWriteSuccess", true)) {
                throw new Exception(foxResponse.getString("failureCause", "Remote Alarm Database Failure"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
            this.getDeviceExt().setLastSendFailureCause(exception.toString());
            throw exception;
        }
        this.getDeviceExt().setLastSendTime(bAbsTime);
    }

    public void ackAlarms(BAlarmRecord[] bAlarmRecordArray) throws Exception {
        FoxRequest foxRequest = this.makeRequest("ack");
        if (logger.isTraceOn()) {
            logger.trace("sending " + bAlarmRecordArray.length + " alarm acks");
        }
        BAbsTime bAbsTime = BAbsTime.NULL;
        int n = 0;
        while (n < bAlarmRecordArray.length) {
            foxRequest.add("alarm", FoxAlarmCodec.encodeAlarm((BAlarmRecord)bAlarmRecordArray[n]));
            if (bAlarmRecordArray[n].getLastUpdate().isAfter(bAbsTime)) {
                bAbsTime = bAlarmRecordArray[n].getLastUpdate();
            }
            ++n;
        }
        if (logger.isTraceOn()) {
            logger.trace("sending: ack");
        }
        try {
            this.sendAsync(foxRequest);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
            this.getDeviceExt().setLastSendFailureCause(exception.toString());
            throw exception;
        }
        this.getDeviceExt().setLastSendTime(bAbsTime);
    }

    private final FoxResponse ackAlarms(FoxRequest foxRequest) throws Exception {
        if (logger.isTraceOn()) {
            logger.trace("received: ack");
        }
        BUser bUser = this.getSessionContext().getUser();
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BNiagaraAlarmDeviceExt bNiagaraAlarmDeviceExt = this.getDeviceExt();
        bNiagaraAlarmDeviceExt.setLastReceivedTime(BAbsTime.make());
        if (logger.isTraceOn()) {
            logger.trace("checking required permissions");
        }
        try {
            bUser.check((BIProtected)bAlarmService, BPermissions.adminWrite);
            if (logger.isTraceOn()) {
                logger.trace("AlarmChannel: " + bUser + " has valid permissions");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        FoxTuple[] foxTupleArray = foxRequest.list("alarm");
        if (logger.isTraceOn()) {
            logger.trace("received " + foxTupleArray.length + " alarm acks");
        }
        int n = 0;
        while (n < foxTupleArray.length) {
            BAlarmRecord bAlarmRecord = FoxAlarmCodec.decodeAlarm((FoxMessage)((FoxMessage)foxTupleArray[n]));
            if (this.isTraceOn()) {
                this.trace("BAlarmChannel: ack -> routeAlarm: " + bAlarmRecord.getTimestamp() + ' ');
            }
            this.alarmAck(bAlarmRecord);
            ++n;
        }
        return foxResponse;
    }

    public void doAlarmAck(BAlarmRecord bAlarmRecord) throws Exception {
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmDatabase bAlarmDatabase = bAlarmService.getAlarmDb();
        BAlarmRecord bAlarmRecord2 = bAlarmDatabase.getRecord(bAlarmRecord.getUuid());
        if (bAlarmRecord2 == null) {
            if (logger.isTraceOn()) {
                logger.trace("add new alarm");
            }
            bAlarmRecord.setLastUpdate(BAbsTime.now());
            bAlarmDatabase.append(bAlarmRecord);
        } else if (bAlarmRecord2.getAckState() != BAckState.acked) {
            if (logger.isTraceOn()) {
                logger.trace("update alarm ackState = " + bAlarmRecord.getAckState());
            }
            bAlarmRecord.setLastUpdate(BAbsTime.now());
            BObject bObject = bAlarmRecord2.getAlarmData().get("sourceName");
            if (bObject != null) {
                bAlarmRecord.setAlarmData(BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (String)"sourceName", (BIDataValue)((BIDataValue)bObject)));
            }
            bAlarmDatabase.update(bAlarmRecord);
        } else {
            if (logger.isTraceOn()) {
                logger.trace("already have ack for " + bAlarmRecord.getUuid() + " notifying sender...");
            }
            this.getDeviceExt().doRouteAlarm(bAlarmRecord2);
            return;
        }
        if (bAlarmRecord2 != null) {
            bAlarmRecord.setAlarmClass(bAlarmRecord2.getAlarmClass());
        }
        bAlarmService.ackAlarm(bAlarmRecord);
    }

    public void updateAlarms(BAlarmRecord[] bAlarmRecordArray) throws Exception {
        FoxRequest foxRequest = this.makeRequest("update");
        if (logger.isTraceOn()) {
            logger.trace("sending " + bAlarmRecordArray.length + " alarm updates");
        }
        BAbsTime bAbsTime = BAbsTime.NULL;
        int n = 0;
        while (n < bAlarmRecordArray.length) {
            foxRequest.add("alarm", FoxAlarmCodec.encodeAlarm((BAlarmRecord)bAlarmRecordArray[n]));
            if (bAlarmRecordArray[n].getLastUpdate().isAfter(bAbsTime)) {
                bAbsTime = bAlarmRecordArray[n].getLastUpdate();
            }
            ++n;
        }
        if (logger.isTraceOn()) {
            logger.trace("sending: update");
        }
        try {
            this.sendAsync(foxRequest);
        }
        catch (InvalidCommandException invalidCommandException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
            this.getDeviceExt().setLastSendFailureCause(exception.toString());
            throw exception;
        }
        this.getDeviceExt().setLastSendTime(bAbsTime);
    }

    private final FoxResponse updateAlarms(FoxRequest foxRequest) throws Exception {
        if (logger.isTraceOn()) {
            logger.trace("received: update");
        }
        BUser bUser = this.getSessionContext().getUser();
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BNiagaraAlarmDeviceExt bNiagaraAlarmDeviceExt = this.getDeviceExt();
        bNiagaraAlarmDeviceExt.setLastReceivedTime(BAbsTime.make());
        if (logger.isTraceOn()) {
            logger.trace("checking required permissions");
        }
        try {
            bUser.check((BIProtected)bAlarmService, BPermissions.operatorWrite);
            if (logger.isTraceOn()) {
                logger.trace("AlarmChannel: " + bUser + " has valid permissions");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        FoxTuple[] foxTupleArray = foxRequest.list("alarm");
        if (logger.isTraceOn()) {
            logger.trace("received " + foxTupleArray.length + " alarm updates");
        }
        int n = 0;
        while (n < foxTupleArray.length) {
            BAlarmRecord bAlarmRecord = FoxAlarmCodec.decodeAlarm((FoxMessage)((FoxMessage)foxTupleArray[n]));
            if (this.isTraceOn()) {
                this.trace("BAlarmChannel: update -> routeToSource: " + bAlarmRecord.getTimestamp() + ' ');
            }
            this.alarmUpdate(bAlarmRecord);
            ++n;
        }
        return foxResponse;
    }

    public void doAlarmUpdate(BAlarmRecord bAlarmRecord) throws Exception {
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        boolean bl = true;
        BAlarmDatabase bAlarmDatabase = bAlarmService.getAlarmDb();
        BAlarmRecord bAlarmRecord2 = bAlarmDatabase.getRecord(bAlarmRecord.getUuid());
        if (bAlarmRecord2 == null) {
            if (logger.isTraceOn()) {
                logger.trace("add updated alarm");
            }
            bAlarmRecord.setLastUpdate(BAbsTime.now());
            bAlarmDatabase.append(bAlarmRecord);
            bAlarmRecord2 = bAlarmRecord;
        } else {
            if (logger.isTraceOn()) {
                logger.trace("update updated alarm");
            }
            if (bAlarmRecord.getAlarmData().get("notes") != null && !bAlarmRecord.getAlarmData().get("notes").equals((Object)bAlarmRecord2.getAlarmData().get("notes"))) {
                bAlarmRecord2.setAlarmData(BFacets.make((BFacets)bAlarmRecord2.getAlarmData(), (String)"notes", (BIDataValue)((BIDataValue)bAlarmRecord.getAlarmData().get("notes"))));
                bAlarmRecord2.setLastUpdate(BAbsTime.now());
                bAlarmDatabase.update(bAlarmRecord2);
            } else {
                bl = false;
            }
        }
        if (bl) {
            bAlarmService.doRouteToSource(bAlarmRecord2);
            bAlarmService.doRouteAlarm(bAlarmRecord2);
        }
    }

    public final BNiagaraAlarmDeviceExt getDeviceExt() {
        try {
            return ((BNiagaraStation)this.getConnection().getParent()).getAlarms();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAlarmChannel() {
        super("alarm");
    }

    static {
        Class clazz = class$com$tridium$nd$alarm$BAlarmChannel;
        if (clazz == null) {
            clazz = class$com$tridium$nd$alarm$BAlarmChannel = BAlarmChannel.class("[Lcom.tridium.nd.alarm.BAlarmChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        logger = Log.getLog((String)"niagara.alarms");
    }
}

