/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.NiagaraNetwork;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.nd.BCyclicThreadPoolWorker;
import com.tridium.nd.BNiagaraFoxService;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.BNiagaraStationFolder;
import com.tridium.nd.BStationDiscoveryJob;
import com.tridium.nd.alarm.BAlarmChannel;
import com.tridium.nd.history.BArchiveChannel;
import com.tridium.nd.point.BNiagaraTuningPolicyMap;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.schedule.BScheduleChannel;
import com.tridium.nd.spy.SpyIndex;
import com.tridium.nd.sysdef.BBogProvider;
import com.tridium.nd.sysdef.BLocalSysDefStation;
import com.tridium.nd.sysdef.BSysDefChannel;
import com.tridium.nd.sysdef.BSysDefProvider;
import com.tridium.nd.user.BUserSyncChannel;
import com.tridium.nd.virtual.BNiagaraVirtualChannel;
import com.tridium.nd.virtual.BNiagaraVirtualNetworkExt;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.history.BHistoryNetworkExt;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nd.BINiagaraNetwork;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nd.SysDefSession;
import javax.baja.spy.Spy;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BNiagaraNetwork
extends BDeviceNetwork
implements BIService,
NiagaraNetwork,
BINiagaraNetwork {
    public static final Property localStation = BNiagaraNetwork.newProperty((int)0, (BValue)new BLocalSysDefStation(), null);
    public static final Property sysDefProvider = BNiagaraNetwork.newProperty((int)0, (BValue)new BBogProvider(), null);
    public static final Property foxService = BNiagaraNetwork.newProperty((int)0, (BValue)new BNiagaraFoxService(), null);
    public static final Property tuningPolicies = BNiagaraNetwork.newProperty((int)0, (BValue)new BNiagaraTuningPolicyMap(), null);
    public static final Property historyPolicies = BNiagaraNetwork.newProperty((int)0, (BValue)new BHistoryNetworkExt(), null);
    public static final Property workers = BNiagaraNetwork.newProperty((int)0, (BValue)new BCyclicThreadPoolWorker("NiagaraNetwork:SharedWorkers", Integer.MAX_VALUE), null);
    public static final Property virtualPolicies = BNiagaraNetwork.newProperty((int)0, (BValue)new BNiagaraVirtualNetworkExt(), null);
    public static final Action resetAllConnections = BNiagaraNetwork.newAction((int)144, null);
    public static final Action submitStationDiscoveryJob = BNiagaraNetwork.newAction((int)0, null);
    public static final Action rebuildStationMap = BNiagaraNetwork.newAction((int)20, null);
    public static final Type TYPE;
    private static Type[] serviceTypes;
    public static final Log log;
    HashMap stations;
    static /* synthetic */ Class class$com$tridium$nd$BNiagaraNetwork;
    static /* synthetic */ Class class$com$tridium$fox$sys$BFoxServerConnection;

    public final BLocalSysDefStation getLocalStation() {
        return (BLocalSysDefStation)this.get(localStation);
    }

    public final void setLocalStation(BLocalSysDefStation bLocalSysDefStation) {
        this.set(localStation, (BValue)bLocalSysDefStation, null);
    }

    public final BSysDefProvider getSysDefProvider() {
        return (BSysDefProvider)this.get(sysDefProvider);
    }

    public final void setSysDefProvider(BSysDefProvider bSysDefProvider) {
        this.set(sysDefProvider, (BValue)bSysDefProvider, null);
    }

    public final BNiagaraFoxService getFoxService() {
        return (BNiagaraFoxService)this.get(foxService);
    }

    public final void setFoxService(BNiagaraFoxService bNiagaraFoxService) {
        this.set(foxService, (BValue)bNiagaraFoxService, null);
    }

    public final BNiagaraTuningPolicyMap getTuningPolicies() {
        return (BNiagaraTuningPolicyMap)this.get(tuningPolicies);
    }

    public final void setTuningPolicies(BNiagaraTuningPolicyMap bNiagaraTuningPolicyMap) {
        this.set(tuningPolicies, (BValue)bNiagaraTuningPolicyMap, null);
    }

    public final BHistoryNetworkExt getHistoryPolicies() {
        return (BHistoryNetworkExt)this.get(historyPolicies);
    }

    public final void setHistoryPolicies(BHistoryNetworkExt bHistoryNetworkExt) {
        this.set(historyPolicies, (BValue)bHistoryNetworkExt, null);
    }

    public final BCyclicThreadPoolWorker getWorkers() {
        return (BCyclicThreadPoolWorker)this.get(workers);
    }

    public final void setWorkers(BCyclicThreadPoolWorker bCyclicThreadPoolWorker) {
        this.set(workers, (BValue)bCyclicThreadPoolWorker, null);
    }

    public final BNiagaraVirtualNetworkExt getVirtualPolicies() {
        return (BNiagaraVirtualNetworkExt)this.get(virtualPolicies);
    }

    public final void setVirtualPolicies(BNiagaraVirtualNetworkExt bNiagaraVirtualNetworkExt) {
        this.set(virtualPolicies, (BValue)bNiagaraVirtualNetworkExt, null);
    }

    public final void resetAllConnections() {
        this.invoke(resetAllConnections, null, null);
    }

    public final BOrd submitStationDiscoveryJob() {
        return (BOrd)this.invoke(submitStationDiscoveryJob, null, null);
    }

    public final void rebuildStationMap() {
        this.invoke(rebuildStationMap, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Type getDeviceType() {
        return BNiagaraStation.TYPE;
    }

    public final Type getDeviceFolderType() {
        return BNiagaraStationFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "niagaraDriver");
    }

    public final NiagaraStation getStation(String string) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        if (this.stations == null) {
            this.rebuildStationMap();
        }
        return (NiagaraStation)this.stations.get(string);
    }

    public final BINiagaraStation getNiagaraStation(String string) {
        if (!this.isRunning() || this.stations == null) {
            throw new NotRunningException();
        }
        return (BINiagaraStation)this.stations.get(string);
    }

    public final SysDefSession createSysDefSession(Context context) {
        this.loadSlots();
        return this.getSysDefProvider().createSession(context);
    }

    public final void scheduleSync(BStationRole bStationRole) {
        BDevice[] bDeviceArray = this.getDevices();
        int n = 0;
        while (n < bDeviceArray.length) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)bDeviceArray[n];
            if (bNiagaraStation.getSysDef().getRole().equals((Object)bStationRole)) {
                bNiagaraStation.getSysDef().getSyncTask().schedule();
            }
            ++n;
        }
    }

    private final void syncNonPeers() {
        this.scheduleSync(BStationRole.subordinate);
        this.scheduleSync(BStationRole.supervisor);
    }

    public final Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final void serviceStarted() throws Exception {
        Spy.ROOT.add("niagaraNetwork", (Spy)new SpyIndex(this));
        this.updateLocalStation();
    }

    private final void updateLocalStation() {
        BLocalSysDefStation bLocalSysDefStation = this.getLocalStation();
        String string = Sys.getStation().getStationName();
        String string2 = Sys.getLocalHost().getHostAddress();
        boolean bl = false;
        if (!bLocalSysDefStation.getStationName().equals(string)) {
            bLocalSysDefStation.setStationName(string);
            bLocalSysDefStation.resetVersions();
            bl = true;
        }
        if (!bLocalSysDefStation.getAddress().equals(string2)) {
            bLocalSysDefStation.setAddress(string2);
            bl = true;
        }
        if (bl) {
            if (log.isTraceOn()) {
                log.trace("Niagara Network detected changes to the local station while it was offline.");
            }
            bLocalSysDefStation.updateStationVersion();
        }
    }

    public final void serviceStopped() throws Exception {
    }

    public final void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.rebuildStationMap();
        this.getWorkers().register(this, -1);
    }

    public final void stopped() throws Exception {
        super.stopped();
        this.getWorkers().unregister(this);
    }

    public final void doResetAllConnections() {
        BFoxServerConnection[] bFoxServerConnectionArray;
        Object object;
        Set set = this.stations.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                object = (String)iterator.next();
                bFoxServerConnectionArray = (BFoxServerConnection[])this.getNiagaraStation((String)object);
                bFoxServerConnectionArray.getClientConnection().manualDisconnect();
                bFoxServerConnectionArray.getServerConnection().forceDisconnect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = this.getFoxService().getServerConnections();
        Class clazz = class$com$tridium$fox$sys$BFoxServerConnection;
        if (clazz == null) {
            clazz = class$com$tridium$fox$sys$BFoxServerConnection = BNiagaraNetwork.class("[Lcom.tridium.fox.sys.BFoxServerConnection;", false);
        }
        bFoxServerConnectionArray = (BFoxServerConnection[])object.getChildren(clazz);
        int n = 0;
        while (n < bFoxServerConnectionArray.length) {
            try {
                bFoxServerConnectionArray[n].forceDisconnect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }

    public final BOrd doSubmitStationDiscoveryJob(Context context) {
        return new BStationDiscoveryJob(this).submit(context);
    }

    public final void doRebuildStationMap() {
        if (!this.isRunning()) {
            return;
        }
        String string = Sys.getStation().getStationName();
        HashMap<String, BNiagaraStation> hashMap = new HashMap<String, BNiagaraStation>();
        BDevice[] bDeviceArray = this.getDevices();
        int n = 0;
        while (n < bDeviceArray.length) {
            BNiagaraStation bNiagaraStation = (BNiagaraStation)bDeviceArray[n];
            String string2 = bNiagaraStation.getName();
            if (string2.equals(string)) {
                bNiagaraStation.configFail("Station name is same as this station");
            } else if (hashMap.get(string2) != null) {
                bNiagaraStation.configFail("Duplicate station name under NiagaraNework");
            } else {
                hashMap.put(string2, bNiagaraStation);
                bNiagaraStation.configOk();
            }
            ++n;
        }
        this.stations = hashMap;
        BStationRole[] bStationRoleArray = new BStationRole[]{BStationRole.subordinate, BStationRole.supervisor};
        boolean bl = false;
        int n2 = 0;
        while (n2 < bStationRoleArray.length) {
            String[] stringArray = this.getLocalStation().getStationRefs(bStationRoleArray[n2]);
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (this.getStation(stringArray[n3]) == null) {
                    if (log.isTraceOn()) {
                        log.trace("Removing deleted station: " + stringArray[n3] + " from " + (Object)((Object)bStationRoleArray[n2]));
                    }
                    this.getLocalStation().removeRef(stringArray[n3], bStationRoleArray[n2]);
                    bl = true;
                }
                ++n3;
            }
            ++n2;
        }
        if (bl) {
            this.getSysDefProvider().purge();
        }
    }

    public final IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)resetAllConnections)) {
            try {
                Invocation invocation = new Invocation((BComponent)this, action, null, context);
                try {
                    this.getWorkers().process(invocation);
                    return null;
                }
                catch (NotRunningException notRunningException) {
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return super.post(action, bValue, context);
    }

    public final void renamed(Property property, String string, Context context) {
        super.renamed(property, string, context);
        this.rebuildStationMap();
    }

    public final void childParented(Property property, BValue bValue, Context context) {
        super.childParented(property, bValue, context);
        if (bValue instanceof BNiagaraStation || bValue instanceof BNiagaraStationFolder) {
            this.rebuildStationMap();
        }
    }

    public final void childUnparented(Property property, BValue bValue, Context context) {
        super.childUnparented(property, bValue, context);
        if (bValue instanceof BNiagaraStation || bValue instanceof BNiagaraStationFolder) {
            this.rebuildStationMap();
        }
    }

    public final AgentList getAgents(Context context) {
        return BNiagaraNetwork.filterProvAgentList((BComponent)this, super.getAgents(context));
    }

    static final AgentList filterProvAgentList(BComponent bComponent, AgentList agentList) {
        int n = agentList.indexOf("provisioningNiagara:ProvisioningManager");
        if (n >= 0) {
            BNiagaraNetwork bNiagaraNetwork = null;
            if (bComponent instanceof BNiagaraNetwork) {
                bNiagaraNetwork = (BNiagaraNetwork)bComponent;
            } else {
                BComplex bComplex = bComponent.getParent();
                while (bComplex != null) {
                    if (bComplex instanceof BNiagaraNetwork) {
                        bNiagaraNetwork = (BNiagaraNetwork)bComplex;
                        break;
                    }
                    bComplex = bComplex.getParent();
                }
            }
            boolean bl = true;
            if (bNiagaraNetwork != null && bNiagaraNetwork.isMounted()) {
                try {
                    Type type = Sys.getType((String)"provisioningNiagara:ProvisioningNiagaraNetworkExt");
                    bNiagaraNetwork.lease();
                    SlotCursor slotCursor = bNiagaraNetwork.getProperties();
                    while (slotCursor.nextComponent()) {
                        if (!slotCursor.get().getType().is(type)) continue;
                        bl = false;
                        break;
                    }
                }
                catch (Throwable throwable) {}
            }
            if (bl) {
                agentList.remove(n);
            } else {
                int n2 = agentList.indexOf("niagaraDriver:StationManager");
                if (n < n2) {
                    agentList.swap(n, n2);
                }
            }
        }
        return agentList;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.stations = null;
    }

    public BNiagaraNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nd$BNiagaraNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$nd$BNiagaraNetwork = BNiagaraNetwork.class("[Lcom.tridium.nd.BNiagaraNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        serviceTypes = new Type[]{TYPE, BINiagaraNetwork.TYPE};
        BFoxChannelRegistry.getPrototype().add("point", (BValue)new BPointChannel());
        BFoxChannelRegistry.getPrototype().add("schedule", (BValue)new BScheduleChannel());
        BFoxChannelRegistry.getPrototype().add("alarm", (BValue)new BAlarmChannel());
        BFoxChannelRegistry.getPrototype().add("history", (BValue)new BHistoryChannel());
        BFoxChannelRegistry.getPrototype().add("archive", (BValue)new BArchiveChannel());
        BFoxChannelRegistry.getPrototype().add("usersync", (BValue)new BUserSyncChannel());
        BFoxChannelRegistry.getPrototype().add("niagaraVirtual", (BValue)new BNiagaraVirtualChannel());
        BFoxChannelRegistry.getPrototype().add("sysdef", (BValue)new BSysDefChannel());
        log = Log.getLog((String)"niagaraDriver");
    }
}

