/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dedicatedMicros.comm.req;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfPingRequest;
import com.tridium.ddf.comm.req.BIDdfCustomRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.rsp.BDdfResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddfHttp.comm.BDdfHttpReceiver;
import com.tridium.dedicatedMicros.comm.BDedicatedCommunicator;
import com.tridium.dedicatedMicros.comm.req.BDedicatedSyncTimeRequest;
import com.tridium.dedicatedMicros.comm.req.DedicatedHttpReq;
import com.tridium.dedicatedMicros.datatypes.BDedicatedTimeSyncParams;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDedicatedGetDvrTimeReq
extends BDdfPingRequest
implements DedicatedHttpReq,
BIDdfCustomRequest {
    public static final Type TYPE;
    public static final long NO_TIME_SYNC = -1L;
    protected BAbsTime timeTheResponseWasReceived;
    protected long dvrSecondsSinceMidnightJanFirst1970;
    protected final long deltaTolerance;
    protected String dvrIpAddress;
    BDedicatedCommunicator communicator;
    static /* synthetic */ Class class$com$tridium$dedicatedMicros$comm$req$BDedicatedGetDvrTimeReq;

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        Object object;
        this.timeTheResponseWasReceived = BAbsTime.now();
        if (iDdfDataFrame instanceof BDdfHttpReceiver.DdfHttpReceiveFrame) {
            object = (BDdfHttpReceiver.DdfHttpReceiveFrame)iDdfDataFrame;
            if (object.httpException != null) {
                if (this.deltaTolerance != (long)-1) {
                    this.getLog().error("Unable to read DVR time.", (Throwable)object.httpException);
                }
                throw new DdfResponseException((Throwable)object.httpException);
            }
        }
        object = new String(iDdfDataFrame.getFrameBytes(), 0, iDdfDataFrame.getFrameSize());
        this.dvrSecondsSinceMidnightJanFirst1970 = Long.parseLong((String)object);
        return new BDdfResponse();
    }

    public byte[] toByteArray() {
        if (this.deltaTolerance != (long)-1 && this.getLog().isTraceOn()) {
            this.getLog().trace("Reading DVR time");
        }
        String string = "http://" + this.dvrIpAddress + "/variable.cgi?variable=current_julian";
        return string.getBytes();
    }

    public void processErrorResponse(DdfResponseException ddfResponseException) {
    }

    public void processLateResponse(BIDdfResponse bIDdfResponse) {
    }

    public BAbsTime getDvrTime() {
        if (this.dvrSecondsSinceMidnightJanFirst1970 == (long)-1) {
            return null;
        }
        return BAbsTime.make((long)(this.dvrSecondsSinceMidnightJanFirst1970 * 1000L));
    }

    public void processResponse(BIDdfResponse bIDdfResponse) {
        BAbsTime bAbsTime = BAbsTime.make((long)(this.dvrSecondsSinceMidnightJanFirst1970 * 1000L));
        if (this.getLog().isTraceOn() && this.deltaTolerance != (long)-1) {
            this.getLog().trace("DVR time is " + bAbsTime);
        }
        if (this.deltaTolerance != (long)-1) {
            long l = Math.abs(bAbsTime.getMillis() - this.timeTheResponseWasReceived.getMillis());
            if (l > this.deltaTolerance) {
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace("DVR time differs by " + BRelTime.make((long)l));
                    this.getLog().trace("Synchronizing DVR time to " + this.timeTheResponseWasReceived);
                }
                BDedicatedSyncTimeRequest bDedicatedSyncTimeRequest = new BDedicatedSyncTimeRequest();
                this.communicator.communicate((BIDdfRequest)bDedicatedSyncTimeRequest);
            } else if (this.getLog().isTraceOn()) {
                this.getLog().trace("DVR time differs by " + BRelTime.make((long)l));
                this.getLog().trace("This is less than the tolerance of " + BRelTime.make((long)this.deltaTolerance));
                this.getLog().trace("There is no need to synchronize the DVR time at this moment.");
            }
        }
    }

    public void processTimeout() {
    }

    public void setCommunicator(BDedicatedCommunicator bDedicatedCommunicator) {
        this.communicator = bDedicatedCommunicator;
        this.dvrIpAddress = bDedicatedCommunicator.getDvrIpAddressText();
    }

    protected Log getLog() {
        return Log.getLog((String)("dm.timesync_" + this.dvrIpAddress));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.timeTheResponseWasReceived = null;
        this.dvrSecondsSinceMidnightJanFirst1970 = -1;
    }

    public BDedicatedGetDvrTimeReq() {
        this.this();
        this.deltaTolerance = -1;
    }

    public BDedicatedGetDvrTimeReq(BDedicatedTimeSyncParams bDedicatedTimeSyncParams) {
        this.this();
        this.deltaTolerance = bDedicatedTimeSyncParams.getTolerance().getMillis();
    }

    static {
        Class clazz = class$com$tridium$dedicatedMicros$comm$req$BDedicatedGetDvrTimeReq;
        if (clazz == null) {
            clazz = class$com$tridium$dedicatedMicros$comm$req$BDedicatedGetDvrTimeReq = BDedicatedGetDvrTimeReq.class("[Lcom.tridium.dedicatedMicros.comm.req.BDedicatedGetDvrTimeReq;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

