/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dedicatedMicros.comm;

import com.tridium.ddf.BDdfWorker;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddfIp.comm.BDdfIpAddressPort;
import com.tridium.ddfVideo.event.BDdfVideoEventStatus;
import com.tridium.dedicatedMicros.BDedicatedMicrosNetwork;
import com.tridium.dedicatedMicros.camera.BDedicatedCamera;
import com.tridium.dedicatedMicros.camera.BDedicatedCameraDeviceId;
import com.tridium.dedicatedMicros.comm.BDedicatedCommunicator;
import com.tridium.dedicatedMicros.comm.req.BDedicatedCameraPingRequest;
import com.tridium.dedicatedMicros.comm.req.BDedicatedGetDvrTimeReq;
import com.tridium.dedicatedMicros.dvr.BDedicatedDvr;
import com.tridium.dedicatedMicros.event.BDedicatedEventCameraExt;
import com.tridium.dedicatedMicros.event.BDedicatedEventProxyExt;
import com.tridium.dedicatedMicros.event.BDedicatedEventTypesEnum;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDedicatedEventsReceiver
extends BComponent {
    public static final Property enabled = BDedicatedEventsReceiver.newProperty((int)0, (boolean)true, null);
    public static final Property tcpIpPort = BDedicatedEventsReceiver.newProperty((int)0, (int)8787, null);
    public static final Property socketTimeout = BDedicatedEventsReceiver.newProperty((int)0, (int)60000, null);
    public static final Property connectionProcessor = BDedicatedEventsReceiver.newProperty((int)4, (BValue)new BDdfWorker(), null);
    public static final Type TYPE;
    protected ConnectionAcceptor rxEventsConnectionAcceptor;
    static /* synthetic */ Class class$com$tridium$dedicatedMicros$comm$BDedicatedEventsReceiver;
    static /* synthetic */ Class class$java$lang$String;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public int getTcpIpPort() {
        return this.getInt(tcpIpPort);
    }

    public void setTcpIpPort(int n) {
        this.setInt(tcpIpPort, n, null);
    }

    public int getSocketTimeout() {
        return this.getInt(socketTimeout);
    }

    public void setSocketTimeout(int n) {
        this.setInt(socketTimeout, n, null);
    }

    public BDdfWorker getConnectionProcessor() {
        return (BDdfWorker)this.get(connectionProcessor);
    }

    public void setConnectionProcessor(BDdfWorker bDdfWorker) {
        this.set(connectionProcessor, (BValue)bDdfWorker, null);
    }

    public Type getType() {
        return TYPE;
    }

    boolean isCommEnabled() {
        BDedicatedMicrosNetwork bDedicatedMicrosNetwork = (BDedicatedMicrosNetwork)this.getParent();
        boolean bl = false;
        if (!bDedicatedMicrosNetwork.isDisabled() && !bDedicatedMicrosNetwork.isFault() && this.getEnabled()) {
            bl = true;
        }
        return bl;
    }

    public void started() throws Exception {
        this.rxEventsConnectionAcceptor = new ConnectionAcceptor();
        this.rxEventsConnectionAcceptor.startAcceptor();
        super.started();
    }

    public void stopped() throws Exception {
        this.rxEventsConnectionAcceptor.stopAcceptor();
        super.stopped();
    }

    public Log getLog() {
        return Log.getLog((String)("dm.cameraEvents." + this.getTcpIpPort()));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$dedicatedMicros$comm$BDedicatedEventsReceiver;
        if (clazz == null) {
            clazz = class$com$tridium$dedicatedMicros$comm$BDedicatedEventsReceiver = BDedicatedEventsReceiver.class("[Lcom.tridium.dedicatedMicros.comm.BDedicatedEventsReceiver;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ConnectionAcceptor
    extends Thread {
        protected boolean started;
        protected ServerSocket tcpServer;

        public void startAcceptor() {
            this.started = true;
            this.start();
        }

        public void stopAcceptor() {
            block3: {
                this.started = false;
                this.interrupt();
                if (this.tcpServer != null) {
                    try {
                        this.tcpServer.close();
                    }
                    catch (IOException iOException) {
                        if (!BDedicatedEventsReceiver.this.getLog().isTraceOn()) break block3;
                        BDedicatedEventsReceiver.this.getLog().trace(iOException.toString(), (Throwable)iOException);
                    }
                }
            }
        }

        public void run() {
            while (this.started) {
                try {
                    if (BDedicatedEventsReceiver.this.isCommEnabled()) {
                        this.tryAcceptEvent();
                        continue;
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Exception exception) {
                    BDedicatedEventsReceiver.this.getLog().error(exception.toString(), (Throwable)exception);
                }
            }
        }

        protected void tryAcceptEvent() {
            try {
                this.acceptEvent();
            }
            catch (IOException iOException) {
                if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                    BDedicatedEventsReceiver.this.getLog().trace(iOException.toString(), (Throwable)iOException);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void acceptEvent() throws IOException {
            this.tcpServer = new ServerSocket(BDedicatedEventsReceiver.this.getTcpIpPort());
            try {
                this.tcpServer.setSoTimeout(BDedicatedEventsReceiver.this.getSocketTimeout());
                if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                    BDedicatedEventsReceiver.this.getLog().trace("Waiting for DVR to connect...");
                }
                Socket socket = this.tcpServer.accept();
                if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                    BDedicatedEventsReceiver.this.getLog().trace("DVR Connection Established...processing in background");
                }
                BDedicatedEventsReceiver.this.getConnectionProcessor().processInBackground((Runnable)new ConnectionProcessor(socket));
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.tcpServer.close();
                throw throwable;
            }
            {
                Object var2_4 = null;
            }
            this.tcpServer.close();
        }

        private final /* synthetic */ void this() {
            this.started = false;
        }

        public ConnectionAcceptor() {
            super("dm.AcceptEvents");
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ConnectionProcessor
    implements Runnable {
        protected Socket clientSocket;
        protected LineNumberReader lnr;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    this.readEvent();
                }
                catch (IOException iOException) {
                    if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                        BDedicatedEventsReceiver.this.getLog().trace(iOException.toString(), (Throwable)iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                try {
                    this.clientSocket.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    if (!BDedicatedEventsReceiver.this.getLog().isTraceOn()) throw throwable;
                    BDedicatedEventsReceiver.this.getLog().trace(iOException.toString(), (Throwable)iOException);
                }
                throw throwable;
            }
            {
                Object var2_4 = null;
            }
            try {}
            catch (IOException iOException) {
                if (!BDedicatedEventsReceiver.this.getLog().isTraceOn()) return;
                BDedicatedEventsReceiver.this.getLog().trace(iOException.toString(), (Throwable)iOException);
                return;
            }
            this.clientSocket.close();
        }

        public String[] readLinesOfTextForEvent() throws IOException {
            Class clazz;
            if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                BDedicatedEventsReceiver.this.getLog().trace("Reading...");
            }
            if ((clazz = class$java$lang$String) == null) {
                clazz = class$java$lang$String = BDedicatedEventsReceiver.class("[Ljava.lang.String;", false);
            }
            Array array = new Array(clazz);
            String string = this.lnr.readLine();
            while (string != null && string.length() > 0) {
                array.add((Object)string);
                string = this.lnr.readLine();
            }
            return (String[])array.trim();
        }

        public void readEvent() throws IOException {
            String[] stringArray = this.readLinesOfTextForEvent();
            if (stringArray.length > 0) {
                this.processLinesOfTextForEvent(stringArray);
            }
        }

        protected BAbsTime constructEventTime(String string) {
            int n = Integer.parseInt(string.substring(0, 2));
            int n2 = Integer.parseInt(string.substring(3, 5));
            int n3 = Integer.parseInt(string.substring(6, 8));
            int n4 = Integer.parseInt(string.substring(12, 14));
            int n5 = Integer.parseInt(string.substring(15, 17));
            int n6 = Integer.parseInt(string.substring(18, 22));
            return BAbsTime.make((int)n6, (BMonth)BMonth.make((int)(n5 - 1)), (int)n4, (int)n, (int)n2, (int)n3, (int)0, (BTimeZone)BTimeZone.GMT);
        }

        protected String getDvrIpAddressFromIpAddressBytes(BDdfIpAddressPort bDdfIpAddressPort) {
            try {
                byte[] byArray = bDdfIpAddressPort.getInetAddress().getAddress();
                String string = Integer.toString(byArray[0] & 0xFF) + '.' + Integer.toString(byArray[1] & 0xFF) + '.' + Integer.toString(byArray[2] & 0xFF) + '.' + Integer.toString(byArray[3] & 0xFF);
                return string;
            }
            catch (UnknownHostException unknownHostException) {
                return "UnknownHostException-&*^&^Y)&*(*(&*(&*^&TYJKHJKHJKHJKGHJTGdjkfhadjskf";
            }
        }

        protected boolean compareDvrIpAddress(BDedicatedDvr bDedicatedDvr, String string) {
            BDedicatedCommunicator bDedicatedCommunicator = (BDedicatedCommunicator)bDedicatedDvr.getCommunicator();
            BDdfIpAddressPort bDdfIpAddressPort = bDedicatedCommunicator.getUdpCommunicator().getUdpTransmitter().getSendToAddress();
            String string2 = bDdfIpAddressPort.getIpAddress();
            return string2.equals(string) || this.getDvrIpAddressFromIpAddressBytes(bDdfIpAddressPort).equals(string);
        }

        protected void updateEventPointsForCamera(BDedicatedCamera bDedicatedCamera, BVideoEvent bVideoEvent) {
            BDynamicEnum bDynamicEnum = (BDynamicEnum)bVideoEvent.getMetaData().get("dmEventType");
            BDedicatedEventTypesEnum bDedicatedEventTypesEnum = BDedicatedEventTypesEnum.make(bDynamicEnum.getOrdinal());
            if (bDedicatedEventTypesEnum == BDedicatedEventTypesEnum.cameraFail) {
                bDedicatedCamera.pingFail(BDedicatedCameraPingRequest.LEX.getText("CameraOffline"));
            } else if (bDedicatedEventTypesEnum == BDedicatedEventTypesEnum.cameraRestored) {
                bDedicatedCamera.pingOk();
            }
            BDedicatedEventCameraExt bDedicatedEventCameraExt = (BDedicatedEventCameraExt)bDedicatedCamera.getEvents();
            BControlPoint[] bControlPointArray = bDedicatedEventCameraExt.getPoints();
            int n = 0;
            while (n < bControlPointArray.length) {
                BDedicatedEventProxyExt bDedicatedEventProxyExt = (BDedicatedEventProxyExt)bControlPointArray[n].getProxyExt();
                if (bDedicatedEventProxyExt.getEventTypeEnum() == bVideoEvent.getEventType()) {
                    bDedicatedEventProxyExt.readOk((BStatusValue)new BDdfVideoEventStatus((BVideoEvent)bVideoEvent.newCopy()));
                }
                ++n;
            }
        }

        protected void updateEventPointsForCamerasUnderDvr(BDedicatedDvr bDedicatedDvr, int n, BVideoEvent bVideoEvent) {
            BIVideoCamera[] bIVideoCameraArray = bDedicatedDvr.getCameraExt().getAllCameras();
            int n2 = 0;
            while (n2 < bIVideoCameraArray.length) {
                BDedicatedCamera bDedicatedCamera;
                BDedicatedCameraDeviceId bDedicatedCameraDeviceId;
                if (bIVideoCameraArray[n2] instanceof BDedicatedCamera && (bDedicatedCameraDeviceId = (BDedicatedCameraDeviceId)(bDedicatedCamera = (BDedicatedCamera)bIVideoCameraArray[n2]).getVideoDeviceId()).getCameraId() == n) {
                    this.updateEventPointsForCamera(bDedicatedCamera, bVideoEvent);
                }
                ++n2;
            }
        }

        protected void updateEventPoint(String string, int n, BVideoEvent bVideoEvent) {
            BDedicatedMicrosNetwork bDedicatedMicrosNetwork = (BDedicatedMicrosNetwork)BDedicatedEventsReceiver.this.getParent();
            BDevice[] bDeviceArray = bDedicatedMicrosNetwork.getDevices();
            int n2 = 0;
            while (n2 < bDeviceArray.length) {
                if (bDeviceArray[n2] instanceof BDedicatedDvr && this.compareDvrIpAddress((BDedicatedDvr)bDeviceArray[n2], string)) {
                    this.verifyDmEventAccuracy(bVideoEvent, (BDedicatedDvr)bDeviceArray[n2]);
                    this.updateEventPointsForCamerasUnderDvr((BDedicatedDvr)bDeviceArray[n2], n, bVideoEvent);
                }
                ++n2;
            }
        }

        protected void verifyDmEventAccuracy(BVideoEvent bVideoEvent, BDedicatedDvr bDedicatedDvr) {
            BAbsTime bAbsTime = bVideoEvent.getTimestamp();
            if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                BDedicatedEventsReceiver.this.getLog().trace("Verifying accuracy of event time: " + bAbsTime);
            }
            BDedicatedGetDvrTimeReq bDedicatedGetDvrTimeReq = (BDedicatedGetDvrTimeReq)bDedicatedDvr.makePingRequest();
            if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                BDedicatedEventsReceiver.this.getLog().trace("Asking the DedicatedDvr for its present time.");
            }
            DdfRequestUtil.communicateSync((BIDdfCommunicator)bDedicatedDvr.getDdfCommunicator(), (BIDdfRequest)bDedicatedGetDvrTimeReq);
            BAbsTime bAbsTime2 = bDedicatedGetDvrTimeReq.getDvrTime();
            if (bAbsTime2 == null) {
                if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                    BDedicatedEventsReceiver.this.getLog().trace("Unable to read the Dedicated DVR's time. The timestamp in the event that was just received could be inaccurate.");
                }
            } else {
                if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                    BDedicatedEventsReceiver.this.getLog().trace("Current time in DVR is: " + bAbsTime2);
                }
                long l = Math.abs(bAbsTime.getMillis() - bAbsTime2.getMillis());
                if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                    BDedicatedEventsReceiver.this.getLog().trace("Event time differs from current Dedicated Dvr by " + l + " millis.");
                }
                if (l > 15000L) {
                    if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                        BDedicatedEventsReceiver.this.getLog().trace("Detected inaccurate event time. Correctiong from " + bAbsTime + " to " + bAbsTime2);
                    }
                    bVideoEvent.setTimestamp(bAbsTime2);
                } else if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                    BDedicatedEventsReceiver.this.getLog().trace("Difference is within tolerable range.");
                    BDedicatedEventsReceiver.this.getLog().trace("Verified accuracy of event time: " + bAbsTime);
                }
            }
        }

        protected void processCameraEvent(String string, int n, String string2, String string3) {
            BVideoEvent bVideoEvent = BVideoEvent.makeNormalEvent();
            boolean bl = false;
            if (string2 != null) {
                bVideoEvent.setDescription(string2);
                if (string2.startsWith("VMD")) {
                    bVideoEvent.setEventType(BVideoEventTypesEnum.motionStarted);
                    bVideoEvent.setMetaData(BFacets.make((String)"dmEventType", (BIDataValue)BDynamicEnum.make((BEnum)BDedicatedEventTypesEnum.motionDetected)));
                    bVideoEvent.setIsNormal(false);
                    bl = true;
                } else if (string2.startsWith("Camera-Fail")) {
                    bVideoEvent.setEventType(BVideoEventTypesEnum.fault);
                    bVideoEvent.setMetaData(BFacets.make((String)"dmEventType", (BIDataValue)BDynamicEnum.make((BEnum)BDedicatedEventTypesEnum.cameraFail)));
                    bVideoEvent.setIsNormal(false);
                    bl = true;
                } else if (string2.startsWith("Camera-Restored")) {
                    bVideoEvent.setEventType(BVideoEventTypesEnum.fault);
                    bVideoEvent.setMetaData(BFacets.make((String)"dmEventType", (BIDataValue)BDynamicEnum.make((BEnum)BDedicatedEventTypesEnum.cameraRestored)));
                    bVideoEvent.setIsNormal(true);
                    bl = true;
                }
                if (bl) {
                    if (string3 != null && string3.length() >= 22) {
                        BAbsTime bAbsTime = this.constructEventTime(string3);
                        bVideoEvent.setTimestamp(bAbsTime);
                    } else {
                        bVideoEvent.setTimestamp(BAbsTime.now());
                    }
                    this.updateEventPoint(string, n, bVideoEvent);
                }
            }
        }

        protected void processLinesOfTextForEvent(String[] stringArray) {
            String string = null;
            int n = -1;
            String string2 = null;
            String string3 = null;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].startsWith("Local-IP")) {
                    string = stringArray[n2].substring(stringArray[n2].indexOf(58) + 1).trim();
                    if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                        BDedicatedEventsReceiver.this.getLog().trace("Parsed out the Local-IP:" + string);
                    }
                } else if (stringArray[n2].startsWith("Activating-Channel")) {
                    n = Integer.parseInt(stringArray[n2].substring(stringArray[n2].indexOf(58) + 1).trim());
                    if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                        BDedicatedEventsReceiver.this.getLog().trace("Parsed out the camera number:" + n);
                    }
                } else if (stringArray[n2].startsWith("Response-Area")) {
                    string2 = stringArray[n2].substring(stringArray[n2].indexOf(58) + 1).trim();
                    if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                        BDedicatedEventsReceiver.this.getLog().trace("Parsed out the event description:" + string2);
                    }
                } else if (stringArray[n2].startsWith("Camera-Fail:")) {
                    int n3 = 19;
                    int n4 = stringArray[n2].lastIndexOf(32);
                    n = Integer.parseInt(stringArray[n2].substring(n3, n4).trim());
                    if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                        BDedicatedEventsReceiver.this.getLog().trace("Parsed out the camera number:" + n);
                    }
                    if (stringArray[n2].endsWith("restored")) {
                        string2 = "Camera-Restored";
                    } else if (stringArray[n2].endsWith("failed")) {
                        string2 = "Camera-Fail";
                    }
                    if (string2 != null && BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                        BDedicatedEventsReceiver.this.getLog().trace("Parsed out the event description:" + string2);
                    }
                } else if (stringArray[n2].startsWith("Rec-Index")) {
                    string3 = stringArray[n2].substring(stringArray[n2].indexOf(58) + 1).trim();
                    if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                        BDedicatedEventsReceiver.this.getLog().trace("Parsed out the event timestamp:" + string3);
                    }
                }
                if (BDedicatedEventsReceiver.this.getLog().isTraceOn()) {
                    BDedicatedEventsReceiver.this.getLog().trace("EVENT_LINE>> " + stringArray[n2]);
                }
                ++n2;
            }
            this.processCameraEvent(string, n, string2, string3);
        }

        public ConnectionProcessor(Socket socket) throws IOException {
            this.lnr = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
            this.clientSocket = socket;
        }
    }
}

