/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dedicatedMicros.camera;

import com.tridium.dedicatedMicros.camera.DedicatedMicrosFfmpegMpeg4Decoder;
import com.tridium.dedicatedMicros.camera.DedicatedMicrosMjpegDecoder;
import com.tridium.util.EscUtil;
import com.tridium.videoDriver.ui.BIVideoPlayer;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.decoder.IVideoMultistreamDecoder;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import com.tridium.videoDriver.videoStream.decoder.VideoDecoder;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DedicatedMicrosVideoDecoder
extends VideoDecoder {
    public static final String CONTENT_TYPE_KEY = EscUtil.slot.escape("content-type");
    protected BFacets httpRspHeader;
    protected IVideoDecoder theRealDecoder;
    protected Hashtable dmContentTypeFields;
    BIVideoSource videoSource;
    BIVideoPlayer videoPlayer;
    BRelTime stopDecodingTimeout;
    IVideoSession videoSession;
    protected boolean stopped;

    public int getCameraNbrForMostRecentFrame() {
        if (this.theRealDecoder instanceof DedicatedMicrosMjpegDecoder) {
            return ((DedicatedMicrosMjpegDecoder)this.theRealDecoder).getCameraNbrForMostRecentFrame();
        }
        if (this.theRealDecoder instanceof DedicatedMicrosFfmpegMpeg4Decoder) {
            return ((DedicatedMicrosFfmpegMpeg4Decoder)this.theRealDecoder).getCameraNbrForMostRecentFrame();
        }
        throw new IllegalStateException("Unsuported Dedicated Micros Decoder class: " + this.theRealDecoder.getClass().getName() + ". Please have my program fixed.");
    }

    protected void parseFieldsFromDmContentType() {
        this.dmContentTypeFields = new Hashtable();
        String string = EscUtil.slot.unescape(this.httpRspHeader.gets(CONTENT_TYPE_KEY, ""));
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n <= 0) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            this.dmContentTypeFields.put(string3, string4);
        }
    }

    public String getFieldFromDmContentType(String string) {
        if (this.dmContentTypeFields == null) {
            this.parseFieldsFromDmContentType();
        }
        return (String)this.dmContentTypeFields.get(string);
    }

    public synchronized void receiveVideoStream(IVideoStream iVideoStream) {
        if (this.stopped) {
            try {
                iVideoStream.closeVideoStream();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            this.httpRspHeader = iVideoStream.getPlaybackParams().getHttpRspHeader();
            String string = this.getFieldFromDmContentType("compression");
            if (string == null) {
                this.theRealDecoder = new DedicatedMicrosMjpegDecoder();
            } else if (string.equals("MPEG4")) {
                this.theRealDecoder = new DedicatedMicrosFfmpegMpeg4Decoder();
            } else if (string.equals("JPEG")) {
                this.theRealDecoder = new DedicatedMicrosMjpegDecoder();
            } else {
                throw new IllegalStateException("Unsupported Dedicated Micros compression: " + string);
            }
            this.theRealDecoder.init(this.videoSource, this.videoPlayer, this.stopDecodingTimeout, this.videoSession);
            this.theRealDecoder.receiveVideoStream(iVideoStream);
        }
    }

    public IVideoMultistreamDecoder getMultistreamDecoder() {
        return this.theRealDecoder.getMultistreamDecoder();
    }

    public BIVideoPlayer getVideoPlayer() {
        return this.videoPlayer;
    }

    public IVideoSession getVideoSession() {
        return this.videoSession;
    }

    public BIVideoSource getVideoSource() {
        return this.videoSource;
    }

    public boolean isFinished() {
        if (this.theRealDecoder == null) {
            return false;
        }
        return this.theRealDecoder.isFinished();
    }

    public void keepAlive() {
        if (this.theRealDecoder != null) {
            this.theRealDecoder.keepAlive();
        }
    }

    public void readFrameData(VidFrame vidFrame) throws Exception {
        this.theRealDecoder.readFrameData(vidFrame);
    }

    public void decodeFrame(VidFrame vidFrame) throws Exception {
        this.theRealDecoder.decodeFrame(vidFrame);
    }

    public void setMultistreamDecoder(IVideoMultistreamDecoder iVideoMultistreamDecoder) {
        this.theRealDecoder.setMultistreamDecoder(iVideoMultistreamDecoder);
    }

    public synchronized void stopDecoding(WaitForStopDecoding waitForStopDecoding) {
        this.stopped = true;
        if (this.theRealDecoder != null) {
            this.theRealDecoder.stopDecoding(waitForStopDecoding);
        }
    }

    public IVideoDecoder getVideoDecoder() {
        return this.theRealDecoder.getVideoDecoder();
    }

    public void videoStreamTimeout() {
        this.theRealDecoder.videoStreamTimeout();
    }

    public void init(BIVideoSource bIVideoSource, BIVideoPlayer bIVideoPlayer, BRelTime bRelTime, IVideoSession iVideoSession) {
        this.videoSource = bIVideoSource;
        this.videoPlayer = bIVideoPlayer;
        this.stopDecodingTimeout = bRelTime;
        this.videoSession = iVideoSession;
    }

    private final /* synthetic */ void this() {
        this.stopped = false;
    }

    public DedicatedMicrosVideoDecoder() {
        this.this();
    }
}

