/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.testng.Assert;

public class AssertXML
extends Assert {
    private static boolean ignoreComments = true;
    private static boolean ignoreAttributeOrder = true;
    private static boolean ignoreWhitespace = true;

    private static void setXMLUnitAttributes() {
        XMLUnit.setIgnoreComments(ignoreComments);
        XMLUnit.setIgnoreAttributeOrder(ignoreAttributeOrder);
        XMLUnit.setIgnoreWhitespace(ignoreWhitespace);
    }

    public static synchronized void assertXMLEquivalent(String string, String string2) {
        if (string2 == null && string == null) {
            return;
        }
        try {
            AssertXML.setXMLUnitAttributes();
            Diff diff = XMLUnit.compareXML(string, string2);
            if (diff.similar()) {
                return;
            }
            DetailedDiff detailedDiff = new DetailedDiff(diff);
            List list = detailedDiff.getAllDifferences();
            Iterator iterator = list.iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                stringBuffer.append(e.toString()).append("\r\n");
            }
            AssertXML.fail(stringBuffer.toString());
        }
        catch (Exception exception) {
            AssertXML.fail("Error comparing xml docs", exception);
        }
    }

    public static void assertXMLEquivalent(File file, String string) {
        if (string == null && file == null) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n = fileInputStream.read(byArray);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = fileInputStream.read(byArray);
            }
            byteArrayOutputStream.close();
            fileInputStream.close();
            AssertXML.assertXMLEquivalent(byteArrayOutputStream.toString("UTF-8"), string);
        }
        catch (Exception exception) {
            AssertXML.fail("Error comparing xml docs", exception);
        }
    }

    public static void assertXMLEquivalent(File file, File file2) {
        if (file2 == null && file == null) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n = fileInputStream.read(byArray);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = fileInputStream.read(byArray);
            }
            byteArrayOutputStream.close();
            fileInputStream.close();
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            n = fileInputStream2.read(byArray);
            while (n != -1) {
                byteArrayOutputStream2.write(byArray, 0, n);
                n = fileInputStream2.read(byArray);
            }
            byteArrayOutputStream2.close();
            fileInputStream2.close();
            AssertXML.assertXMLEquivalent(byteArrayOutputStream.toString("UTF-8"), byteArrayOutputStream2.toString("UTF-8"));
        }
        catch (Exception exception) {
            AssertXML.fail("Error comparing xml docs", exception);
        }
    }

    public static void assertXMLEquivalent(InputStream inputStream, String string) {
        if (string == null && inputStream == null) {
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n = inputStream.read(byArray);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            byteArrayOutputStream.close();
            inputStream.close();
            AssertXML.assertXMLEquivalent(byteArrayOutputStream.toString("UTF-8"), string);
        }
        catch (Exception exception) {
            AssertXML.fail("Error comparing xml docs", exception);
        }
    }
}

