/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oncall;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.BStationRecipient;
import com.tridium.history.audit.BAuditHistoryService;
import com.tridium.oncall.BOnCallContact;
import com.tridium.oncall.BOnCallRecipient;
import com.tridium.oncall.BOnCallService;
import com.tridium.oncall.util.OnCallToolkit;
import java.util.HashSet;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BICollection;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.security.AuditEvent;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.IFilter;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.SortUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BOnCallList
extends BComponent
implements BIStatus {
    public static final Property status = BOnCallList.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property active = BOnCallList.newProperty((int)67, (boolean)false, (BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"%lexicon(onCall:active)%"), (String)"falseText", (BIDataValue)BString.make((String)"%lexicon(onCall:inactive)%")));
    public static final Property lastFaultCause = BOnCallList.newProperty((int)67, (String)"", null);
    public static final Property ordinal = BOnCallList.newProperty((int)65, (int)-1, null);
    public static final Action reorderContacts = BOnCallList.newAction((int)20, null);
    public static final Action rotate = BOnCallList.newAction((int)24, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static final String ON_CALL_RECIPIENT = "OnCallRecipient";
    static final String ON_CALL_CONTACT = "OnCallContact";
    static final String ON_CALL_USER = "OnCallUser";
    static final String ON_CALL_START_TIME = "OnCallStartTime";
    static final String ON_CALL_LIST = "OnCallList";
    static final String ON_CALL_PRIORITY = "OnCallListPriority";
    private static final Context reorderContext;
    private Object reorderMon;
    private Clock.Ticket reorderTicket;
    static /* synthetic */ Class class$com$tridium$oncall$BOnCallList;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;
    static /* synthetic */ Class class$com$tridium$oncall$BOnCallContact;
    static /* synthetic */ Class class$java$lang$Integer;

    public final BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public final void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public final boolean getActive() {
        return this.getBoolean(active);
    }

    public final void setActive(boolean bl) {
        this.setBoolean(active, bl, null);
    }

    public final String getLastFaultCause() {
        return this.getString(lastFaultCause);
    }

    public final void setLastFaultCause(String string) {
        this.setString(lastFaultCause, string, null);
    }

    public final int getOrdinal() {
        return this.getInt(ordinal);
    }

    public final void setOrdinal(int n) {
        this.setInt(ordinal, n, null);
    }

    public final void reorderContacts() {
        this.invoke(reorderContacts, null, null);
    }

    public final void rotate() {
        this.invoke(rotate, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        BOnCallService bOnCallService = BOnCallService.getInstance();
        if (bOnCallService == null) {
            throw new Exception("Could not find OnCallService");
        }
        if (this.getOrdinal() == -1) {
            this.setOrdinal(BOnCallService.getInstance().getNewOrdinalNumber());
        }
        this.updateStatus();
        BOnCallService.getInstance().callListUpdateFacetsOnAllSchedules(bOnCallService.getCallListEnumRangeFacets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void stopped() throws Exception {
        Object object = this.reorderMon;
        synchronized (object) {
            if (this.reorderTicket != null) {
                this.reorderTicket.cancel();
                this.reorderTicket = null;
            }
            return;
        }
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BOnCallService;
    }

    public final BIcon getIcon() {
        return icon;
    }

    public final void added(Property property, Context context) {
        if (this.isRunning() && property.getType().is(BOnCallContact.TYPE)) {
            this.updateStatus();
            ((BOnCallContact)this.get(property)).updateRotationMarker(false);
            this.startReorderTimer();
        }
    }

    public final void removed(Property property, BValue bValue, Context context) {
        if (this.isRunning() && property.getType().is(BOnCallContact.TYPE)) {
            this.updateStatus();
            this.startReorderTimer();
        }
    }

    public final void renamed(Property property, String string, Context context) {
        if (this.isRunning() && property.getType().is(BOnCallContact.TYPE)) {
            this.startReorderTimer();
        }
    }

    public final void reordered(Context context) {
        if (this.isRunning() && context != reorderContext) {
            this.reorderContacts();
        }
    }

    public final IFuture post(Action action, BValue bValue, Context context) {
        if (action == reorderContacts || action == rotate) {
            return BOnCallService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public final BStatusEnum getOrdinalStatusEnum() {
        return new BStatusEnum((BEnum)BDynamicEnum.make((int)this.getOrdinal()));
    }

    final void routeAlarm(BAlarmRecord bAlarmRecord, BOnCallRecipient bOnCallRecipient) {
        this.doRouteAlarm(bAlarmRecord, this.findNextContacts(-1), bOnCallRecipient);
    }

    private final void doRouteAlarm(BAlarmRecord bAlarmRecord, BOnCallContact[] bOnCallContactArray, BOnCallRecipient bOnCallRecipient) {
        StringBuffer stringBuffer;
        BConsoleRecipient[] bConsoleRecipientArray;
        if (BOnCallService.getInstance().isFatalFault()) {
            return;
        }
        if (!this.getActive()) {
            return;
        }
        if (bOnCallContactArray.length <= 0) {
            return;
        }
        try {
            StringBuffer stringBuffer2;
            bConsoleRecipientArray = (BConsoleRecipient[])Sys.getService((Type)BAlarmService.TYPE);
            BAlarmDatabase bAlarmDatabase = bConsoleRecipientArray.getAlarmDb();
            bAlarmRecord = bAlarmDatabase.getRecord(bAlarmRecord.getUuid());
            if (bAlarmRecord == null) {
                return;
            }
            if (bAlarmRecord.isAcknowledged()) {
                return;
            }
            StringBuffer stringBuffer3 = new StringBuffer();
            int n = 0;
            while (n < bOnCallContactArray.length) {
                if (n > 0) {
                    stringBuffer3.append(", ");
                }
                stringBuffer3.append(bOnCallContactArray[n].getCurrentUserName());
                ++n;
            }
            stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < bOnCallContactArray.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(bOnCallContactArray[n2].getName());
                ++n2;
            }
            String[] stringArray = new String[]{ON_CALL_RECIPIENT, ON_CALL_LIST, ON_CALL_START_TIME, ON_CALL_USER, ON_CALL_CONTACT, ON_CALL_PRIORITY};
            BIDataValue[] bIDataValueArray = new BIDataValue[]{BString.make((String)bOnCallRecipient.getName()), BString.make((String)this.getName()), BAbsTime.now(), BString.make((String)stringBuffer3.toString()), BString.make((String)stringBuffer.toString()), BInteger.make((int)bOnCallContactArray[0].getPriority())};
            BFacets bFacets = BFacets.make((String[])stringArray, (BIDataValue[])bIDataValueArray);
            bAlarmRecord.setAlarmData(BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (BFacets)bFacets));
            bAlarmRecord.setLastUpdate(BAbsTime.now());
            bAlarmDatabase.update(bAlarmRecord);
            if (OnCallToolkit.log.isTraceOn()) {
                stringBuffer2 = new StringBuffer();
                stringBuffer2.append("Route alarm: ");
                stringBuffer2.append(bAlarmRecord.getUuid().encodeToString());
                stringBuffer2.append(" ");
                stringBuffer2.append(bFacets.toDebugString());
                OnCallToolkit.log.trace(stringBuffer2.toString());
            }
            if (BOnCallService.getInstance().getAuditAlarmEscalation()) {
                stringBuffer2 = (BAuditHistoryService)Sys.getService((Type)BAuditHistoryService.TYPE);
                stringBuffer2.audit(new AuditEvent("Escalated", bAlarmRecord.getUuid().encodeToString(), bAlarmRecord.getSource().toString(), "", String.valueOf(bOnCallContactArray[0].getPriority()), stringBuffer.toString()));
            }
        }
        catch (Exception exception) {
            OnCallToolkit.log.error("Routing new alarm", (Throwable)exception);
            return;
        }
        bConsoleRecipientArray = bOnCallRecipient.getLinkedConsoleRecipients();
        int n = 0;
        while (n < bConsoleRecipientArray.length) {
            bConsoleRecipientArray[n].routeAlarm(bAlarmRecord);
            ++n;
        }
        BStationRecipient[] bStationRecipientArray = bOnCallRecipient.getLinkedStationRecipients();
        int n3 = 0;
        while (n3 < bStationRecipientArray.length) {
            bStationRecipientArray[n3].routeAlarm(bAlarmRecord);
            ++n3;
        }
        n3 = 0;
        while (n3 < bOnCallContactArray.length) {
            stringBuffer = bOnCallContactArray[n3].getCurrentUserAlarmRecipient();
            if (stringBuffer != null && bOnCallContactArray[n3].getCurrentUser() != null && bOnCallContactArray[n3].getCurrentUser().isMounted()) {
                stringBuffer.handleAlarmForUser(bOnCallContactArray[n3].getCurrentUser(), bAlarmRecord);
            } else {
                OnCallToolkit.log.error("Routing alarm to On Call Contact with no valid Alarm Recipient: " + bOnCallContactArray[n3].getName());
            }
            ++n3;
        }
    }

    final void checkEscalation(BOnCallRecipient bOnCallRecipient) {
        String string;
        if (BOnCallService.getInstance().isFatalFault()) {
            return;
        }
        if (OnCallToolkit.log.isTraceOn()) {
            OnCallToolkit.log.trace("Checking escalation");
        }
        if ((string = bOnCallRecipient.buildAlarmClassPredicate()).length() <= 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("alarm:|bql:select from openAlarms where not isAcknowledged");
        stringBuffer.append(string);
        BICollection bICollection = (BICollection)BOrd.make((String)stringBuffer.toString()).get((BObject)this);
        Cursor cursor = bICollection.cursor();
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BOnCallList.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        Array array = new Array(clazz);
        while (cursor.next()) {
            array.add((Object)cursor.get().asValue().newCopy());
        }
        BAlarmRecord[] bAlarmRecordArray = (BAlarmRecord[])array.trim();
        int n = 0;
        while (n < bAlarmRecordArray.length) {
            if (!bAlarmRecordArray[n].getAlarmData().gets(ON_CALL_LIST, "").equals(this.getName())) {
                if (OnCallToolkit.log.isTraceOn()) {
                    try {
                        OnCallToolkit.log.trace("Rerouting alarm: " + bAlarmRecordArray[n].getUuid().encodeToString());
                    }
                    catch (Exception exception) {}
                }
                this.routeAlarm(bAlarmRecordArray[n], bOnCallRecipient);
            } else {
                BAbsTime bAbsTime;
                BAbsTime bAbsTime2 = (BAbsTime)bAlarmRecordArray[n].getAlarmData().get(ON_CALL_START_TIME);
                if (bAbsTime2 == null || !(bAbsTime = bAbsTime2.add(bOnCallRecipient.getEscalationDelay())).equals((Object)BAbsTime.now()) && !bAbsTime.isAfter(BAbsTime.now())) {
                    int n2 = bAlarmRecordArray[n].getAlarmData().geti(ON_CALL_PRIORITY, -1);
                    BOnCallContact[] bOnCallContactArray = this.findNextContacts(n2);
                    if (OnCallToolkit.log.isTraceOn()) {
                        try {
                            OnCallToolkit.log.trace("Escalating alarm : " + bAlarmRecordArray[n].getUuid().encodeToString());
                        }
                        catch (Exception exception) {}
                    }
                    this.doRouteAlarm(bAlarmRecordArray[n], bOnCallContactArray, bOnCallRecipient);
                }
            }
            ++n;
        }
    }

    private final BOnCallContact[] findNextContacts(int n) {
        Class clazz = class$com$tridium$oncall$BOnCallContact;
        if (clazz == null) {
            clazz = class$com$tridium$oncall$BOnCallContact = BOnCallList.class("[Lcom.tridium.oncall.BOnCallContact;", false);
        }
        BOnCallContact[] bOnCallContactArray = (BOnCallContact[])this.getChildren(clazz);
        Class clazz2 = class$com$tridium$oncall$BOnCallContact;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$oncall$BOnCallContact = BOnCallList.class("[Lcom.tridium.oncall.BOnCallContact;", false);
        }
        Array array = new Array(clazz2);
        int n2 = -1;
        int n3 = 0;
        while (n3 < bOnCallContactArray.length) {
            if (bOnCallContactArray[n3].getStatus().isOk()) {
                if (n2 > -1) {
                    if (bOnCallContactArray[n3].getPriority() == n2) {
                        array.add((Object)bOnCallContactArray[n3]);
                    } else if (bOnCallContactArray[n3].getPriority() > n2) {
                        break;
                    }
                } else if (bOnCallContactArray[n3].getPriority() > n) {
                    n2 = bOnCallContactArray[n3].getPriority();
                    array.add((Object)bOnCallContactArray[n3]);
                }
            }
            ++n3;
        }
        return (BOnCallContact[])array.trim();
    }

    public final void doReorderContacts() {
        Class clazz;
        if (OnCallToolkit.log.isTraceOn()) {
            OnCallToolkit.log.trace("Reordering Contacts");
        }
        if ((clazz = class$com$tridium$oncall$BOnCallContact) == null) {
            clazz = class$com$tridium$oncall$BOnCallContact = BOnCallList.class("[Lcom.tridium.oncall.BOnCallContact;", false);
        }
        BOnCallContact[] bOnCallContactArray = this.sort((BOnCallContact[])this.getChildren(clazz));
        Property[] propertyArray = new Property[bOnCallContactArray.length];
        int n = 0;
        while (n < bOnCallContactArray.length) {
            propertyArray[n] = bOnCallContactArray[n].getPropertyInParent();
            ++n;
        }
        this.reorder(propertyArray, reorderContext);
        BOnCallService.getInstance().callListMatchClearAndEscalate(BString.make((String)this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void startReorderTimer() {
        Object object = this.reorderMon;
        synchronized (object) {
            if (this.reorderTicket != null) {
                this.reorderTicket.cancel();
            }
            this.reorderTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)1000L), (Action)reorderContacts, null);
            return;
        }
    }

    private final BOnCallContact[] sort(BOnCallContact[] bOnCallContactArray) {
        if (bOnCallContactArray.length == 0) {
            return bOnCallContactArray;
        }
        Object[] objectArray = PriorityComparable.makeArray(bOnCallContactArray);
        SortUtil.sort((Object[])objectArray);
        Class clazz = class$java$lang$Integer;
        if (clazz == null) {
            clazz = class$java$lang$Integer = BOnCallList.class("[Ljava.lang.Integer;", false);
        }
        Array array = new Array(clazz);
        int n = -1;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (n != -1) {
                if (((PriorityComparable)objectArray[n2]).c.getPriority() != n) {
                    array.add((Object)new Integer(((PriorityComparable)objectArray[n2]).c.getPriority()));
                }
            } else {
                array.add((Object)new Integer(((PriorityComparable)objectArray[n2]).c.getPriority()));
            }
            n = ((PriorityComparable)objectArray[n2]).c.getPriority();
            ++n2;
        }
        Integer[] integerArray = (Integer[])array.trim();
        Class clazz2 = class$com$tridium$oncall$BOnCallContact;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$oncall$BOnCallContact = BOnCallList.class("[Lcom.tridium.oncall.BOnCallContact;", false);
        }
        Array array2 = new Array(clazz2);
        int n3 = 0;
        while (n3 < objectArray.length) {
            array2.add((Object)((PriorityComparable)objectArray[n3]).c);
            ++n3;
        }
        Class clazz3 = class$com$tridium$oncall$BOnCallContact;
        if (clazz3 == null) {
            clazz3 = class$com$tridium$oncall$BOnCallContact = BOnCallList.class("[Lcom.tridium.oncall.BOnCallContact;", false);
        }
        Array array3 = new Array(clazz3);
        int n4 = 0;
        while (n4 < integerArray.length) {
            final int n5 = integerArray[n4];
            Array array4 = array2.filter(new IFilter(){

                public final boolean accept(Object object) {
                    BOnCallContact bOnCallContact = (BOnCallContact)object;
                    boolean bl = false;
                    if (bOnCallContact.getPriority() == n5) {
                        bl = true;
                    }
                    return bl;
                }
            });
            Object[] objectArray2 = RotationMarkerComparable.makeArray((BOnCallContact[])array4.trim());
            SortUtil.sort((Object[])objectArray2);
            int n6 = 0;
            while (n6 < objectArray2.length) {
                array3.add((Object)((RotationMarkerComparable)objectArray2[n6]).c);
                ++n6;
            }
            ++n4;
        }
        return (BOnCallContact[])array3.trim();
    }

    final void updateStatus() {
        Class clazz = class$com$tridium$oncall$BOnCallContact;
        if (clazz == null) {
            clazz = class$com$tridium$oncall$BOnCallContact = BOnCallList.class("[Lcom.tridium.oncall.BOnCallContact;", false);
        }
        BOnCallContact[] bOnCallContactArray = (BOnCallContact[])this.getChildren(clazz);
        boolean bl = false;
        int n = 0;
        while (n < bOnCallContactArray.length) {
            if (!bl && bOnCallContactArray[n].getStatus().isFault()) {
                bl = true;
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setLastFaultCause(bOnCallContactArray[n].getName() + ": " + bOnCallContactArray[n].getLastFaultCause());
            }
            bOnCallContactArray[n].updateDisabledStatus();
            ++n;
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)bl));
    }

    public final void doRotate() throws Exception {
        BOnCallContact[] bOnCallContactArray;
        Class clazz;
        if (this.isRunning()) {
            this.doReorderContacts();
        }
        if ((clazz = class$com$tridium$oncall$BOnCallContact) == null) {
            clazz = class$com$tridium$oncall$BOnCallContact = BOnCallList.class("[Lcom.tridium.oncall.BOnCallContact;", false);
        }
        if ((bOnCallContactArray = (BOnCallContact[])this.getChildren(clazz)).length == 0) {
            return;
        }
        int n = bOnCallContactArray[0].getPriority();
        int n2 = bOnCallContactArray[0].getRotationMarker();
        int n3 = bOnCallContactArray.length - 1;
        while (n3 >= 0) {
            int n4 = n;
            int n5 = n2;
            n = bOnCallContactArray[n3].getPriority();
            n2 = bOnCallContactArray[n3].getRotationMarker();
            bOnCallContactArray[n3].setRotationMarker(n5);
            bOnCallContactArray[n3].setInt(BOnCallContact.priority, n4, BOnCallContact.ROTATE_CONTEXT);
            --n3;
        }
        this.reorderContacts();
    }

    public final String getPriorityList(BOrd bOrd) {
        Class clazz = class$com$tridium$oncall$BOnCallContact;
        if (clazz == null) {
            clazz = class$com$tridium$oncall$BOnCallContact = BOnCallList.class("[Lcom.tridium.oncall.BOnCallContact;", false);
        }
        BOnCallContact[] bOnCallContactArray = (BOnCallContact[])this.getChildren(clazz);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = 0;
        while (n < bOnCallContactArray.length) {
            if (bOnCallContactArray[n].getUser().equals((Object)bOrd) && !bOnCallContactArray[n].getStatus().isDisabled()) {
                hashSet.add(new Integer(bOnCallContactArray[n].getPriority()));
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = hashSet.toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[n2].toString());
            ++n2;
        }
        return stringBuffer.toString();
    }

    public final void spy(SpyWriter spyWriter) throws Exception {
        if (this.isRunning()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("alarm:|bql:select from openAlarms where not isAcknowledged and alarmData.");
            stringBuffer.append(ON_CALL_LIST);
            stringBuffer.append(" = '");
            stringBuffer.append(this.getName());
            stringBuffer.append("'");
            BICollection bICollection = (BICollection)BOrd.make((String)stringBuffer.toString()).get((BObject)this);
            Cursor cursor = bICollection.cursor();
            spyWriter.startTable(true);
            spyWriter.w((Object)"<tr>").th((Object)"On Call Recipient").th((Object)"On Call Contact").th((Object)"On Call Priority").th((Object)"Start Time").th((Object)"End Time").th((Object)"Remaining").th((Object)"Source").th((Object)"State").th((Object)"Uuid").w((Object)"</tr>\n");
            while (cursor.next()) {
                BICollection bICollection2;
                BObject[] bObjectArray;
                BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
                String string = bAlarmRecord.getAlarmData().gets(ON_CALL_RECIPIENT, "");
                if (string.length() <= 0 || (bObjectArray = (bICollection2 = (BICollection)BOrd.make((String)("service:alarm:AlarmService|bql:select from onCall:OnCallRecipient where name = '" + string + '\'')).get((BObject)this)).toList().list()).length <= 0) continue;
                BOnCallRecipient bOnCallRecipient = (BOnCallRecipient)bObjectArray[0];
                BAbsTime bAbsTime = (BAbsTime)bAlarmRecord.getAlarmData().get(ON_CALL_START_TIME);
                BAbsTime bAbsTime2 = null;
                if (bAbsTime != null) {
                    bAbsTime2 = bAbsTime.add(bOnCallRecipient.getEscalationDelay());
                }
                if (bAbsTime2 != null && (bAbsTime2.equals((Object)BAbsTime.now()) || bAbsTime2.isAfter(BAbsTime.now()))) {
                    BRelTime bRelTime = BAbsTime.now().delta(bAbsTime2);
                    spyWriter.w((Object)"<tr>");
                    spyWriter.td((Object)bAlarmRecord.getAlarmData().gets(ON_CALL_RECIPIENT, ""));
                    spyWriter.td((Object)bAlarmRecord.getAlarmData().gets(ON_CALL_CONTACT, ""));
                    spyWriter.td((Object)String.valueOf(bAlarmRecord.getAlarmData().geti(ON_CALL_PRIORITY, -1)));
                    spyWriter.td((Object)bAbsTime.toTimeString(null));
                    spyWriter.td((Object)bAbsTime2.toTimeString(null));
                    spyWriter.td((Object)bRelTime);
                    spyWriter.td((Object)bAlarmRecord.getSource());
                    spyWriter.td((Object)bAlarmRecord.getSourceState());
                    spyWriter.td((Object)bAlarmRecord.getUuid());
                    spyWriter.w((Object)"</tr>\n");
                    continue;
                }
                spyWriter.w((Object)"<tr>");
                spyWriter.td((Object)bAlarmRecord.getAlarmData().gets(ON_CALL_RECIPIENT, ""));
                spyWriter.td((Object)bAlarmRecord.getAlarmData().gets(ON_CALL_CONTACT, ""));
                spyWriter.td((Object)String.valueOf(bAlarmRecord.getAlarmData().geti(ON_CALL_PRIORITY, -1)));
                spyWriter.td((Object)"Expired");
                spyWriter.td((Object)"Expired");
                spyWriter.td((Object)"Expired");
                spyWriter.td((Object)bAlarmRecord.getSource());
                spyWriter.td((Object)bAlarmRecord.getSourceState());
                spyWriter.td((Object)bAlarmRecord.getUuid());
                spyWriter.w((Object)"</tr>\n");
            }
            spyWriter.endTable();
            spyWriter.w((Object)"<br />");
        }
        super.spy(spyWriter);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.reorderMon = new Object();
        this.reorderTicket = null;
    }

    public BOnCallList() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$oncall$BOnCallList;
        if (clazz == null) {
            clazz = class$com$tridium$oncall$BOnCallList = BOnCallList.class("[Lcom.tridium.oncall.BOnCallList;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://onCall/res/onCallList.png");
        reorderContext = new BasicContext();
    }

    private static class PriorityComparable
    implements Comparable {
        private BOnCallContact c;

        private static final PriorityComparable[] makeArray(BOnCallContact[] bOnCallContactArray) {
            PriorityComparable[] priorityComparableArray = new PriorityComparable[bOnCallContactArray.length];
            int n = 0;
            while (n < priorityComparableArray.length) {
                priorityComparableArray[n] = new PriorityComparable(bOnCallContactArray[n]);
                ++n;
            }
            return priorityComparableArray;
        }

        public int compareTo(Object object) {
            if (object == null) {
                return 1;
            }
            if (object instanceof PriorityComparable) {
                BOnCallContact bOnCallContact = ((PriorityComparable)object).c;
                if (bOnCallContact.getPriority() == this.c.getPriority()) {
                    return 0;
                }
                if (bOnCallContact.getPriority() < this.c.getPriority()) {
                    return 1;
                }
                return -1;
            }
            return 1;
        }

        private PriorityComparable(BOnCallContact bOnCallContact) {
            this.c = bOnCallContact;
        }
    }

    private static class RotationMarkerComparable
    implements Comparable {
        private BOnCallContact c;

        private static final RotationMarkerComparable[] makeArray(BOnCallContact[] bOnCallContactArray) {
            RotationMarkerComparable[] rotationMarkerComparableArray = new RotationMarkerComparable[bOnCallContactArray.length];
            int n = 0;
            while (n < rotationMarkerComparableArray.length) {
                rotationMarkerComparableArray[n] = new RotationMarkerComparable(bOnCallContactArray[n]);
                ++n;
            }
            return rotationMarkerComparableArray;
        }

        public int compareTo(Object object) {
            if (object == null) {
                return 1;
            }
            if (object instanceof RotationMarkerComparable) {
                BOnCallContact bOnCallContact = ((RotationMarkerComparable)object).c;
                if (bOnCallContact.getRotationMarker() == this.c.getRotationMarker()) {
                    return 0;
                }
                if (bOnCallContact.getRotationMarker() < this.c.getRotationMarker()) {
                    return 1;
                }
                return -1;
            }
            return 1;
        }

        private RotationMarkerComparable(BOnCallContact bOnCallContact) {
            this.c = bOnCallContact;
        }
    }
}

