/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mobile.history;

import com.tridium.history.BRootHistoryFolder;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.box.BIServerSideCallHandler;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryGroupings;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryScheme;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BAbsTimeRange;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUnrestrictedFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BHistoryServerSideHandler
extends BSingleton
implements BIServerSideCallHandler {
    public static final BHistoryServerSideHandler INSTANCE = new BHistoryServerSideHandler();
    public static final Type TYPE;
    private static final Log log;
    private static final String COL_ID = "id";
    private static final String COL_REC_TYPE = "recordType";
    private static final String COL_DISPLAY = "displayName";
    private static final String COL_ORD = "ord";
    private static final String QUERY_PARAM_END = "end=";
    private static final String QUERY_PARAM_START = "start=";
    private static final String FACETS_END_TIME = "END_TIME";
    private static final String FACETS_START_TIME = "START_TIME";
    static /* synthetic */ Class class$com$tridium$mobile$history$BHistoryServerSideHandler;

    public final Type getType() {
        return TYPE;
    }

    public final BValue getHistoryRange(BComponent bComponent, BValue bValue, Context context) {
        BOrd bOrd = BOrd.NULL;
        BAbsTimeRange bAbsTimeRange = new BAbsTimeRange();
        if (!(bValue instanceof BOrd)) {
            return bAbsTimeRange;
        }
        bOrd = (BOrd)bValue;
        OrdQuery[] ordQueryArray = bOrd.parse();
        int n = 0;
        while (n < ordQueryArray.length) {
            OrdQuery ordQuery = ordQueryArray[n];
            if (ordQuery.getScheme().equals(BHistoryScheme.INSTANCE.getId())) {
                Object object;
                Object object2;
                String string = ordQuery.getBody();
                BAbsTime bAbsTime = BAbsTime.DEFAULT;
                BAbsTime bAbsTime2 = BAbsTime.DEFAULT;
                int n2 = string.indexOf(63);
                if (n2 > 0) {
                    object2 = string.substring(n2 + 1);
                    string = string.substring(0, n2);
                    int n3 = ((String)object2).indexOf(QUERY_PARAM_START);
                    int n4 = ((String)object2).indexOf(QUERY_PARAM_END);
                    if (n3 > 0 && n4 > 0) {
                        object = ((String)object2).substring(n3);
                        object = ((String)object).substring(QUERY_PARAM_START.length(), ((String)object).indexOf(";") - 1);
                        String string2 = ((String)object2).substring(n4);
                        string2 = string2.substring(QUERY_PARAM_END.length(), string2.indexOf(";") - 1);
                        try {
                            bAbsTime = (BAbsTime)bAbsTime.decodeFromString((String)object);
                            bAbsTime2 = (BAbsTime)bAbsTime2.decodeFromString(string2);
                            bAbsTimeRange.setStartTime(bAbsTime);
                            bAbsTimeRange.setEndTime(bAbsTime2);
                            break;
                        }
                        catch (Exception exception) {
                            log.error("failed to parse time query data for history query: " + ordQuery.toString(), (Throwable)exception);
                        }
                    }
                }
                object2 = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                BHistoryId bHistoryId = BHistoryId.make((String)string);
                BHistoryDatabase bHistoryDatabase = object2.getDatabase();
                object = bHistoryDatabase.getHistory(bHistoryId);
                bAbsTime = object.getFirstTimestamp();
                bAbsTime2 = object.getLastTimestamp();
                bAbsTimeRange.setStartTime(bAbsTime);
                bAbsTimeRange.setEndTime(bAbsTime2);
                break;
            }
            ++n;
        }
        return bAbsTimeRange;
    }

    public final BValue getHistoryNavList(BComponent bComponent, Context context) {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BINavNode[] bINavNodeArray = bHistoryService.getDatabase().getNavChildren();
        return BHistoryServerSideHandler.encodeNavNodePaths(bINavNodeArray, context);
    }

    public final BValue getNavChildren(BComponent bComponent, BValue bValue, Context context) {
        BOrd bOrd = (BOrd)bValue;
        BObject bObject = bOrd.get();
        if (bObject instanceof BINavNode) {
            BINavNode bINavNode = (BINavNode)bObject;
            return BHistoryServerSideHandler.encodeNavNodePaths(bINavNode.getNavChildren(), context);
        }
        return null;
    }

    public final BValue getOrdDisplayName(BComponent bComponent, BValue bValue, Context context) {
        BINavNode bINavNode = (BINavNode)((BOrd)bValue).get();
        return BString.make((String)bINavNode.getNavDisplayName(context));
    }

    public final BValue getDeviceHistories(BComponent bComponent, BValue bValue, Context context) {
        if (bValue == null) {
            return null;
        }
        String string = bValue.toString();
        String string2 = "history:|bql:select id where id like '/" + string + "/%' order by id";
        BOrd bOrd = BOrd.make((String)string2);
        BITable bITable = (BITable)bOrd.get();
        return BHistoryServerSideHandler.encodeDeviceNavPaths(bITable, context);
    }

    private static final BComponent encodeNavNodePaths(BINavNode[] bINavNodeArray, Context context) {
        Arrays.sort(bINavNodeArray, new SortNavNodesByDisplay(context));
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryGroupings bHistoryGroupings = bHistoryService.getHistoryGroupings();
        BComponent bComponent = new BComponent();
        int n = 0;
        while (n < bINavNodeArray.length) {
            BUnrestrictedFolder bUnrestrictedFolder;
            BINavNode bINavNode = bINavNodeArray[n];
            if (!(bINavNode instanceof BIProtected) || (bUnrestrictedFolder = context.getUser().getPermissionsFor((BIProtected)bINavNode)).hasOperatorRead()) {
                BAbsTime bAbsTime;
                Object object;
                OrdQuery[] ordQueryArray;
                bUnrestrictedFolder = new BUnrestrictedFolder();
                BFacets bFacets = BFacets.NULL;
                BOrd bOrd = bINavNode.getNavOrd();
                BObject bObject = bOrd.get();
                if (bObject instanceof BIHistory) {
                    ordQueryArray = (OrdQuery[])bObject;
                    object = ordQueryArray.getId();
                    bAbsTime = ordQueryArray.getFirstTimestamp();
                    BAbsTime bAbsTime2 = ordQueryArray.getLastTimestamp();
                    BTypeSpec bTypeSpec = ordQueryArray.getRecordType();
                    bFacets = BFacets.make((String)FACETS_START_TIME, (BIDataValue)bAbsTime, (String)FACETS_END_TIME, (BIDataValue)bAbsTime2);
                    bUnrestrictedFolder.add(SlotPath.escape((String)COL_REC_TYPE), bTypeSpec.newCopy(true));
                    bUnrestrictedFolder.add(SlotPath.escape((String)COL_ID), (BValue)BString.make((String)object.getHistoryName()));
                }
                ordQueryArray = bOrd.parse();
                int n2 = 0;
                while (n2 < ordQueryArray.length) {
                    bAbsTime = ordQueryArray[n2];
                    if (bAbsTime.getScheme().equals(BHistoryScheme.INSTANCE.getId())) {
                        bOrd = BOrd.make((OrdQuery)bAbsTime);
                        break;
                    }
                    ++n2;
                }
                bUnrestrictedFolder.add(SlotPath.escape((String)COL_ORD), bOrd.newCopy(true));
                object = bINavNode.getNavDisplayName(context);
                if (bINavNode instanceof BRootHistoryFolder && (bAbsTime = bHistoryGroupings.getProperty((String)object)) != null) {
                    object = bHistoryGroupings.getDisplayName((Slot)bAbsTime, context);
                }
                bUnrestrictedFolder.add(SlotPath.escape((String)COL_DISPLAY), (BValue)BString.make((String)object));
                bComponent.add("row?", (BValue)bUnrestrictedFolder, 0, bFacets, null);
            }
            ++n;
        }
        return bComponent;
    }

    private static final BComponent encodeDeviceNavPaths(BITable bITable, Context context) {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BComponent bComponent = new BComponent();
        Column[] columnArray = bITable.getColumns().list();
        TableCursor tableCursor = (TableCursor)bITable.cursor();
        while (tableCursor.next()) {
            BUnrestrictedFolder bUnrestrictedFolder = new BUnrestrictedFolder();
            BPermissions bPermissions = BPermissions.DEFAULT;
            int n = 0;
            while (n < columnArray.length) {
                BObject bObject = tableCursor.get(columnArray[n]);
                if (bObject instanceof BHistoryId) {
                    BHistoryId bHistoryId = (BHistoryId)bObject;
                    BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
                    BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
                    if (!(bIHistory instanceof BIProtected) || (bPermissions = context.getUser().getPermissionsFor((BIProtected)bIHistory)).hasOperatorRead()) {
                        BAbsTime bAbsTime = bIHistory.getFirstTimestamp();
                        BAbsTime bAbsTime2 = bIHistory.getLastTimestamp();
                        BFacets bFacets = BFacets.make((String)FACETS_START_TIME, (BIDataValue)bAbsTime, (String)FACETS_END_TIME, (BIDataValue)bAbsTime2);
                        BTypeSpec bTypeSpec = bIHistory.getRecordType();
                        bUnrestrictedFolder.add(COL_DISPLAY, (BValue)BString.make((String)bIHistory.getNavDisplayName(context)));
                        bUnrestrictedFolder.add(COL_ORD, (BValue)bIHistory.getOrdInSpace());
                        bUnrestrictedFolder.add(COL_REC_TYPE, bTypeSpec.newCopy(true));
                        bUnrestrictedFolder.add(COL_ID, (BValue)BString.make((String)bHistoryId.getHistoryName()));
                        bComponent.add("row?", (BValue)bUnrestrictedFolder, 0, bFacets, null);
                    }
                }
                ++n;
            }
        }
        return bComponent;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BHistoryServerSideHandler() {
    }

    static {
        Class clazz = class$com$tridium$mobile$history$BHistoryServerSideHandler;
        if (clazz == null) {
            clazz = class$com$tridium$mobile$history$BHistoryServerSideHandler = BHistoryServerSideHandler.class("[Lcom.tridium.mobile.history.BHistoryServerSideHandler;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"MobileHistoryApp");
    }

    private static class SortNavNodesByDisplay
    implements Comparator {
        private Context cx;

        public int compare(Object object, Object object2) {
            BINavNode bINavNode = (BINavNode)object;
            BINavNode bINavNode2 = (BINavNode)object2;
            if (object == null) {
                int n = 0;
                if (object2 == null) {
                    n = 1;
                }
                return 1 - n;
            }
            if (object2 == null) {
                return -1;
            }
            return bINavNode.getNavDisplayName(this.cx).compareTo(bINavNode2.getNavDisplayName(this.cx));
        }

        public SortNavNodesByDisplay(Context context) {
            this.cx = context;
        }
    }
}

