/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nx584.ui;

import com.tridium.nx584.BNx6Panel;
import com.tridium.nx584.datatypes.BNx6Component;
import com.tridium.nx584.point.BNx6ProxyExt;
import com.tridium.nx584.ui.BNx6CreationEntry;
import com.tridium.nx584.ui.BNx6PointManager;
import java.util.ArrayList;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.gx.BImage;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class Nx6PointLearn
extends MgrLearn {
    static Lexicon lex = BNx6PointManager.lex;
    static BImage FloatElementIcon = BImage.make((String)"module://icons/x16/statusNumeric.png");
    static BImage BooleanElementIcon = BImage.make((String)"module://icons/x16/statusBoolean.png");
    static BImage EnumElementIcon = BImage.make((String)"module://icons/x16/statusEnum.png");
    static BImage StringElementIcon = BImage.make((String)"module://icons/x16/statusString.png");
    static BImage ObjectIcon = BImage.make((String)"module://icons/x16/shapes/squareGold.png");
    static BImage FolderIcon = BImage.make((String)"module://icons/x16/objectFolder.png");
    BNx6Panel panel;

    public void load(BComponent bComponent) {
        super.load(bComponent);
        BComplex bComplex = bComponent.getParent();
        while (!bComplex.getType().is(BNx6Panel.TYPE)) {
            bComplex = bComplex.getParent();
        }
        this.panel = (BNx6Panel)bComplex;
        this.panel.getComponentSpace().update((BComponent)this.panel, Integer.MAX_VALUE);
        this.updateDiscoveryRows();
    }

    void updateDiscoveryRows() {
        ArrayList arrayList = new ArrayList();
        this.doUpdateDiscoveryRows(arrayList, (BComponent)this.panel, "");
        BNx6CreationEntry[] bNx6CreationEntryArray = arrayList.toArray(new BNx6CreationEntry[arrayList.size()]);
        this.updateRoots((Object[])bNx6CreationEntryArray);
    }

    private final void doUpdateDiscoveryRows(ArrayList arrayList, BComponent bComponent, String string) {
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.nextObject()) {
            Property property = slotCursor.property();
            if (!property.getType().is(BNx6Component.TYPE)) continue;
            BComponent bComponent2 = (BComponent)slotCursor.get();
            BNx6CreationEntry bNx6CreationEntry = this.addElementRows(bComponent, bComponent2, bComponent2.getName(), string);
            if (bNx6CreationEntry == null) {
                System.out.println("e==null");
                continue;
            }
            arrayList.add(bNx6CreationEntry);
        }
    }

    private final BNx6CreationEntry addElementRows(BComponent bComponent, BComponent bComponent2, String string, String string2) {
        BNx6CreationEntry[] bNx6CreationEntryArray;
        BNx6CreationEntry bNx6CreationEntry = null;
        ArrayList<BNx6CreationEntry> arrayList = null;
        SlotCursor slotCursor = bComponent2.getProperties();
        while (slotCursor.nextObject()) {
            Object object;
            bNx6CreationEntryArray = slotCursor.property();
            BNx6CreationEntry bNx6CreationEntry2 = null;
            if (bNx6CreationEntryArray.getType().is(BStatusValue.TYPE)) {
                object = bNx6CreationEntryArray.getFacets();
                BUnit bUnit = (BUnit)object.get("units");
                String string3 = bUnit == null ? "" : bUnit.getSymbol();
                bNx6CreationEntry2 = new BNx6CreationEntry(bComponent2, bNx6CreationEntryArray.getName(), string3);
            } else if (bNx6CreationEntryArray.getType().is(BNx6Component.TYPE)) {
                object = string + '/' + bNx6CreationEntryArray.getDefaultDisplayName(null);
                bNx6CreationEntry2 = this.addElementRows(bComponent, (BComponent)slotCursor.get(), (String)object, string2);
            }
            if (bNx6CreationEntry2 == null) continue;
            if (bNx6CreationEntry == null) {
                bNx6CreationEntry = bNx6CreationEntry2;
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<BNx6CreationEntry>();
            }
            arrayList.add(bNx6CreationEntry2);
        }
        if (arrayList != null) {
            bNx6CreationEntryArray = arrayList.toArray(new BNx6CreationEntry[arrayList.size()]);
            bNx6CreationEntry.children = bNx6CreationEntryArray;
        }
        return bNx6CreationEntry;
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Prop(lex.getText("learn.columnTitle.targetComp"), BNx6CreationEntry.targetComp, 1), new MgrColumn.Prop(lex.getText("learn.columnTitle.targetElement"), BNx6CreationEntry.targetElement, 1)};
    }

    public boolean isDepthExpandable(int n) {
        return true;
    }

    public boolean hasChildren(Object object) {
        return ((BNx6CreationEntry)((Object)object)).hasChildren();
    }

    public Object[] getChildren(Object object) {
        BNx6CreationEntry[] bNx6CreationEntryArray = ((BNx6CreationEntry)((Object)object)).getChildren();
        if (bNx6CreationEntryArray == null) {
            return new Object[0];
        }
        return bNx6CreationEntryArray;
    }

    public BImage getIcon(Object object) {
        Type type = ((BNx6CreationEntry)((Object)object)).getTarget().getType();
        if (type.is(BComponent.TYPE)) {
            return ObjectIcon;
        }
        if (type == BStatusNumeric.TYPE) {
            return FloatElementIcon;
        }
        if (type == BStatusBoolean.TYPE) {
            return BooleanElementIcon;
        }
        if (type == BStatusEnum.TYPE) {
            return EnumElementIcon;
        }
        if (type == BStatusString.TYPE) {
            return StringElementIcon;
        }
        return null;
    }

    public MgrTypeInfo[] toTypes(Object object) throws Exception {
        BNx6CreationEntry bNx6CreationEntry = (BNx6CreationEntry)((Object)object);
        ArrayList<MgrTypeInfo> arrayList = new ArrayList<MgrTypeInfo>();
        Type type = bNx6CreationEntry.getTarget().getType();
        if (type == BStatusNumeric.TYPE) {
            arrayList.add(MgrTypeInfo.make((BComponent)new BNumericPoint()));
        } else if (type == BStatusBoolean.TYPE) {
            arrayList.add(MgrTypeInfo.make((BComponent)new BBooleanPoint()));
        } else if (type == BStatusEnum.TYPE) {
            arrayList.add(MgrTypeInfo.make((BComponent)new BEnumPoint()));
        } else {
            arrayList.add(MgrTypeInfo.make((BComponent)new BStringPoint()));
        }
        return arrayList.toArray(new MgrTypeInfo[arrayList.size()]);
    }

    public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
        BNx6CreationEntry bNx6CreationEntry = (BNx6CreationEntry)((Object)object);
        BNx6PointManager bNx6PointManager = (BNx6PointManager)mgrEditRow.getManager();
        mgrEditRow.setDefaultName(bNx6CreationEntry.getDefaultProxyName());
        mgrEditRow.setCell(bNx6PointManager.colTarget, (BValue)BString.make((String)bNx6CreationEntry.getTargetPathName()));
        mgrEditRow.setCell(bNx6PointManager.colElement, (BValue)BString.make((String)bNx6CreationEntry.getTargetElement()));
        mgrEditRow.setCell(bNx6PointManager.colFacets, (BValue)bNx6CreationEntry.getFacets());
    }

    public boolean isExisting(Object object, BComponent bComponent) {
        if (!bComponent.getType().is(BControlPoint.TYPE)) {
            return false;
        }
        BNx6CreationEntry bNx6CreationEntry = (BNx6CreationEntry)((Object)object);
        BControlPoint bControlPoint = (BControlPoint)bComponent;
        BNx6ProxyExt bNx6ProxyExt = (BNx6ProxyExt)bControlPoint.getProxyExt();
        String string = bNx6ProxyExt.getTargetElement();
        boolean bl = false;
        if (string.equals(bNx6CreationEntry.getTargetComp()) && bNx6ProxyExt.getTargetElement().equals(bNx6CreationEntry.getTargetElement())) {
            bl = true;
        }
        return bl;
    }

    public Nx6PointLearn(BAbstractManager bAbstractManager) {
        super(bAbstractManager);
    }
}

