/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nx584.messages;

import com.tridium.nx584.messages.Nx6InputStream;
import com.tridium.nx584.messages.Nx6MessageConst;
import com.tridium.nx584.messages.Nx6Request;
import com.tridium.nx584.messages.Nx6Response;
import com.tridium.nx584.util.Nx6ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZoneStatus
extends Nx6Response
implements Nx6MessageConst {
    Nx6Request request;
    public int zoneNumber;
    byte[] data;

    public void fromInputStream(Nx6InputStream nx6InputStream) {
        int n = nx6InputStream.readByte();
        this.msgType = nx6InputStream.readByte();
        this.zoneNumber = nx6InputStream.readByte() + 1;
        int n2 = 0;
        while (n2 < this.data.length) {
            this.data[n2] = (byte)nx6InputStream.readByte();
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Zone status for zone ").append(this.zoneNumber).append("\n");
        if (this.isBitActive(0, 0)) {
            stringBuffer.append(" Partition 1 enable       ").append("\n");
        }
        if (this.isBitActive(0, 1)) {
            stringBuffer.append(" Partition 2 enable       ").append("\n");
        }
        if (this.isBitActive(0, 2)) {
            stringBuffer.append(" Partition 3 enable       ").append("\n");
        }
        if (this.isBitActive(0, 3)) {
            stringBuffer.append(" Partition 4 enable       ").append("\n");
        }
        if (this.isBitActive(0, 4)) {
            stringBuffer.append(" Partition 5 enable       ").append("\n");
        }
        if (this.isBitActive(0, 5)) {
            stringBuffer.append(" Partition 6 enable       ").append("\n");
        }
        if (this.isBitActive(0, 6)) {
            stringBuffer.append(" Partition 7 enable       ").append("\n");
        }
        if (this.isBitActive(0, 7)) {
            stringBuffer.append(" Partition 8 enable       ").append("\n");
        }
        if (this.isBitActive(1, 0)) {
            stringBuffer.append(" Fire                     ").append("\n");
        }
        if (this.isBitActive(1, 1)) {
            stringBuffer.append(" 24 Hour                  ").append("\n");
        }
        if (this.isBitActive(1, 2)) {
            stringBuffer.append(" Key-switch               ").append("\n");
        }
        if (this.isBitActive(1, 3)) {
            stringBuffer.append(" Follower                 ").append("\n");
        }
        if (this.isBitActive(1, 4)) {
            stringBuffer.append(" Entry / exit delay 1     ").append("\n");
        }
        if (this.isBitActive(1, 5)) {
            stringBuffer.append(" Entry / exit delay 2     ").append("\n");
        }
        if (this.isBitActive(1, 6)) {
            stringBuffer.append(" Interior                 ").append("\n");
        }
        if (this.isBitActive(1, 7)) {
            stringBuffer.append(" Local only               ").append("\n");
        }
        if (this.isBitActive(2, 0)) {
            stringBuffer.append(" Keypad sounder           ").append("\n");
        }
        if (this.isBitActive(2, 1)) {
            stringBuffer.append(" Yelping siren            ").append("\n");
        }
        if (this.isBitActive(2, 2)) {
            stringBuffer.append(" Steady siren             ").append("\n");
        }
        if (this.isBitActive(2, 3)) {
            stringBuffer.append(" Chime                    ").append("\n");
        }
        if (this.isBitActive(2, 4)) {
            stringBuffer.append(" Bypassable               ").append("\n");
        }
        if (this.isBitActive(2, 5)) {
            stringBuffer.append(" Group bypassable         ").append("\n");
        }
        if (this.isBitActive(2, 6)) {
            stringBuffer.append(" Force armable            ").append("\n");
        }
        if (this.isBitActive(2, 7)) {
            stringBuffer.append(" Entry guard              ").append("\n");
        }
        if (this.isBitActive(3, 0)) {
            stringBuffer.append(" Fast loop response       ").append("\n");
        }
        if (this.isBitActive(3, 1)) {
            stringBuffer.append(" Double EOL tamper        ").append("\n");
        }
        if (this.isBitActive(3, 2)) {
            stringBuffer.append(" Trouble                  ").append("\n");
        }
        if (this.isBitActive(3, 3)) {
            stringBuffer.append(" Cross zone               ").append("\n");
        }
        if (this.isBitActive(3, 4)) {
            stringBuffer.append(" Dialer delay             ").append("\n");
        }
        if (this.isBitActive(3, 5)) {
            stringBuffer.append(" Swinger shutdown         ").append("\n");
        }
        if (this.isBitActive(3, 6)) {
            stringBuffer.append(" Restorable               ").append("\n");
        }
        if (this.isBitActive(3, 7)) {
            stringBuffer.append(" Listen in                ").append("\n");
        }
        if (this.isBitActive(4, 0)) {
            stringBuffer.append(" Faulted (or delayed trip)").append("\n");
        }
        if (this.isBitActive(4, 1)) {
            stringBuffer.append(" Tampered                 ").append("\n");
        }
        if (this.isBitActive(4, 2)) {
            stringBuffer.append(" Trouble                  ").append("\n");
        }
        if (this.isBitActive(4, 3)) {
            stringBuffer.append(" Bypassed                 ").append("\n");
        }
        if (this.isBitActive(4, 4)) {
            stringBuffer.append(" Inhibited (force armed)  ").append("\n");
        }
        if (this.isBitActive(4, 5)) {
            stringBuffer.append(" Low battery              ").append("\n");
        }
        if (this.isBitActive(4, 6)) {
            stringBuffer.append(" Loss of supervision      ").append("\n");
        }
        if (this.isBitActive(5, 0)) {
            stringBuffer.append(" Alarm memory             ").append("\n");
        }
        if (this.isBitActive(5, 1)) {
            stringBuffer.append(" Bypass memory            ").append("\n");
        }
        return stringBuffer.toString();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("zoneNumber=").append(this.zoneNumber);
        stringBuffer.append(" flags=").append(Nx6ByteArrayUtil.toString(this.data));
        return stringBuffer.toString();
    }

    public boolean isBitActive(int n, int n2) {
        boolean bl = false;
        if ((this.data[n] & 1 << n2) != 0) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.data = new byte[6];
    }

    public ZoneStatus() {
        this.this();
    }

    public ZoneStatus(Nx6Request nx6Request) {
        this.this();
        this.request = nx6Request;
    }
}

