/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nx584.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.nx584.BNx6Network;
import com.tridium.nx584.messages.Nx6InputStream;
import com.tridium.nx584.messages.Nx6MessageConst;
import com.tridium.nx584.util.Nx6ByteArrayUtil;
import com.tridium.nx584.util.Nx6Util;
import java.io.OutputStream;
import javax.baja.log.Log;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Nx6Message
extends Message
implements Nx6MessageConst {
    public boolean ackRequired;
    public int msgType;

    public final void write(OutputStream outputStream) {
        try {
            byte[] byArray = this.getData();
            if (this.log().isTraceOn()) {
                System.out.println("send : " + Nx6ByteArrayUtil.toString(byArray));
            }
            outputStream.write(126);
            outputStream.write(byArray.length);
            if (this.ackRequired) {
                byArray[0] = (byte)(byArray[0] | 0x80);
            }
            int n = 0;
            while (n < byArray.length) {
                int n2 = byArray[n] & 0xFF;
                if (n2 == 126) {
                    outputStream.write(125);
                    outputStream.write(94);
                } else if (n2 == 125) {
                    outputStream.write(125);
                    outputStream.write(93);
                } else {
                    outputStream.write(n2);
                }
                ++n;
            }
            n = Nx6Util.calCksum(byArray, 0, byArray.length);
            outputStream.write(n >> 8 & 0xFF);
            outputStream.write(n & 0xFF);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public abstract void fromInputStream(Nx6InputStream var1);

    public byte[] getData() {
        return new byte[]{(byte)this.msgType};
    }

    public String toDebugString() {
        return Nx6ByteArrayUtil.toString(this.getData());
    }

    private final Log log() {
        return BNx6Network.getNxLog();
    }

    private final /* synthetic */ void this() {
        this.ackRequired = false;
        this.msgType = 0;
    }

    public Nx6Message() {
        this.this();
    }
}

