/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nx584.messages;

import com.tridium.nx584.messages.Nx6InputStream;
import com.tridium.nx584.messages.Nx6Request;
import com.tridium.nx584.messages.Nx6Response;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class InterfaceConfiguration
extends Nx6Response {
    Nx6Request request;
    public String firmwareVersion;
    byte[] data;

    public void fromInputStream(Nx6InputStream nx6InputStream) {
        int n = nx6InputStream.readByte();
        this.msgType = nx6InputStream.readByte();
        this.firmwareVersion = nx6InputStream.readString(4);
        int n2 = 0;
        while (n2 < this.data.length) {
            this.data[n2] = (byte)nx6InputStream.read();
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("firmwareVersion=").append(this.firmwareVersion).append("\n");
        stringBuffer.append("Transition Messages:").append("\n");
        if (this.isBitActive(0, 1)) {
            stringBuffer.append("  Interface Configuration Message").append("\n");
        }
        if (this.isBitActive(0, 4)) {
            stringBuffer.append("  Zone Status Message").append("\n");
        }
        if (this.isBitActive(0, 5)) {
            stringBuffer.append("  Zones Snapshot Message").append("\n");
        }
        if (this.isBitActive(0, 6)) {
            stringBuffer.append("  Partition Status Message").append("\n");
        }
        if (this.isBitActive(0, 7)) {
            stringBuffer.append("  Partitions Snapshot Message").append("\n");
        }
        if (this.isBitActive(1, 0)) {
            stringBuffer.append("  System Status Message").append("\n");
        }
        if (this.isBitActive(1, 1)) {
            stringBuffer.append("  X-10 Message Received").append("\n");
        }
        if (this.isBitActive(1, 2)) {
            stringBuffer.append("  Log Event Message").append("\n");
        }
        if (this.isBitActive(1, 3)) {
            stringBuffer.append("  Keypad Message Received").append("\n");
        }
        stringBuffer.append("Supported Messages:").append("\n");
        if (this.isBitActive(2, 1)) {
            stringBuffer.append("  Interface Configuration Request").append("\n");
        }
        if (this.isBitActive(2, 3)) {
            stringBuffer.append("  Zone Name Request").append("\n");
        }
        if (this.isBitActive(2, 4)) {
            stringBuffer.append("  Zone Status Request").append("\n");
        }
        if (this.isBitActive(2, 5)) {
            stringBuffer.append("  Zones Snapshot Request").append("\n");
        }
        if (this.isBitActive(2, 6)) {
            stringBuffer.append("  Partition Status Request").append("\n");
        }
        if (this.isBitActive(2, 7)) {
            stringBuffer.append("  Partitions Snapshot Request").append("\n");
        }
        if (this.isBitActive(3, 0)) {
            stringBuffer.append("  System Status Request").append("\n");
        }
        if (this.isBitActive(3, 1)) {
            stringBuffer.append("  Send X-10 Message").append("\n");
        }
        if (this.isBitActive(3, 2)) {
            stringBuffer.append("  Log Event Request").append("\n");
        }
        if (this.isBitActive(3, 3)) {
            stringBuffer.append("  Send Keypad Text Message").append("\n");
        }
        if (this.isBitActive(3, 4)) {
            stringBuffer.append("  Keypad Terminal Mode Request").append("\n");
        }
        if (this.isBitActive(4, 0)) {
            stringBuffer.append("  Program Data Request").append("\n");
        }
        if (this.isBitActive(4, 1)) {
            stringBuffer.append("  Program Data Command").append("\n");
        }
        if (this.isBitActive(4, 2)) {
            stringBuffer.append("  User Information Request with PIN").append("\n");
        }
        if (this.isBitActive(4, 3)) {
            stringBuffer.append("  User Information Request without PIN").append("\n");
        }
        if (this.isBitActive(4, 4)) {
            stringBuffer.append("  Set User Code Command with PIN").append("\n");
        }
        if (this.isBitActive(4, 5)) {
            stringBuffer.append("  Set User Code Command without PIN").append("\n");
        }
        if (this.isBitActive(4, 6)) {
            stringBuffer.append("  Set User Authorization Command with PIN").append("\n");
        }
        if (this.isBitActive(4, 7)) {
            stringBuffer.append("  Set User Authorization Command without PIN").append("\n");
        }
        if (this.isBitActive(5, 2)) {
            stringBuffer.append("  Store Communication Event Command").append("\n");
        }
        if (this.isBitActive(5, 3)) {
            stringBuffer.append("  Set Clock / Calendar Command").append("\n");
        }
        if (this.isBitActive(5, 4)) {
            stringBuffer.append("  Primary Keypad Function with PIN").append("\n");
        }
        if (this.isBitActive(5, 5)) {
            stringBuffer.append("  Primary Keypad Function without PIN").append("\n");
        }
        if (this.isBitActive(5, 6)) {
            stringBuffer.append("  Secondary Keypad Function").append("\n");
        }
        if (this.isBitActive(5, 7)) {
            stringBuffer.append("  Zone Bypass Toggle").append("\n");
        }
        return stringBuffer.toString();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("firmwareVersion=").append(this.firmwareVersion);
        return stringBuffer.toString();
    }

    public boolean isBitActive(int n, int n2) {
        boolean bl = false;
        if ((this.data[n] & 1 << n2) != 0) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.data = new byte[6];
    }

    public InterfaceConfiguration() {
        this.this();
    }

    public InterfaceConfiguration(Nx6Request nx6Request) {
        this.this();
        this.request = nx6Request;
    }
}

