/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nx584.comm;

import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.nx584.BNx6Network;
import com.tridium.nx584.messages.Nx6ReceivedMessage;
import com.tridium.nx584.util.Nx6ByteArrayUtil;
import com.tridium.nx584.util.Nx6Util;
import javax.baja.io.ByteBuffer;
import javax.baja.log.Log;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Nx6CommReceiver
extends CommReceiver {
    private static final boolean ASCII = false;
    private static final int IDLE = 0;
    private static final int READ_LENGTH = 1;
    private static final int READ_DATA = 2;
    private static final int READ_CKSUM1 = 3;
    private static final int READ_CKSUM2 = 4;
    private int state;
    private ByteBuffer rcvBuffer;
    private Nx6ReceivedMessage msg;
    private boolean done;

    public void initReceiveState(Message message) {
        this.resetReceiveBuffer();
    }

    protected ReceivedMessage receive() throws Exception {
        this.state = 0;
        this.done = false;
        int n = 0;
        block7: while (!this.done) {
            int n2 = this.getInputStream().read();
            boolean bl = false;
            if (n2 != -1) {
                bl = true;
            }
            boolean bl2 = bl;
            n2 &= 0xFF;
            boolean bl3 = false;
            if (!bl2) continue;
            switch (this.state) {
                case 0: {
                    if (n2 != 126) continue block7;
                    this.state = 1;
                    break;
                }
                case 1: {
                    n = n2;
                    this.rcvBuffer.write(n);
                    this.state = 2;
                    break;
                }
                case 2: {
                    if (bl3) {
                        n2 ^= 0x20;
                        bl3 = false;
                    } else if (n2 == 125) {
                        bl3 = true;
                        break;
                    }
                    this.rcvBuffer.write(n2);
                    if (--n > 0) continue block7;
                    this.state = 3;
                    break;
                }
                case 3: {
                    this.rcvBuffer.write(n2);
                    this.state = 4;
                    break;
                }
                case 4: {
                    this.rcvBuffer.write(n2);
                    this.state = 0;
                    this.done = true;
                    break;
                }
            }
        }
        if (this.msg == null) {
            this.msg = new Nx6ReceivedMessage(this.rcvBuffer.getBytes(), this.rcvBuffer.getLength());
        } else {
            this.msg.setBytes(this.rcvBuffer.getBytes());
            this.msg.setLength(this.rcvBuffer.getLength());
        }
        if (this.log().isTraceOn()) {
            System.out.println("\nreceived message = " + Nx6ByteArrayUtil.toString(this.rcvBuffer.getBytes(), this.rcvBuffer.getLength()));
        }
        this.resetReceiveBuffer();
        return this.msg;
    }

    public synchronized void resetReceiveBuffer() {
        this.rcvBuffer.reset();
    }

    private final void processAscii() throws Exception {
        int n = this.getInputStream().read();
        boolean bl = false;
        if (n != -1) {
            bl = true;
        }
        boolean bl2 = bl;
        n &= 0xFF;
        boolean bl3 = true;
        int n2 = 0;
        if (bl2) {
            switch (this.state) {
                case 0: {
                    if (n != 10) break;
                    this.state = 2;
                    bl3 = true;
                    break;
                }
                case 2: {
                    if (n == 13) {
                        if (Nx6Util.isCksumOk(this.rcvBuffer.getBytes(), 1, this.rcvBuffer.getLength() - 3)) {
                            this.done = true;
                            break;
                        }
                        this.resetReceiveBuffer();
                        this.state = 0;
                        break;
                    }
                    int n3 = Character.digit((char)n, 16);
                    if (n3 < 0) {
                        this.resetReceiveBuffer();
                        this.state = 0;
                        break;
                    }
                    if (bl3) {
                        n2 = n3;
                        break;
                    }
                    this.rcvBuffer.write((n2 << 4) + n3);
                    break;
                }
            }
        }
    }

    private final Log log() {
        return BNx6Network.getNxLog();
    }

    private final /* synthetic */ void this() {
        this.state = 0;
        this.rcvBuffer = new ByteBuffer();
        this.msg = null;
        this.done = false;
    }

    public Nx6CommReceiver() {
        this.this();
    }
}

