/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nx584.comm;

import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BBasicUnsolicitedReceive;
import com.tridium.nx584.BNx6Network;
import com.tridium.nx584.BNx6Panel;
import com.tridium.nx584.datatypes.BNx6Partition;
import com.tridium.nx584.datatypes.BNx6Zone;
import com.tridium.nx584.messages.InterfaceConfiguration;
import com.tridium.nx584.messages.Nx6InputStream;
import com.tridium.nx584.messages.Nx6MessageConst;
import com.tridium.nx584.messages.Nx6ReceivedMessage;
import com.tridium.nx584.messages.PartitionStatus;
import com.tridium.nx584.messages.SystemStatus;
import com.tridium.nx584.messages.ZoneStatus;
import com.tridium.nx584.messages.ZonesSnapshot;
import com.tridium.nx584.util.Nx6Util;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNx6UnsolicitedReceive
extends BBasicUnsolicitedReceive
implements Nx6MessageConst {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$nx584$comm$BNx6UnsolicitedReceive;
    static /* synthetic */ Class class$com$tridium$nx584$datatypes$BNx6Partition;
    static /* synthetic */ Class class$com$tridium$nx584$datatypes$BNx6Zone;

    public Type getType() {
        return TYPE;
    }

    BNx6Network getNetwork() {
        return (BNx6Network)this.getParent();
    }

    protected void processUnsolicitedMessage(ReceivedMessage receivedMessage) {
        BNx6Network bNx6Network = this.getNetwork();
        Nx6ReceivedMessage nx6ReceivedMessage = (Nx6ReceivedMessage)receivedMessage;
        byte[] byArray = nx6ReceivedMessage.getBytes();
        if (nx6ReceivedMessage.isAcknowledgeRequired()) {
            Nx6Util.sendAck(bNx6Network, 29);
        }
        switch (nx6ReceivedMessage.getMessageType()) {
            case 1: {
                InterfaceConfiguration interfaceConfiguration = new InterfaceConfiguration(null);
                interfaceConfiguration.fromInputStream(new Nx6InputStream(byArray));
                bNx6Network.getInterfaceConfig().updateInterfaceConfig(interfaceConfiguration);
                break;
            }
            case 8: {
                SystemStatus systemStatus = new SystemStatus(null);
                systemStatus.fromInputStream(new Nx6InputStream(byArray));
                bNx6Network.getPanel().getSystemStatus().updateSystemStatus(systemStatus);
                break;
            }
            case 6: {
                PartitionStatus partitionStatus = new PartitionStatus(null);
                partitionStatus.fromInputStream(new Nx6InputStream(byArray));
                this.updatePartition(bNx6Network.getPanel(), partitionStatus);
                break;
            }
            case 4: {
                ZoneStatus zoneStatus = new ZoneStatus(null);
                zoneStatus.fromInputStream(new Nx6InputStream(byArray));
                this.updateZone(bNx6Network.getPanel(), zoneStatus);
                break;
            }
            case 5: {
                ZonesSnapshot zonesSnapshot = new ZonesSnapshot(null);
                zonesSnapshot.fromInputStream(new Nx6InputStream(byArray));
                break;
            }
            default: {
                if (!this.log().isTraceOn()) break;
                System.out.println("received unexpected message type " + nx6ReceivedMessage.getMessageType());
            }
        }
    }

    private final void updatePartition(BNx6Panel bNx6Panel, PartitionStatus partitionStatus) {
        BNx6Partition bNx6Partition = null;
        int n = partitionStatus.partitionNumber;
        Class clazz = class$com$tridium$nx584$datatypes$BNx6Partition;
        if (clazz == null) {
            clazz = class$com$tridium$nx584$datatypes$BNx6Partition = BNx6UnsolicitedReceive.class("[Lcom.tridium.nx584.datatypes.BNx6Partition;", false);
        }
        BNx6Partition[] bNx6PartitionArray = (BNx6Partition[])bNx6Panel.getChildren(clazz);
        int n2 = 0;
        while (n2 < bNx6PartitionArray.length) {
            if (bNx6PartitionArray[n2].getPartitionNumber() == n) {
                bNx6Partition = bNx6PartitionArray[n2];
                break;
            }
            ++n2;
        }
        if (bNx6Partition == null) {
            if (this.log().isTraceOn()) {
                this.log().trace("received update for unknown partion " + n);
            }
        } else {
            bNx6Partition.updatePartition(partitionStatus);
        }
    }

    private final void updateZone(BNx6Panel bNx6Panel, ZoneStatus zoneStatus) {
        BNx6Zone bNx6Zone = null;
        int n = zoneStatus.zoneNumber;
        Class clazz = class$com$tridium$nx584$datatypes$BNx6Zone;
        if (clazz == null) {
            clazz = class$com$tridium$nx584$datatypes$BNx6Zone = BNx6UnsolicitedReceive.class("[Lcom.tridium.nx584.datatypes.BNx6Zone;", false);
        }
        BNx6Zone[] bNx6ZoneArray = (BNx6Zone[])bNx6Panel.getChildren(clazz);
        int n2 = 0;
        while (n2 < bNx6ZoneArray.length) {
            if (bNx6ZoneArray[n2].getZoneNumber() == n) {
                bNx6Zone = bNx6ZoneArray[n2];
                break;
            }
            ++n2;
        }
        if (bNx6Zone == null) {
            if (this.log().isTraceOn()) {
                this.log().trace("received update for unknown zone " + n);
            }
        } else {
            bNx6Zone.updateZone(zoneStatus);
        }
    }

    private final Log log() {
        return BNx6Network.getNxLog();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$nx584$comm$BNx6UnsolicitedReceive;
        if (clazz == null) {
            clazz = class$com$tridium$nx584$comm$BNx6UnsolicitedReceive = BNx6UnsolicitedReceive.class("[Lcom.tridium.nx584.comm.BNx6UnsolicitedReceive;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

